/*
 * Decompiled with CFR 0.152.
 */
package org.sweble.wikitext.engine;

import java.io.Serializable;
import java.util.Map;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.sweble.wikitext.engine.ExpansionFrame;
import org.sweble.wikitext.engine.config.WikiConfig;
import org.sweble.wikitext.engine.nodes.EngineNodeFactory;
import org.sweble.wikitext.engine.utils.EngineAstTextUtils;
import org.sweble.wikitext.parser.nodes.WtNode;
import org.sweble.wikitext.parser.nodes.WtNodeList;
import org.sweble.wikitext.parser.nodes.WtTagExtension;
import org.sweble.wikitext.parser.nodes.WtTagExtensionBody;

@XmlTransient
@XmlJavaTypeAdapter(value=TagExtensionAdapter.class)
public abstract class TagExtensionBase
implements Serializable,
Comparable<TagExtensionBase> {
    private static final long serialVersionUID = 1L;
    private final String id;
    private WikiConfig wikiConfig;
    private EngineAstTextUtils tu;
    private EngineNodeFactory nf;

    protected TagExtensionBase(String id) {
        if (id == null || id.isEmpty()) {
            throw new IllegalArgumentException();
        }
        this.id = id;
    }

    protected TagExtensionBase(WikiConfig wikiConfig, String id) {
        this(id);
        this.setWikiConfig(wikiConfig);
    }

    public void setWikiConfig(WikiConfig wikiConfig) {
        if (wikiConfig == null) {
            throw new IllegalArgumentException();
        }
        this.wikiConfig = wikiConfig;
        this.nf = wikiConfig.getNodeFactory();
        this.tu = wikiConfig.getAstTextUtils();
    }

    public WikiConfig getWikiConfig() {
        return this.wikiConfig;
    }

    public String getId() {
        return this.id;
    }

    protected EngineNodeFactory nf() {
        return this.nf;
    }

    protected EngineAstTextUtils tu() {
        return this.tu;
    }

    public abstract WtNode invoke(ExpansionFrame var1, WtTagExtension var2, Map<String, WtNodeList> var3, WtTagExtensionBody var4);

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        return this.getClass() == obj.getClass();
    }

    @Override
    public int compareTo(TagExtensionBase o) {
        return this.id.compareTo(o.getId());
    }

    public String toString() {
        return "TagExtensionBase [id=" + this.id + "]";
    }

    public static final class TagExtensionAdapter
    extends XmlAdapter<TagExtensionRef, TagExtensionBase> {
        public TagExtensionRef marshal(TagExtensionBase v) throws Exception {
            return new TagExtensionRef(v.getClass().getName());
        }

        public TagExtensionBase unmarshal(TagExtensionRef v) throws Exception {
            Class<?> clazz = Class.forName(v.className);
            return (TagExtensionBase)clazz.newInstance();
        }
    }

    protected static final class TagExtensionRef {
        @XmlAttribute(name="class")
        public String className;

        public TagExtensionRef() {
        }

        public TagExtensionRef(String name) {
            this.className = name;
        }
    }
}

