/*
 * Decompiled with CFR 0.152.
 */
package org.sweble.wikitext.engine.config;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import org.sweble.wikitext.engine.ParserFunctionBase;

@XmlType(name="pfnGroup")
public class ParserFunctionGroup
implements Serializable,
Comparable<ParserFunctionGroup> {
    private static final long serialVersionUID = 1L;
    @XmlAttribute
    private String name;
    private final transient HashSet<String> pfnIds = new HashSet();
    private final HashSet<ParserFunctionBase> pfns = new HashSet();

    public ParserFunctionGroup() {
    }

    public ParserFunctionGroup(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Collection<ParserFunctionBase> getParserFunctions() {
        return Collections.unmodifiableCollection(this.pfns);
    }

    public void addParserFunction(ParserFunctionBase pfn) {
        if (this.pfnIds.contains(pfn.getId())) {
            throw new IllegalArgumentException("Parser function group already contains parser function with ID: " + pfn.getId());
        }
        this.pfnIds.add(pfn.getId());
        this.pfns.add(pfn);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.pfns == null ? 0 : this.pfns.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ParserFunctionGroup)) {
            return false;
        }
        ParserFunctionGroup other = (ParserFunctionGroup)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.pfns == null ? other.pfns != null : !this.pfns.equals(other.pfns));
    }

    public String toString() {
        return "ParserFunctionGroup [name=" + this.name + ", pfns=" + this.pfns + "]";
    }

    @Override
    public int compareTo(ParserFunctionGroup o) {
        return this.name.compareTo(o.getName());
    }

    @XmlElement(name="pfn")
    private ArrayList<ParserFunctionBase> getPfns() {
        ArrayList<ParserFunctionBase> sorted = new ArrayList<ParserFunctionBase>(this.pfns);
        Collections.sort(sorted);
        return sorted;
    }

    private void setPfns(ArrayList<ParserFunctionBase> pfns) {
        for (ParserFunctionBase pfn : pfns) {
            this.addParserFunction(pfn);
        }
    }
}

