/*
 * Decompiled with CFR 0.152.
 */
package org.sweble.wikitext.engine.config;

import com.sun.xml.bind.marshaller.NamespacePrefixMapper;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.PropertyException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.util.JAXBSource;
import javax.xml.transform.Source;
import org.sweble.wikitext.engine.ParserFunctionBase;
import org.sweble.wikitext.engine.TagExtensionBase;
import org.sweble.wikitext.engine.config.EngineConfigImpl;
import org.sweble.wikitext.engine.config.I18nAlias;
import org.sweble.wikitext.engine.config.I18nAliasImpl;
import org.sweble.wikitext.engine.config.Interwiki;
import org.sweble.wikitext.engine.config.InterwikiImpl;
import org.sweble.wikitext.engine.config.Namespace;
import org.sweble.wikitext.engine.config.NamespaceImpl;
import org.sweble.wikitext.engine.config.ParserConfigImpl;
import org.sweble.wikitext.engine.config.ParserFunctionGroup;
import org.sweble.wikitext.engine.config.TagExtensionGroup;
import org.sweble.wikitext.engine.config.WikiConfig;
import org.sweble.wikitext.engine.config.WikiRuntimeInfo;
import org.sweble.wikitext.engine.config.WikiRuntimeInfoImpl;
import org.sweble.wikitext.engine.nodes.EngineNodeFactoryImpl;
import org.sweble.wikitext.engine.utils.EngineAstTextUtils;
import org.sweble.wikitext.engine.utils.EngineAstTextUtilsImpl;

@XmlRootElement(name="WikiConfig", namespace="org.sweble.wikitext.engine")
@XmlType(propOrder={"siteName", "wikiUrl", "contentLang", "iwPrefix", "jaxbNamespaces", "jaxbInterwikis", "jaxbAliases", "jaxbPfnGroups", "jaxbTagExtGroups", "parserConfig", "engineConfig"})
@XmlAccessorType(value=XmlAccessType.NONE)
public class WikiConfigImpl
implements WikiConfig {
    @XmlElement
    private final ParserConfigImpl parserConfig;
    @XmlElement
    private final EngineConfigImpl engineConfig;
    private EngineNodeFactoryImpl nodeFactory;
    private EngineAstTextUtilsImpl textUtils;
    @XmlElement
    private String siteName;
    @XmlElement
    private String wikiUrl;
    @XmlElement
    private String contentLang;
    @XmlElement
    private String iwPrefix;
    private final Map<String, I18nAliasImpl> aliases = new HashMap<String, I18nAliasImpl>();
    private final transient Map<String, I18nAliasImpl> nameToAliasMap = new HashMap<String, I18nAliasImpl>();
    private final Map<String, ParserFunctionGroup> pfnGroups = new HashMap<String, ParserFunctionGroup>();
    private final transient Map<String, ParserFunctionBase> parserFunctions = new HashMap<String, ParserFunctionBase>();
    private final transient Map<I18nAliasImpl, ParserFunctionBase> aliasToPfnMap = new HashMap<I18nAliasImpl, ParserFunctionBase>();
    private final Map<String, TagExtensionGroup> tagExtGroups = new HashMap<String, TagExtensionGroup>();
    private final transient Map<String, TagExtensionBase> tagExtensions = new HashMap<String, TagExtensionBase>();
    private final Map<String, InterwikiImpl> prefixToInterwikiMap = new HashMap<String, InterwikiImpl>();
    private final Map<Integer, NamespaceImpl> namespaceById = new HashMap<Integer, NamespaceImpl>();
    private final transient Map<String, NamespaceImpl> namespaceByName = new HashMap<String, NamespaceImpl>();
    private NamespaceImpl templateNamespace;
    private NamespaceImpl defaultNamespace;
    private WikiRuntimeInfo runtimeInfo;

    public WikiConfigImpl() {
        this.parserConfig = new ParserConfigImpl(this);
        this.nodeFactory = new EngineNodeFactoryImpl(this.parserConfig);
        this.textUtils = new EngineAstTextUtilsImpl(this.parserConfig);
        this.runtimeInfo = new WikiRuntimeInfoImpl(this);
        this.engineConfig = new EngineConfigImpl();
    }

    @Override
    public ParserConfigImpl getParserConfig() {
        return this.parserConfig;
    }

    @Override
    public EngineConfigImpl getEngineConfig() {
        return this.engineConfig;
    }

    @Override
    public EngineNodeFactoryImpl getNodeFactory() {
        return this.nodeFactory;
    }

    @Override
    public EngineAstTextUtils getAstTextUtils() {
        return this.textUtils;
    }

    public void addNamespace(NamespaceImpl ns) {
        NamespaceImpl old = this.namespaceById.get(ns.getId());
        if (old == ns) {
            throw new IllegalArgumentException("The namespace with id `" + ns.getId() + "' is already registered.");
        }
        if (old != null) {
            throw new IllegalArgumentException("A namespace with the same id `" + ns.getId() + "' is already registered.");
        }
        ArrayList<String> names = new ArrayList<String>(ns.getAliases().size() + 2);
        for (String name : ns.getAliases()) {
            names.add(name.toLowerCase());
        }
        names.add(ns.getName().toLowerCase());
        names.add(ns.getCanonical().toLowerCase());
        for (String name : names) {
            old = this.namespaceByName.get(name);
            if (old == null) continue;
            throw new IllegalArgumentException("Another namespace already registered the name `" + name + "'.");
        }
        this.namespaceById.put(ns.getId(), ns);
        for (String name : names) {
            this.namespaceByName.put(name, ns);
        }
    }

    public void setDefaultNamespace(NamespaceImpl defaultNamespace) {
        if (this.namespaceById.get(defaultNamespace.getId()) != defaultNamespace) {
            throw new IllegalArgumentException("Given namespace unknown in this configuration");
        }
        this.defaultNamespace = defaultNamespace;
    }

    public void setTemplateNamespace(NamespaceImpl templateNamespace) {
        if (this.namespaceById.get(templateNamespace.getId()) != templateNamespace) {
            throw new IllegalArgumentException("Given namespace unknown in this configuration");
        }
        this.templateNamespace = templateNamespace;
    }

    @Override
    public NamespaceImpl getNamespace(String name) {
        return this.namespaceByName.get(name.toLowerCase());
    }

    @Override
    public Collection<Namespace> getNamespaces() {
        return Collections.unmodifiableCollection(this.namespaceById.values());
    }

    @Override
    public NamespaceImpl getNamespace(int id) {
        return this.namespaceById.get(id);
    }

    @Override
    public NamespaceImpl getDefaultNamespace() {
        return this.defaultNamespace;
    }

    @Override
    public NamespaceImpl getTemplateNamespace() {
        return this.templateNamespace;
    }

    @Override
    public Namespace getFileNamespace() {
        return this.getNamespace("File");
    }

    @Override
    public Namespace getSubjectNamespaceFor(Namespace namespace) {
        if (namespace.isSubjectNamespace()) {
            return namespace;
        }
        return this.getNamespace(namespace.getSubjectspaceId());
    }

    @Override
    public Namespace getTalkNamespaceFor(Namespace namespace) {
        if (namespace.isTalkNamespace()) {
            return namespace;
        }
        return this.getNamespace(namespace.getTalkspaceId());
    }

    public void addInterwiki(InterwikiImpl iw) {
        InterwikiImpl old = this.prefixToInterwikiMap.get(iw.getPrefix());
        if (old == iw) {
            throw new IllegalArgumentException("The wiki with interwiki prefix `" + iw.getPrefix() + "' is already registered.");
        }
        if (old != null) {
            throw new IllegalArgumentException("A wiki with the same interwiki prefix `" + iw.getPrefix() + "' is already registered.");
        }
        this.prefixToInterwikiMap.put(iw.getPrefix(), iw);
    }

    @Override
    public InterwikiImpl getInterwiki(String prefix) {
        return this.prefixToInterwikiMap.get(prefix);
    }

    @Override
    public Collection<Interwiki> getInterwikis() {
        return Collections.unmodifiableCollection(this.prefixToInterwikiMap.values());
    }

    public void addI18nAlias(I18nAliasImpl alias) {
        I18nAliasImpl old = this.aliases.get(alias.getId());
        if (old == alias || old != null && old.equals(alias)) {
            throw new IllegalArgumentException("This alias is already registered: " + alias.getId());
        }
        if (old != null) {
            throw new IllegalArgumentException("An alias with the same id `" + alias.getId() + "' is already registered.");
        }
        for (String a : alias.getAliases()) {
            String lcAlias = a.toLowerCase();
            I18nAliasImpl old2 = this.nameToAliasMap.get(lcAlias);
            if (old2 == alias) {
                throw new IllegalArgumentException("This alias (`" + alias.getId() + "') registeres the name `" + a + "' twice.");
            }
            if (old2 != null) {
                throw new IllegalArgumentException("The name `" + a + "' was already registered by the alias `" + old2.getId() + "' when trying to register it for alias `" + alias.getId() + "'.");
            }
            this.nameToAliasMap.put(lcAlias, alias);
        }
        this.aliases.put(alias.getId(), alias);
    }

    @Override
    public I18nAliasImpl getI18nAlias(String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        I18nAliasImpl alias = this.nameToAliasMap.get(name.toLowerCase());
        if (alias != null && alias.isCaseSensitive() && !alias.getAliases().contains(name)) {
            alias = null;
        }
        return alias;
    }

    public I18nAliasImpl getI18nAliasById(String id) {
        return this.aliases.get(id);
    }

    @Override
    public Collection<I18nAlias> getI18nAliases() {
        return Collections.unmodifiableCollection(this.aliases.values());
    }

    public void addParserFunctionGroup(ParserFunctionGroup pfnGroup) {
        ParserFunctionGroup old = this.pfnGroups.get(pfnGroup.getName());
        if (old == pfnGroup) {
            throw new IllegalArgumentException("The parser function group `" + pfnGroup.getName() + "' is already registered.");
        }
        if (old != null) {
            throw new IllegalArgumentException("A parser function group with the same name `" + pfnGroup.getName() + "' is already registered.");
        }
        for (ParserFunctionBase pfn : pfnGroup.getParserFunctions()) {
            this.addParserFunction(pfn);
        }
        this.pfnGroups.put(pfnGroup.getName(), pfnGroup);
    }

    protected void addParserFunction(ParserFunctionBase pfn) {
        ParserFunctionBase old = this.parserFunctions.get(pfn.getId());
        if (old == pfn) {
            throw new IllegalArgumentException("The parser function `" + pfn.getId() + "' is already registered.");
        }
        if (old != null) {
            throw new IllegalArgumentException("A parser function with the same id `" + pfn.getId() + "' is already registered.");
        }
        this.parserFunctions.put(pfn.getId(), pfn);
        I18nAliasImpl alias = this.aliases.get(pfn.getId());
        if (alias == null) {
            throw new IllegalArgumentException("No alias registered for parser function `" + pfn.getId() + "'.");
        }
        if (this.aliasToPfnMap.put(alias, pfn) != null) {
            throw new InternalError("Alias collision should not be possible...");
        }
    }

    @Override
    public Collection<ParserFunctionBase> getParserFunctions() {
        return Collections.unmodifiableCollection(this.parserFunctions.values());
    }

    @Override
    public ParserFunctionBase getParserFunction(String name) {
        I18nAliasImpl alias = this.getI18nAlias(name);
        if (alias == null) {
            return null;
        }
        ParserFunctionBase pfn = this.aliasToPfnMap.get(alias);
        if (pfn != null && pfn.isPageSwitch()) {
            return null;
        }
        return pfn;
    }

    @Override
    public ParserFunctionBase getPageSwitch(String name) {
        I18nAliasImpl alias = this.getI18nAlias(name);
        if (alias == null) {
            return null;
        }
        ParserFunctionBase pfn = this.aliasToPfnMap.get(alias);
        if (pfn != null && !pfn.isPageSwitch()) {
            return null;
        }
        return pfn;
    }

    public void addTagExtensionGroup(TagExtensionGroup tagExtGroup) {
        TagExtensionGroup old = this.tagExtGroups.get(tagExtGroup.getName());
        if (old == tagExtGroup) {
            throw new IllegalArgumentException("The tag extension group `" + tagExtGroup.getName() + "' is already registered.");
        }
        if (old != null) {
            throw new IllegalArgumentException("A tag extension group with the same name `" + tagExtGroup.getName() + "' is already registered.");
        }
        for (TagExtensionBase tagExt : tagExtGroup.getTagExtensions()) {
            this.addTagExtension(tagExt);
        }
        this.tagExtGroups.put(tagExtGroup.getName(), tagExtGroup);
    }

    protected void addTagExtension(TagExtensionBase tagExt) {
        TagExtensionBase old = this.tagExtensions.get(tagExt.getId());
        if (old == tagExt) {
            throw new IllegalArgumentException("The tag extension `" + tagExt.getId() + "' is already registered.");
        }
        if (old != null) {
            throw new IllegalArgumentException("A tag extension with the same id `" + tagExt.getId() + "' is already registered.");
        }
        this.tagExtensions.put(tagExt.getId(), tagExt);
    }

    @Override
    public Collection<TagExtensionBase> getTagExtensions() {
        return Collections.unmodifiableCollection(this.tagExtensions.values());
    }

    @Override
    public TagExtensionBase getTagExtension(String name) {
        return this.tagExtensions.get(name);
    }

    public void setSiteName(String siteName) {
        this.siteName = siteName;
    }

    @Override
    public String getSiteName() {
        return this.siteName;
    }

    public void setWikiUrl(String wikiUrl) {
        this.wikiUrl = wikiUrl;
    }

    @Override
    public String getWikiUrl() {
        return this.wikiUrl;
    }

    @Override
    public String getArticlePath() {
        return this.getWikiUrl() + "?title=$1";
    }

    public void setContentLang(String contentLang) {
        this.contentLang = contentLang;
    }

    @Override
    public String getContentLanguage() {
        return this.contentLang;
    }

    public void setIwPrefix(String iwPrefix) {
        this.iwPrefix = iwPrefix;
    }

    @Override
    public String getInterwikiPrefix() {
        return this.iwPrefix;
    }

    @Override
    public TimeZone getTimezone() {
        return TimeZone.getDefault();
    }

    @Override
    public WikiRuntimeInfo getRuntimeInfo() {
        return this.runtimeInfo;
    }

    public void setRuntimeInfo(WikiRuntimeInfo runtimeInfo) {
        this.runtimeInfo = runtimeInfo;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.aliases == null ? 0 : this.aliases.hashCode());
        result = 31 * result + (this.engineConfig == null ? 0 : this.engineConfig.hashCode());
        result = 31 * result + (this.contentLang == null ? 0 : this.contentLang.hashCode());
        result = 31 * result + (this.defaultNamespace == null ? 0 : this.defaultNamespace.hashCode());
        result = 31 * result + (this.iwPrefix == null ? 0 : this.iwPrefix.hashCode());
        result = 31 * result + (this.namespaceById == null ? 0 : this.namespaceById.hashCode());
        result = 31 * result + (this.parserConfig == null ? 0 : this.parserConfig.hashCode());
        result = 31 * result + (this.pfnGroups == null ? 0 : this.pfnGroups.hashCode());
        result = 31 * result + (this.prefixToInterwikiMap == null ? 0 : this.prefixToInterwikiMap.hashCode());
        result = 31 * result + (this.tagExtGroups == null ? 0 : this.tagExtGroups.hashCode());
        result = 31 * result + (this.templateNamespace == null ? 0 : this.templateNamespace.hashCode());
        result = 31 * result + (this.wikiUrl == null ? 0 : this.wikiUrl.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        WikiConfigImpl other = (WikiConfigImpl)obj;
        if (this.aliases == null ? other.aliases != null : !this.aliases.equals(other.aliases)) {
            return false;
        }
        if (this.engineConfig == null ? other.engineConfig != null : !this.engineConfig.equals(other.engineConfig)) {
            return false;
        }
        if (this.contentLang == null ? other.contentLang != null : !this.contentLang.equals(other.contentLang)) {
            return false;
        }
        if (this.defaultNamespace == null ? other.defaultNamespace != null : !this.defaultNamespace.equals(other.defaultNamespace)) {
            return false;
        }
        if (this.iwPrefix == null ? other.iwPrefix != null : !this.iwPrefix.equals(other.iwPrefix)) {
            return false;
        }
        if (this.namespaceById == null ? other.namespaceById != null : !this.namespaceById.equals(other.namespaceById)) {
            return false;
        }
        if (this.parserConfig == null ? other.parserConfig != null : !this.parserConfig.equals(other.parserConfig)) {
            return false;
        }
        if (this.pfnGroups == null ? other.pfnGroups != null : !this.pfnGroups.equals(other.pfnGroups)) {
            return false;
        }
        if (this.prefixToInterwikiMap == null ? other.prefixToInterwikiMap != null : !this.prefixToInterwikiMap.equals(other.prefixToInterwikiMap)) {
            return false;
        }
        if (this.tagExtGroups == null ? other.tagExtGroups != null : !this.tagExtGroups.equals(other.tagExtGroups)) {
            return false;
        }
        if (this.templateNamespace == null ? other.templateNamespace != null : !this.templateNamespace.equals(other.templateNamespace)) {
            return false;
        }
        return !(this.wikiUrl == null ? other.wikiUrl != null : !this.wikiUrl.equals(other.wikiUrl));
    }

    public void save(File file) throws JAXBException {
        this.createMarshaller().marshal((Object)this, file);
    }

    public void save(Writer writer) throws JAXBException {
        this.createMarshaller().marshal((Object)this, writer);
    }

    public void save(OutputStream out) throws JAXBException {
        this.createMarshaller().marshal((Object)this, out);
    }

    public JAXBSource getAsJAXBSource() throws JAXBException {
        return new JAXBSource(this.createMarshaller(), (Object)this);
    }

    private Marshaller createMarshaller() throws JAXBException {
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{WikiConfigImpl.class});
        Marshaller m = context.createMarshaller();
        m.setEventHandler(new ValidationEventHandler(){

            public boolean handleEvent(ValidationEvent event) {
                System.err.println(event);
                return true;
            }
        });
        try {
            m.setProperty("com.sun.xml.bind.namespacePrefixMapper", (Object)new NamespaceMapper());
            m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        }
        catch (PropertyException propertyException) {
            // empty catch block
        }
        return m;
    }

    public static WikiConfigImpl load(File file) throws JAXBException {
        return WikiConfigImpl.finishImport((WikiConfigImpl)WikiConfigImpl.createUnmarshaller().unmarshal(file));
    }

    public static WikiConfigImpl load(Reader reader) throws JAXBException {
        return WikiConfigImpl.finishImport((WikiConfigImpl)WikiConfigImpl.createUnmarshaller().unmarshal(reader));
    }

    public static WikiConfigImpl load(InputStream in) throws JAXBException {
        return WikiConfigImpl.finishImport((WikiConfigImpl)WikiConfigImpl.createUnmarshaller().unmarshal(in));
    }

    public static WikiConfigImpl load(Source in) throws JAXBException {
        return WikiConfigImpl.finishImport((WikiConfigImpl)WikiConfigImpl.createUnmarshaller().unmarshal(in));
    }

    private static WikiConfigImpl finishImport(WikiConfigImpl config) {
        for (ParserFunctionBase pf : config.getParserFunctions()) {
            pf.setWikiConfig(config);
        }
        for (TagExtensionBase te : config.getTagExtensions()) {
            te.setWikiConfig(config);
        }
        config.parserConfig.setWikiConfig(config);
        config.nodeFactory = new EngineNodeFactoryImpl(config.parserConfig);
        return config;
    }

    private static Unmarshaller createUnmarshaller() throws JAXBException {
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{WikiConfigImpl.class});
        Unmarshaller m = context.createUnmarshaller();
        m.setEventHandler(new ValidationEventHandler(){

            public boolean handleEvent(ValidationEvent event) {
                return false;
            }
        });
        return m;
    }

    @XmlElement(name="i18nAlias")
    @XmlElementWrapper(name="i18nAliases")
    private I18nAliasImpl[] getJaxbAliases() {
        Object[] jaxbAliases = this.aliases.values().toArray(new I18nAliasImpl[this.aliases.size()]);
        Arrays.sort(jaxbAliases);
        return jaxbAliases;
    }

    private void setJaxbAliases(I18nAliasImpl[] aliases) {
        for (I18nAliasImpl alias : aliases) {
            this.addI18nAlias(alias);
        }
    }

    @XmlElement(name="pfnGroup")
    @XmlElementWrapper(name="pfnGroups")
    private ParserFunctionGroup[] getJaxbPfnGroups() {
        Object[] jaxbPfnGroups = this.pfnGroups.values().toArray(new ParserFunctionGroup[this.pfnGroups.size()]);
        Arrays.sort(jaxbPfnGroups);
        return jaxbPfnGroups;
    }

    private void setJaxbPfnGroups(ParserFunctionGroup[] pfnGroups) {
        for (ParserFunctionGroup pfnGroup : pfnGroups) {
            this.addParserFunctionGroup(pfnGroup);
        }
    }

    @XmlElement(name="tagExtGroup")
    @XmlElementWrapper(name="tagExtGroups")
    private TagExtensionGroup[] getJaxbTagExtGroups() {
        Object[] jaxbTagExtGroups = this.tagExtGroups.values().toArray(new TagExtensionGroup[this.tagExtGroups.size()]);
        Arrays.sort(jaxbTagExtGroups);
        return jaxbTagExtGroups;
    }

    private void setJaxbTagExtGroups(TagExtensionGroup[] tagExtGroups) {
        for (TagExtensionGroup tagExtGroup : tagExtGroups) {
            this.addTagExtensionGroup(tagExtGroup);
        }
    }

    @XmlElement(name="interwiki")
    @XmlElementWrapper(name="interwikis")
    private InterwikiImpl[] getJaxbInterwikis() {
        Object[] jaxbInterwikis = this.prefixToInterwikiMap.values().toArray(new InterwikiImpl[this.prefixToInterwikiMap.size()]);
        Arrays.sort(jaxbInterwikis);
        return jaxbInterwikis;
    }

    private void setJaxbInterwikis(InterwikiImpl[] interwikis) {
        for (InterwikiImpl iw : interwikis) {
            this.addInterwiki(iw);
        }
    }

    @XmlElement(name="namespaces")
    private Namespaces getJaxbNamespaces() {
        return new Namespaces(this.namespaceById.values().toArray(new NamespaceImpl[this.namespaceById.size()]), this.defaultNamespace.getId(), this.templateNamespace.getId());
    }

    private void setJaxbNamespaces(Namespaces namespaces) {
        for (NamespaceImpl ns : namespaces.namespaces) {
            this.addNamespace(ns);
        }
        this.setDefaultNamespace(this.getNamespace(namespaces.defaultNsId));
        this.setTemplateNamespace(this.getNamespace(namespaces.templateNsId));
    }

    private static final class Namespaces {
        @XmlElement(name="namespace")
        private NamespaceImpl[] namespaces;
        @XmlAttribute
        private int defaultNsId;
        @XmlAttribute
        private int templateNsId;

        public Namespaces() {
        }

        public Namespaces(NamespaceImpl[] namespaces, int defId, int tmplId) {
            Arrays.sort(namespaces);
            this.namespaces = namespaces;
            this.defaultNsId = defId;
            this.templateNsId = tmplId;
        }
    }

    private static final class NamespaceMapper
    extends NamespacePrefixMapper {
        private static final String SWC_ENGINE_PREFIX = "swc-engine";
        private static final String SWC_ENGINE_URI = "org.sweble.wikitext.engine";

        private NamespaceMapper() {
        }

        public String getPreferredPrefix(String namespaceUri, String suggestion, boolean requirePrefix) {
            if (SWC_ENGINE_URI.equals(namespaceUri)) {
                return SWC_ENGINE_PREFIX;
            }
            return suggestion;
        }

        public String[] getPreDeclaredNamespaceUris() {
            return new String[]{SWC_ENGINE_URI};
        }
    }
}

