/*
 * Decompiled with CFR 0.152.
 */
package org.sweble.wikitext.engine.ext.core;

import java.util.List;
import org.sweble.wikitext.engine.ExpansionFrame;
import org.sweble.wikitext.engine.PageTitle;
import org.sweble.wikitext.engine.PfnArgumentMode;
import org.sweble.wikitext.engine.config.Namespace;
import org.sweble.wikitext.engine.config.ParserFunctionGroup;
import org.sweble.wikitext.engine.config.WikiConfig;
import org.sweble.wikitext.engine.ext.core.CorePfnVariable;
import org.sweble.wikitext.engine.utils.UrlEncoding;
import org.sweble.wikitext.parser.nodes.WtNode;
import org.sweble.wikitext.parser.nodes.WtTemplate;
import org.sweble.wikitext.parser.parser.LinkTargetException;
import org.sweble.wikitext.parser.utils.StringConversionException;

public class CorePfnVariablesPageNames
extends ParserFunctionGroup {
    private static final long serialVersionUID = 1L;

    protected CorePfnVariablesPageNames(WikiConfig wikiConfig) {
        super("Core - Variables - Page names");
        this.addParserFunction(new FullPagenamePfn(wikiConfig));
        this.addParserFunction(new FullPagenameePfn(wikiConfig));
        this.addParserFunction(new PagenamePfn(wikiConfig));
        this.addParserFunction(new PagenameePfn(wikiConfig));
        this.addParserFunction(new BasePagenamePfn(wikiConfig));
        this.addParserFunction(new SubjectPagenamePfn(wikiConfig));
        this.addParserFunction(new TalkPagenamePfn(wikiConfig));
    }

    public static CorePfnVariablesPageNames group(WikiConfig wikiConfig) {
        return new CorePfnVariablesPageNames(wikiConfig);
    }

    public static final class TalkPagenamePfn
    extends CorePfnVariable {
        private static final long serialVersionUID = 1L;

        public TalkPagenamePfn() {
            super(PfnArgumentMode.EXPANDED_AND_TRIMMED_VALUES, "talkpagename");
        }

        public TalkPagenamePfn(WikiConfig wikiConfig) {
            super(wikiConfig, PfnArgumentMode.EXPANDED_AND_TRIMMED_VALUES, "talkpagename");
        }

        @Override
        public WtNode invoke(WtTemplate var, ExpansionFrame frame, List<? extends WtNode> argsValues) {
            Namespace ns;
            WikiConfig config;
            Namespace talkNs;
            PageTitle title = frame.getRootFrame().getTitle();
            if (!argsValues.isEmpty()) {
                try {
                    String titleStr = this.tu().astToText(argsValues.get(0)).trim();
                    title = PageTitle.make(frame.getWikiConfig(), titleStr);
                }
                catch (StringConversionException e) {
                    return var;
                }
                catch (LinkTargetException e) {
                    return var;
                }
            }
            if ((talkNs = (config = frame.getWikiConfig()).getTalkNamespaceFor(ns = title.getNamespace())) != ns) {
                title = title.newWithNamespace(talkNs);
            }
            return this.nf().text(title.getDenormalizedFullTitle());
        }
    }

    public static final class SubjectPagenamePfn
    extends CorePfnVariable {
        private static final long serialVersionUID = 1L;

        public SubjectPagenamePfn() {
            super("subjectpagename");
        }

        public SubjectPagenamePfn(WikiConfig wikiConfig) {
            super(wikiConfig, "subjectpagename");
        }

        @Override
        protected final WtNode invoke(WtTemplate var, ExpansionFrame frame) {
            return this.invokeStatic(frame);
        }

        protected WtNode invokeStatic(ExpansionFrame frame) {
            PageTitle title;
            Namespace ns;
            WikiConfig config = frame.getWikiConfig();
            Namespace subjectNs = config.getSubjectNamespaceFor(ns = (title = frame.getRootFrame().getTitle()).getNamespace());
            if (subjectNs != ns) {
                title = title.newWithNamespace(subjectNs);
            }
            return this.nf().text(title.getDenormalizedFullTitle());
        }
    }

    public static final class BasePagenamePfn
    extends CorePfnVariable {
        private static final long serialVersionUID = 1L;

        public BasePagenamePfn() {
            super("basepagename");
        }

        public BasePagenamePfn(WikiConfig wikiConfig) {
            super(wikiConfig, "basepagename");
        }

        @Override
        protected final WtNode invoke(WtTemplate var, ExpansionFrame frame) {
            return this.nf().text(frame.getRootFrame().getTitle().getBaseTitle().getDenormalizedFullTitle());
        }
    }

    public static final class PagenameePfn
    extends CorePfnVariable {
        private static final long serialVersionUID = 1L;

        public PagenameePfn() {
            super(PfnArgumentMode.EXPANDED_AND_TRIMMED_VALUES, "pagenamee");
        }

        public PagenameePfn(WikiConfig wikiConfig) {
            super(wikiConfig, PfnArgumentMode.EXPANDED_AND_TRIMMED_VALUES, "pagenamee");
        }

        @Override
        public WtNode invoke(WtTemplate var, ExpansionFrame frame, List<? extends WtNode> argsValues) {
            PageTitle title = frame.getRootFrame().getTitle();
            if (!argsValues.isEmpty()) {
                try {
                    String titleStr = this.tu().astToText(argsValues.get(0)).trim();
                    title = PageTitle.make(frame.getWikiConfig(), titleStr);
                }
                catch (StringConversionException e) {
                    return var;
                }
                catch (LinkTargetException e) {
                    return var;
                }
            }
            String link = title.getTitle();
            return this.nf().text(UrlEncoding.WIKI.encode(link));
        }
    }

    public static final class PagenamePfn
    extends CorePfnVariable {
        private static final long serialVersionUID = 1L;

        public PagenamePfn() {
            super("pagename");
        }

        public PagenamePfn(WikiConfig wikiConfig) {
            super(wikiConfig, "pagename");
        }

        @Override
        protected final WtNode invoke(WtTemplate var, ExpansionFrame frame) {
            return this.nf().text(frame.getRootFrame().getTitle().getDenormalizedTitle());
        }
    }

    public static final class FullPagenameePfn
    extends CorePfnVariable {
        private static final long serialVersionUID = 1L;

        public FullPagenameePfn() {
            super("fullpagenamee");
        }

        public FullPagenameePfn(WikiConfig wikiConfig) {
            super(wikiConfig, "fullpagenamee");
        }

        @Override
        protected final WtNode invoke(WtTemplate var, ExpansionFrame frame) {
            return this.nf().text(UrlEncoding.WIKI.encode(frame.getRootFrame().getTitle().getNormalizedFullTitle()));
        }
    }

    public static final class FullPagenamePfn
    extends CorePfnVariable {
        private static final long serialVersionUID = 1L;

        public FullPagenamePfn() {
            super("fullpagename");
        }

        public FullPagenamePfn(WikiConfig wikiConfig) {
            super(wikiConfig, "fullpagename");
        }

        @Override
        protected final WtNode invoke(WtTemplate var, ExpansionFrame frame) {
            return this.nf().text(frame.getRootFrame().getTitle().getDenormalizedFullTitle());
        }
    }
}

