/*
 * Decompiled with CFR 0.152.
 */
package org.sweble.wikitext.engine.ext.parser_functions;

import java.util.List;
import org.sweble.wikitext.engine.ExpansionFrame;
import org.sweble.wikitext.engine.PageTitle;
import org.sweble.wikitext.engine.config.WikiConfig;
import org.sweble.wikitext.engine.ext.parser_functions.ParserFunctionsExtPfn;
import org.sweble.wikitext.parser.nodes.WtNode;
import org.sweble.wikitext.parser.nodes.WtTemplate;
import org.sweble.wikitext.parser.parser.LinkTargetException;
import org.sweble.wikitext.parser.utils.StringConversionException;

public class ParserFunctionIfExist
extends ParserFunctionsExtPfn.IfThenElseStmt {
    private static final long serialVersionUID = 1L;

    public ParserFunctionIfExist() {
        super("ifexist", 1);
    }

    public ParserFunctionIfExist(WikiConfig wikiConfig) {
        super(wikiConfig, "ifexist", 1);
    }

    @Override
    protected boolean evaluateCondition(WtTemplate pfn, ExpansionFrame frame, List<? extends WtNode> args) {
        WtNode test = frame.expand(args.get(0));
        String testStr = null;
        try {
            testStr = this.tu().astToText(test).trim();
            PageTitle pageTitle = PageTitle.make(frame.getWikiConfig(), testStr);
            return frame.existsPage(pageTitle);
        }
        catch (StringConversionException e1) {
            return false;
        }
        catch (LinkTargetException e) {
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }
}

