/*
 * Decompiled with CFR 0.152.
 */
package org.sweble.wikitext.engine.ext.parser_functions;

import java.util.List;
import org.sweble.wikitext.engine.ExpansionFrame;
import org.sweble.wikitext.engine.config.WikiConfig;
import org.sweble.wikitext.engine.ext.parser_functions.ParserFunctionsExtPfn;
import org.sweble.wikitext.parser.nodes.WtNode;
import org.sweble.wikitext.parser.nodes.WtNodeList;
import org.sweble.wikitext.parser.nodes.WtTemplate;
import org.sweble.wikitext.parser.nodes.WtText;
import org.sweble.wikitext.parser.utils.StringConversionException;

public class ParserFunctionSwitch
extends ParserFunctionsExtPfn.CtrlStmt {
    private static final long serialVersionUID = 1L;

    public ParserFunctionSwitch() {
        super("switch");
    }

    public ParserFunctionSwitch(WikiConfig wikiConfig) {
        super(wikiConfig, "switch");
    }

    @Override
    protected WtNode evaluate(WtTemplate pfn, ExpansionFrame frame, List<? extends WtNode> args) {
        if (args.size() < 1) {
            return this.nf().list();
        }
        return new Evaluator(frame, args).evaluate();
    }

    private final class Evaluator {
        private ExpansionFrame frame;
        private List<? extends WtNode> args;
        private WtNodeList after;
        private WtNodeList before;
        private WtNode result;

        public Evaluator(ExpansionFrame frame, List<? extends WtNode> args) {
            this.frame = frame;
            this.args = args;
        }

        public WtNode evaluate() {
            WtNode arg0 = this.frame.expand(this.args.get(0));
            String cmp = null;
            Double icmp = null;
            try {
                cmp = ParserFunctionSwitch.this.tu().astToText(arg0).trim();
                icmp = this.strToDbl(cmp);
            }
            catch (StringConversionException e) {
                // empty catch block
            }
            boolean found = false;
            this.result = null;
            for (int i = 1; i < this.args.size(); ++i) {
                this.after = null;
                this.before = ParserFunctionSwitch.this.nf().list();
                if (this.args.get(i).isNodeType(2)) {
                    this.splitNodeListAtEquals(i);
                } else {
                    WtNode c = this.args.get(i);
                    if (c.isNodeType(4097)) {
                        this.splitTextAtEquals(c);
                    }
                }
                if (!found) {
                    found = this.compare(cmp, icmp);
                }
                if (!found || this.after == null) continue;
                this.result = this.after;
                break;
            }
            if (this.before != null && this.after == null && this.result == null) {
                this.result = this.before;
            }
            return this.result;
        }

        private boolean compare(String cmp, Double icmp) {
            Double icmp2;
            String cmp2;
            this.before = (WtNodeList)this.frame.expand((WtNode)this.before);
            try {
                cmp2 = ParserFunctionSwitch.this.tu().astToText((WtNode)this.before).trim();
            }
            catch (StringConversionException e) {
                return false;
            }
            if (cmp2.equals("#default")) {
                this.result = this.after;
                return false;
            }
            if (icmp != null && cmp2 != null && icmp.equals(icmp2 = this.strToDbl(cmp2))) {
                return true;
            }
            return cmp != null && cmp.equals(cmp2);
        }

        private Double strToDbl(String str) {
            try {
                return Double.parseDouble(str);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }

        private void splitNodeListAtEquals(int i) {
            for (WtNode c : this.args.get(i)) {
                if (this.after == null) {
                    if (c.isNodeType(4097)) {
                        this.splitTextAtEquals(c);
                        continue;
                    }
                    this.before.add((Object)c);
                    continue;
                }
                this.after.add((Object)c);
            }
        }

        private void splitTextAtEquals(WtNode c) {
            String text = ((WtText)c).getContent();
            int j = text.indexOf(61);
            if (j != -1) {
                this.before.add((Object)ParserFunctionSwitch.this.nf().text(text.substring(0, j)));
                this.after = ParserFunctionSwitch.this.nf().list((WtNode)ParserFunctionSwitch.this.nf().text(text.substring(j + 1)));
            } else {
                this.before.add((Object)c);
            }
        }
    }
}

