/*
 * Decompiled with CFR 0.152.
 */
package org.sweble.wikitext.engine.ext.parser_functions;

import de.fau.cs.osr.utils.StringUtils;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import org.sweble.wikitext.engine.ExpansionFrame;
import org.sweble.wikitext.engine.config.WikiConfig;
import org.sweble.wikitext.engine.ext.parser_functions.ParserFunctionsExtPfn;
import org.sweble.wikitext.engine.nodes.EngSoftErrorNode;
import org.sweble.wikitext.engine.nodes.EngineRtData;
import org.sweble.wikitext.parser.nodes.WtNode;
import org.sweble.wikitext.parser.nodes.WtTemplate;
import org.sweble.wikitext.parser.utils.StringConversionException;

public class ParserFunctionTime
extends ParserFunctionsExtPfn {
    private static final long serialVersionUID = 1L;

    public ParserFunctionTime() {
        super("time");
    }

    public ParserFunctionTime(WikiConfig wikiConfig) {
        super(wikiConfig, "time");
    }

    @Override
    public WtNode invoke(WtTemplate pfn, ExpansionFrame frame, List<? extends WtNode> args) {
        if (args.size() < 1) {
            return pfn;
        }
        String format = this.expandArgToString(frame, args, 0);
        if (format == null) {
            return this.error(this._("Cannot convert format argument to string!", new Object[0]));
        }
        String timestampStr = null;
        if (args.size() >= 2 && (timestampStr = this.expandArgToString(frame, args, 1)) == null) {
            return this.error(this._("Cannot convert timestamp argument to string!", new Object[0]));
        }
        if (timestampStr != null && !timestampStr.isEmpty()) {
            return this.notYetImplemented(this._("Cannot handle non-empty timestamp argument!", new Object[0]));
        }
        String languageTag = null;
        if (args.size() >= 3 && (languageTag = this.expandArgToString(frame, args, 2)) == null) {
            return this.error(this._("Cannot convert language argument to string!", new Object[0]));
        }
        if (languageTag != null && !languageTag.isEmpty()) {
            return this.notYetImplemented(this._("Cannot handle non-empty language argument!", new Object[0]));
        }
        languageTag = "en";
        Locale locale = new Locale(languageTag);
        Calendar timestamp = this.getWikiConfig().getRuntimeInfo().getDateAndTime(locale);
        return this.format(format, timestamp, locale);
    }

    private WtNode format(String format, Calendar timestamp, Locale locale) {
        StringBuilder sb = new StringBuilder();
        block5: for (int i = 0; i < format.length(); ++i) {
            char ch = format.charAt(i);
            switch (ch) {
                case 'j': {
                    sb.append(timestamp.get(5));
                    continue block5;
                }
                case 'Y': {
                    sb.append(timestamp.get(1));
                    continue block5;
                }
                case 'F': {
                    sb.append(timestamp.getDisplayName(2, 2, locale));
                    continue block5;
                }
                default: {
                    sb.append(ch);
                }
            }
        }
        return this.nf().text(sb.toString());
    }

    private String _(String string, Object ... args) {
        return string;
    }

    private String expandArgToString(ExpansionFrame preprocessorFrame, List<? extends WtNode> args, int index) {
        WtNode arg = preprocessorFrame.expand(args.get(index));
        this.tu().trim(arg);
        String format = null;
        try {
            format = this.tu().astToText(arg).trim();
        }
        catch (StringConversionException e1) {
            // empty catch block
        }
        return format;
    }

    private EngSoftErrorNode error(String msg) {
        return EngineRtData.set(this.nf().softError(EngineRtData.set(this.nf().nowiki(StringUtils.escHtml((String)msg)))));
    }

    private EngSoftErrorNode notYetImplemented(String msg) {
        return this.nf().addCssClass(EngineRtData.set(this.nf().softError(EngineRtData.set(this.nf().nowiki(StringUtils.escHtml((String)msg))))), "not-yet-implemented");
    }
}

