/*
 * Decompiled with CFR 0.152.
 */
package org.sweble.wikitext.engine.utils;

import de.fau.cs.osr.ptk.common.AstPrinter;
import de.fau.cs.osr.ptk.common.ast.AstNode;
import org.sweble.wikitext.engine.ExpansionCallback;
import org.sweble.wikitext.engine.ExpansionFrame;
import org.sweble.wikitext.engine.FullPage;
import org.sweble.wikitext.engine.PageId;
import org.sweble.wikitext.engine.PageTitle;
import org.sweble.wikitext.engine.WtEngineImpl;
import org.sweble.wikitext.engine.config.WikiConfig;
import org.sweble.wikitext.engine.config.WikiConfigImpl;
import org.sweble.wikitext.engine.nodes.EngProcessedPage;
import org.sweble.wikitext.engine.utils.DefaultConfigEnWp;

public class WtEngineToolbox {
    private WikiConfigImpl wikiConfig;
    private WtEngineImpl engine;

    public WtEngineToolbox() {
        this.restartEngine(DefaultConfigEnWp.generate());
    }

    public void restartEngine(WikiConfigImpl wikiConfig) {
        this.wikiConfig = wikiConfig;
        this.engine = new WtEngineImpl(wikiConfig);
    }

    public WikiConfigImpl getWikiConfig() {
        return this.wikiConfig;
    }

    public WtEngineImpl getEngine() {
        return this.engine;
    }

    public PageId makePageId(String title) throws Exception {
        return WtEngineToolbox.makePageId(this.wikiConfig, title);
    }

    public PageId makePageId(String title, long id) throws Exception {
        return WtEngineToolbox.makePageId(this.wikiConfig, title, id);
    }

    public static PageId makePageId(WikiConfig wikiConfig, String title) throws Exception {
        return WtEngineToolbox.makePageId(wikiConfig, title, -1L);
    }

    public static PageId makePageId(WikiConfig wikiConfig, String title, long id) throws Exception {
        PageTitle pageTitle = PageTitle.make(wikiConfig, title);
        return new PageId(pageTitle, id);
    }

    public EngProcessedPage wmToAst(PageId pageId, String wikitext) throws Exception {
        return this.wmToAst(pageId, wikitext, new TestExpansionCallback());
    }

    public EngProcessedPage wmToAst(PageId pageId, String wikitext, ExpansionCallback callback) throws Exception {
        return this.engine.postprocess(pageId, wikitext, callback);
    }

    public static String printAst(EngProcessedPage ast) {
        return AstPrinter.print((AstNode)ast.getPage());
    }

    public static final class TestExpansionCallback
    implements ExpansionCallback {
        @Override
        public FullPage retrieveWikitext(ExpansionFrame expansionFrame, PageTitle pageTitle) throws Exception {
            return null;
        }

        @Override
        public String fileUrl(PageTitle pageTitle, int width, int height) throws Exception {
            return null;
        }
    }
}

