/*
 * Decompiled with CFR 0.152.
 */
package play.core.server.common;

import play.api.http.HeaderNames$;
import play.api.http.HttpProtocol$;
import play.api.http.Writeable$;
import play.api.libs.iteratee.Concurrent$;
import play.api.libs.iteratee.Done$;
import play.api.libs.iteratee.Enumerator;
import play.api.libs.iteratee.Enumerator$;
import play.api.libs.iteratee.Execution;
import play.api.libs.iteratee.Input;
import play.api.libs.iteratee.Iteratee;
import play.api.libs.iteratee.Iteratee$;
import play.api.mvc.Codec$;
import play.api.mvc.Cookie;
import play.api.mvc.Cookies$;
import play.api.mvc.Flash;
import play.api.mvc.Flash$;
import play.api.mvc.HttpConnection$;
import play.api.mvc.RequestHeader;
import play.api.mvc.Result;
import play.api.mvc.Results$;
import play.core.server.common.ServerResultUtils;
import play.core.server.common.ServerResultUtils$;
import play.core.server.common.ServerResultUtils$DefaultClose$;
import play.core.server.common.ServerResultUtils$DefaultKeepAlive$;
import play.core.server.common.ServerResultUtils$SendClose$;
import play.core.server.common.ServerResultUtils$SendKeepAlive$;
import play.core.server.common.ServerResultUtils$StreamWithNoBody$;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class ServerResultUtils$ {
    public static final ServerResultUtils$ MODULE$;
    private final byte[] play$core$server$common$ServerResultUtils$$emptyBytes;
    private final String play$core$server$common$ServerResultUtils$$KEEP_ALIVE;
    private final String play$core$server$common$ServerResultUtils$$CLOSE;

    static {
        new ServerResultUtils$();
    }

    public byte[] play$core$server$common$ServerResultUtils$$emptyBytes() {
        return this.play$core$server$common$ServerResultUtils$$emptyBytes;
    }

    public String play$core$server$common$ServerResultUtils$$KEEP_ALIVE() {
        return this.play$core$server$common$ServerResultUtils$$KEEP_ALIVE;
    }

    public String play$core$server$common$ServerResultUtils$$CLOSE() {
        return this.play$core$server$common$ServerResultUtils$$CLOSE;
    }

    public Future<Either<ServerResultUtils.InvalidResult, Tuple2<ServerResultUtils.ResultStreaming, ServerResultUtils.ConnectionHeader>>> determineResultStreaming(RequestHeader requestHeader, Result result) {
        Future future;
        boolean needsClose;
        String string = requestHeader.version();
        String string2 = HttpProtocol$.MODULE$.HTTP_1_0();
        boolean isHttp10 = !(string != null ? !string.equals(string2) : string2 != null);
        Enumeration.Value value = result.connection();
        Enumeration.Value value2 = HttpConnection$.MODULE$.Close();
        boolean forceClose = !(value != null ? !value.equals(value2) : value2 != null);
        boolean bl = needsClose = forceClose || this.defaultClose$1(requestHeader, isHttp10);
        Product connection = needsClose ? (isHttp10 ? ServerResultUtils$DefaultClose$.MODULE$ : ServerResultUtils$SendClose$.MODULE$) : (isHttp10 ? ServerResultUtils$SendKeepAlive$.MODULE$ : ServerResultUtils$DefaultKeepAlive$.MODULE$);
        Result result2 = result;
        if (result.header().headers().exists((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<String, String> x$2) {
                return x$2._2() == null;
            }
        })) {
            future = this.invalid$1("A header was set to null", Results$.MODULE$.InternalServerError().apply((Object)"", Writeable$.MODULE$.wString(Codec$.MODULE$.utf_8())));
        } else if (result.header().status() == 204 || result.header().status() == 304) {
            future = this.valid$1(ServerResultUtils$StreamWithNoBody$.MODULE$, (ServerResultUtils.ConnectionHeader)connection);
        } else if (result.header().headers().contains((Object)HeaderNames$.MODULE$.TRANSFER_ENCODING())) {
            future = isHttp10 ? this.invalid$1("Chunked response to HTTP/1.0 request", Results$.MODULE$.HttpVersionNotSupported().apply((Object)"The response to this request is chunked and hence requires HTTP 1.1 to be sent, but this is a HTTP 1.0 request.", Writeable$.MODULE$.wString(Codec$.MODULE$.utf_8()))) : this.valid$1(new ServerResultUtils.UseExistingTransferEncoding((Enumerator<byte[]>)result.body()), (ServerResultUtils.ConnectionHeader)connection);
        } else if (result.header().headers().contains((Object)HeaderNames$.MODULE$.CONTENT_LENGTH())) {
            future = this.valid$1(new ServerResultUtils.StreamWithKnownLength((Enumerator<byte[]>)result.body()), (ServerResultUtils.ConnectionHeader)connection);
        } else if (connection.willClose()) {
            future = this.valid$1(new ServerResultUtils.StreamWithClose((Enumerator<byte[]>)result.body()), (ServerResultUtils.ConnectionHeader)connection);
        } else {
            Future bodyReadAhead = this.readAheadOne(result.body().$greater$greater$greater(Enumerator$.MODULE$.eof()));
            future = bodyReadAhead.map((Function1)new Serializable(isHttp10, (ServerResultUtils.ConnectionHeader)connection){
                public static final long serialVersionUID = 0L;
                private final boolean isHttp10$1;
                private final ServerResultUtils.ConnectionHeader connection$1;

                public final Either<ServerResultUtils.InvalidResult, Tuple2<ServerResultUtils.ResultStreaming, ServerResultUtils.ConnectionHeader>> apply(Either<Option<byte[]>, Enumerator<byte[]>> x0$1) {
                    Either<Option<byte[]>, Enumerator<byte[]>> either;
                    block4: {
                        Right right;
                        block3: {
                            block2: {
                                either = x0$1;
                                if (!(either instanceof Left)) break block2;
                                Left left = (Left)either;
                                Option bodyOption = (Option)left.a();
                                byte[] body = (byte[])bodyOption.getOrElse((Function0)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final byte[] apply() {
                                        return ServerResultUtils$.MODULE$.play$core$server$common$ServerResultUtils$$emptyBytes();
                                    }
                                });
                                right = package$.MODULE$.Right().apply((Object)new Tuple2((Object)new ServerResultUtils.StreamWithStrictBody(body), (Object)this.connection$1));
                                break block3;
                            }
                            if (!(either instanceof Right)) break block4;
                            Right right2 = (Right)either;
                            Enumerator bodyEnum = (Enumerator)right2.b();
                            right = this.isHttp10$1 ? package$.MODULE$.Right().apply((Object)new Tuple2((Object)new ServerResultUtils.StreamWithClose((Enumerator<byte[]>)bodyEnum), (Object)ServerResultUtils$DefaultClose$.MODULE$)) : package$.MODULE$.Right().apply((Object)new Tuple2((Object)new ServerResultUtils.PerformChunkedTransferEncoding((Enumerator<byte[]>)bodyEnum), (Object)this.connection$1));
                        }
                        return right;
                    }
                    throw new MatchError(either);
                }
                {
                    this.isHttp10$1 = isHttp10$1;
                    this.connection$1 = connection$1;
                }
            }, Execution.Implicits$.MODULE$.trampoline());
        }
        return future;
    }

    public <A> Future<Either<Option<A>, Enumerator<A>>> readAheadOne(Enumerator<A> enumerator) {
        Promise result = Promise$.MODULE$.apply();
        Iteratee it = Iteratee$.MODULE$.takeUpTo(1).flatMap((Function1)new Serializable(result){
            public static final long serialVersionUID = 0L;
            public final Promise result$1;

            public final Iteratee<A, BoxedUnit> apply(Seq<A> taken) {
                return Iteratee$.MODULE$.isEmpty().flatMap((Function1)new Serializable(this, taken){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.2 $outer;
                    private final Seq taken$1;

                    public final Iteratee<A, BoxedUnit> apply(boolean emptyAfterTaken) {
                        Tuple2 tuple2;
                        block4: {
                            Iteratee iteratee;
                            block3: {
                                Tuple2 tuple22;
                                block2: {
                                    if (!emptyAfterTaken) break block2;
                                    Predef$.MODULE$.assert(this.taken$1.length() <= 1);
                                    this.$outer.result$1.success((Object)package$.MODULE$.Left().apply((Object)this.taken$1.headOption()));
                                    iteratee = Done$.MODULE$.apply((Object)BoxedUnit.UNIT, (Input)Done$.MODULE$.apply$default$2());
                                    break block3;
                                }
                                tuple2 = Concurrent$.MODULE$.joined();
                                if (tuple2 == null) break block4;
                                Iteratee remainingIt = (Iteratee)tuple2._1();
                                Enumerator remainingEnum = (Enumerator)tuple2._2();
                                Tuple2 tuple23 = tuple22 = new Tuple2((Object)remainingIt, (Object)remainingEnum);
                                Iteratee remainingIt2 = (Iteratee)tuple23._1();
                                Enumerator remainingEnum2 = (Enumerator)tuple23._2();
                                this.$outer.result$1.success((Object)package$.MODULE$.Right().apply((Object)Enumerator$.MODULE$.enumerate((TraversableOnce)this.taken$1, Execution.Implicits$.MODULE$.trampoline()).$greater$greater$greater(remainingEnum2)));
                                iteratee = remainingIt2;
                            }
                            return iteratee.map((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final void apply(BoxedUnit _) {
                                }
                            }, Execution.Implicits$.MODULE$.trampoline());
                        }
                        throw new MatchError((Object)tuple2);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.taken$1 = taken$1;
                    }
                }, Execution.Implicits$.MODULE$.trampoline());
            }
            {
                this.result$1 = result$1;
            }
        }, Execution.Implicits$.MODULE$.trampoline());
        enumerator.apply(it);
        return result.future();
    }

    public Result cleanFlashCookie(RequestHeader requestHeader, Result result) {
        Flash requestFlash;
        Option optResultFlashCookies = result.header().headers().get((Object)HeaderNames$.MODULE$.SET_COOKIE()).flatMap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Option<Cookie> apply(String setCookieValue) {
                return Cookies$.MODULE$.decodeSetCookieHeader(setCookieValue).find((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Cookie x$4) {
                        String string = x$4.name();
                        String string2 = Flash$.MODULE$.COOKIE_NAME();
                        return !(string != null ? !string.equals(string2) : string2 != null);
                    }
                });
            }
        });
        return optResultFlashCookies.isDefined() ? result : ((requestFlash = requestHeader.flash()).isEmpty() ? result : result.withHeaders((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HeaderNames$.MODULE$.SET_COOKIE()), (Object)Cookies$.MODULE$.encodeSetCookieHeader((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Cookie[]{Flash$.MODULE$.discard().toCookie()}))))})));
    }

    public Iterable<Tuple2<String, String>> splitSetCookieHeaders(Map<String, String> headers) {
        return headers.contains((Object)HeaderNames$.MODULE$.SET_COOKIE()) ? (Iterable)((TraversableLike)headers.to(Predef$.MODULE$.fallbackStringCanBuildFrom())).flatMap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final SeqLike<Tuple2<String, String>, Object> apply(Tuple2<String, String> x0$2) {
                Tuple2<String, String> tuple2;
                block4: {
                    SeqLike seqLike;
                    block3: {
                        block2: {
                            tuple2 = x0$2;
                            if (tuple2 == null) break block2;
                            String string = (String)tuple2._1();
                            String value = (String)tuple2._2();
                            String string2 = HeaderNames$.MODULE$.SET_COOKIE();
                            String string3 = string;
                            if (string2 != null ? !string2.equals(string3) : string3 != null) break block2;
                            String[] cookieParts = Cookies$.MODULE$.SetCookieHeaderSeparatorRegex().split((CharSequence)value);
                            seqLike = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])cookieParts).map((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final Tuple2<String, String> apply(String cookiePart) {
                                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HeaderNames$.MODULE$.SET_COOKIE()), (Object)cookiePart);
                                }
                            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))));
                            break block3;
                        }
                        if (tuple2 == null) break block4;
                        String name = (String)tuple2._1();
                        String value = (String)tuple2._2();
                        seqLike = (SeqLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)name, (Object)value)}));
                    }
                    return seqLike;
                }
                throw new MatchError(tuple2);
            }
        }, Seq$.MODULE$.canBuildFrom()) : headers;
    }

    private final boolean requestConnectionHeaderMatches$1(String value, Option requestConnectionHeader$1) {
        return requestConnectionHeader$1.exists((Function1)new Serializable(value){
            public static final long serialVersionUID = 0L;
            private final String value$1;

            public final boolean apply(String x$1) {
                return x$1.equalsIgnoreCase(this.value$1);
            }
            {
                this.value$1 = value$1;
            }
        });
    }

    private final boolean defaultClose$1(RequestHeader requestHeader$1, boolean isHttp10$1) {
        Option requestConnectionHeader = requestHeader$1.headers().get(HeaderNames$.MODULE$.CONNECTION());
        return isHttp10$1 && !this.requestConnectionHeaderMatches$1(this.play$core$server$common$ServerResultUtils$$KEEP_ALIVE(), requestConnectionHeader) || !isHttp10$1 && this.requestConnectionHeaderMatches$1(this.play$core$server$common$ServerResultUtils$$CLOSE(), requestConnectionHeader);
    }

    private final Future invalid$1(String reason, Result alternativeResult) {
        return Future$.MODULE$.successful((Object)package$.MODULE$.Left().apply((Object)new ServerResultUtils.InvalidResult(reason, alternativeResult)));
    }

    private final Future valid$1(ServerResultUtils.ResultStreaming streaming, ServerResultUtils.ConnectionHeader connection) {
        return Future$.MODULE$.successful((Object)package$.MODULE$.Right().apply((Object)new Tuple2((Object)streaming, (Object)connection)));
    }

    private ServerResultUtils$() {
        MODULE$ = this;
        this.play$core$server$common$ServerResultUtils$$emptyBytes = new byte[0];
        this.play$core$server$common$ServerResultUtils$$KEEP_ALIVE = "keep-alive";
        this.play$core$server$common$ServerResultUtils$$CLOSE = "close";
    }
}

