/*
 * Decompiled with CFR 0.152.
 */
package play.core.server.ssl;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPublicKey;
import java.util.Date;
import javax.net.ssl.KeyManagerFactory;
import play.api.Logger;
import play.api.Logger$;
import play.core.server.ssl.FakeKeyStore$;
import play.utils.PlayIO$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Serializable;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.NonLocalReturnControl;
import scala.util.Properties$;
import sun.security.x509.AlgorithmId;
import sun.security.x509.CertificateAlgorithmId;
import sun.security.x509.CertificateIssuerName;
import sun.security.x509.CertificateSerialNumber;
import sun.security.x509.CertificateSubjectName;
import sun.security.x509.CertificateValidity;
import sun.security.x509.CertificateVersion;
import sun.security.x509.CertificateX509Key;
import sun.security.x509.X500Name;
import sun.security.x509.X509CertImpl;
import sun.security.x509.X509CertInfo;

public final class FakeKeyStore$ {
    public static final FakeKeyStore$ MODULE$;
    private final Logger logger;
    private final String GeneratedKeyStore;
    private final String DnName;

    static {
        new FakeKeyStore$();
    }

    private Logger logger() {
        return this.logger;
    }

    public String GeneratedKeyStore() {
        return this.GeneratedKeyStore;
    }

    public String DnName() {
        return this.DnName;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean shouldGenerate(File keyStoreFile) {
        boolean bl;
        Object object = new Object();
        try {
            if (!keyStoreFile.exists()) return true;
            KeyStore store = KeyStore.getInstance("JKS");
            FileInputStream in = new FileInputStream(keyStoreFile);
            try {
                store.load(in, "".toCharArray());
            }
            catch (Throwable throwable) {
                void var5_4;
                PlayIO$.MODULE$.closeQuietly((Closeable)var5_4);
                throw throwable;
            }
            PlayIO$.MODULE$.closeQuietly((Closeable)in);
            ((Iterator)JavaConverters$.MODULE$.enumerationAsScalaIteratorConverter(store.aliases()).asScala()).foreach((Function1)new Serializable(store, object){
                public static final long serialVersionUID = 0L;
                private final KeyStore store$1;
                public final Object nonLocalReturnKey1$1;

                public final Option<BoxedUnit> apply(String alias) {
                    return Option$.MODULE$.apply((Object)this.store$1.getCertificate(alias)).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.shouldGenerate.1 $outer;

                        public final void apply(Certificate c) {
                            RSAPublicKey key = (RSAPublicKey)c.getPublicKey();
                            if (key.getModulus().bitLength() < 2048) {
                                throw new NonLocalReturnControl.mcZ.sp(this.$outer.nonLocalReturnKey1$1, true);
                            }
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                }
                {
                    this.store$1 = store$1;
                    this.nonLocalReturnKey1$1 = nonLocalReturnKey1$1;
                }
            });
            return false;
        }
        catch (NonLocalReturnControl nonLocalReturnControl22) {
            if (nonLocalReturnControl22.key() != object) throw nonLocalReturnControl22;
            bl = nonLocalReturnControl22.value$mcZ$sp();
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public KeyManagerFactory keyManagerFactory(File appPath) {
        KeyStore keyStore;
        block5: {
            File keyStoreFile;
            block4: {
                keyStore = KeyStore.getInstance("JKS");
                keyStoreFile = new File(appPath, this.GeneratedKeyStore());
                if (!this.shouldGenerate(keyStoreFile)) break block4;
                this.logger().info((Function0)new Serializable(keyStoreFile){
                    public static final long serialVersionUID = 0L;
                    private final File keyStoreFile$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Generating HTTPS key pair in ").append((Object)this.keyStoreFile$1.getAbsolutePath()).append((Object)" - this may take some time. If nothing happens, try moving the mouse/typing on the keyboard to generate some entropy.").toString();
                    }
                    {
                        this.keyStoreFile$1 = keyStoreFile$1;
                    }
                });
                KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
                keyPairGenerator.initialize(2048);
                KeyPair keyPair = keyPairGenerator.generateKeyPair();
                X509Certificate cert = this.createSelfSignedCertificate(keyPair);
                keyStore.load(null, "".toCharArray());
                keyStore.setKeyEntry("playgenerated", keyPair.getPrivate(), "".toCharArray(), (Certificate[])((Object[])new Certificate[]{cert}));
                keyStore.setCertificateEntry("playgeneratedtrusted", cert);
                FileOutputStream out = new FileOutputStream(keyStoreFile);
                try {
                    keyStore.store(out, "".toCharArray());
                }
                catch (Throwable throwable) {
                    void var7_7;
                    PlayIO$.MODULE$.closeQuietly((Closeable)var7_7);
                    throw throwable;
                }
                PlayIO$.MODULE$.closeQuietly((Closeable)out);
                break block5;
            }
            FileInputStream in = new FileInputStream(keyStoreFile);
            try {}
            catch (Throwable throwable) {
                void var9_8;
                PlayIO$.MODULE$.closeQuietly((Closeable)var9_8);
                throw throwable;
            }
            keyStore.load(in, "".toCharArray());
            PlayIO$.MODULE$.closeQuietly((Closeable)in);
        }
        KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
        kmf.init(keyStore, "".toCharArray());
        return kmf;
    }

    public X509Certificate createSelfSignedCertificate(KeyPair keyPair) {
        X509CertInfo certInfo = new X509CertInfo();
        certInfo.set("serialNumber", new CertificateSerialNumber(new BigInteger(64, new SecureRandom())));
        certInfo.set("version", new CertificateVersion(2));
        Date validFrom = new Date();
        Date validTo = new Date(validFrom.getTime() + 1576800000000L);
        CertificateValidity validity = new CertificateValidity(validFrom, validTo);
        certInfo.set("validity", validity);
        X500Name owner = new X500Name(this.DnName());
        boolean justName = Properties$.MODULE$.isJavaAtLeast("1.8");
        certInfo.set("subject", justName ? owner : new CertificateSubjectName(owner));
        certInfo.set("issuer", justName ? owner : new CertificateIssuerName(owner));
        certInfo.set("key", new CertificateX509Key(keyPair.getPublic()));
        AlgorithmId algorithm = new AlgorithmId(AlgorithmId.sha1WithRSAEncryption_oid);
        certInfo.set("algorithmID", new CertificateAlgorithmId(algorithm));
        X509CertImpl cert = new X509CertImpl(certInfo);
        cert.sign(keyPair.getPrivate(), "SHA1withRSA");
        AlgorithmId actualAlgorithm = (AlgorithmId)cert.get("x509.algorithm");
        certInfo.set("algorithmID.algorithm", actualAlgorithm);
        X509CertImpl newCert = new X509CertImpl(certInfo);
        newCert.sign(keyPair.getPrivate(), "SHA1withRSA");
        return newCert;
    }

    private FakeKeyStore$() {
        MODULE$ = this;
        this.logger = Logger$.MODULE$.apply(this.getClass());
        this.GeneratedKeyStore = "conf/generated.keystore";
        this.DnName = "CN=localhost, OU=Unit Testing, O=Mavericks, L=Moon Base 1, ST=Cyberspace, C=CY";
    }
}

