/*
 * Decompiled with CFR 0.152.
 */
package play.mvc;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import play.Play;
import play.api.http.MediaRange;
import play.api.libs.json.JsValue;
import play.api.libs.json.jackson.JacksonJson;
import play.api.mvc.AnyContent;
import play.api.mvc.AnyContentAsEmpty$;
import play.api.mvc.AnyContentAsFormUrlEncoded;
import play.api.mvc.AnyContentAsJson;
import play.api.mvc.AnyContentAsRaw;
import play.api.mvc.AnyContentAsText;
import play.api.mvc.AnyContentAsXml;
import play.api.mvc.Cookies$;
import play.api.mvc.Flash$;
import play.api.mvc.Headers;
import play.api.mvc.Session$;
import play.core.j.JavaHelpers$;
import play.core.j.JavaParsers;
import play.core.j.RequestHeaderImpl;
import play.core.system.RequestIdProvider;
import play.i18n.Lang;
import play.i18n.Messages;
import play.i18n.MessagesApi;
import play.libs.Scala;
import scala.Option;
import scala.Predef;
import scala.Tuple2;
import scala.collection.JavaConversions;
import scala.collection.Seq;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.WrappedArray;
import scala.xml.NodeSeq;
import scala.xml.XML;

public class Http {

    public static interface MimeTypes {
        public static final String TEXT = "text/plain";
        public static final String HTML = "text/html";
        public static final String JSON = "application/json";
        public static final String XML = "application/xml";
        public static final String CSS = "text/css";
        public static final String JAVASCRIPT = "text/javascript";
        public static final String FORM = "application/x-www-form-urlencoded";
        public static final String EVENT_STREAM = "text/event-stream";
        public static final String BINARY = "application/octet-stream";
    }

    public static interface Status {
        public static final int CONTINUE = 100;
        public static final int SWITCHING_PROTOCOLS = 101;
        public static final int OK = 200;
        public static final int CREATED = 201;
        public static final int ACCEPTED = 202;
        public static final int NON_AUTHORITATIVE_INFORMATION = 203;
        public static final int NO_CONTENT = 204;
        public static final int RESET_CONTENT = 205;
        public static final int PARTIAL_CONTENT = 206;
        public static final int MULTIPLE_CHOICES = 300;
        public static final int MOVED_PERMANENTLY = 301;
        public static final int FOUND = 302;
        public static final int SEE_OTHER = 303;
        public static final int NOT_MODIFIED = 304;
        public static final int USE_PROXY = 305;
        public static final int TEMPORARY_REDIRECT = 307;
        public static final int BAD_REQUEST = 400;
        public static final int UNAUTHORIZED = 401;
        public static final int PAYMENT_REQUIRED = 402;
        public static final int FORBIDDEN = 403;
        public static final int NOT_FOUND = 404;
        public static final int METHOD_NOT_ALLOWED = 405;
        public static final int NOT_ACCEPTABLE = 406;
        public static final int PROXY_AUTHENTICATION_REQUIRED = 407;
        public static final int REQUEST_TIMEOUT = 408;
        public static final int CONFLICT = 409;
        public static final int GONE = 410;
        public static final int LENGTH_REQUIRED = 411;
        public static final int PRECONDITION_FAILED = 412;
        public static final int REQUEST_ENTITY_TOO_LARGE = 413;
        public static final int REQUEST_URI_TOO_LONG = 414;
        public static final int UNSUPPORTED_MEDIA_TYPE = 415;
        public static final int REQUESTED_RANGE_NOT_SATISFIABLE = 416;
        public static final int EXPECTATION_FAILED = 417;
        public static final int INTERNAL_SERVER_ERROR = 500;
        public static final int NOT_IMPLEMENTED = 501;
        public static final int BAD_GATEWAY = 502;
        public static final int SERVICE_UNAVAILABLE = 503;
        public static final int GATEWAY_TIMEOUT = 504;
        public static final int HTTP_VERSION_NOT_SUPPORTED = 505;
    }

    public static interface HeaderNames {
        public static final String ACCEPT = "Accept";
        public static final String ACCEPT_CHARSET = "Accept-Charset";
        public static final String ACCEPT_ENCODING = "Accept-Encoding";
        public static final String ACCEPT_LANGUAGE = "Accept-Language";
        public static final String ACCEPT_RANGES = "Accept-Ranges";
        public static final String AGE = "Age";
        public static final String ALLOW = "Allow";
        public static final String AUTHORIZATION = "Authorization";
        public static final String CACHE_CONTROL = "Cache-Control";
        public static final String CONNECTION = "Connection";
        public static final String CONTENT_DISPOSITION = "Content-Disposition";
        public static final String CONTENT_ENCODING = "Content-Encoding";
        public static final String CONTENT_LANGUAGE = "Content-Language";
        public static final String CONTENT_LENGTH = "Content-Length";
        public static final String CONTENT_LOCATION = "Content-Location";
        public static final String CONTENT_MD5 = "Content-MD5";
        public static final String CONTENT_RANGE = "Content-Range";
        public static final String CONTENT_TRANSFER_ENCODING = "Content-Transfer-Encoding";
        public static final String CONTENT_TYPE = "Content-Type";
        public static final String COOKIE = "Cookie";
        public static final String DATE = "Date";
        public static final String ETAG = "ETag";
        public static final String EXPECT = "Expect";
        public static final String EXPIRES = "Expires";
        public static final String FORWARDED = "Forwarded";
        public static final String FROM = "From";
        public static final String HOST = "Host";
        public static final String IF_MATCH = "If-Match";
        public static final String IF_MODIFIED_SINCE = "If-Modified-Since";
        public static final String IF_NONE_MATCH = "If-None-Match";
        public static final String IF_RANGE = "If-Range";
        public static final String IF_UNMODIFIED_SINCE = "If-Unmodified-Since";
        public static final String LAST_MODIFIED = "Last-Modified";
        public static final String LOCATION = "Location";
        public static final String MAX_FORWARDS = "Max-Forwards";
        public static final String PRAGMA = "Pragma";
        public static final String PROXY_AUTHENTICATE = "Proxy-Authenticate";
        public static final String PROXY_AUTHORIZATION = "Proxy-Authorization";
        public static final String RANGE = "Range";
        public static final String REFERER = "Referer";
        public static final String RETRY_AFTER = "Retry-After";
        public static final String SERVER = "Server";
        public static final String SET_COOKIE = "Set-Cookie";
        public static final String SET_COOKIE2 = "Set-Cookie2";
        public static final String TE = "Te";
        public static final String TRAILER = "Trailer";
        public static final String TRANSFER_ENCODING = "Transfer-Encoding";
        public static final String UPGRADE = "Upgrade";
        public static final String USER_AGENT = "User-Agent";
        public static final String VARY = "Vary";
        public static final String VIA = "Via";
        public static final String WARNING = "Warning";
        public static final String WWW_AUTHENTICATE = "WWW-Authenticate";
        public static final String ACCESS_CONTROL_ALLOW_ORIGIN = "Access-Control-Allow-Origin";
        public static final String ACCESS_CONTROL_EXPOSE_HEADERS = "Access-Control-Expose-Headers";
        public static final String ACCESS_CONTROL_MAX_AGE = "Access-Control-Max-Age";
        public static final String ACCESS_CONTROL_ALLOW_CREDENTIALS = "Access-Control-Allow-Credentials";
        public static final String ACCESS_CONTROL_ALLOW_METHODS = "Access-Control-Allow-Methods";
        public static final String ACCESS_CONTROL_ALLOW_HEADERS = "Access-Control-Allow-Headers";
        public static final String ORIGIN = "Origin";
        public static final String ACCESS_CONTROL_REQUEST_METHOD = "Access-Control-Request-Method";
        public static final String ACCESS_CONTROL_REQUEST_HEADERS = "Access-Control-Request-Headers";
        public static final String X_FORWARDED_FOR = "X-Forwarded-For";
        public static final String X_FORWARDED_HOST = "X-Forwarded-Host";
        public static final String X_FORWARDED_PORT = "X-Forwarded-Port";
        public static final String X_FORWARDED_PROTO = "X-Forwarded-Proto";
        public static final String X_REQUESTED_WITH = "X-Requested-With";
    }

    public static interface Cookies
    extends Iterable<Cookie> {
        public Cookie get(String var1);
    }

    public static class Cookie {
        private final String name;
        private final String value;
        private final Integer maxAge;
        private final String path;
        private final String domain;
        private final boolean secure;
        private final boolean httpOnly;

        public Cookie(String string, String string2, Integer n, String string3, String string4, boolean bl, boolean bl2) {
            this.name = string;
            this.value = string2;
            this.maxAge = n;
            this.path = string3;
            this.domain = string4;
            this.secure = bl;
            this.httpOnly = bl2;
        }

        public String name() {
            return this.name;
        }

        public String value() {
            return this.value;
        }

        public Integer maxAge() {
            return this.maxAge;
        }

        public String path() {
            return this.path;
        }

        public String domain() {
            return this.domain;
        }

        public boolean secure() {
            return this.secure;
        }

        public boolean httpOnly() {
            return this.httpOnly;
        }
    }

    public static class Flash
    extends HashMap<String, String> {
        public boolean isDirty = false;

        public Flash(Map<String, String> map2) {
            super(map2);
        }

        @Override
        public String remove(Object object) {
            this.isDirty = true;
            return (String)super.remove(object);
        }

        @Override
        public String put(String string, String string2) {
            this.isDirty = true;
            return super.put(string, string2);
        }

        @Override
        public void putAll(Map<? extends String, ? extends String> map2) {
            this.isDirty = true;
            super.putAll(map2);
        }

        @Override
        public void clear() {
            this.isDirty = true;
            super.clear();
        }
    }

    public static class Session
    extends HashMap<String, String> {
        public boolean isDirty = false;

        public Session(Map<String, String> map2) {
            super(map2);
        }

        @Override
        public String remove(Object object) {
            this.isDirty = true;
            return (String)super.remove(object);
        }

        @Override
        public String put(String string, String string2) {
            this.isDirty = true;
            return super.put(string, string2);
        }

        @Override
        public void putAll(Map<? extends String, ? extends String> map2) {
            this.isDirty = true;
            super.putAll(map2);
        }

        @Override
        public void clear() {
            this.isDirty = true;
            super.clear();
        }
    }

    public static class Response
    implements HeaderNames {
        private final Map<String, String> headers = new TreeMap<String, String>(String::compareToIgnoreCase);
        private final List<Cookie> cookies = new ArrayList<Cookie>();

        public void setHeader(String string, String string2) {
            this.headers.put(string, string2);
        }

        public Map<String, String> getHeaders() {
            return this.headers;
        }

        public void setContentType(String string) {
            this.setHeader("Content-Type", string);
        }

        public void setCookie(String string, String string2) {
            this.setCookie(string, string2, null);
        }

        public void setCookie(String string, String string2, Integer n) {
            this.setCookie(string, string2, n, "/");
        }

        public void setCookie(String string, String string2, Integer n, String string3) {
            this.setCookie(string, string2, n, string3, null);
        }

        public void setCookie(String string, String string2, Integer n, String string3, String string4) {
            this.setCookie(string, string2, n, string3, string4, false, false);
        }

        public void setCookie(String string, String string2, Integer n, String string3, String string4, boolean bl, boolean bl2) {
            this.cookies.add(new Cookie(string, string2, n, string3, string4, bl, bl2));
        }

        public void discardCookie(String string) {
            this.discardCookie(string, "/", null, false);
        }

        public void discardCookie(String string, String string2) {
            this.discardCookie(string, string2, null, false);
        }

        public void discardCookie(String string, String string2, String string3) {
            this.discardCookie(string, string2, string3, false);
        }

        public void discardCookie(String string, String string2, String string3, boolean bl) {
            this.cookies.add(new Cookie(string, "", -86400, string2, string3, bl, false));
        }

        public Collection<Cookie> cookies() {
            return this.cookies;
        }

        public Optional<Cookie> cookie(String string) {
            return this.cookies.stream().filter(cookie -> cookie.name().equals(string)).findFirst();
        }
    }

    public static class RequestBody {
        @Deprecated
        public boolean isMaxSizeExceeded() {
            return false;
        }

        public MultipartFormData asMultipartFormData() {
            return null;
        }

        public Map<String, String[]> asFormUrlEncoded() {
            return null;
        }

        public RawBuffer asRaw() {
            return null;
        }

        public String asText() {
            return null;
        }

        public Document asXml() {
            return null;
        }

        public JsonNode asJson() {
            return null;
        }

        public <T> T as(Class<T> clazz) {
            if (this.getClass().isAssignableFrom(clazz)) {
                return (T)this;
            }
            return null;
        }
    }

    public static abstract class MultipartFormData {
        public abstract Map<String, String[]> asFormUrlEncoded();

        public abstract List<FilePart> getFiles();

        public FilePart getFile(String string) {
            for (FilePart filePart : this.getFiles()) {
                if (!filePart.getKey().equals(string)) continue;
                return filePart;
            }
            return null;
        }

        public static class FilePart {
            final String key;
            final String filename;
            final String contentType;
            final File file;

            public FilePart(String string, String string2, String string3, File file2) {
                this.key = string;
                this.filename = string2;
                this.contentType = string3;
                this.file = file2;
            }

            public String getKey() {
                return this.key;
            }

            public String getFilename() {
                return this.filename;
            }

            public String getContentType() {
                return this.contentType;
            }

            public File getFile() {
                return this.file;
            }
        }
    }

    public static abstract class RawBuffer {
        public abstract Long size();

        public abstract byte[] asBytes(int var1);

        public abstract byte[] asBytes();

        public abstract File asFile();
    }

    public static class RequestBuilder {
        protected AnyContent body;
        protected String username;
        protected Long id = RequestIdProvider.requestIDs().incrementAndGet();
        protected Map<String, String> tags = new HashMap<String, String>();
        protected String method;
        protected boolean secure;
        protected URI uri;
        protected String version;
        protected Map<String, String[]> headers = new HashMap<String, String[]>();
        protected String remoteAddress;

        public RequestBuilder() {
            this.method("GET");
            this.uri("/");
            this.host("localhost");
            this.version("HTTP/1.1");
            this.remoteAddress("127.0.0.1");
            this.body(AnyContentAsEmpty$.MODULE$);
        }

        public RequestBody body() {
            if (this.body == null) {
                return null;
            }
            return new JavaParsers.DefaultRequestBody(this.body.asFormUrlEncoded(), this.body.asRaw(), this.body.asText(), this.body.asJson(), this.body.asXml(), this.body.asMultipartFormData());
        }

        public AnyContent bodyAsAnyContent() {
            return this.body;
        }

        public String username() {
            return this.username;
        }

        public RequestBuilder username(String string) {
            this.username = string;
            return this;
        }

        protected RequestBuilder body(AnyContent anyContent2, String string) {
            this.header("Content-Type", string);
            this.body(anyContent2);
            return this;
        }

        protected RequestBuilder body(AnyContent anyContent2) {
            this.body = anyContent2;
            return this;
        }

        public RequestBuilder bodyRaw(byte[] byArray) {
            play.api.mvc.RawBuffer rawBuffer = new play.api.mvc.RawBuffer(byArray.length, byArray);
            return this.body(new AnyContentAsRaw(rawBuffer), "application/octet-stream");
        }

        public RequestBuilder bodyFormArrayValues(Map<String, String[]> map2) {
            HashMap<String, WrappedArray> hashMap = new HashMap<String, WrappedArray>();
            for (Map.Entry<String, String[]> entry : map2.entrySet()) {
                hashMap.put(entry.getKey(), Predef.genericWrapArray((Object)entry.getValue()));
            }
            Iterator<Map.Entry<String, String[]>> iterator2 = Scala.asScala(hashMap);
            return this.body(new AnyContentAsFormUrlEncoded((scala.collection.immutable.Map<String, Seq<String>>)iterator2), "application/x-www-form-urlencoded");
        }

        public RequestBuilder bodyForm(Map<String, String> map2) {
            HashMap<String, Buffer> hashMap = new HashMap<String, Buffer>();
            for (Map.Entry<String, String> entry : map2.entrySet()) {
                hashMap.put(entry.getKey(), JavaConversions.asScalaBuffer(Arrays.asList(entry.getValue())));
            }
            Iterator<Map.Entry<String, String>> iterator2 = Scala.asScala(hashMap);
            return this.body(new AnyContentAsFormUrlEncoded((scala.collection.immutable.Map<String, Seq<String>>)iterator2), "application/x-www-form-urlencoded");
        }

        public RequestBuilder bodyJson(JsonNode jsonNode) {
            return this.bodyJson(JacksonJson.jsonNodeToJsValue((JsonNode)jsonNode));
        }

        public RequestBuilder bodyJson(JsValue jsValue) {
            return this.body(new AnyContentAsJson(jsValue), "application/json");
        }

        public RequestBuilder bodyXml(InputSource inputSource) {
            return this.body(new AnyContentAsXml((NodeSeq)XML.load((InputSource)inputSource)), "application/xml");
        }

        public RequestBuilder bodyText(String string) {
            return this.body(new AnyContentAsText(string), "text/plain");
        }

        public RequestImpl build() {
            return new RequestImpl(new play.api.mvc.RequestImpl<RequestBody>(this.body(), this.id, Scala.asScala(this.tags()), this.uri.toString(), this.uri.getRawPath(), this.method, this.version, RequestBuilder.mapListToScala(this.splitQuery()), this.buildHeaders(), this.remoteAddress, this.secure));
        }

        public Long id() {
            return this.id;
        }

        public RequestBuilder id(Long l) {
            this.id = l;
            return this;
        }

        public Map<String, String> tags() {
            return this.tags;
        }

        public RequestBuilder tags(Map<String, String> map2) {
            this.tags = map2;
            return this;
        }

        public RequestBuilder tag(String string, String string2) {
            this.tags.put(string, string2);
            return this;
        }

        public String method() {
            return this.method;
        }

        public RequestBuilder method(String string) {
            this.method = string;
            return this;
        }

        public String uri() {
            return this.uri.toString();
        }

        public RequestBuilder uri(URI uRI) {
            if (uRI.getScheme() != null) {
                if (!uRI.getScheme().equals("http") && !uRI.getScheme().equals("https")) {
                    throw new IllegalArgumentException("URI scheme must be http or https");
                }
                this.secure = uRI.getScheme().equals("https");
            }
            this.uri = uRI;
            this.host(uRI.getHost());
            return this;
        }

        public RequestBuilder uri(String string) {
            try {
                this.uri(new URI(string));
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new IllegalArgumentException("Exception parsing URI", uRISyntaxException);
            }
            return this;
        }

        public RequestBuilder secure(boolean bl) {
            this.secure = bl;
            return this;
        }

        public boolean secure() {
            return this.secure;
        }

        public String host() {
            return this.header("Host");
        }

        public RequestBuilder host(String string) {
            this.header("Host", string);
            return this;
        }

        public String path() {
            return this.uri.getRawPath();
        }

        public RequestBuilder path(String string) {
            try {
                this.uri = new URI(this.uri.getScheme(), this.uri.getUserInfo(), this.uri.getHost(), this.uri.getPort(), string, this.uri.getQuery(), this.uri.getFragment());
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new IllegalArgumentException(uRISyntaxException);
            }
            return this;
        }

        public String version() {
            return this.version;
        }

        public RequestBuilder version(String string) {
            this.version = string;
            return this;
        }

        public String header(String string) {
            String[] stringArray = this.headers.get(string);
            return stringArray == null || stringArray.length == 0 ? null : stringArray[0];
        }

        public String[] headers(String string) {
            return this.headers.get(string);
        }

        public Map<String, String[]> headers() {
            return this.headers;
        }

        public RequestBuilder headers(Map<String, String[]> map2) {
            this.headers = map2;
            return this;
        }

        public RequestBuilder header(String string, String[] stringArray) {
            this.headers.put(string, stringArray);
            return this;
        }

        public RequestBuilder header(String string, String string2) {
            this.headers.put(string, new String[]{string2});
            return this;
        }

        private play.api.mvc.Cookies scalaCookies() {
            String string = this.header("Cookie");
            Option option = Option.apply((Object)string);
            return Cookies$.MODULE$.fromCookieHeader((Option<String>)option);
        }

        public Cookies cookies() {
            return JavaHelpers$.MODULE$.cookiesToJavaCookies(this.scalaCookies());
        }

        private void cookies(Seq<play.api.mvc.Cookie> seq2) {
            String string = this.header("Cookie");
            String string2 = Cookies$.MODULE$.mergeCookieHeader(string != null ? string : "", seq2);
            this.header("Cookie", string2);
        }

        public RequestBuilder cookie(Cookie cookie) {
            this.cookies(JavaHelpers$.MODULE$.cookiesToScalaCookies(Arrays.asList(cookie)));
            return this;
        }

        public Map<String, String> flash() {
            play.api.mvc.Cookies cookies = this.scalaCookies();
            Option<play.api.mvc.Cookie> option = cookies.get(Flash$.MODULE$.COOKIE_NAME());
            scala.collection.immutable.Map<String, String> map2 = Flash$.MODULE$.decodeCookieToMap(option);
            return JavaConversions.mapAsJavaMap(map2);
        }

        public RequestBuilder flash(String string, String string2) {
            HashMap<String, String> hashMap = new HashMap<String, String>(this.flash());
            hashMap.put(string, string2);
            this.flash(hashMap);
            return this;
        }

        public RequestBuilder flash(Map<String, String> map2) {
            play.api.mvc.Flash flash = new play.api.mvc.Flash(Scala.asScala(map2));
            this.cookies((Seq<play.api.mvc.Cookie>)JavaConversions.asScalaBuffer(Arrays.asList(Flash$.MODULE$.encodeAsCookie(flash))));
            return this;
        }

        public Map<String, String> session() {
            play.api.mvc.Cookies cookies = this.scalaCookies();
            Option<play.api.mvc.Cookie> option = cookies.get(Session$.MODULE$.COOKIE_NAME());
            scala.collection.immutable.Map<String, String> map2 = Session$.MODULE$.decodeCookieToMap(option);
            return JavaConversions.mapAsJavaMap(map2);
        }

        public RequestBuilder session(String string, String string2) {
            HashMap<String, String> hashMap = new HashMap<String, String>(this.session());
            hashMap.put(string, string2);
            this.session(hashMap);
            return this;
        }

        public RequestBuilder session(Map<String, String> map2) {
            play.api.mvc.Session session = new play.api.mvc.Session(Scala.asScala(map2));
            this.cookies((Seq<play.api.mvc.Cookie>)JavaConversions.asScalaBuffer(Arrays.asList(Session$.MODULE$.encodeAsCookie(session))));
            return this;
        }

        public String remoteAddress() {
            return this.remoteAddress;
        }

        public RequestBuilder remoteAddress(String string) {
            this.remoteAddress = string;
            return this;
        }

        protected Map<String, List<String>> splitQuery() {
            try {
                String[] stringArray;
                LinkedHashMap<String, List<String>> linkedHashMap = new LinkedHashMap<String, List<String>>();
                String string = this.uri.getQuery();
                if (string == null) {
                    return new HashMap<String, List<String>>();
                }
                for (String string2 : stringArray = string.split("&")) {
                    String string3;
                    int n = string2.indexOf("=");
                    String string4 = string3 = n > 0 ? URLDecoder.decode(string2.substring(0, n), "UTF-8") : string2;
                    if (!linkedHashMap.containsKey(string3)) {
                        linkedHashMap.put(string3, new LinkedList());
                    }
                    String string5 = n > 0 && string2.length() > n + 1 ? URLDecoder.decode(string2.substring(n + 1), "UTF-8") : null;
                    ((List)linkedHashMap.get(string3)).add(string5);
                }
                return linkedHashMap;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new IllegalStateException("This can never happen", unsupportedEncodingException);
            }
        }

        protected static scala.collection.immutable.Map<String, Seq<String>> mapListToScala(Map<String, List<String>> map2) {
            HashMap<String, Buffer> hashMap = new HashMap<String, Buffer>();
            for (String string : map2.keySet()) {
                hashMap.put(string, JavaConversions.asScalaBuffer(map2.get(string)));
            }
            return Scala.asScala(hashMap);
        }

        protected Headers buildHeaders() {
            ArrayList<Tuple2> arrayList = new ArrayList<Tuple2>();
            for (Map.Entry<String, String[]> entry : this.headers().entrySet()) {
                for (String string : entry.getValue()) {
                    arrayList.add(new Tuple2((Object)entry.getKey(), (Object)string));
                }
            }
            return new Headers((Seq<Tuple2<String, String>>)JavaConversions.asScalaBuffer(arrayList));
        }
    }

    public static class RequestImpl
    extends RequestHeaderImpl
    implements Request {
        private final play.api.mvc.Request<RequestBody> underlying;
        private String username;

        public RequestImpl(play.api.mvc.RequestHeader requestHeader) {
            super(requestHeader);
            this.underlying = null;
        }

        public RequestImpl(play.api.mvc.Request<RequestBody> request) {
            super(request);
            this.underlying = request;
        }

        private RequestImpl(play.api.mvc.Request<RequestBody> request, String string) {
            super(request);
            this.underlying = request;
            this.username = string;
        }

        @Override
        public RequestBody body() {
            return this.underlying != null ? this.underlying.body() : null;
        }

        @Override
        public String username() {
            return this.username;
        }

        @Override
        public void setUsername(String string) {
            this.username = string;
        }

        @Override
        public Request withUsername(String string) {
            return new RequestImpl(this.underlying, string);
        }

        @Override
        public play.api.mvc.Request<RequestBody> _underlyingRequest() {
            return this.underlying;
        }
    }

    public static interface Request
    extends RequestHeader {
        public RequestBody body();

        public String username();

        @Deprecated
        public void setUsername(String var1);

        public Request withUsername(String var1);

        public play.api.mvc.Request<RequestBody> _underlyingRequest();
    }

    public static interface RequestHeader {
        public String uri();

        public String method();

        public String version();

        public String remoteAddress();

        public boolean secure();

        public String host();

        public String path();

        public List<Lang> acceptLanguages();

        public List<MediaRange> acceptedTypes();

        public boolean accepts(String var1);

        public Map<String, String[]> queryString();

        public String getQueryString(String var1);

        public Cookies cookies();

        public Cookie cookie(String var1);

        public Map<String, String[]> headers();

        public String getHeader(String var1);

        public boolean hasHeader(String var1);

        public play.api.mvc.RequestHeader _underlyingHeader();
    }

    public static abstract class WrappedContext
    extends Context {
        private final Context wrapped;

        public WrappedContext(Context context) {
            super(context.id(), context._requestHeader(), context.request(), context.session(), context.flash(), context.args);
            this.args = context.args;
            this.wrapped = context;
        }

        @Override
        public Long id() {
            return this.wrapped.id();
        }

        @Override
        public Request request() {
            return this.wrapped.request();
        }

        @Override
        public Response response() {
            return this.wrapped.response();
        }

        @Override
        public Session session() {
            return this.wrapped.session();
        }

        @Override
        public Flash flash() {
            return this.wrapped.flash();
        }

        @Override
        public play.api.mvc.RequestHeader _requestHeader() {
            return this.wrapped._requestHeader();
        }

        @Override
        public Lang lang() {
            return this.wrapped.lang();
        }

        @Override
        public boolean changeLang(String string) {
            return this.wrapped.changeLang(string);
        }

        @Override
        public boolean changeLang(Lang lang) {
            return this.wrapped.changeLang(lang);
        }

        @Override
        public void clearLang() {
            this.wrapped.clearLang();
        }
    }

    public static class Context {
        public static ThreadLocal<Context> current = new ThreadLocal();
        private final Long id;
        private final play.api.mvc.RequestHeader header;
        private final Request request;
        private final Response response;
        private final Session session;
        private final Flash flash;
        private Lang lang = null;
        public Map<String, Object> args;

        public static Context current() {
            Context context = current.get();
            if (context == null) {
                throw new RuntimeException("There is no HTTP Context available from here.");
            }
            return context;
        }

        public Context(RequestBuilder requestBuilder) {
            this(requestBuilder.build());
        }

        public Context(Request request) {
            this.request = request;
            this.header = request._underlyingHeader();
            this.id = this.header.id();
            this.response = new Response();
            this.session = new Session(JavaConversions.mapAsJavaMap(this.header.session().data()));
            this.flash = new Flash(JavaConversions.mapAsJavaMap(this.header.flash().data()));
            this.args = new HashMap<String, Object>();
            this.args.putAll(JavaConversions.mapAsJavaMap(this.header.tags()));
        }

        public Context(Long l, play.api.mvc.RequestHeader requestHeader, Request request, Map<String, String> map2, Map<String, String> map3, Map<String, Object> map4) {
            this.id = l;
            this.header = requestHeader;
            this.request = request;
            this.response = new Response();
            this.session = new Session(map2);
            this.flash = new Flash(map3);
            this.args = new HashMap<String, Object>(map4);
        }

        public Long id() {
            return this.id;
        }

        public Request request() {
            return this.request;
        }

        public Response response() {
            return this.response;
        }

        public Session session() {
            return this.session;
        }

        public Flash flash() {
            return this.flash;
        }

        public play.api.mvc.RequestHeader _requestHeader() {
            return this.header;
        }

        public Lang lang() {
            if (this.lang != null) {
                return this.lang;
            }
            return this.messages().lang();
        }

        public Messages messages() {
            return Play.application().injector().instanceOf(MessagesApi.class).preferred(this.request());
        }

        public boolean changeLang(String string) {
            return this.changeLang(Lang.forCode(string));
        }

        public boolean changeLang(Lang lang) {
            if (Lang.availables().contains(lang)) {
                this.lang = lang;
                Option<String> option = play.api.mvc.Session.domain();
                this.response.setCookie(Play.langCookieName(), lang.code(), null, play.api.mvc.Session.path(), option.isDefined() ? (String)option.get() : null, Play.langCookieSecure(), Play.langCookieHttpOnly());
                return true;
            }
            return false;
        }

        public void clearLang() {
            this.lang = null;
            Option<String> option = play.api.mvc.Session.domain();
            this.response.discardCookie(Play.langCookieName(), play.api.mvc.Session.path(), option.isDefined() ? (String)option.get() : null, Play.langCookieSecure());
        }

        public void setTransientLang(String string) {
            this.setTransientLang(Lang.forCode(string));
        }

        public void setTransientLang(Lang lang) {
            if (!Lang.availables().contains(lang)) {
                throw new IllegalArgumentException("Language not supported in this application: " + lang + " not in Lang.availables()");
            }
            this.lang = lang;
        }

        public void clearTransientLang() {
            this.lang = null;
        }

        public String toString() {
            return "Context attached to (" + this.request() + ")";
        }

        public static class Implicit {
            public static Response response() {
                return Context.current().response();
            }

            public static Request request() {
                return Context.current().request();
            }

            public static Flash flash() {
                return Context.current().flash();
            }

            public static Session session() {
                return Context.current().session();
            }

            public static Lang lang() {
                return Context.current().lang();
            }

            public static Messages messages() {
                return Context.current().messages();
            }

            public static Context ctx() {
                return Context.current();
            }
        }
    }
}

