/*
 * Decompiled with CFR 0.152.
 */
package play.mvc;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import play.api.http.Writeable;
import play.api.libs.MimeTypes;
import play.api.libs.iteratee.Concurrent;
import play.api.libs.iteratee.Enumerator;
import play.api.mvc.Codec;
import play.api.mvc.Results;
import play.core.j.JavaResults;
import play.libs.F;
import play.libs.Scala;
import play.mvc.Call;
import play.mvc.Result;
import play.twirl.api.Content;
import views.html.defaultpages.todo;

public class Results {
    static Codec utf8 = Codec.javaSupported("utf-8");
    static int defaultChunkSize = 8192;
    public static Result TODO = new Todo();

    public static StatusHeader status(int n) {
        return new StatusHeader(JavaResults.Status(n));
    }

    public static Status status(int n, Content content) {
        return new Status(JavaResults.Status(n), content, utf8);
    }

    public static Status status(int n, Content content, String string) {
        return new Status(JavaResults.Status(n), content, Codec.javaSupported(string));
    }

    public static Status status(int n, String string) {
        return new Status(JavaResults.Status(n), string, utf8);
    }

    public static Status status(int n, String string, String string2) {
        return new Status(JavaResults.Status(n), string, Codec.javaSupported(string2));
    }

    public static Status status(int n, JsonNode jsonNode) {
        return new Status(JavaResults.Status(n), jsonNode, utf8);
    }

    public static Status status(int n, JsonNode jsonNode, String string) {
        return new Status(JavaResults.Status(n), jsonNode, Codec.javaSupported(string));
    }

    public static Status status(int n, byte[] byArray) {
        return new Status(JavaResults.Status(n), byArray);
    }

    public static Status status(int n, InputStream inputStream) {
        return Results.status(n, inputStream, defaultChunkSize);
    }

    public static Status status(int n, InputStream inputStream, int n2) {
        return new Status(JavaResults.Status(n), inputStream, n2);
    }

    public static Status status(int n, File file2) {
        return new Status(JavaResults.Status(n), file2);
    }

    public static Status status(int n, File file2, int n2) {
        return new Status(JavaResults.Status(n), file2, n2);
    }

    public static Status status(int n, Chunks<?> chunks) {
        return new Status(JavaResults.Status(n), chunks);
    }

    public static StatusHeader ok() {
        return new StatusHeader(JavaResults.Ok());
    }

    public static Status ok(Content content) {
        return new Status(JavaResults.Ok(), content, utf8);
    }

    public static Status ok(Content content, String string) {
        return new Status(JavaResults.Ok(), content, Codec.javaSupported(string));
    }

    public static Status ok(String string) {
        return new Status(JavaResults.Ok(), string, utf8);
    }

    public static Status ok(String string, String string2) {
        return new Status(JavaResults.Ok(), string, Codec.javaSupported(string2));
    }

    public static Status ok(JsonNode jsonNode) {
        return new Status(JavaResults.Ok(), jsonNode, utf8);
    }

    public static Status ok(JsonNode jsonNode, String string) {
        return new Status(JavaResults.Ok(), jsonNode, Codec.javaSupported(string));
    }

    public static Status ok(byte[] byArray) {
        return new Status(JavaResults.Ok(), byArray);
    }

    public static Status ok(InputStream inputStream) {
        return Results.ok(inputStream, defaultChunkSize);
    }

    public static Status ok(InputStream inputStream, int n) {
        return new Status(JavaResults.Ok(), inputStream, n);
    }

    public static Status ok(File file2) {
        return new Status(JavaResults.Ok(), file2);
    }

    public static Status ok(File file2, boolean bl) {
        return new Status(JavaResults.Ok(), file2, bl);
    }

    public static Status ok(File file2, String string) {
        return new Status(JavaResults.Ok(), file2, true, string);
    }

    public static Status ok(Chunks<?> chunks) {
        return new Status(JavaResults.Ok(), chunks);
    }

    public static StatusHeader created() {
        return new StatusHeader(JavaResults.Created());
    }

    public static Status created(Content content) {
        return new Status(JavaResults.Created(), content, utf8);
    }

    public static Status created(Content content, String string) {
        return new Status(JavaResults.Created(), content, Codec.javaSupported(string));
    }

    public static Status created(String string) {
        return new Status(JavaResults.Created(), string, utf8);
    }

    public static Status created(String string, String string2) {
        return new Status(JavaResults.Created(), string, Codec.javaSupported(string2));
    }

    public static Status created(JsonNode jsonNode) {
        return new Status(JavaResults.Created(), jsonNode, utf8);
    }

    public static Status created(JsonNode jsonNode, String string) {
        return new Status(JavaResults.Created(), jsonNode, Codec.javaSupported(string));
    }

    public static Status created(byte[] byArray) {
        return new Status(JavaResults.Created(), byArray);
    }

    public static Status created(InputStream inputStream) {
        return Results.created(inputStream, defaultChunkSize);
    }

    public static Status created(InputStream inputStream, int n) {
        return new Status(JavaResults.Created(), inputStream, n);
    }

    public static Status created(File file2) {
        return new Status(JavaResults.Created(), file2);
    }

    public static Status created(File file2, boolean bl) {
        return new Status(JavaResults.Created(), file2, bl);
    }

    public static Status created(File file2, String string) {
        return new Status(JavaResults.Created(), file2, true, string);
    }

    public static Status created(Chunks<?> chunks) {
        return new Status(JavaResults.Created(), chunks);
    }

    public static Status noContent() {
        return new Status(JavaResults.NoContent());
    }

    public static StatusHeader internalServerError() {
        return new StatusHeader(JavaResults.InternalServerError());
    }

    public static Status internalServerError(Content content) {
        return new Status(JavaResults.InternalServerError(), content, utf8);
    }

    public static Status internalServerError(Content content, String string) {
        return new Status(JavaResults.InternalServerError(), content, Codec.javaSupported(string));
    }

    public static Status internalServerError(String string) {
        return new Status(JavaResults.InternalServerError(), string, utf8);
    }

    public static Status internalServerError(String string, String string2) {
        return new Status(JavaResults.InternalServerError(), string, Codec.javaSupported(string2));
    }

    public static Status internalServerError(JsonNode jsonNode) {
        return new Status(JavaResults.InternalServerError(), jsonNode, utf8);
    }

    public static Status internalServerError(JsonNode jsonNode, String string) {
        return new Status(JavaResults.InternalServerError(), jsonNode, Codec.javaSupported(string));
    }

    public static Status internalServerError(byte[] byArray) {
        return new Status(JavaResults.InternalServerError(), byArray);
    }

    public static Status internalServerError(InputStream inputStream) {
        return Results.internalServerError(inputStream, defaultChunkSize);
    }

    public static Status internalServerError(InputStream inputStream, int n) {
        return new Status(JavaResults.InternalServerError(), inputStream, n);
    }

    public static Status internalServerError(File file2) {
        return new Status(JavaResults.InternalServerError(), file2);
    }

    public static Status internalServerError(File file2, boolean bl) {
        return new Status(JavaResults.InternalServerError(), file2, bl);
    }

    public static Status internalServerError(File file2, String string) {
        return new Status(JavaResults.InternalServerError(), file2, true, string);
    }

    public static Status internalServerError(Chunks<?> chunks) {
        return new Status(JavaResults.InternalServerError(), chunks);
    }

    public static StatusHeader notFound() {
        return new StatusHeader(JavaResults.NotFound());
    }

    public static Status notFound(Content content) {
        return new Status(JavaResults.NotFound(), content, utf8);
    }

    public static Status notFound(Content content, String string) {
        return new Status(JavaResults.NotFound(), content, Codec.javaSupported(string));
    }

    public static Status notFound(String string) {
        return new Status(JavaResults.NotFound(), string, utf8);
    }

    public static Status notFound(String string, String string2) {
        return new Status(JavaResults.NotFound(), string, Codec.javaSupported(string2));
    }

    public static Status notFound(JsonNode jsonNode) {
        return new Status(JavaResults.NotFound(), jsonNode, utf8);
    }

    public static Status notFound(JsonNode jsonNode, String string) {
        return new Status(JavaResults.NotFound(), jsonNode, Codec.javaSupported(string));
    }

    public static Status notFound(byte[] byArray) {
        return new Status(JavaResults.NotFound(), byArray);
    }

    public static Status notFound(InputStream inputStream) {
        return Results.notFound(inputStream, defaultChunkSize);
    }

    public static Status notFound(InputStream inputStream, int n) {
        return new Status(JavaResults.NotFound(), inputStream, n);
    }

    public static Status notFound(File file2) {
        return new Status(JavaResults.NotFound(), file2);
    }

    public static Status notFound(File file2, boolean bl) {
        return new Status(JavaResults.NotFound(), file2, bl);
    }

    public static Status notFound(File file2, String string) {
        return new Status(JavaResults.NotFound(), file2, true, string);
    }

    public static Status notFound(Chunks<?> chunks) {
        return new Status(JavaResults.NotFound(), chunks);
    }

    public static StatusHeader forbidden() {
        return new StatusHeader(JavaResults.Forbidden());
    }

    public static Status forbidden(Content content) {
        return new Status(JavaResults.Forbidden(), content, utf8);
    }

    public static Status forbidden(Content content, String string) {
        return new Status(JavaResults.Forbidden(), content, Codec.javaSupported(string));
    }

    public static Status forbidden(String string) {
        return new Status(JavaResults.Forbidden(), string, utf8);
    }

    public static Status forbidden(String string, String string2) {
        return new Status(JavaResults.Forbidden(), string, Codec.javaSupported(string2));
    }

    public static Status forbidden(JsonNode jsonNode) {
        return new Status(JavaResults.Forbidden(), jsonNode, utf8);
    }

    public static Status forbidden(JsonNode jsonNode, String string) {
        return new Status(JavaResults.Forbidden(), jsonNode, Codec.javaSupported(string));
    }

    public static Status forbidden(byte[] byArray) {
        return new Status(JavaResults.Forbidden(), byArray);
    }

    public static Status forbidden(InputStream inputStream) {
        return Results.forbidden(inputStream, defaultChunkSize);
    }

    public static Status forbidden(InputStream inputStream, int n) {
        return new Status(JavaResults.Forbidden(), inputStream, n);
    }

    public static Status forbidden(File file2) {
        return new Status(JavaResults.Forbidden(), file2);
    }

    public static Status forbidden(File file2, boolean bl) {
        return new Status(JavaResults.Forbidden(), file2, bl);
    }

    public static Status forbidden(File file2, String string) {
        return new Status(JavaResults.Forbidden(), file2, true, string);
    }

    public static Status forbidden(Chunks<?> chunks) {
        return new Status(JavaResults.Forbidden(), chunks);
    }

    public static StatusHeader paymentRequired() {
        return new StatusHeader(JavaResults.PaymentRequired());
    }

    public static Status paymentRequired(Content content) {
        return new Status(JavaResults.PaymentRequired(), content, utf8);
    }

    public static Status paymentRequired(Content content, String string) {
        return new Status(JavaResults.PaymentRequired(), content, Codec.javaSupported(string));
    }

    public static Status paymentRequired(String string) {
        return new Status(JavaResults.PaymentRequired(), string, utf8);
    }

    public static Status paymentRequired(String string, String string2) {
        return new Status(JavaResults.PaymentRequired(), string, Codec.javaSupported(string2));
    }

    public static Status paymentRequired(JsonNode jsonNode) {
        return new Status(JavaResults.PaymentRequired(), jsonNode, utf8);
    }

    public static Status paymentRequired(JsonNode jsonNode, String string) {
        return new Status(JavaResults.PaymentRequired(), jsonNode, Codec.javaSupported(string));
    }

    public static Status paymentRequired(byte[] byArray) {
        return new Status(JavaResults.PaymentRequired(), byArray);
    }

    public static Status paymentRequired(InputStream inputStream) {
        return Results.paymentRequired(inputStream, defaultChunkSize);
    }

    public static Status paymentRequired(InputStream inputStream, int n) {
        return new Status(JavaResults.PaymentRequired(), inputStream, n);
    }

    public static Status paymentRequired(File file2) {
        return new Status(JavaResults.PaymentRequired(), file2);
    }

    public static Status paymentRequired(File file2, boolean bl) {
        return new Status(JavaResults.PaymentRequired(), file2, bl);
    }

    public static Status paymentRequired(File file2, String string) {
        return new Status(JavaResults.PaymentRequired(), file2, true, string);
    }

    public static Status paymentRequired(Chunks<?> chunks) {
        return new Status(JavaResults.PaymentRequired(), chunks);
    }

    public static StatusHeader unauthorized() {
        return new StatusHeader(JavaResults.Unauthorized());
    }

    public static Status unauthorized(Content content) {
        return new Status(JavaResults.Unauthorized(), content, utf8);
    }

    public static Status unauthorized(Content content, String string) {
        return new Status(JavaResults.Unauthorized(), content, Codec.javaSupported(string));
    }

    public static Status unauthorized(String string) {
        return new Status(JavaResults.Unauthorized(), string, utf8);
    }

    public static Status unauthorized(String string, String string2) {
        return new Status(JavaResults.Unauthorized(), string, Codec.javaSupported(string2));
    }

    public static Status unauthorized(JsonNode jsonNode) {
        return new Status(JavaResults.Unauthorized(), jsonNode, utf8);
    }

    public static Status unauthorized(JsonNode jsonNode, String string) {
        return new Status(JavaResults.Unauthorized(), jsonNode, Codec.javaSupported(string));
    }

    public static Status unauthorized(byte[] byArray) {
        return new Status(JavaResults.Unauthorized(), byArray);
    }

    public static Status unauthorized(InputStream inputStream) {
        return Results.unauthorized(inputStream, defaultChunkSize);
    }

    public static Status unauthorized(InputStream inputStream, int n) {
        return new Status(JavaResults.Unauthorized(), inputStream, n);
    }

    public static Status unauthorized(File file2) {
        return new Status(JavaResults.Unauthorized(), file2);
    }

    public static Status unauthorized(File file2, boolean bl) {
        return new Status(JavaResults.Unauthorized(), file2, bl);
    }

    public static Status unauthorized(File file2, String string) {
        return new Status(JavaResults.Unauthorized(), file2, true, string);
    }

    public static Status unauthorized(Chunks<?> chunks) {
        return new Status(JavaResults.Unauthorized(), chunks);
    }

    public static StatusHeader badRequest() {
        return new StatusHeader(JavaResults.BadRequest());
    }

    public static Status badRequest(Content content) {
        return new Status(JavaResults.BadRequest(), content, utf8);
    }

    public static Status badRequest(Content content, String string) {
        return new Status(JavaResults.BadRequest(), content, Codec.javaSupported(string));
    }

    public static Status badRequest(String string) {
        return new Status(JavaResults.BadRequest(), string, utf8);
    }

    public static Status badRequest(String string, String string2) {
        return new Status(JavaResults.BadRequest(), string, Codec.javaSupported(string2));
    }

    public static Status badRequest(JsonNode jsonNode) {
        return new Status(JavaResults.BadRequest(), jsonNode, utf8);
    }

    public static Status badRequest(JsonNode jsonNode, String string) {
        return new Status(JavaResults.BadRequest(), jsonNode, Codec.javaSupported(string));
    }

    public static Status badRequest(byte[] byArray) {
        return new Status(JavaResults.BadRequest(), byArray);
    }

    public static Status badRequest(InputStream inputStream) {
        return Results.badRequest(inputStream, defaultChunkSize);
    }

    public static Status badRequest(InputStream inputStream, int n) {
        return new Status(JavaResults.BadRequest(), inputStream, n);
    }

    public static Status badRequest(File file2) {
        return new Status(JavaResults.BadRequest(), file2);
    }

    public static Status badRequest(File file2, boolean bl) {
        return new Status(JavaResults.BadRequest(), file2, bl);
    }

    public static Status badRequest(File file2, String string) {
        return new Status(JavaResults.BadRequest(), file2, true, string);
    }

    public static Status badRequest(Chunks<?> chunks) {
        return new Status(JavaResults.BadRequest(), chunks);
    }

    public static Result redirect(String string) {
        return new Redirect(303, string);
    }

    public static Result redirect(Call call2) {
        return new Redirect(303, call2.url());
    }

    public static Result found(String string) {
        return new Redirect(302, string);
    }

    public static Result found(Call call2) {
        return new Redirect(302, call2.url());
    }

    public static Result movedPermanently(String string) {
        return new Redirect(301, string);
    }

    public static Result movedPermanently(Call call2) {
        return new Redirect(301, call2.url());
    }

    public static Result seeOther(String string) {
        return new Redirect(303, string);
    }

    public static Result seeOther(Call call2) {
        return new Redirect(303, call2.url());
    }

    public static Result temporaryRedirect(String string) {
        return new Redirect(307, string);
    }

    public static Result temporaryRedirect(Call call2) {
        return new Redirect(307, call2.url());
    }

    public static class Redirect
    implements Result {
        private final play.api.mvc.Result wrappedResult;

        public Redirect(int n, String string) {
            this.wrappedResult = JavaResults.Redirect(string, n);
        }

        @Override
        public play.api.mvc.Result toScala() {
            return this.wrappedResult;
        }
    }

    public static class Status
    implements Result {
        private play.api.mvc.Result wrappedResult;

        public Status(play.api.mvc.Result result) {
            this.wrappedResult = result;
        }

        public Status(Results.Status status, String string, Codec codec) {
            if (string == null) {
                throw new NullPointerException("null content");
            }
            this.wrappedResult = status.apply(string, JavaResults.writeString(codec));
        }

        public Status(Results.Status status, JsonNode jsonNode, Codec codec) {
            if (jsonNode == null) {
                throw new NullPointerException("null content");
            }
            this.wrappedResult = status.apply(jsonNode, JavaResults.writeJson(codec));
        }

        public Status(Results.Status status, Content content, Codec codec) {
            if (content == null) {
                throw new NullPointerException("null content");
            }
            this.wrappedResult = status.apply(content, JavaResults.writeContent(content.contentType(), codec));
        }

        public <A> Status(Results.Status status, Chunks<A> chunks) {
            if (chunks == null) {
                throw new NullPointerException("null content");
            }
            this.wrappedResult = status.chunked(chunks.enumerator, chunks.writable);
        }

        public Status(Results.Status status, byte[] byArray) {
            if (byArray == null) {
                throw new NullPointerException("null content");
            }
            this.wrappedResult = status.apply(byArray, JavaResults.writeBytes());
        }

        public Status(Results.Status status, File file2) {
            this(status, file2, false);
        }

        public Status(Results.Status status, File file2, boolean bl) {
            this(status, file2, bl, file2.getName());
        }

        public Status(Results.Status status, File file2, boolean bl, String string) {
            if (file2 == null) {
                throw new NullPointerException("null content");
            }
            this.wrappedResult = JavaResults.sendFile(status, file2, bl, string);
        }

        public Status(Results.Status status, File file2, int n) {
            if (file2 == null) {
                throw new NullPointerException("null content");
            }
            this.wrappedResult = status.chunked(JavaResults.chunked(file2, n), JavaResults.writeBytes(Scala.orNull(MimeTypes.forFileName(file2.getName()))));
        }

        public Status(Results.Status status, InputStream inputStream, int n) {
            if (inputStream == null) {
                throw new NullPointerException("null content");
            }
            this.wrappedResult = status.stream(JavaResults.chunked(inputStream, n), JavaResults.writeBytes());
        }

        @Override
        public play.api.mvc.Result toScala() {
            return this.wrappedResult;
        }

        public Status as(String string) {
            this.wrappedResult = this.wrappedResult.as(string);
            return this;
        }

        public String toString() {
            return this.wrappedResult.toString();
        }
    }

    public static class StatusHeader
    implements Result {
        private final Results.Status wrappedStatus;

        public StatusHeader(Results.Status status) {
            this.wrappedStatus = status;
        }

        public Status sendResource(String string) {
            return this.sendResource(string, true);
        }

        public Status sendResource(String string, ClassLoader classLoader) {
            return this.sendResource(string, classLoader, true);
        }

        public Status sendResource(String string, boolean bl) {
            return this.sendResource(string, this.getClass().getClassLoader(), bl);
        }

        public Status sendResource(String string, ClassLoader classLoader, boolean bl) {
            return new Status(this.wrappedStatus.sendResource(string, classLoader, bl));
        }

        public Status sendPath(Path path) {
            return this.sendPath(path, false);
        }

        public Status sendPath(Path path, boolean bl) {
            return this.sendPath(path, bl, path.getFileName().toString());
        }

        public Status sendPath(Path path, boolean bl, String string) {
            if (path == null) {
                throw new NullPointerException("null content");
            }
            return new Status(JavaResults.sendPath(this.wrappedStatus, path, bl, string));
        }

        public Status sendPath(Path path, int n) {
            if (path == null) {
                throw new NullPointerException("null content");
            }
            return new Status(this.wrappedStatus.chunked(JavaResults.chunked(path, n), JavaResults.writeBytes(Scala.orNull(MimeTypes.forFileName(path.getFileName().toString())))));
        }

        @Override
        public play.api.mvc.Result toScala() {
            return this.wrappedStatus;
        }
    }

    public static class Todo
    implements Result {
        private final play.api.mvc.Result wrappedResult = JavaResults.NotImplemented().apply(todo.render(), JavaResults.writeContent("text/html", utf8));

        @Override
        public play.api.mvc.Result toScala() {
            return this.wrappedResult;
        }
    }

    public static abstract class ByteChunks
    extends Chunks<byte[]> {
        public ByteChunks() {
            super(JavaResults.writeBytes());
        }

        public static ByteChunks whenReady(F.Callback<Chunks.Out<byte[]>> callback) {
            return new WhenReadyByteChunks(callback);
        }

        static final class WhenReadyByteChunks
        extends ByteChunks {
            private static final Logger logger = LoggerFactory.getLogger(WhenReadyByteChunks.class);
            private final F.Callback<Chunks.Out<byte[]>> callback;

            WhenReadyByteChunks(F.Callback<Chunks.Out<byte[]>> callback) {
                if (callback == null) {
                    throw new NullPointerException("ByteChunks onReady callback cannot be null");
                }
                this.callback = callback;
            }

            @Override
            public void onReady(Chunks.Out<byte[]> out) {
                try {
                    this.callback.invoke(out);
                }
                catch (Throwable throwable) {
                    logger.error("Exception in ByteChunks.onReady", throwable);
                }
            }
        }
    }

    public static abstract class StringChunks
    extends Chunks<String> {
        private static final Logger logger = LoggerFactory.getLogger(StringChunks.class);

        public StringChunks() {
            this(utf8);
        }

        public StringChunks(String string) {
            this(Codec.javaSupported(string));
        }

        public StringChunks(Codec codec) {
            super(JavaResults.writeString(codec));
        }

        public static StringChunks whenReady(F.Callback<Chunks.Out<String>> callback) {
            return StringChunks.whenReady(utf8, callback);
        }

        public static StringChunks whenReady(String string, F.Callback<Chunks.Out<String>> callback) {
            return StringChunks.whenReady(Codec.javaSupported(string), callback);
        }

        public static StringChunks whenReady(Codec codec, F.Callback<Chunks.Out<String>> callback) {
            return new WhenReadyStringChunks(codec, callback);
        }

        static final class WhenReadyStringChunks
        extends StringChunks {
            private final F.Callback<Chunks.Out<String>> callback;

            WhenReadyStringChunks(Codec codec, F.Callback<Chunks.Out<String>> callback) {
                super(codec);
                if (callback == null) {
                    throw new NullPointerException("StringChunks onReady callback cannot be null");
                }
                this.callback = callback;
            }

            @Override
            public void onReady(Chunks.Out<String> out) {
                try {
                    this.callback.invoke(out);
                }
                catch (Throwable throwable) {
                    logger.error("Exception in StringChunks.onReady", throwable);
                }
            }
        }
    }

    public static abstract class Chunks<A> {
        final Enumerator<A> enumerator;
        final Writeable<A> writable;

        public Chunks(Writeable<A> writeable2) {
            final Chunks chunks = this;
            this.writable = writeable2;
            final F.RedeemablePromise redeemablePromise = F.RedeemablePromise.empty();
            this.enumerator = JavaResults.chunked(new F.Callback<Concurrent.Channel<A>>(){

                @Override
                public void invoke(Concurrent.Channel<A> channel) {
                    Out out = new Out(channel, redeemablePromise);
                    chunks.onReady(out);
                }
            }, () -> redeemablePromise.success(null));
        }

        public abstract void onReady(Out<A> var1);

        public static class Out<A> {
            final F.RedeemablePromise<Object> disconnected;
            final Concurrent.Channel<A> channel;

            public Out(Concurrent.Channel<A> channel, F.RedeemablePromise<Object> redeemablePromise) {
                this.channel = channel;
                this.disconnected = redeemablePromise;
            }

            public Out(Concurrent.Channel<A> channel, List<F.Callback0> list) {
                this.channel = channel;
                this.disconnected = F.RedeemablePromise.empty();
                for (F.Callback0 callback0 : list) {
                    this.onDisconnected(callback0);
                }
            }

            public void write(A a) {
                this.channel.push(a);
            }

            public void onDisconnected(F.Callback0 callback0) {
                this.disconnected.onRedeem(object -> callback0.invoke());
            }

            public void close() {
                this.channel.eofAndEnd();
            }
        }
    }
}

