/*
 * Decompiled with CFR 0.152.
 */
package org.sweble.wom3.impl;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.ListIterator;
import java.util.Map;
import org.sweble.wom3.Wom3Article;
import org.sweble.wom3.Wom3Body;
import org.sweble.wom3.Wom3Category;
import org.sweble.wom3.Wom3Node;
import org.sweble.wom3.Wom3Redirect;
import org.sweble.wom3.impl.AttributeBase;
import org.sweble.wom3.impl.AttributeDescriptor;
import org.sweble.wom3.impl.Backbone;
import org.sweble.wom3.impl.BackboneContainer;
import org.sweble.wom3.impl.BodyImpl;
import org.sweble.wom3.impl.CategoryImpl;
import org.sweble.wom3.impl.ChildDescriptor;
import org.sweble.wom3.impl.DocumentImpl;
import org.sweble.wom3.impl.NativeAndStringValuePair;
import org.sweble.wom3.impl.RedirectImpl;
import org.sweble.wom3.impl.SiblingCollectionBounds;
import org.sweble.wom3.impl.SiblingRangeCollection;
import org.sweble.wom3.impl.Toolbox;

public class ArticleImpl
extends BackboneContainer
implements Wom3Article {
    private static final long serialVersionUID = 1L;
    private static final ChildDescriptor[] BODY_DESCRIPTOR = new ChildDescriptor[]{ArticleImpl.childDesc("redirect"), ArticleImpl.childDesc("category", 2), ArticleImpl.childDesc("body", 1)};
    private RedirectImpl redirect = null;
    private SiblingRangeCollection<ArticleImpl, CategoryImpl> categories;
    private BodyImpl body;
    private static final Map<String, AttributeDescriptor> nameMap = ArticleImpl.getNameMap();

    public ArticleImpl(DocumentImpl owner) {
        super(owner);
        this.setAttributeDirectNoChecks("version", "3.0");
        this.categories = new SiblingRangeCollection(this, new SiblingCollectionsBoundIml());
    }

    @Override
    public String getWomName() {
        return "article";
    }

    @Override
    public String getName() {
        String namespace = this.getNamespace();
        String path = this.getPath();
        String title = this.getTitle();
        String name = "";
        if (namespace != null) {
            name = name + namespace;
            name = name + ':';
        }
        if (path != null) {
            name = name + path;
            name = name + '/';
        }
        name = name + title;
        return name;
    }

    @Override
    public String getVersion() {
        return "3.0";
    }

    @Override
    public String getTitle() {
        return this.getStringAttr("title");
    }

    @Override
    public String setTitle(String title) throws IllegalArgumentException, NullPointerException {
        return this.setAttributeDirect(Attributes.TITLE, "title", title);
    }

    @Override
    public String getNamespace() {
        return this.getStringAttr("namespace");
    }

    @Override
    public String setNamespace(String namespace) {
        return this.setAttributeDirect(Attributes.NAMESPACE, "namespace", namespace);
    }

    @Override
    public String getPath() {
        return this.getStringAttr("path");
    }

    @Override
    public String setPath(String path) {
        return this.setAttributeDirect(Attributes.PATH, "path", path);
    }

    @Override
    public boolean isRedirect() {
        return this.redirect != null;
    }

    @Override
    public Wom3Redirect getRedirect() {
        return this.redirect;
    }

    @Override
    public Wom3Redirect setRedirect(Wom3Redirect redirect) {
        return (Wom3Redirect)this.replaceOrInsertBeforeOrAppend(this.redirect, this.getFirstChild(), redirect, false);
    }

    @Override
    public Collection<Wom3Category> getCategories() {
        Collection<Wom3Category> uc = Collections.unmodifiableCollection(this.categories);
        return uc;
    }

    @Override
    public boolean hasCategory(String name) throws NullPointerException {
        ListIterator i = this.categories.listIterator();
        while (i.hasNext()) {
            CategoryImpl cat = (CategoryImpl)i.next();
            if (!cat.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Wom3Category removeCategory(String name) throws NullPointerException {
        if (name == null) {
            throw new NullPointerException();
        }
        ListIterator i = this.categories.listIterator();
        while (i.hasNext()) {
            CategoryImpl cat = (CategoryImpl)i.next();
            if (!cat.getName().equals(name)) continue;
            i.remove();
            return cat;
        }
        return null;
    }

    @Override
    public Wom3Category addCategory(String name) throws NullPointerException {
        CategoryImpl cat;
        ListIterator<CategoryImpl> i = this.categories.listIterator();
        while (i.hasNext()) {
            cat = (CategoryImpl)i.next();
            if (!cat.getName().equals(name)) continue;
            return cat;
        }
        cat = (CategoryImpl)this.getOwnerDocument().createElementNS("http://sweble.org/schema/wom30", "category");
        cat.setName(name);
        i.add(cat);
        return cat;
    }

    @Override
    public Wom3Body getBody() {
        return this.body;
    }

    @Override
    public Wom3Body setBody(Wom3Body body) throws NullPointerException {
        return (Wom3Body)this.replaceOrAppend(this.body, body, true);
    }

    @Override
    public Wom3Node cloneNode(boolean deep) {
        ArticleImpl newNode = (ArticleImpl)super.cloneNode(deep);
        newNode.categories = new SiblingRangeCollection(this, new SiblingCollectionsBoundIml());
        return newNode;
    }

    @Override
    protected void allowsInsertion(Backbone prev, Backbone child) {
        this.checkInsertion(prev, child, BODY_DESCRIPTOR);
    }

    @Override
    protected void allowsRemoval(Backbone child) {
        this.checkRemoval(child, BODY_DESCRIPTOR);
    }

    @Override
    protected void allowsReplacement(Backbone oldChild, Backbone newChild) {
        this.checkReplacement(oldChild, newChild, BODY_DESCRIPTOR);
    }

    @Override
    protected void childInserted(Backbone prev, Backbone added) {
        if (added instanceof Wom3Redirect) {
            this.redirect = (RedirectImpl)added;
        } else if (added instanceof Wom3Body) {
            this.body = (BodyImpl)added;
        }
    }

    @Override
    protected void childRemoved(Backbone prev, Backbone removed) {
        if (removed == this.redirect) {
            this.redirect = null;
        }
    }

    protected void validateCategoryNameChange(CategoryImpl catImpl, String newName) {
        ListIterator i = this.categories.listIterator();
        while (i.hasNext()) {
            CategoryImpl cat = (CategoryImpl)i.next();
            if (!cat.getName().equals(newName)) continue;
            if (cat == catImpl) {
                return;
            }
            throw new IllegalStateException("Renaming the attribute leads to name collision in parent node!");
        }
    }

    private static Map<String, AttributeDescriptor> getNameMap() {
        HashMap<String, AttributeDescriptor> nameMap = new HashMap<String, AttributeDescriptor>();
        nameMap.put("version", Attributes.VERSION);
        nameMap.put("namespace", Attributes.NAMESPACE);
        nameMap.put("path", Attributes.PATH);
        nameMap.put("title", Attributes.TITLE);
        return nameMap;
    }

    @Override
    protected AttributeDescriptor getAttributeDescriptor(String namespaceUri, String localName, String qualifiedName) {
        return ArticleImpl.getAttrDescStrict(namespaceUri, localName, qualifiedName, nameMap);
    }

    private static enum Attributes implements AttributeDescriptor
    {
        VERSION{

            @Override
            public boolean verifyAndConvert(Backbone parent, NativeAndStringValuePair verified) {
                if ("3.0".equals(verified.strValue)) {
                    verified.value = verified.strValue;
                    return true;
                }
                throw new UnsupportedOperationException("Cannot alter read-only attribute `version'");
            }

            @Override
            public boolean isRemovable() {
                return false;
            }
        }
        ,
        TITLE{

            @Override
            public boolean verifyAndConvert(Backbone parent, NativeAndStringValuePair verified) {
                if (verified.strValue == null) {
                    verified.strValue = (String)verified.value;
                }
                Toolbox.checkValidTitle(verified.strValue);
                return true;
            }

            @Override
            public boolean isRemovable() {
                return false;
            }
        }
        ,
        NAMESPACE{

            @Override
            public boolean verifyAndConvert(Backbone parent, NativeAndStringValuePair verified) {
                if (verified.strValue == null) {
                    verified.strValue = (String)verified.value;
                }
                verified.strValue = Toolbox.checkValidNamespace(verified.strValue);
                verified.value = verified.strValue;
                return verified.strValue != null;
            }
        }
        ,
        PATH{

            @Override
            public boolean verifyAndConvert(Backbone parent, NativeAndStringValuePair verified) {
                if (verified.strValue == null) {
                    verified.strValue = (String)verified.value;
                }
                verified.strValue = Toolbox.checkValidPath(verified.strValue);
                verified.value = verified.strValue;
                return verified.strValue != null;
            }
        };


        @Override
        public boolean isRemovable() {
            return true;
        }

        @Override
        public AttributeDescriptor.Normalization getNormalizationMode() {
            return AttributeDescriptor.Normalization.NONE;
        }

        @Override
        public void customAction(Wom3Node parent, AttributeBase oldAttr, AttributeBase newAttr) {
        }
    }

    private final class SiblingCollectionsBoundIml
    implements SiblingCollectionBounds,
    Serializable {
        private static final long serialVersionUID = 1L;

        private SiblingCollectionsBoundIml() {
        }

        @Override
        public Backbone getPred() {
            return ArticleImpl.this.redirect;
        }

        @Override
        public Backbone getSucc() {
            return ArticleImpl.this.body;
        }
    }
}

