/*
 * Decompiled with CFR 0.152.
 */
package org.sweble.wom3.impl;

import org.sweble.wom3.Wom3Attribute;
import org.sweble.wom3.impl.AttributeDescriptor;
import org.sweble.wom3.impl.Backbone;
import org.sweble.wom3.impl.BackboneElement;
import org.sweble.wom3.impl.DocumentImpl;
import org.sweble.wom3.impl.NativeAndStringValuePair;
import org.sweble.wom3.impl.Toolbox;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.TypeInfo;

public abstract class AttributeBase
extends Backbone
implements Wom3Attribute {
    private static final long serialVersionUID = 1L;
    private String name;

    protected AttributeBase(DocumentImpl owner) {
        super(owner);
    }

    @Override
    public abstract String getValue();

    protected abstract Object getNativeValue();

    protected abstract void setValue(Object var1, String var2);

    @Override
    public String getNodeName() {
        return this.getName();
    }

    @Override
    public short getNodeType() {
        return 2;
    }

    @Override
    public Backbone getParentNode() {
        return null;
    }

    @Override
    public Element getOwnerElement() {
        return (Element)((Object)this.getParentNodeIntern());
    }

    @Override
    public void setTextContent(String textContent) throws DOMException {
    }

    @Override
    public boolean getSpecified() {
        return true;
    }

    @Override
    public TypeInfo getSchemaTypeInfo() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isId() {
        return false;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String setName(String name) throws IllegalArgumentException, NullPointerException {
        if (this.name != null && this.name.equals(name)) {
            return this.name;
        }
        Toolbox.checkValidXmlName(name);
        return this.setName(null, null, name);
    }

    @Override
    public String getNodeValue() throws DOMException {
        return this.getValue();
    }

    @Override
    public void setValue(String value) {
        this.setNodeValue(value);
    }

    @Override
    public void setNodeValue(String nodeValue) throws DOMException {
        if (nodeValue == null) {
            throw new NullPointerException();
        }
        this.validateValueChangeWithParentAndSet(nodeValue);
    }

    protected String setName(String namespaceUri, String localName, String name) throws IllegalArgumentException, NullPointerException {
        if (this.name != null && this.name.equals(name) && this.getNamespaceURI() != null && this.getNamespaceURI().equals(namespaceUri)) {
            return this.name;
        }
        this.validateNameChangeWithParent(namespaceUri, localName, name);
        String old = this.getName();
        this.setNameUnchecked(name);
        return old;
    }

    protected void setNameUnchecked(String name) {
        this.name = name;
    }

    private void validateNameChangeWithParent(String namespaceUri, String localName, String name) {
        boolean exists;
        BackboneElement parent = (BackboneElement)this.getOwnerElement();
        if (parent == null) {
            return;
        }
        boolean bl = localName != null ? parent.getAttributeNodeNS(namespaceUri, localName) != null : (exists = parent.getAttributeNode(name) != null);
        if (exists) {
            throw new IllegalArgumentException("Attribute with this name already exists for the corresponding element!");
        }
        AttributeDescriptor descriptor = parent.getAttributeDescriptorOrFail(namespaceUri, localName, name);
        descriptor.customAction(parent, this, this);
    }

    private void validateValueChangeWithParentAndSet(String value) {
        BackboneElement parent = (BackboneElement)this.getOwnerElement();
        if (parent == null) {
            this.setValue(value, value);
            return;
        }
        String namespaceUri = this.getNamespaceURI();
        String localName = this.getLocalName();
        AttributeDescriptor descriptor = parent.getAttributeDescriptorOrFail(namespaceUri, localName, this.name);
        NativeAndStringValuePair verified = new NativeAndStringValuePair(value);
        if (value == null || !descriptor.verifyAndConvert(parent, verified)) {
            throw new UnsupportedOperationException("Attribute `" + namespaceUri + "' / `" + this.name + "' cannot remove itself!");
        }
        this.setValue(verified.value, verified.strValue);
        descriptor.customAction(parent, this, this);
    }
}

