/*
 * Decompiled with CFR 0.152.
 */
package org.sweble.wom3.impl;

import org.sweble.wom3.impl.AttributeImpl;
import org.sweble.wom3.impl.DocumentImpl;
import org.sweble.wom3.impl.Toolbox;
import org.w3c.dom.DOMException;

public class AttributeNsImpl
extends AttributeImpl {
    private static final long serialVersionUID = 1L;
    private static final String XMLNS_URI = "http://www.w3.org/2000/xmlns/";
    private static final String XML_URI = "http://www.w3.org/XML/1998/namespace";
    private String namespaceUri;
    private String localName;
    private String prefix;

    public AttributeNsImpl(DocumentImpl owner, String namespaceUri, String qualifiedName) {
        super(owner);
        this.setNamespaceUri(namespaceUri);
        this.setPrefixAndLocalName(qualifiedName);
    }

    @Override
    public String getNamespaceURI() {
        return this.namespaceUri;
    }

    @Override
    public String getLocalName() {
        return this.localName;
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public void setPrefix(String prefix) throws DOMException {
        String newName = this.localName;
        if (prefix != null && !prefix.isEmpty()) {
            if (prefix.indexOf(58) >= 0) {
                throw new DOMException(14, "Prefix must not contain ':'");
            }
            AttributeNsImpl.checkNamespaceUriAndPrefix(prefix, this.namespaceUri);
            Toolbox.checkValidXmlName(prefix);
            newName = prefix + ":" + this.localName;
        }
        super.setName(newName);
    }

    @Override
    public String setName(String qualifiedName) throws IllegalArgumentException, NullPointerException {
        return this.setPrefixAndLocalName(qualifiedName);
    }

    private void setNamespaceUri(String namespaceUri) {
        this.namespaceUri = namespaceUri;
        if (this.namespaceUri != null && this.namespaceUri.isEmpty()) {
            this.namespaceUri = null;
        }
    }

    private String setPrefixAndLocalName(String qualifiedName) {
        String prefix = null;
        String localName = null;
        int colon = qualifiedName.indexOf(58);
        if (colon < 0) {
            prefix = null;
            localName = qualifiedName;
            AttributeNsImpl.checkNamespaceUriAndName(this.namespaceUri, qualifiedName);
        } else {
            if (colon == 0 || colon == qualifiedName.length() - 1 || qualifiedName.indexOf(58, colon + 1) >= 0) {
                throw new DOMException(14, "Invalid qualified attribute name: " + qualifiedName);
            }
            prefix = qualifiedName.substring(0, colon);
            localName = qualifiedName.substring(colon + 1);
            AttributeNsImpl.checkNamespaceUriAndPrefix(prefix, this.namespaceUri);
            Toolbox.checkValidXmlName(prefix);
        }
        Toolbox.checkValidXmlName(localName);
        String old = this.setName(this.namespaceUri, localName, qualifiedName);
        this.prefix = prefix;
        this.localName = localName;
        return old;
    }

    private static void checkNamespaceUriAndName(String namespaceUri, String qualifiedName) {
        assert (qualifiedName != null);
        if (qualifiedName.equals("xmlns") && !XMLNS_URI.equals(namespaceUri)) {
            throw new DOMException(14, "An attribute with name 'xmlns' must have its its namespace URI set to 'http://www.w3.org/2000/xmlns/'");
        }
        if (XMLNS_URI.equals(namespaceUri) && !qualifiedName.equals("xmlns")) {
            throw new DOMException(14, "An attribute with namespace URI 'http://www.w3.org/2000/xmlns/' must be called 'xmlns' or must have a prefix called 'xmlns'");
        }
    }

    private static void checkNamespaceUriAndPrefix(String prefix, String namespaceUri) {
        assert (prefix != null && namespaceUri != null);
        if (namespaceUri == null) {
            throw new DOMException(14, "A qualified (prefixed) attribute name requires a non-null namespace URI");
        }
        if (prefix.equals("xml") && !namespaceUri.equals(XML_URI)) {
            throw new DOMException(14, "An attribute with prefix 'xml' must have its namespace URI set to 'http://www.w3.org/XML/1998/namespace'");
        }
        if (prefix.equals("xmlns") && !namespaceUri.equals(XMLNS_URI)) {
            throw new DOMException(14, "An attribute with prefix 'xmlns' must have its its namespace URI set to 'http://www.w3.org/2000/xmlns/'");
        }
        if (namespaceUri.equals(XMLNS_URI) && !prefix.equals("xmlns")) {
            throw new DOMException(14, "An attribute with namespace URI 'http://www.w3.org/2000/xmlns/' must be called 'xmlns' or must have a prefix called 'xmlns'");
        }
    }
}

