/*
 * Decompiled with CFR 0.152.
 */
package org.sweble.wom3.impl;

import java.net.URL;
import org.joda.time.DateTime;
import org.sweble.wom3.Wom3BulletStyle;
import org.sweble.wom3.Wom3Clear;
import org.sweble.wom3.Wom3HorizAlign;
import org.sweble.wom3.Wom3I18nDir;
import org.sweble.wom3.Wom3TableCaptionAlign;
import org.sweble.wom3.Wom3TableCellScope;
import org.sweble.wom3.Wom3TableFrame;
import org.sweble.wom3.Wom3TableRules;
import org.sweble.wom3.Wom3TableVAlign;
import org.sweble.wom3.Wom3ValueWithUnit;
import org.sweble.wom3.impl.Backbone;
import org.sweble.wom3.impl.ColorImpl;
import org.sweble.wom3.impl.NativeAndStringValuePair;
import org.sweble.wom3.impl.Toolbox;

public enum AttributeVerifiers {
    ID{

        @Override
        public boolean verifyAndConvert(Backbone parent, NativeAndStringValuePair verified) {
            return true;
        }
    }
    ,
    NMTOKENS{

        @Override
        public boolean verifyAndConvert(Backbone parent, NativeAndStringValuePair verified) {
            return true;
        }
    }
    ,
    STYLESHEET{

        @Override
        public boolean verifyAndConvert(Backbone parent, NativeAndStringValuePair verified) {
            return true;
        }
    }
    ,
    DIR{

        @Override
        public boolean verifyAndConvert(Backbone parent, NativeAndStringValuePair verified) {
            if (verified.strValue != null) {
                verified.value = Toolbox.stringToDir(verified.strValue);
            } else {
                verified.strValue = Toolbox.dirToString((Wom3I18nDir)((Object)verified.value));
            }
            return true;
        }
    }
    ,
    LANGUAGE_CODE{

        @Override
        public boolean verifyAndConvert(Backbone parent, NativeAndStringValuePair verified) {
            return true;
        }
    }
    ,
    SCRIPT{

        @Override
        public boolean verifyAndConvert(Backbone parent, NativeAndStringValuePair verified) {
            return true;
        }
    }
    ,
    CLEAR{

        @Override
        public boolean verifyAndConvert(Backbone parent, NativeAndStringValuePair verified) {
            if (verified.strValue != null) {
                verified.value = Toolbox.stringToClear(verified.strValue);
            } else {
                verified.strValue = Toolbox.clearToString((Wom3Clear)((Object)verified.value));
            }
            return true;
        }
    }
    ,
    URL{

        @Override
        public boolean verifyAndConvert(Backbone parent, NativeAndStringValuePair verified) {
            if (verified.strValue != null) {
                verified.value = Toolbox.stringToUrl(verified.strValue);
            } else {
                verified.strValue = Toolbox.urlToString((URL)verified.value);
            }
            if (verified.strValue.isEmpty()) {
                throw new IllegalArgumentException("Expected non-empty URL");
            }
            return true;
        }
    }
    ,
    DATETIME{

        @Override
        public boolean verifyAndConvert(Backbone parent, NativeAndStringValuePair verified) {
            if (verified.strValue != null) {
                verified.value = Toolbox.stringToDateTime(verified.strValue);
            } else {
                verified.strValue = Toolbox.dateTimeToString((DateTime)verified.value);
            }
            return true;
        }
    }
    ,
    LCR_ALIGN{

        @Override
        public boolean verifyAndConvert(Backbone parent, NativeAndStringValuePair verified) {
            if (verified.strValue != null) {
                verified.value = Toolbox.stringToHorizAlign(verified.strValue);
            } else {
                verified.strValue = Toolbox.horizAlignToString((Wom3HorizAlign)((Object)verified.value));
            }
            switch ((Wom3HorizAlign)((Object)verified.value)) {
                case CHAR: {
                    throw new IllegalArgumentException("`char' not allowed as alignment!");
                }
                case JUSTIFY: {
                    throw new IllegalArgumentException("`justify' not allowed as alignment!");
                }
            }
            return true;
        }
    }
    ,
    LCRJ_ALIGN{

        @Override
        public boolean verifyAndConvert(Backbone parent, NativeAndStringValuePair verified) {
            if (verified.strValue != null) {
                verified.value = Toolbox.stringToHorizAlign(verified.strValue);
            } else {
                verified.strValue = Toolbox.horizAlignToString((Wom3HorizAlign)((Object)verified.value));
            }
            if ((Wom3HorizAlign)((Object)verified.value) == Wom3HorizAlign.CHAR) {
                throw new IllegalArgumentException("`char' not allowed as alignment!");
            }
            return true;
        }
    }
    ,
    PIXELS{

        @Override
        public boolean verifyAndConvert(Backbone parent, NativeAndStringValuePair verified) {
            if (verified.strValue != null) {
                verified.value = Integer.parseInt(verified.strValue.trim());
            } else {
                verified.strValue = String.valueOf((Integer)verified.value);
            }
            if ((Integer)verified.value < 0) {
                throw new IllegalArgumentException("Expected non-negative integer!");
            }
            return true;
        }
    }
    ,
    COLOR{

        @Override
        public boolean verifyAndConvert(Backbone parent, NativeAndStringValuePair verified) {
            if (verified.strValue != null) {
                verified.value = ColorImpl.valueOf(verified.strValue);
            } else {
                verified.strValue = verified.value.toString();
            }
            return true;
        }
    }
    ,
    FONTSIZE{

        @Override
        public boolean verifyAndConvert(Backbone parent, NativeAndStringValuePair verified) {
            if (verified.strValue != null) {
                verified.value = 14.verifyRange(verified.strValue, 1, 7);
            } else {
                verified.strValue = String.valueOf(14.verifyRange((Integer)verified.value, 1, 7));
            }
            return true;
        }
    }
    ,
    NUMBER{

        @Override
        public boolean verifyAndConvert(Backbone parent, NativeAndStringValuePair verified) {
            if (verified.strValue != null) {
                verified.value = Integer.parseInt(verified.strValue.trim());
            } else {
                verified.strValue = String.valueOf((Integer)verified.value);
            }
            if ((Integer)verified.value < 0) {
                throw new IllegalArgumentException("Expected non-negative integer!");
            }
            return true;
        }
    }
    ,
    LENGTH{

        @Override
        public boolean verifyAndConvert(Backbone parent, NativeAndStringValuePair verified) {
            if (verified.strValue != null) {
                verified.value = Toolbox.stringToLength(verified.strValue);
            } else {
                verified.strValue = Toolbox.lengthToString((Wom3ValueWithUnit)verified.value);
            }
            return true;
        }
    }
    ,
    OLTYPE{

        @Override
        public boolean verifyAndConvert(Backbone parent, NativeAndStringValuePair verified) {
            return true;
        }
    }
    ,
    ULTYPE{

        @Override
        public boolean verifyAndConvert(Backbone parent, NativeAndStringValuePair verified) {
            if (verified.strValue != null) {
                verified.value = Toolbox.stringToBulletStyle(verified.strValue);
            } else {
                verified.strValue = Toolbox.bulletStyleToString((Wom3BulletStyle)((Object)verified.value));
            }
            return true;
        }
    }
    ,
    ITEMTYPE{

        @Override
        public boolean verifyAndConvert(Backbone parent, NativeAndStringValuePair verified) {
            return true;
        }
    }
    ,
    LCRJC_ALIGN{

        @Override
        public boolean verifyAndConvert(Backbone parent, NativeAndStringValuePair verified) {
            return LCRJ_ALIGN.verifyAndConvert(parent, verified);
        }
    }
    ,
    TMBB_VALIGN{

        @Override
        public boolean verifyAndConvert(Backbone parent, NativeAndStringValuePair verified) {
            if (verified.strValue != null) {
                verified.value = Toolbox.stringToTableVAlign(verified.strValue);
            } else {
                verified.strValue = Toolbox.tableVAlignToString((Wom3TableVAlign)((Object)verified.value));
            }
            return true;
        }
    }
    ,
    TBLR_ALIGN{

        @Override
        public boolean verifyAndConvert(Backbone parent, NativeAndStringValuePair verified) {
            if (verified.strValue != null) {
                verified.value = Toolbox.stringToCaptionAlign(verified.strValue);
            } else {
                verified.strValue = Toolbox.captionAlignToString((Wom3TableCaptionAlign)((Object)verified.value));
            }
            return true;
        }
    }
    ,
    SCOPE{

        @Override
        public boolean verifyAndConvert(Backbone parent, NativeAndStringValuePair verified) {
            if (verified.strValue != null) {
                verified.value = Toolbox.stringToTableScope(verified.strValue);
            } else {
                verified.strValue = Toolbox.tableScopeToString((Wom3TableCellScope)((Object)verified.value));
            }
            return true;
        }
    }
    ,
    FRAME{

        @Override
        public boolean verifyAndConvert(Backbone parent, NativeAndStringValuePair verified) {
            if (verified.strValue != null) {
                verified.value = Toolbox.stringToTableFrame(verified.strValue);
            } else {
                verified.strValue = Toolbox.tableFrameToString((Wom3TableFrame)((Object)verified.value));
            }
            return true;
        }
    }
    ,
    RULES{

        @Override
        public boolean verifyAndConvert(Backbone parent, NativeAndStringValuePair verified) {
            if (verified.strValue != null) {
                verified.value = Toolbox.stringToTableRules(verified.strValue);
            } else {
                verified.strValue = Toolbox.tableRulesToString((Wom3TableRules)((Object)verified.value));
            }
            return true;
        }
    };


    public abstract boolean verifyAndConvert(Backbone var1, NativeAndStringValuePair var2);

    public static boolean verifyAndConvertBool(Backbone parent, NativeAndStringValuePair verified, String attrName) {
        if (verified.strValue != null) {
            verified.value = true;
            verified.strValue = attrName;
        } else {
            verified.strValue = attrName;
        }
        return (Boolean)verified.value;
    }

    public static int verifyRange(String valueStr, int lower, int upper) {
        Integer x = Integer.parseInt(valueStr.trim());
        AttributeVerifiers.verifyRange(x, lower, upper);
        return x;
    }

    public static int verifyRange(int value, int lower, int upper) {
        if (value < lower || value > upper) {
            throw new IllegalArgumentException(String.format("Attribute value out of bounds: %d <= (%d) <= %d.", lower, value, upper));
        }
        return value;
    }
}

