/*
 * Decompiled with CFR 0.152.
 */
package org.sweble.wom3.impl;

import de.fau.cs.osr.utils.StringUtils;
import java.util.Collection;
import java.util.Iterator;
import org.sweble.wom3.Wom3Attribute;
import org.sweble.wom3.Wom3Document;
import org.sweble.wom3.Wom3Node;
import org.sweble.wom3.impl.BackboneUserData;
import org.sweble.wom3.impl.DocumentImpl;
import org.sweble.wom3.impl.ImmutableSiblingCollection;
import org.sweble.wom3.impl.NodeListImpl;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.UserDataHandler;

public abstract class Backbone
implements Wom3Node {
    private static final long serialVersionUID = 1L;
    protected transient int childrenChanges = 0;
    private DocumentImpl owner;
    private Backbone parent;
    private Backbone prevSibling;
    private Backbone nextSibling;
    private BackboneUserData userData;

    public Backbone(DocumentImpl owner) {
        this.owner = owner;
    }

    @Override
    public abstract String getNodeName();

    @Override
    public String getNodeValue() throws DOMException {
        return null;
    }

    @Override
    public void setNodeValue(String nodeValue) throws DOMException {
    }

    @Override
    public abstract short getNodeType();

    @Override
    public Wom3Document getOwnerDocument() {
        return this.owner;
    }

    @Override
    public abstract Backbone getParentNode();

    @Override
    public Backbone getFirstChild() {
        return null;
    }

    @Override
    public Backbone getLastChild() {
        return null;
    }

    @Override
    public final Backbone getPreviousSibling() {
        return this.prevSibling;
    }

    @Override
    public final Backbone getNextSibling() {
        return this.nextSibling;
    }

    @Override
    public NodeList getChildNodes() {
        return new NodeListImpl(this);
    }

    @Override
    public NamedNodeMap getAttributes() {
        return null;
    }

    @Override
    public String getNamespaceURI() {
        return null;
    }

    @Override
    public String getPrefix() {
        return null;
    }

    @Override
    public void setPrefix(String prefix) throws DOMException {
    }

    @Override
    public String getLocalName() {
        return null;
    }

    @Override
    public final String getBaseURI() {
        return null;
    }

    @Override
    public String getTextContent() throws DOMException {
        if (!this.hasChildNodes()) {
            return "";
        }
        if (this.getFirstChild() == this.getLastChild()) {
            return this.getFirstChild().getTextContent();
        }
        StringBuilder b = new StringBuilder();
        this.getTextContentRecursive(b);
        return b.toString();
    }

    @Override
    public boolean hasAttributes() {
        return this.getFirstAttr() != null;
    }

    @Override
    public boolean hasChildNodes() {
        return this.getFirstChild() != null;
    }

    @Override
    public Wom3Node insertBefore(Node child_, Node before_) throws DOMException {
        return this.doesNotSupportChildNodes();
    }

    @Override
    public Wom3Node replaceChild(Node newChild_, Node oldChild_) throws DOMException {
        return this.doesNotSupportChildNodes();
    }

    @Override
    public Wom3Node removeChild(Node child_) throws DOMException {
        return this.doesNotSupportChildNodes();
    }

    @Override
    public Wom3Node appendChild(Node child_) throws DOMException {
        return this.doesNotSupportChildNodes();
    }

    @Override
    public void normalize() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String lookupPrefix(String namespaceURI) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String lookupNamespaceURI(String prefix) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isDefaultNamespace(String namespaceURI) {
        return namespaceURI != null && namespaceURI.equals("http://sweble.org/schema/wom30");
    }

    @Override
    public boolean isSameNode(Node other) {
        return other == this;
    }

    @Override
    public boolean isEqualNode(Node arg) {
        throw new UnsupportedOperationException();
    }

    @Override
    public short compareDocumentPosition(Node otherNode) throws DOMException {
        int i;
        Node n;
        Document otherOwner;
        Node thisNode = this;
        if (thisNode.isSameNode(otherNode)) {
            return 0;
        }
        if (!(otherNode instanceof Backbone)) {
            throw new DOMException(9, "Cannot compare nodes from different implementations");
        }
        Document thisOwner = this.getOwnerDocument();
        if (thisOwner == null) {
            assert (thisNode.getNodeType() == 9);
            thisOwner = (Document)thisNode;
        }
        if ((otherOwner = otherNode.getOwnerDocument()) == null) {
            assert (otherNode.getNodeType() == 9);
            otherOwner = (Document)otherNode;
        }
        if (thisOwner == null || !thisOwner.isSameNode(otherOwner)) {
            throw new DOMException(9, "Cannot compare nodes from different documents");
        }
        int thisDepth = 1;
        Node thisAncestor = thisNode;
        for (Node n2 = thisNode.getParentNode(); n2 != null; n2 = n2.getParentNode()) {
            if (n2.isSameNode(otherNode)) {
                return 10;
            }
            thisAncestor = n2;
            ++thisDepth;
        }
        int otherDepth = 1;
        Node otherAncestor = otherNode;
        for (Node n3 = otherNode.getParentNode(); n3 != null; n3 = n3.getParentNode()) {
            if (n3.isSameNode(thisNode)) {
                return 20;
            }
            otherAncestor = n3;
            ++otherDepth;
        }
        if (thisAncestor.getNodeType() == 2) {
            Wom3Attribute thisAncestorAttr = (Wom3Attribute)thisAncestor;
            if (otherAncestor.getNodeType() == 2) {
                Wom3Attribute otherAncestorAttr = (Wom3Attribute)otherAncestor;
                Element thisOwnerE = thisAncestorAttr.getOwnerElement();
                Element otherOwnerE = otherAncestorAttr.getOwnerElement();
                if (thisOwnerE == null || otherOwnerE == null) {
                    return 1;
                }
                if (thisOwnerE.isSameNode(otherOwnerE)) {
                    return (short)(((Backbone)((Object)otherAncestorAttr)).precedes(thisAncestorAttr) ? 34 : 36);
                }
            }
            thisDepth = 0;
            for (n = thisNode = thisAncestorAttr.getOwnerElement(); n != null; n = n.getParentNode()) {
                if (n.isSameNode(otherNode)) {
                    return 10;
                }
                thisAncestor = n;
                ++thisDepth;
            }
        }
        if (otherAncestor.getNodeType() == 2) {
            Wom3Attribute otherAncestorAttr = (Wom3Attribute)otherAncestor;
            otherDepth = 0;
            for (n = otherNode = otherAncestorAttr.getOwnerElement(); n != null; n = n.getParentNode()) {
                if (n.isSameNode(thisNode)) {
                    return 20;
                }
                otherAncestor = n;
                ++otherDepth;
            }
        }
        if (thisAncestor != otherAncestor || thisAncestor != thisOwner) {
            throw new RuntimeException("This should not happen...");
        }
        if (thisDepth > otherDepth) {
            for (i = 0; i < thisDepth - otherDepth; ++i) {
                if (!(thisNode = thisNode.getParentNode()).isSameNode(otherNode)) continue;
                return 2;
            }
        } else {
            for (i = 0; i < otherDepth - thisDepth; ++i) {
                if (!(otherNode = otherNode.getParentNode()).isSameNode(thisNode)) continue;
                return 4;
            }
        }
        Node thisNode2 = thisNode.getParentNode();
        for (Node otherNode2 = otherNode.getParentNode(); thisNode2 != otherNode2; thisNode2 = thisNode2.getParentNode(), otherNode2 = otherNode2.getParentNode()) {
            thisNode = thisNode2;
            otherNode = otherNode2;
        }
        for (Node n4 = thisNode2.getFirstChild(); n4 != null; n4 = n4.getNextSibling()) {
            if (n4 == otherNode) {
                return 2;
            }
            if (n4 != thisNode) continue;
            return 4;
        }
        throw new RuntimeException("This should not happen...");
    }

    @Override
    public boolean isSupported(String feature, String version) {
        return false;
    }

    @Override
    public Object getFeature(String feature, String version) {
        return null;
    }

    @Override
    public Object setUserData(String key, Object data, UserDataHandler handler) {
        Object oldValue;
        if (data == null) {
            if (this.userData == null) {
                return null;
            }
            oldValue = this.userData.remove(key);
            if (this.userData.isEmpty()) {
                this.userData = null;
            }
        } else {
            if (this.userData == null) {
                this.userData = new BackboneUserData();
            }
            oldValue = this.userData.set(key, data, handler);
        }
        return oldValue;
    }

    @Override
    public Object getUserData(String key) {
        if (this.userData == null) {
            return null;
        }
        return this.userData.get(key);
    }

    @Override
    public Wom3Node cloneNode(boolean deep) {
        Backbone newNode;
        try {
            newNode = (Backbone)this.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)"Internal error!");
        }
        newNode.parent = null;
        newNode.prevSibling = null;
        newNode.nextSibling = null;
        newNode.userData = null;
        return newNode;
    }

    @Override
    public Collection<Wom3Node> getWomChildNodes() {
        return new ImmutableSiblingCollection<Wom3Node>(this.getFirstChild());
    }

    @Override
    public Iterator<Wom3Node> iterator() {
        return new ImmutableSiblingCollection<Backbone>(this.getFirstChild()).iterator();
    }

    @Override
    public Collection<Wom3Attribute> getWomAttributes() {
        return new ImmutableSiblingCollection<Wom3Attribute>(this.getFirstAttr());
    }

    @Override
    public Iterator<Wom3Attribute> attributeIterator() {
        return new ImmutableSiblingCollection<Wom3Attribute>(this.getFirstAttr()).iterator();
    }

    protected Wom3Attribute getFirstAttr() {
        return null;
    }

    protected void getTextContentRecursive(StringBuilder b) {
        String value = this.getNodeValue();
        if (value != null) {
            b.append(value);
        }
    }

    protected boolean isContentWhitespace() {
        return false;
    }

    protected Wom3Node doesNotSupportChildNodes() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Node `" + this.getNodeName() + "' does not support child nodes!");
    }

    protected void adoptTo(DocumentImpl doc) {
        this.owner = doc;
    }

    protected boolean hasSameOwnerDocument(Backbone other) {
        Document otherOwner;
        Document thisOwner = this.getOwnerDocument();
        if (thisOwner == null) {
            thisOwner = (Document)((Object)this);
        }
        if ((otherOwner = other.getOwnerDocument()) == null) {
            otherOwner = (Document)((Object)other);
        }
        return thisOwner.isSameNode(otherOwner);
    }

    protected boolean precedes(Wom3Node other) {
        for (Backbone n = this.getNextSibling(); n != null; n = n.getNextSibling()) {
            if (n != other) continue;
            return true;
        }
        return false;
    }

    protected boolean precedesOrIsSame(Wom3Node other) {
        for (Backbone n = this; n != null; n = n.getNextSibling()) {
            if (n != other) continue;
            return true;
        }
        return false;
    }

    protected final Backbone getParentNodeIntern() {
        return this.parent;
    }

    protected final boolean isLinked() {
        return this.parent != null;
    }

    protected final void unlink() {
        this.parent = null;
        if (this.prevSibling != null) {
            this.prevSibling.nextSibling = this.nextSibling;
        }
        if (this.nextSibling != null) {
            this.nextSibling.prevSibling = this.prevSibling;
        }
        this.prevSibling = null;
        this.nextSibling = null;
    }

    protected final void link(Backbone parent, Backbone prevSibling, Backbone nextSibling) {
        if (!this.hasSameOwnerDocument(parent)) {
            throw new IllegalStateException("Different owner documents.");
        }
        if (this.isLinked()) {
            throw new IllegalStateException("Node is still child of another WOM node.");
        }
        this.parent = parent;
        this.prevSibling = prevSibling;
        if (prevSibling != null) {
            if (prevSibling.nextSibling != nextSibling) {
                throw new IllegalStateException("WOM sibling chain inconsistent.");
            }
            prevSibling.nextSibling = this;
        }
        this.nextSibling = nextSibling;
        if (nextSibling != null) {
            if (nextSibling.prevSibling != prevSibling) {
                throw new IllegalStateException("WOM sibling chain inconsistent.");
            }
            nextSibling.prevSibling = this;
        }
    }

    public String toString() {
        return this.toString(new StringBuilder()).toString();
    }

    protected StringBuilder toString(StringBuilder b) {
        switch (this.getNodeType()) {
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 12: {
                throw new InternalError();
            }
            case 2: {
                b.append(((Wom3Attribute)((Object)this)).getName());
                b.append("=\"");
                b.append(StringUtils.escHtml((String)this.getNodeValue()));
                b.append('\"');
                break;
            }
            case 8: {
                b.append("<!--");
                b.append(this.getNodeValue());
                b.append("-->");
                break;
            }
            case 1: 
            case 9: {
                b.append('<');
                b.append(this.getNodeName());
                for (Wom3Attribute attr : this.getWomAttributes()) {
                    b.append(' ');
                    if (attr instanceof Backbone) {
                        ((Backbone)((Object)attr)).toString(b);
                        continue;
                    }
                    b.append(attr.toString());
                }
                if (this.hasChildNodes()) {
                    b.append('>');
                    for (Wom3Node child : this.getWomChildNodes()) {
                        if (child instanceof Backbone) {
                            ((Backbone)child).toString(b);
                            continue;
                        }
                        b.append(child.toString());
                    }
                    b.append("</");
                    b.append(this.getNodeName());
                    b.append('>');
                    break;
                }
                b.append(" />");
                break;
            }
            case 3: {
                b.append(StringUtils.escHtml((String)this.getNodeValue()));
            }
        }
        return b;
    }
}

