/*
 * Decompiled with CFR 0.152.
 */
package org.sweble.wom3.impl;

import org.sweble.wom3.Wom3Comment;
import org.sweble.wom3.Wom3Rtd;
import org.sweble.wom3.Wom3XmlComment;
import org.sweble.wom3.Wom3XmlText;
import org.sweble.wom3.impl.Backbone;
import org.sweble.wom3.impl.BackboneWithChildren;
import org.sweble.wom3.impl.ChildDescriptor;
import org.sweble.wom3.impl.XmlTextBase;

public final class BackboneChildOperationChecker {
    private final BackboneWithChildren node;
    private ChildDescriptor current = null;
    private int pos = 0;

    BackboneChildOperationChecker(BackboneWithChildren node) {
        this.node = node;
    }

    protected boolean isIgnored(Backbone child) {
        return BackboneChildOperationChecker.isIgnoredDefault(child);
    }

    protected static boolean isIgnoredDefault(Backbone child) {
        return child instanceof Wom3Rtd || child instanceof XmlTextBase && ((XmlTextBase)child).isContentWhitespace() || !"http://sweble.org/schema/wom30".equals(child.getNamespaceURI()) || child instanceof Wom3Comment || child instanceof Wom3XmlComment || child instanceof Wom3XmlText && ((Wom3XmlText)((Object)child)).isElementContentWhitespace();
    }

    protected void checkInsertion(Backbone prev, Backbone child, ChildDescriptor[] desc) {
        if (this.isIgnored(child)) {
            return;
        }
        this.forwardDescriptor(prev, desc);
        if (this.current != null && this.current.isMultiple() && this.current.matches(child)) {
            return;
        }
        while (true) {
            if (this.pos < desc.length) {
                this.current = desc[this.pos];
                if (this.current.matches(child)) {
                    return;
                }
                ++this.pos;
                continue;
            }
            this.node.doesNotAllowInsertion(prev, child);
        }
    }

    protected void checkRemoval(Backbone child, ChildDescriptor[] desc) {
        this.forwardDescriptor(child, desc);
        if (this.current != null && this.current.isRequired()) {
            this.node.doesNotAllowRemoval(child);
        }
    }

    protected void checkReplacement(Backbone oldChild, Backbone newChild, ChildDescriptor[] desc) {
        this.forwardDescriptor(oldChild, desc);
        if (this.current != null) {
            if (this.current.matches(newChild)) {
                return;
            }
            if (this.current.isRequired()) {
                this.node.doesNotAllowReplacement(oldChild, newChild);
            }
        }
        if (this.isIgnored(newChild)) {
            return;
        }
        while (true) {
            if (this.pos < desc.length) {
                this.current = desc[this.pos];
                if (this.current.matches(newChild)) {
                    return;
                }
                ++this.pos;
                continue;
            }
            this.node.doesNotAllowReplacement(oldChild, newChild);
        }
    }

    private void forwardDescriptor(Backbone to, ChildDescriptor[] desc) throws AssertionError {
        ChildDescriptor active = null;
        if (to == null) {
            return;
        }
        for (Backbone n = this.node.getFirstChild(); n != null; n = n.getNextSibling()) {
            if (this.isIgnored(n)) {
                this.current = null;
            } else if (active == null || !active.matches(n)) {
                active = null;
                while (true) {
                    if (this.pos >= desc.length) {
                        throw new AssertionError((Object)"Children already messed up!");
                    }
                    this.current = desc[this.pos];
                    if (this.current.matches(n)) {
                        if (this.current.isMultiple()) {
                            active = this.current;
                        }
                        ++this.pos;
                        break;
                    }
                    ++this.pos;
                }
            }
            if (n == to) break;
        }
    }
}

