/*
 * Decompiled with CFR 0.152.
 */
package org.sweble.wom3.impl;

import org.sweble.wom3.Wom3Attribute;
import org.sweble.wom3.Wom3ElementNode;
import org.sweble.wom3.Wom3Node;
import org.sweble.wom3.Wom3NodeList;
import org.sweble.wom3.impl.AttributeBase;
import org.sweble.wom3.impl.AttributeDescriptor;
import org.sweble.wom3.impl.AttributeMap;
import org.sweble.wom3.impl.Backbone;
import org.sweble.wom3.impl.BackboneWithChildren;
import org.sweble.wom3.impl.DocumentImpl;
import org.sweble.wom3.impl.ElementsByTagNameNodeList;
import org.sweble.wom3.impl.GenericAttributeDescriptor;
import org.sweble.wom3.impl.NativeAndStringValuePair;
import org.sweble.wom3.impl.Toolbox;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.TypeInfo;

public abstract class BackboneElement
extends BackboneWithChildren
implements Wom3ElementNode {
    private static final long serialVersionUID = 1L;
    private AttributeBase firstAttr;

    public BackboneElement(DocumentImpl owner) {
        super(owner);
    }

    protected AttributeDescriptor getAttributeDescriptor(String namespaceUri, String localName, String qualifiedName) {
        return null;
    }

    @Override
    public abstract String getNodeName();

    @Override
    public final short getNodeType() {
        return 1;
    }

    @Override
    public Backbone getParentNode() {
        return this.getParentNodeIntern();
    }

    @Override
    public final String getTagName() {
        return this.getNodeName();
    }

    @Override
    public Wom3NodeList getElementsByTagName(String name) {
        return new ElementsByTagNameNodeList(this, name);
    }

    @Override
    public Wom3NodeList getElementsByTagNameNS(String namespaceURI, String localName) throws DOMException {
        return new ElementsByTagNameNodeList(this, namespaceURI, localName);
    }

    @Override
    public TypeInfo getSchemaTypeInfo() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Wom3Node cloneNode(boolean deep) {
        BackboneElement newNode = (BackboneElement)super.cloneNode(deep);
        newNode.firstAttr = null;
        for (AttributeBase child = this.getFirstAttr(); child != null; child = (AttributeBase)child.getNextSibling()) {
            newNode.setAttributeNode((AttributeBase)child.cloneNode(deep));
        }
        return newNode;
    }

    @Override
    public AttributeBase getFirstAttr() {
        return this.firstAttr;
    }

    public final void setFirstAttr(AttributeBase firstAttr) {
        this.firstAttr = firstAttr;
    }

    @Override
    public boolean hasAttributeNS(String namespaceUri, String localName) throws DOMException {
        return this.getAttributeNodeNS(namespaceUri, localName) != null;
    }

    @Override
    public String getAttributeNS(String namespaceUri, String localName) throws DOMException {
        AttributeBase attributeNode = this.getAttributeNodeNS(namespaceUri, localName);
        if (attributeNode == null) {
            return "";
        }
        return attributeNode.getNodeValue();
    }

    @Override
    public AttributeBase getAttributeNodeNS(String namespaceUri, String localName) throws DOMException {
        if (localName == null) {
            throw new IllegalArgumentException("Argument `localName' is null.");
        }
        for (Wom3Attribute i = this.getFirstAttr(); i != null; i = (Wom3Attribute)((Object)i.getNextSibling())) {
            String iNamespaceUri = i.getNamespaceURI();
            String iLocalName = i.getLocalName();
            if (namespaceUri == null) {
                if (iNamespaceUri != null) continue;
                if (localName.equals(iLocalName)) {
                    return i;
                }
                if (iLocalName != null || !localName.equals(i.getNodeName())) continue;
                return (AttributeBase)i;
            }
            if (!namespaceUri.equals(iNamespaceUri) || !localName.equals(iLocalName)) continue;
            return i;
        }
        return null;
    }

    @Override
    public void setAttributeNS(String namespaceUri, String qualifiedName, String value) throws DOMException {
        int index = qualifiedName.indexOf(58);
        String localName = index < 0 ? qualifiedName : qualifiedName.substring(index + 1);
        AttributeDescriptor descriptor = this.getAttributeDescriptorOrFail(namespaceUri, localName, qualifiedName);
        NativeAndStringValuePair verified = new NativeAndStringValuePair(value);
        if (value != null && descriptor.verifyAndConvert(this, verified)) {
            this.setAttributeNs(descriptor, namespaceUri, localName, qualifiedName, verified);
        } else {
            AttributeBase old = this.getAttributeNodeNS(namespaceUri, localName);
            if (old != null) {
                this.removeAttribute(descriptor, old);
            }
        }
    }

    @Override
    public Wom3Attribute setAttributeNodeNS(Attr attr_) throws DOMException {
        if (attr_ == null) {
            throw new IllegalArgumentException("Argument `attr' is null.");
        }
        Wom3Attribute attr = Toolbox.expectType(Wom3Attribute.class, attr_);
        if (attr.getOwnerElement() == this) {
            return (AttributeBase)attr;
        }
        String namespaceUri = attr.getNamespaceURI();
        String localName = attr.getLocalName();
        String name = attr.getName();
        AttributeDescriptor descriptor = this.getAttributeDescriptorOrFail(namespaceUri, localName, name);
        NativeAndStringValuePair verified = new NativeAndStringValuePair(attr.getNodeValue());
        if (attr.getNodeValue() == null || descriptor.verifyAndConvert(this, verified)) {
            return this.setAttributeNodeNS(descriptor, attr, verified);
        }
        AttributeBase old = this.getAttributeNodeNS(namespaceUri, localName);
        if (old != null) {
            this.removeAttribute(descriptor, old);
        }
        return old;
    }

    @Override
    public void setIdAttributeNS(String namespaceURI, String localName, boolean isId) throws DOMException {
        if (isId) {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    public void removeAttributeNS(String namespaceUri, String localName) throws DOMException {
        if (localName == null) {
            throw new IllegalArgumentException("Argument `localName' is null.");
        }
        AttributeBase remove = this.getAttributeNodeNS(namespaceUri, localName);
        if (remove == null) {
            return;
        }
        this.removeAttribute(this.getAttributeDescriptor(namespaceUri, localName, remove.getName()), remove);
    }

    @Override
    public boolean hasAttribute(String name) {
        return this.getAttributeNode(name) != null;
    }

    @Override
    public NamedNodeMap getAttributes() {
        return new AttributeMap(this);
    }

    @Override
    public String getAttribute(String name) {
        AttributeBase attributeNode = this.getAttributeNode(name);
        if (attributeNode == null) {
            return "";
        }
        return attributeNode.getNodeValue();
    }

    @Override
    public AttributeBase getAttributeNode(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument `name' is null.");
        }
        for (Wom3Attribute i = this.getFirstAttr(); i != null; i = (Wom3Attribute)((Object)i.getNextSibling())) {
            if (!i.getName().equals(name)) continue;
            return i;
        }
        return null;
    }

    @Override
    public void setAttribute(String name, String value) throws DOMException {
        AttributeDescriptor descriptor = this.getAttributeDescriptorOrFail(name);
        NativeAndStringValuePair verified = new NativeAndStringValuePair(value);
        if (value != null && descriptor.verifyAndConvert(this, verified)) {
            this.setAttribute(descriptor, name, verified);
        } else {
            AttributeBase old = this.getAttributeNode(name);
            if (old != null) {
                this.removeAttribute(descriptor, old);
            }
        }
    }

    @Override
    public Wom3Attribute setAttributeNode(Attr attr_) throws IllegalArgumentException, DOMException {
        if (attr_ == null) {
            throw new IllegalArgumentException("Argument `attr' is null.");
        }
        Wom3Attribute attr = Toolbox.expectType(Wom3Attribute.class, attr_);
        if (attr.getOwnerElement() == this) {
            return (AttributeBase)attr;
        }
        if (attr.getNamespaceURI() != null && !attr.getNamespaceURI().isEmpty() || attr.getPrefix() != null && !attr.getPrefix().isEmpty()) {
            return this.setAttributeNodeNS(attr_);
        }
        AttributeDescriptor descriptor = this.getAttributeDescriptorOrFail(attr.getName());
        NativeAndStringValuePair verified = new NativeAndStringValuePair(attr.getNodeValue());
        if (attr.getNodeValue() == null || descriptor.verifyAndConvert(this, verified)) {
            return this.setAttributeNode(descriptor, attr, verified);
        }
        AttributeBase old = this.getAttributeNode(attr.getName());
        if (old != null) {
            this.removeAttribute(descriptor, old);
        }
        return old;
    }

    @Override
    public void setIdAttribute(String name, boolean isId) throws DOMException {
        if (isId) {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    public void setIdAttributeNode(Attr idAttr, boolean isId) throws DOMException {
        if (isId) {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    public void removeAttribute(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument `name' is null.");
        }
        AttributeBase remove = this.getAttributeNode(name);
        if (remove == null) {
            return;
        }
        this.removeAttribute(this.getAttributeDescriptor(name), remove);
    }

    @Override
    public Wom3Attribute removeAttributeNode(Attr attr_) throws DOMException {
        Wom3Attribute attr = Toolbox.expectType(Wom3Attribute.class, attr_);
        if (attr == null) {
            throw new IllegalArgumentException("Argument `attr' is null.");
        }
        if (attr.getOwnerElement() != this) {
            throw new IllegalArgumentException("Given attribute `attr' is not an attribute of this XML element.");
        }
        this.removeAttribute(this.getAttributeDescriptor(attr.getName()), (AttributeBase)attr);
        return attr;
    }

    protected final <T> T setAttributeDirect(AttributeDescriptor descriptor, String name, T value) {
        AttributeBase old;
        NativeAndStringValuePair verified = new NativeAndStringValuePair(value);
        if (value != null && descriptor.verifyAndConvert(this, verified)) {
            old = this.setAttribute(descriptor, name, verified);
        } else {
            old = this.getAttributeNode(name);
            if (old != null) {
                this.removeAttribute(descriptor, old);
            }
        }
        if (old == null) {
            return null;
        }
        Object oldT = old.getNativeValue();
        return (T)oldT;
    }

    protected final void setAttributeDirectNoChecks(String name, String value) {
        NativeAndStringValuePair verified = new NativeAndStringValuePair(value);
        this.setAttribute(null, name, verified);
    }

    protected final Object getAttributeNativeData(String name) {
        AttributeBase attr = this.getAttributeNode(name);
        return attr == null ? null : attr.getNativeValue();
    }

    protected AttributeBase createAttribute(String name, NativeAndStringValuePair verified) {
        AttributeBase attr = (AttributeBase)this.getOwnerDocument().createAttribute(name);
        attr.setValue(verified.value, verified.strValue);
        return attr;
    }

    protected final AttributeBase createAttributeNS(String namespaceUri, String qualifiedName, NativeAndStringValuePair verified) {
        AttributeBase attr = (AttributeBase)this.getOwnerDocument().createAttributeNS(namespaceUri, qualifiedName);
        attr.setValue(verified.value, verified.strValue);
        return attr;
    }

    protected final AttributeDescriptor getAttributeDescriptorOrFail(String namespaceUri, String localName, String qualifiedName) {
        AttributeDescriptor d = this.getAttributeDescriptor(namespaceUri, localName, qualifiedName);
        if (d == null) {
            if (this.getOwnerDocument().getStrictErrorChecking()) {
                throw new IllegalArgumentException("An attribute named `" + namespaceUri + "' / `" + qualifiedName + "' is not supported by this element!");
            }
            d = GenericAttributeDescriptor.get();
        }
        return d;
    }

    protected final AttributeDescriptor getAttributeDescriptor(String name) {
        return this.getAttributeDescriptor(null, null, name);
    }

    protected final AttributeDescriptor getAttributeDescriptorOrFail(String name) {
        return this.getAttributeDescriptorOrFail(null, null, name);
    }

    private AttributeBase setAttributeNs(AttributeDescriptor descriptor, String namespaceUri, String localName, String qualifiedName, NativeAndStringValuePair verified) {
        AttributeBase newAttr = this.createAttributeNS(namespaceUri, qualifiedName, verified);
        AttributeBase oldAttr = this.getAttributeNodeNS(namespaceUri, localName);
        this.replaceAttributeInternal(descriptor, oldAttr, newAttr);
        return oldAttr;
    }

    private AttributeBase setAttributeNodeNS(AttributeDescriptor descriptor, Wom3Attribute attr, NativeAndStringValuePair verified) {
        AttributeBase newAttr = Toolbox.expectType(AttributeBase.class, attr, "attr");
        newAttr.setValue(verified.value, verified.strValue);
        if (newAttr.isLinked()) {
            throw new IllegalStateException("Given attribute `attr' is still attribute of another WOM node.");
        }
        AttributeBase oldAttr = this.getAttributeNodeNS(attr.getNamespaceURI(), attr.getLocalName());
        this.replaceAttributeInternal(descriptor, oldAttr, newAttr);
        return oldAttr;
    }

    private AttributeBase setAttribute(AttributeDescriptor descriptor, String name, NativeAndStringValuePair verified) {
        Toolbox.checkValidXmlName(name);
        AttributeBase newAttr = this.createAttribute(name, verified);
        AttributeBase oldAttr = this.getAttributeNode(name);
        this.replaceAttributeInternal(descriptor, oldAttr, newAttr);
        return oldAttr;
    }

    private AttributeBase setAttributeNode(AttributeDescriptor descriptor, Wom3Attribute attr, NativeAndStringValuePair verified) {
        AttributeBase newAttr = Toolbox.expectType(AttributeBase.class, attr, "attr");
        newAttr.setValue(verified.value, verified.strValue);
        if (newAttr.isLinked()) {
            throw new IllegalStateException("Given attribute `attr' is still attribute of another WOM node.");
        }
        AttributeBase oldAttr = this.getAttributeNode(attr.getName());
        this.replaceAttributeInternal(descriptor, oldAttr, newAttr);
        return oldAttr;
    }

    private void replaceAttributeInternal(AttributeDescriptor descriptor, AttributeBase oldAttr, AttributeBase newAttr) {
        Backbone prev = null;
        Backbone next = null;
        if (oldAttr != null) {
            prev = oldAttr.getPreviousSibling();
            next = oldAttr.getNextSibling();
            oldAttr.unlink();
        } else if (this.getFirstAttr() != null) {
            prev = this.getFirstAttr();
            while (prev.getNextSibling() != null) {
                prev = prev.getNextSibling();
            }
        }
        newAttr.link(this, prev, next);
        if (this.getFirstAttr() == null || oldAttr == this.getFirstAttr()) {
            this.setFirstAttr(newAttr);
        }
        if (descriptor != null) {
            descriptor.customAction(this, oldAttr, newAttr);
        }
    }

    private final void removeAttribute(AttributeDescriptor descriptor, AttributeBase attribute) {
        if (descriptor != null) {
            this.checkAttributeRemoval(attribute.getName(), descriptor);
        }
        Backbone parent = (Backbone)((Object)attribute.getOwnerElement());
        if (attribute == this.getFirstAttr()) {
            this.setFirstAttr((AttributeBase)attribute.getNextSibling());
        }
        attribute.unlink();
        if (descriptor != null) {
            descriptor.customAction(parent, attribute, null);
        }
    }

    private final void checkAttributeRemoval(String name, AttributeDescriptor descriptor) {
        if (this.getOwnerDocument().getStrictErrorChecking() && !descriptor.isRemovable()) {
            throw new UnsupportedOperationException("Attribute `" + name + "' cannot be removed");
        }
    }
}

