/*
 * Decompiled with CFR 0.152.
 */
package org.sweble.wom3.impl;

import org.sweble.wom3.Wom3Node;
import org.sweble.wom3.impl.Backbone;
import org.sweble.wom3.impl.BackboneChildOperationChecker;
import org.sweble.wom3.impl.ChildDescriptor;
import org.sweble.wom3.impl.DocumentImpl;
import org.sweble.wom3.impl.Toolbox;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;

public abstract class BackboneWithChildren
extends Backbone {
    private static final long serialVersionUID = 1L;
    private Backbone firstChild;
    private Backbone lastChild;

    public BackboneWithChildren(DocumentImpl owner) {
        super(owner);
    }

    public final void setFirstChild(Backbone firstChild) {
        this.firstChild = firstChild;
    }

    @Override
    public Backbone getFirstChild() {
        return this.firstChild;
    }

    public final void setLastChild(Backbone lastChild) {
        this.lastChild = lastChild;
    }

    @Override
    public Backbone getLastChild() {
        return this.lastChild;
    }

    protected boolean ignoresContentWhitespace() {
        return true;
    }

    protected void allowsInsertion(Backbone prev, Backbone child) {
        if (this.getOwnerDocument().getStrictErrorChecking()) {
            this.doesNotAllowInsertion(prev, child);
        }
    }

    protected void allowsReplacement(Backbone oldChild, Backbone newChild) {
        if (this.getOwnerDocument().getStrictErrorChecking()) {
            this.doesNotAllowReplacement(oldChild, newChild);
        }
    }

    protected void allowsRemoval(Backbone child) {
        if (this.getOwnerDocument().getStrictErrorChecking()) {
            this.doesNotAllowRemoval(child);
        }
    }

    protected void childInserted(Backbone prev, Backbone added) {
    }

    protected void childRemoved(Backbone prev, Backbone removed) {
    }

    @Override
    protected void getTextContentRecursive(StringBuilder b) {
        block3: for (Backbone n = this.getFirstChild(); n != null; n = n.getNextSibling()) {
            switch (n.getNodeType()) {
                case 7: 
                case 8: {
                    continue block3;
                }
                default: {
                    n.getTextContentRecursive(b);
                }
            }
        }
    }

    @Override
    public final Wom3Node insertBefore(Node child_, Node before_) throws DOMException {
        Wom3Node child = Toolbox.expectType(Wom3Node.class, child_);
        if (((Backbone)child).isContentWhitespace() && this.ignoresContentWhitespace()) {
            return null;
        }
        Wom3Node before = Toolbox.expectType(Wom3Node.class, before_);
        Backbone prev = this.insertBeforeIntern(before, child, true);
        ++this.childrenChanges;
        this.childInserted(prev, (Backbone)child);
        return child;
    }

    @Override
    public final Wom3Node replaceChild(Node newChild_, Node oldChild_) throws DOMException {
        Wom3Node newChild = Toolbox.expectType(Wom3Node.class, newChild_);
        if (((Backbone)newChild).isContentWhitespace() && this.ignoresContentWhitespace()) {
            return this.removeChild(oldChild_);
        }
        Wom3Node oldChild = Toolbox.expectType(Wom3Node.class, oldChild_);
        this.replaceChild(newChild, oldChild);
        return oldChild;
    }

    @Override
    public final Wom3Node removeChild(Node child_) throws DOMException {
        Wom3Node child = Toolbox.expectType(Wom3Node.class, child_);
        Backbone prev = this.removeChildIntern(child, true);
        ++this.childrenChanges;
        this.childRemoved(prev, (Backbone)child);
        return child;
    }

    @Override
    public final Wom3Node appendChild(Node child_) throws DOMException {
        Wom3Node child = Toolbox.expectType(Wom3Node.class, child_);
        if (((Backbone)child).isContentWhitespace() && this.ignoresContentWhitespace()) {
            return null;
        }
        Backbone prev = this.appendChildIntern(child, true);
        ++this.childrenChanges;
        this.childInserted(prev, (Backbone)child);
        return child;
    }

    @Override
    public void setTextContent(String textContent) throws DOMException {
        this.clearChildren();
        this.appendChild(this.getOwnerDocument().createTextNode(textContent));
    }

    @Override
    public Wom3Node cloneNode(boolean deep) {
        BackboneWithChildren newNode = (BackboneWithChildren)super.cloneNode(deep);
        newNode.firstChild = null;
        newNode.lastChild = null;
        if (deep) {
            for (Backbone child = this.getFirstChild(); child != null; child = child.getNextSibling()) {
                newNode.appendChild(child.cloneNode(deep));
            }
        }
        return newNode;
    }

    private Backbone appendChildIntern(Wom3Node child, boolean notify) {
        if (child == null) {
            throw new IllegalArgumentException("Argument `child' is null.");
        }
        Backbone newChild = Toolbox.expectType(Backbone.class, child, "child");
        if (newChild.isLinked()) {
            throw new IllegalStateException("Given node `child' is still child of another WOM node.");
        }
        Backbone lastChild = this.getLastChild();
        if (notify) {
            this.allowsInsertion(lastChild, newChild);
        }
        newChild.link(this, lastChild, null);
        this.setLastChild(newChild);
        if (this.getFirstChild() == null) {
            this.setFirstChild(newChild);
        }
        return lastChild;
    }

    private Backbone insertBeforeIntern(Wom3Node before, Wom3Node child, boolean notify) {
        if (before == null || child == null) {
            throw new IllegalArgumentException("Argument `before' and/or `child' is null.");
        }
        Backbone newChild = Toolbox.expectType(Backbone.class, child, "child");
        if (newChild.isLinked()) {
            throw new IllegalStateException("Given argument `child' is still child of another WOM node.");
        }
        if (before.getParentNode() != this) {
            throw new IllegalArgumentException("Given node `before' is not a child of this node.");
        }
        Backbone p = (Backbone)before;
        Backbone prev = p.getPreviousSibling();
        if (notify) {
            this.allowsInsertion(prev, newChild);
        }
        newChild.link(this, prev, p);
        if (p == this.getFirstChild()) {
            this.setFirstChild(newChild);
        }
        return prev;
    }

    private Backbone removeChildIntern(Wom3Node child, boolean notify) {
        if (child == null) {
            throw new IllegalArgumentException("Argument `child' is null.");
        }
        Backbone remove = Toolbox.expectType(Backbone.class, child, "child");
        if (child.getParentNode() != this) {
            throw new IllegalArgumentException("Given node `child' is not a child of this node.");
        }
        if (notify) {
            this.allowsRemoval(remove);
        }
        Backbone prev = remove.getPreviousSibling();
        Backbone next = remove.getNextSibling();
        if (remove == this.getFirstChild()) {
            this.setFirstChild(next);
        }
        if (remove == this.getLastChild()) {
            this.setLastChild(prev);
        }
        remove.unlink();
        return prev;
    }

    private void replaceChild(Wom3Node replace, Wom3Node search) {
        this.replaceChildIntern(search, replace, true);
        Backbone oldChild = (Backbone)search;
        Backbone newChild = (Backbone)replace;
        Backbone prev = oldChild.getPreviousSibling();
        Backbone next = oldChild.getNextSibling();
        oldChild.unlink();
        newChild.link(this, prev, next);
        if (oldChild == this.getFirstChild()) {
            this.setFirstChild(newChild);
        }
        if (oldChild == this.getLastChild()) {
            this.setLastChild(newChild);
        }
        ++this.childrenChanges;
        this.childRemoved(prev, oldChild);
        this.childInserted(prev, newChild);
    }

    private void replaceChildIntern(Wom3Node search, Wom3Node replace, boolean notify) {
        if (search == null || replace == null) {
            throw new IllegalArgumentException("Argument `search' and/or `replace' is null.");
        }
        Backbone newChild = Toolbox.expectType(Backbone.class, replace, "replace");
        if (newChild.isLinked()) {
            throw new IllegalStateException("Given node `replace' is still child of another WOM node.");
        }
        if (search.getParentNode() != this) {
            throw new IllegalArgumentException("Given node `search' is not a child of this node.");
        }
        Backbone oldChild = (Backbone)search;
        if (notify) {
            this.allowsReplacement(oldChild, newChild);
        }
    }

    protected void appendChildNoNotify(Wom3Node child) {
        this.appendChildIntern(child, false);
    }

    protected void insertBeforeNoNotify(Wom3Node before, Wom3Node child) throws IllegalArgumentException {
        this.insertBeforeIntern(before, child, false);
    }

    protected void removeChildNoNotify(Wom3Node child) {
        this.removeChildIntern(child, false);
    }

    protected void replaceChildNoNotify(Wom3Node search, Wom3Node replace) {
        this.replaceChildIntern(search, replace, false);
        Backbone oldChild = (Backbone)search;
        Backbone newChild = (Backbone)replace;
        Backbone prev = oldChild.getPreviousSibling();
        Backbone next = oldChild.getNextSibling();
        oldChild.unlink();
        newChild.link(this, prev, next);
        if (oldChild == this.getFirstChild()) {
            this.setFirstChild(newChild);
        }
        if (oldChild == this.getLastChild()) {
            this.setLastChild(newChild);
        }
    }

    protected void clearChildren() {
        while (this.getFirstChild() != null) {
            this.removeChild(this.getFirstChild());
        }
    }

    protected Wom3Node replaceOrAdd(Wom3Node replace, Wom3Node replacement, boolean required) {
        if (replacement == null) {
            if (required && this.getOwnerDocument().getStrictErrorChecking()) {
                throw new NullPointerException("Argument is null but child cannot be removed");
            }
            if (replace != null) {
                this.removeChild(replace);
            }
        } else if (replace != replacement) {
            if (replace != null) {
                this.replaceChild(replacement, replace);
            } else {
                this.appendChild(replacement);
            }
        }
        return replace;
    }

    protected Wom3Node replaceOrInsertBeforeOrAppend(Wom3Node replace, Wom3Node before, Wom3Node replacement, boolean required) {
        if (replacement == null) {
            if (required && this.getOwnerDocument().getStrictErrorChecking()) {
                throw new NullPointerException("Argument is null but child cannot be removed");
            }
            if (replace != null) {
                this.removeChild(replace);
            }
        } else if (replace != replacement) {
            if (replace != null) {
                this.replaceChild(replacement, replace);
            } else if (before != null) {
                this.insertBefore(replacement, before);
            } else {
                this.appendChild(replacement);
            }
        }
        return replace;
    }

    protected Wom3Node replaceOrAppend(Wom3Node replace, Wom3Node replacement, boolean required) {
        if (replacement == null) {
            if (required && this.getOwnerDocument().getStrictErrorChecking()) {
                throw new NullPointerException("Argument is null but child cannot be removed");
            }
            if (replace != null) {
                this.removeChild(replace);
            }
        } else if (replace != replacement) {
            if (replace != null) {
                this.replaceChild(replacement, replace);
            } else {
                this.appendChild(replacement);
            }
        }
        return replace;
    }

    protected void checkInsertion(Backbone prev, Backbone child, ChildDescriptor[] desc) {
        if (this.getOwnerDocument().getStrictErrorChecking()) {
            new BackboneChildOperationChecker(this).checkInsertion(prev, child, desc);
        }
    }

    protected void checkRemoval(Backbone child, ChildDescriptor[] desc) {
        if (this.getOwnerDocument().getStrictErrorChecking()) {
            new BackboneChildOperationChecker(this).checkRemoval(child, desc);
        }
    }

    protected void checkReplacement(Backbone oldChild, Backbone newChild, ChildDescriptor[] desc) {
        if (this.getOwnerDocument().getStrictErrorChecking()) {
            new BackboneChildOperationChecker(this).checkReplacement(oldChild, newChild, desc);
        }
    }

    protected static ChildDescriptor childDesc(String tag) {
        return BackboneWithChildren.childDesc("http://sweble.org/schema/wom30", tag, 0);
    }

    protected static ChildDescriptor childDesc(String namespaceUri, String tag) {
        return new ChildDescriptor(namespaceUri, tag, 0);
    }

    protected static ChildDescriptor childDesc(String tag, int flags) {
        return BackboneWithChildren.childDesc("http://sweble.org/schema/wom30", tag, flags);
    }

    protected static ChildDescriptor childDesc(String namespaceUri, String tag, int flags) {
        return new ChildDescriptor(namespaceUri, tag, flags);
    }

    protected void doesNotAllowInsertion(Backbone prev, Backbone child) {
        if (prev == null) {
            if (this.getFirstChild() != null) {
                throw new IllegalArgumentException(this.getNodeName() + " doesn't accept child " + child.getNodeName() + " in front of child " + this.getFirstChild().getNodeName());
            }
            throw new IllegalArgumentException(this.getNodeName() + " doesn't accept child " + child.getNodeName() + " as first child");
        }
        throw new IllegalArgumentException(this.getNodeName() + " doesn't accept child " + child.getNodeName() + " after child " + prev.getNodeName());
    }

    protected void doesNotAllowRemoval(Backbone child) {
        throw new IllegalArgumentException("Child node " + child.getNodeName() + " cannot be removed from node " + this.getNodeName());
    }

    protected void doesNotAllowReplacement(Backbone oldChild, Backbone newChild) {
        throw new IllegalArgumentException("Child node " + oldChild.getNodeName() + " in node " + this.getNodeName() + " cannot be replaced by node " + newChild.getNodeName());
    }
}

