/*
 * Decompiled with CFR 0.152.
 */
package org.sweble.wom3.impl;

import java.util.HashMap;
import java.util.Map;
import org.sweble.wom3.Wom3Color;

public class ColorImpl
implements Wom3Color {
    private static final long serialVersionUID = 1L;
    private char r;
    private char g;
    private char b;
    private static final Map<String, ColorImpl> namedColors = new HashMap<String, ColorImpl>();

    public ColorImpl(int r, int g, int b) {
        this.r = (char)r;
        this.g = (char)g;
        this.b = (char)b;
    }

    @Override
    public int getRed() {
        return this.r;
    }

    @Override
    public int getGreen() {
        return this.g;
    }

    @Override
    public int getBlue() {
        return this.b;
    }

    @Override
    public String toString() {
        return String.format("#%02X%02X%02X", this.r, (int)this.g, (int)this.b);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.b;
        result = 31 * result + this.g;
        result = 31 * result + this.r;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ColorImpl other = (ColorImpl)obj;
        if (this.b != other.b) {
            return false;
        }
        if (this.g != other.g) {
            return false;
        }
        return this.r == other.r;
    }

    public static ColorImpl valueOf(String color) {
        color = color.trim();
        String c = color.toLowerCase();
        try {
            if (c.startsWith("#")) {
                if (c.length() == 4) {
                    int r = ColorImpl.hexToInt(c.charAt(1)) * 255 / 15;
                    int g = ColorImpl.hexToInt(c.charAt(2)) * 255 / 15;
                    int b = ColorImpl.hexToInt(c.charAt(3)) * 255 / 15;
                    return new ColorImpl(r, g, b);
                }
                if (c.length() == 7) {
                    int r = ColorImpl.hexToInt(c.charAt(1)) * 16 + ColorImpl.hexToInt(c.charAt(2));
                    int g = ColorImpl.hexToInt(c.charAt(3)) * 16 + ColorImpl.hexToInt(c.charAt(4));
                    int b = ColorImpl.hexToInt(c.charAt(5)) * 16 + ColorImpl.hexToInt(c.charAt(6));
                    return new ColorImpl(r, g, b);
                }
            } else {
                ColorImpl named = namedColors.get(c);
                if (named != null) {
                    return named;
                }
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        throw new IllegalArgumentException("Not a valid color: `" + color + "'");
    }

    private static int hexToInt(char ch) {
        if (ch >= '0' && ch <= '9') {
            return ch - 48;
        }
        if (ch >= 'a' && ch <= 'f') {
            return ch - 97 + 10;
        }
        throw new IllegalArgumentException();
    }

    static {
        namedColors.put("aliceblue", new ColorImpl(240, 248, 255));
        namedColors.put("antiquewhite", new ColorImpl(250, 235, 215));
        namedColors.put("aqua", new ColorImpl(0, 255, 255));
        namedColors.put("aquamarine", new ColorImpl(127, 255, 212));
        namedColors.put("azure", new ColorImpl(240, 255, 255));
        namedColors.put("beige", new ColorImpl(245, 245, 220));
        namedColors.put("bisque", new ColorImpl(255, 228, 196));
        namedColors.put("black", new ColorImpl(0, 0, 0));
        namedColors.put("blanchedalmond", new ColorImpl(255, 235, 205));
        namedColors.put("blue", new ColorImpl(0, 0, 255));
        namedColors.put("blueviolet", new ColorImpl(138, 43, 226));
        namedColors.put("brown", new ColorImpl(165, 42, 42));
        namedColors.put("burlywood", new ColorImpl(222, 184, 135));
        namedColors.put("cadetblue", new ColorImpl(95, 158, 160));
        namedColors.put("chartreuse", new ColorImpl(127, 255, 0));
        namedColors.put("chocolate", new ColorImpl(210, 105, 30));
        namedColors.put("coral", new ColorImpl(255, 127, 80));
        namedColors.put("cornflowerblue", new ColorImpl(100, 149, 237));
        namedColors.put("cornsilk", new ColorImpl(255, 248, 220));
        namedColors.put("crimson", new ColorImpl(220, 20, 60));
        namedColors.put("cyan", new ColorImpl(0, 255, 255));
        namedColors.put("darkblue", new ColorImpl(0, 0, 139));
        namedColors.put("darkcyan", new ColorImpl(0, 139, 139));
        namedColors.put("darkgoldenrod", new ColorImpl(184, 134, 11));
        namedColors.put("darkgray", new ColorImpl(169, 169, 169));
        namedColors.put("darkgrey", new ColorImpl(169, 169, 169));
        namedColors.put("darkgreen", new ColorImpl(0, 100, 0));
        namedColors.put("darkkhaki", new ColorImpl(189, 183, 107));
        namedColors.put("darkmagenta", new ColorImpl(139, 0, 139));
        namedColors.put("darkolivegreen", new ColorImpl(85, 107, 47));
        namedColors.put("darkorange", new ColorImpl(255, 140, 0));
        namedColors.put("darkorchid", new ColorImpl(153, 50, 204));
        namedColors.put("darkred", new ColorImpl(139, 0, 0));
        namedColors.put("darksalmon", new ColorImpl(233, 150, 122));
        namedColors.put("darkseagreen", new ColorImpl(143, 188, 143));
        namedColors.put("darkslateblue", new ColorImpl(72, 61, 139));
        namedColors.put("darkslategray", new ColorImpl(47, 79, 79));
        namedColors.put("darkslategrey", new ColorImpl(47, 79, 79));
        namedColors.put("darkturquoise", new ColorImpl(0, 206, 209));
        namedColors.put("darkviolet", new ColorImpl(148, 0, 211));
        namedColors.put("deeppink", new ColorImpl(255, 20, 147));
        namedColors.put("deepskyblue", new ColorImpl(0, 191, 255));
        namedColors.put("dimgray", new ColorImpl(105, 105, 105));
        namedColors.put("dimgrey", new ColorImpl(105, 105, 105));
        namedColors.put("dodgerblue", new ColorImpl(30, 144, 255));
        namedColors.put("firebrick", new ColorImpl(178, 34, 34));
        namedColors.put("floralwhite", new ColorImpl(255, 250, 240));
        namedColors.put("forestgreen", new ColorImpl(34, 139, 34));
        namedColors.put("fuchsia", new ColorImpl(255, 0, 255));
        namedColors.put("gainsboro", new ColorImpl(220, 220, 220));
        namedColors.put("ghostwhite", new ColorImpl(248, 248, 255));
        namedColors.put("gold", new ColorImpl(255, 215, 0));
        namedColors.put("goldenrod", new ColorImpl(218, 165, 32));
        namedColors.put("gray", new ColorImpl(128, 128, 128));
        namedColors.put("grey", new ColorImpl(128, 128, 128));
        namedColors.put("green", new ColorImpl(0, 128, 0));
        namedColors.put("greenyellow", new ColorImpl(173, 255, 47));
        namedColors.put("honeydew", new ColorImpl(240, 255, 240));
        namedColors.put("hotpink", new ColorImpl(255, 105, 180));
        namedColors.put("indianred", new ColorImpl(205, 92, 92));
        namedColors.put("indigo", new ColorImpl(75, 0, 130));
        namedColors.put("ivory", new ColorImpl(255, 255, 240));
        namedColors.put("khaki", new ColorImpl(240, 230, 140));
        namedColors.put("lavender", new ColorImpl(230, 230, 250));
        namedColors.put("lavenderblush", new ColorImpl(255, 240, 245));
        namedColors.put("lawngreen", new ColorImpl(124, 252, 0));
        namedColors.put("lemonchiffon", new ColorImpl(255, 250, 205));
        namedColors.put("lightblue", new ColorImpl(173, 216, 230));
        namedColors.put("lightcoral", new ColorImpl(240, 128, 128));
        namedColors.put("lightcyan", new ColorImpl(224, 255, 255));
        namedColors.put("lightgoldenrodyellow", new ColorImpl(250, 250, 210));
        namedColors.put("lightgray", new ColorImpl(211, 211, 211));
        namedColors.put("lightgrey", new ColorImpl(211, 211, 211));
        namedColors.put("lightgreen", new ColorImpl(144, 238, 144));
        namedColors.put("lightpink", new ColorImpl(255, 182, 193));
        namedColors.put("lightsalmon", new ColorImpl(255, 160, 122));
        namedColors.put("lightseagreen", new ColorImpl(32, 178, 170));
        namedColors.put("lightskyblue", new ColorImpl(135, 206, 250));
        namedColors.put("lightslategray", new ColorImpl(119, 136, 153));
        namedColors.put("lightslategrey", new ColorImpl(119, 136, 153));
        namedColors.put("lightsteelblue", new ColorImpl(176, 196, 222));
        namedColors.put("lightyellow", new ColorImpl(255, 255, 224));
        namedColors.put("lime", new ColorImpl(0, 255, 0));
        namedColors.put("limegreen", new ColorImpl(50, 205, 50));
        namedColors.put("linen", new ColorImpl(250, 240, 230));
        namedColors.put("magenta", new ColorImpl(255, 0, 255));
        namedColors.put("maroon", new ColorImpl(128, 0, 0));
        namedColors.put("mediumaquamarine", new ColorImpl(102, 205, 170));
        namedColors.put("mediumblue", new ColorImpl(0, 0, 205));
        namedColors.put("mediumorchid", new ColorImpl(186, 85, 211));
        namedColors.put("mediumpurple", new ColorImpl(147, 112, 219));
        namedColors.put("mediumseagreen", new ColorImpl(60, 179, 113));
        namedColors.put("mediumslateblue", new ColorImpl(123, 104, 238));
        namedColors.put("mediumspringgreen", new ColorImpl(0, 250, 154));
        namedColors.put("mediumturquoise", new ColorImpl(72, 209, 204));
        namedColors.put("mediumvioletred", new ColorImpl(199, 21, 133));
        namedColors.put("midnightblue", new ColorImpl(25, 25, 112));
        namedColors.put("mintcream", new ColorImpl(245, 255, 250));
        namedColors.put("mistyrose", new ColorImpl(255, 228, 225));
        namedColors.put("moccasin", new ColorImpl(255, 228, 181));
        namedColors.put("navajowhite", new ColorImpl(255, 222, 173));
        namedColors.put("navy", new ColorImpl(0, 0, 128));
        namedColors.put("oldlace", new ColorImpl(253, 245, 230));
        namedColors.put("olive", new ColorImpl(128, 128, 0));
        namedColors.put("olivedrab", new ColorImpl(107, 142, 35));
        namedColors.put("orange", new ColorImpl(255, 165, 0));
        namedColors.put("orangered", new ColorImpl(255, 69, 0));
        namedColors.put("orchid", new ColorImpl(218, 112, 214));
        namedColors.put("palegoldenrod", new ColorImpl(238, 232, 170));
        namedColors.put("palegreen", new ColorImpl(152, 251, 152));
        namedColors.put("paleturquoise", new ColorImpl(175, 238, 238));
        namedColors.put("palevioletred", new ColorImpl(219, 112, 147));
        namedColors.put("papayawhip", new ColorImpl(255, 239, 213));
        namedColors.put("peachpuff", new ColorImpl(255, 218, 185));
        namedColors.put("peru", new ColorImpl(205, 133, 63));
        namedColors.put("pink", new ColorImpl(255, 192, 203));
        namedColors.put("plum", new ColorImpl(221, 160, 221));
        namedColors.put("powderblue", new ColorImpl(176, 224, 230));
        namedColors.put("purple", new ColorImpl(128, 0, 128));
        namedColors.put("red", new ColorImpl(255, 0, 0));
        namedColors.put("rosybrown", new ColorImpl(188, 143, 143));
        namedColors.put("royalblue", new ColorImpl(65, 105, 225));
        namedColors.put("saddlebrown", new ColorImpl(139, 69, 19));
        namedColors.put("salmon", new ColorImpl(250, 128, 114));
        namedColors.put("sandybrown", new ColorImpl(244, 164, 96));
        namedColors.put("seagreen", new ColorImpl(46, 139, 87));
        namedColors.put("seashell", new ColorImpl(255, 245, 238));
        namedColors.put("sienna", new ColorImpl(160, 82, 45));
        namedColors.put("silver", new ColorImpl(192, 192, 192));
        namedColors.put("skyblue", new ColorImpl(135, 206, 235));
        namedColors.put("slateblue", new ColorImpl(106, 90, 205));
        namedColors.put("slategray", new ColorImpl(112, 128, 144));
        namedColors.put("slategrey", new ColorImpl(112, 128, 144));
        namedColors.put("snow", new ColorImpl(255, 250, 250));
        namedColors.put("springgreen", new ColorImpl(0, 255, 127));
        namedColors.put("steelblue", new ColorImpl(70, 130, 180));
        namedColors.put("tan", new ColorImpl(210, 180, 140));
        namedColors.put("teal", new ColorImpl(0, 128, 128));
        namedColors.put("thistle", new ColorImpl(216, 191, 216));
        namedColors.put("tomato", new ColorImpl(255, 99, 71));
        namedColors.put("turquoise", new ColorImpl(64, 224, 208));
        namedColors.put("violet", new ColorImpl(238, 130, 238));
        namedColors.put("wheat", new ColorImpl(245, 222, 179));
        namedColors.put("white", new ColorImpl(255, 255, 255));
        namedColors.put("whitesmoke", new ColorImpl(245, 245, 245));
        namedColors.put("yellow", new ColorImpl(255, 255, 0));
        namedColors.put("yellowgreen", new ColorImpl(154, 205, 50));
    }
}

