/*
 * Decompiled with CFR 0.152.
 */
package org.sweble.wom3.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.sweble.wom3.Wom3DefinitionList;
import org.sweble.wom3.Wom3DefinitionListDef;
import org.sweble.wom3.Wom3DefinitionListItem;
import org.sweble.wom3.Wom3DefinitionListTerm;
import org.sweble.wom3.Wom3Node;
import org.sweble.wom3.impl.AttributeBase;
import org.sweble.wom3.impl.AttributeDescriptor;
import org.sweble.wom3.impl.AttributeVerifiers;
import org.sweble.wom3.impl.Backbone;
import org.sweble.wom3.impl.BackboneWomElemWithCoreAttrs;
import org.sweble.wom3.impl.DefinitionListTermImpl;
import org.sweble.wom3.impl.DocumentImpl;
import org.sweble.wom3.impl.NativeAndStringValuePair;
import org.sweble.wom3.impl.UniversalAttributes;

public class DefinitionListImpl
extends BackboneWomElemWithCoreAttrs
implements Wom3DefinitionList {
    private static final long serialVersionUID = 1L;
    private DefinitionListTermImpl implicitFirstDt;
    private ArrayList<Wom3DefinitionListTerm> terms = new ArrayList();
    private static final Map<String, AttributeDescriptor> nameMap = DefinitionListImpl.getNameMap();

    public DefinitionListImpl(DocumentImpl owner) {
        super(owner);
    }

    @Override
    public String getWomName() {
        return "dl";
    }

    @Override
    public boolean isCompact() {
        return this.getBoolAttr("compact");
    }

    @Override
    public boolean setCompact(boolean compact) {
        return this.setBoolAttr(Attributes.COMPACT, "compact", compact);
    }

    @Override
    public int getTermNum() {
        return this.terms.size();
    }

    @Override
    public Collection<Wom3DefinitionListTerm> getTerms() {
        return Collections.unmodifiableCollection(this.terms);
    }

    @Override
    public Wom3DefinitionListTerm getTerm(int index) throws IndexOutOfBoundsException {
        return this.terms.get(index);
    }

    @Override
    public Wom3DefinitionListTerm replaceTerm(int index, Wom3DefinitionListTerm term) throws IndexOutOfBoundsException {
        Wom3DefinitionListTerm old = this.getTerm(index);
        this.terms.set(index, term);
        this.replaceChildNoNotify(old, term);
        this.removeDefs(old);
        this.appendDefs(term);
        return old;
    }

    @Override
    public Wom3DefinitionListTerm removeTerm(int index) throws IndexOutOfBoundsException {
        Wom3DefinitionListTerm old = this.terms.remove(index);
        this.removeChildNoNotify(old);
        this.removeDefs(old);
        return old;
    }

    @Override
    public void appendTerm(Wom3DefinitionListTerm term) {
        this.terms.add(term);
        this.appendChildNoNotify(term);
        this.appendDefs(term);
    }

    @Override
    public void insertTerm(int beforeIndex, Wom3DefinitionListTerm term) throws IndexOutOfBoundsException {
        if (beforeIndex < 0 || beforeIndex > this.terms.size()) {
            throw new IndexOutOfBoundsException();
        }
        if (beforeIndex == this.terms.size()) {
            this.appendTerm(term);
        } else {
            this.insertBeforeNoNotify(this.terms.get(beforeIndex), term);
        }
        this.terms.add(beforeIndex, term);
        this.appendDefs(term);
    }

    private void removeDefs(Wom3DefinitionListTerm removedTerm) {
        for (Wom3DefinitionListDef dd : removedTerm.getDefs()) {
            this.removeChildNoNotify(dd);
        }
    }

    private void appendDefs(Wom3DefinitionListTerm addedTerm) {
        Backbone before = addedTerm.getNextSibling();
        if (before != null) {
            for (Wom3DefinitionListDef dd : addedTerm.getDefs()) {
                this.insertBeforeNoNotify(before, dd);
            }
        } else {
            for (Wom3DefinitionListDef dd : addedTerm.getDefs()) {
                this.appendChildNoNotify(dd);
            }
        }
    }

    @Override
    public int getItemNum() {
        int count = 0;
        for (Wom3DefinitionListTerm term : this.terms) {
            count += 1 + term.getDefNum();
        }
        return count;
    }

    @Override
    public Collection<Wom3DefinitionListItem> getItems() {
        ArrayList<Wom3DefinitionListItem> items = new ArrayList<Wom3DefinitionListItem>(this.terms.size() * 5);
        if (this.implicitFirstDt != null) {
            items.addAll(this.implicitFirstDt.getDefs());
        }
        for (Wom3DefinitionListTerm term : this.terms) {
            items.add(term);
            items.addAll(term.getDefs());
        }
        return Collections.unmodifiableCollection(items);
    }

    @Override
    public Wom3DefinitionListItem getItem(int index) throws IndexOutOfBoundsException {
        Wom3DefinitionListItem item = this.getItemOrNullAtSize(index);
        if (item == null) {
            throw new IndexOutOfBoundsException();
        }
        return item;
    }

    @Override
    public Wom3DefinitionListItem replaceItem(int index, Wom3DefinitionListItem item) throws IndexOutOfBoundsException {
        Wom3DefinitionListItem old = this.getItem(index);
        if (old.getClass() != item.getClass()) {
            throw new UnsupportedOperationException("Can only replace item with another item of the same type!");
        }
        this.replaceChild(item, old);
        return old;
    }

    @Override
    public Wom3DefinitionListItem removeItem(int index) throws IndexOutOfBoundsException {
        Wom3DefinitionListItem old = this.getItem(index);
        this.removeChild(old);
        return old;
    }

    @Override
    public void appendItem(Wom3DefinitionListItem item) {
        this.appendChild(item);
    }

    @Override
    public void insertItem(int beforeIndex, Wom3DefinitionListItem item) throws IndexOutOfBoundsException {
        Wom3DefinitionListItem before = this.getItemOrNullAtSize(beforeIndex);
        if (before == null) {
            this.appendChild(item);
        } else {
            this.insertBefore(item, before);
        }
    }

    private Wom3DefinitionListItem getItemOrNullAtSize(int index) {
        int count = 0;
        if (this.implicitFirstDt != null) {
            int sub = index;
            int subSize = this.implicitFirstDt.getDefNum();
            if (sub < subSize) {
                return this.implicitFirstDt.getDef(sub);
            }
            count += subSize;
        }
        for (Wom3DefinitionListTerm term : this.terms) {
            int sub;
            if (index == count) {
                return term;
            }
            int subSize = term.getDefNum();
            if ((sub = index - ++count) < subSize) {
                return term.getDef(sub);
            }
            count += subSize;
        }
        if (index == count) {
            return null;
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public void childInserted(Backbone prev, Backbone added) {
        if (added instanceof Wom3DefinitionListDef) {
            Backbone p = this.searchTermForDef(prev);
            if (prev == null) {
                prev = this.implicitFirstDt;
            }
            ((DefinitionListTermImpl)p).defAdded(prev, (Wom3DefinitionListDef)((Object)added));
        } else if (added instanceof Wom3DefinitionListTerm) {
            DefinitionListTermImpl addedTerm = (DefinitionListTermImpl)added;
            int i = prev == null ? 0 : this.indexOfTerm(prev) + 1;
            DefinitionListTermImpl stealFrom = i > 0 ? this.terms.get(i - 1) : this.implicitFirstDt;
            Backbone sFirst = null;
            Backbone sLast = addedTerm;
            if (stealFrom != null && !(addedTerm.getNextSibling() instanceof Wom3DefinitionListTerm)) {
                Backbone n;
                while (!((n = sLast.getNextSibling()) instanceof Wom3DefinitionListTerm) && n != null) {
                    sLast = n;
                }
                sFirst = addedTerm.getNextSibling();
            }
            this.terms.add(i, addedTerm);
            this.appendDefs(addedTerm);
            if (sLast != addedTerm) {
                stealFrom.transfer(sFirst, sLast, addedTerm);
                if (this.implicitFirstDt != null && this.implicitFirstDt.getDefNum() == 0) {
                    this.implicitFirstDt = null;
                }
            }
        }
    }

    @Override
    public void childRemoved(Backbone prev, Backbone removed) {
        if (removed instanceof Wom3DefinitionListDef) {
            Backbone p = this.searchTermForDef(prev);
            ((DefinitionListTermImpl)p).defRemoved((Wom3DefinitionListDef)((Object)removed));
        } else if (removed instanceof Wom3DefinitionListTerm) {
            int i = prev == null ? 0 : this.indexOfTerm(prev) + 1;
            this.terms.remove(i);
            this.removeDefs((Wom3DefinitionListTerm)((Object)removed));
        }
    }

    private Backbone searchTermForDef(Backbone prev) {
        Backbone p;
        for (p = prev; p != null && !(p instanceof Wom3DefinitionListTerm); p = p.getPreviousSibling()) {
        }
        if (p == null) {
            p = this.getImplicitFirstDt();
        }
        return p;
    }

    private Backbone getImplicitFirstDt() {
        if (this.implicitFirstDt == null) {
            this.implicitFirstDt = (DefinitionListTermImpl)this.getOwnerDocument().createElementNS("http://sweble.org/schema/wom30", "dt");
        }
        return this.implicitFirstDt;
    }

    private int indexOfTerm(Wom3Node node) {
        int i = -1;
        Backbone child = this.getFirstChild();
        while (true) {
            if (child instanceof Wom3DefinitionListTerm) {
                ++i;
            }
            if (child == node) {
                return i;
            }
            child = child.getNextSibling();
        }
    }

    private static Map<String, AttributeDescriptor> getNameMap() {
        HashMap<String, AttributeDescriptor> nameMap = new HashMap<String, AttributeDescriptor>();
        nameMap.putAll(UniversalAttributes.getNameMap());
        nameMap.put("compact", Attributes.COMPACT);
        return nameMap;
    }

    @Override
    protected AttributeDescriptor getAttributeDescriptor(String namespaceUri, String localName, String qualifiedName) {
        return DefinitionListImpl.getAttrDesc(namespaceUri, localName, qualifiedName, nameMap);
    }

    private static enum Attributes implements AttributeDescriptor
    {
        COMPACT{

            @Override
            public boolean verifyAndConvert(Backbone parent, NativeAndStringValuePair verified) {
                return AttributeVerifiers.verifyAndConvertBool(parent, verified, "compact");
            }
        };


        @Override
        public boolean isRemovable() {
            return true;
        }

        @Override
        public AttributeDescriptor.Normalization getNormalizationMode() {
            return AttributeDescriptor.Normalization.NON_CDATA;
        }

        @Override
        public void customAction(Wom3Node parent, AttributeBase oldAttr, AttributeBase newAttr) {
        }
    }
}

