/*
 * Decompiled with CFR 0.152.
 */
package org.sweble.wom3.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.sweble.wom3.Wom3DefinitionListDef;
import org.sweble.wom3.Wom3DefinitionListTerm;
import org.sweble.wom3.impl.Backbone;
import org.sweble.wom3.impl.BackboneWomElemWithUnivAttrs;
import org.sweble.wom3.impl.DocumentImpl;

public class DefinitionListTermImpl
extends BackboneWomElemWithUnivAttrs
implements Wom3DefinitionListTerm {
    private static final long serialVersionUID = 1L;
    private ArrayList<Wom3DefinitionListDef> defs = new ArrayList();

    public DefinitionListTermImpl(DocumentImpl owner) {
        super(owner);
    }

    @Override
    public String getWomName() {
        return "dt";
    }

    @Override
    public int getDefNum() {
        return this.defs.size();
    }

    @Override
    public Collection<Wom3DefinitionListDef> getDefs() {
        return Collections.unmodifiableCollection(this.defs);
    }

    @Override
    public Wom3DefinitionListDef getDef(int index) throws IndexOutOfBoundsException {
        return this.defs.get(index);
    }

    @Override
    public Wom3DefinitionListDef replaceDef(int index, Wom3DefinitionListDef def) throws IndexOutOfBoundsException {
        Backbone parent = this.getParentNode();
        if (parent != null) {
            Wom3DefinitionListDef old = this.getDef(index);
            parent.replaceChild(def, old);
            return old;
        }
        return this.defs.set(index, def);
    }

    @Override
    public Wom3DefinitionListDef removeDef(int index) throws IndexOutOfBoundsException {
        Backbone parent = this.getParentNode();
        if (parent != null) {
            Wom3DefinitionListDef old = this.getDef(index);
            parent.removeChild(old);
            return old;
        }
        return this.defs.remove(index);
    }

    @Override
    public void appendDef(Wom3DefinitionListDef def) {
        Backbone parent = this.getParentNode();
        if (parent != null) {
            Backbone before = null;
            if (!this.defs.isEmpty()) {
                Wom3DefinitionListDef lastDef = this.defs.get(this.defs.size() - 1);
                before = lastDef.getNextSibling();
            } else {
                before = this.getNextSibling();
            }
            if (before == null) {
                parent.appendChild(def);
            } else {
                parent.insertBefore(def, before);
            }
        } else {
            this.defs.add(def);
        }
    }

    @Override
    public void insertDef(int beforeIndex, Wom3DefinitionListDef def) throws IndexOutOfBoundsException {
        Backbone parent = this.getParentNode();
        if (parent != null) {
            int size = this.defs.size();
            if (beforeIndex < 0 || beforeIndex > size) {
                throw new IndexOutOfBoundsException();
            }
            if (beforeIndex == size) {
                this.appendDef(def);
            } else {
                parent.insertBefore(def, this.defs.get(beforeIndex));
            }
        } else {
            this.defs.add(beforeIndex, def);
        }
    }

    protected void defRemoved(Wom3DefinitionListDef removed) {
        for (int i = 0; i < this.defs.size(); ++i) {
            if (this.defs.get(i) != removed) continue;
            this.defs.remove(i);
            return;
        }
        throw new InternalError();
    }

    public void defAdded(Backbone prev, Wom3DefinitionListDef added) {
        int i = 0;
        Backbone p = prev;
        while (true) {
            if (p == null) {
                this.defs.add(i, added);
                return;
            }
            if (p instanceof Wom3DefinitionListTerm) {
                if (p != this) {
                    throw new InternalError();
                }
                this.defs.add(i, added);
                return;
            }
            if (p instanceof Wom3DefinitionListDef) {
                ++i;
            }
            p = p.getPreviousSibling();
        }
    }

    public void appendAll(Collection<Wom3DefinitionListDef> defs) {
        this.defs.addAll(defs);
    }

    public void transfer(Backbone sFirst, Backbone sLast, DefinitionListTermImpl other) {
        Backbone d = sLast;
        int i = this.defs.size();
        while (true) {
            if (d instanceof Wom3DefinitionListDef && this.defs.get(--i) != d) {
                throw new InternalError();
            }
            if (d == sFirst) break;
            d = d.getPreviousSibling();
        }
        if (d != sFirst) {
            throw new InternalError();
        }
        other.appendAll(this.defs.subList(i, this.defs.size()));
        while (this.defs.size() > i) {
            this.defs.remove(this.defs.size() - 1);
        }
    }
}

