/*
 * Decompiled with CFR 0.152.
 */
package org.sweble.wom3.impl;

import org.sweble.wom3.Wom3Element;
import org.sweble.wom3.impl.DocumentImpl;
import org.sweble.wom3.impl.ElementImpl;
import org.sweble.wom3.impl.Toolbox;
import org.w3c.dom.DOMException;

public class ElementNsImpl
extends ElementImpl
implements Wom3Element {
    private static final long serialVersionUID = 1L;
    private String namespaceUri;
    private String localName;
    private String prefix;

    protected ElementNsImpl(DocumentImpl owner) {
        super(owner);
    }

    public ElementNsImpl(DocumentImpl owner, String namespaceUri, String qualifiedName) {
        super(owner, qualifiedName);
        this.setNamespaceUri(namespaceUri);
        this.setPrefixAndLocalName(qualifiedName);
    }

    @Override
    public String getNamespaceURI() {
        return this.namespaceUri;
    }

    @Override
    public String getLocalName() {
        return this.localName;
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public void setPrefix(String prefix) throws DOMException {
        throw new UnsupportedOperationException();
    }

    protected void setNamespaceUri(String namespaceUri) {
        this.namespaceUri = namespaceUri;
        if (this.namespaceUri != null && this.namespaceUri.isEmpty()) {
            this.namespaceUri = null;
        }
    }

    protected void setPrefixAndLocalName(String qualifiedName) {
        String prefix = null;
        String localName = null;
        int colon = qualifiedName.indexOf(58);
        if (colon < 0) {
            prefix = null;
            localName = qualifiedName;
            ElementNsImpl.checkNamespaceUriAndName(this.namespaceUri, qualifiedName);
        } else {
            if (colon == 0 || colon == qualifiedName.length() - 1 || qualifiedName.indexOf(58, colon + 1) >= 0) {
                throw new DOMException(14, "Invalid qualified attribute name: " + qualifiedName);
            }
            prefix = qualifiedName.substring(0, colon);
            localName = qualifiedName.substring(colon + 1);
            ElementNsImpl.checkNamespaceUriAndPrefix(prefix, this.namespaceUri);
            Toolbox.checkValidXmlName(prefix);
        }
        Toolbox.checkValidXmlName(localName);
        this.prefix = prefix;
        this.localName = localName;
    }

    private static void checkNamespaceUriAndName(String namespaceUri, String qualifiedName) {
    }

    private static void checkNamespaceUriAndPrefix(String prefix, String namespaceUri) {
    }
}

