/*
 * Decompiled with CFR 0.152.
 */
package org.sweble.wom3.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.sweble.wom3.Wom3ElementNode;
import org.sweble.wom3.Wom3Node;
import org.sweble.wom3.Wom3NodeList;
import org.sweble.wom3.impl.Backbone;

public class ElementsByTagNameNodeList
implements Wom3NodeList {
    private final String tagName;
    private final String namespaceUri;
    private Wom3Node root;
    private boolean withNs = false;
    private ArrayList<Wom3Node> nodes = null;

    public ElementsByTagNameNodeList(Wom3Node root, String tagName) {
        this.root = root;
        this.namespaceUri = null;
        this.tagName = tagName;
    }

    public ElementsByTagNameNodeList(Wom3Node root, String namespaceURI, String localName) {
        this.withNs = true;
        this.root = root;
        if (namespaceURI != null && namespaceURI.isEmpty()) {
            namespaceURI = null;
        }
        this.namespaceUri = namespaceURI;
        this.tagName = localName;
    }

    @Override
    public int getLength() {
        this.item(Integer.MAX_VALUE);
        return this.nodes != null ? this.nodes.size() : 0;
    }

    @Override
    public Wom3Node item(int index) {
        if (this.nodes != null && this.nodes.size() > index) {
            return this.nodes.get(index);
        }
        if (this.root == null) {
            return null;
        }
        Wom3Node current = this.root;
        if (this.nodes != null && !this.nodes.isEmpty()) {
            current = this.nodes.get(this.nodes.size() - 1);
        }
        while (true) {
            if ((current = this.advance(current)) == null) {
                this.root = null;
                return null;
            }
            if (!this.isMatch(current)) continue;
            if (this.nodes == null) {
                this.nodes = new ArrayList();
            }
            this.nodes.add(current);
            if (this.nodes.size() > index) break;
        }
        return current;
    }

    private boolean isMatch(Wom3Node current) {
        if (current.getNodeType() != 1) {
            return false;
        }
        Wom3ElementNode e = (Wom3ElementNode)current;
        if (this.withNs) {
            return this.isNsMatch(e) && this.isLocalNameMatch(e);
        }
        return this.isTagNameMatch(e);
    }

    private boolean isTagNameMatch(Wom3ElementNode e) {
        if (this.tagName.equals("*")) {
            return true;
        }
        return this.tagName.equals(e.getTagName());
    }

    private boolean isLocalNameMatch(Wom3ElementNode e) {
        if (this.tagName.equals("*")) {
            return true;
        }
        return this.tagName.equals(e.getLocalName());
    }

    private boolean isNsMatch(Wom3ElementNode e) {
        if (this.namespaceUri != null) {
            if (this.namespaceUri.equals("*")) {
                return true;
            }
            return this.namespaceUri.equals(e.getNamespaceURI());
        }
        return e.getNamespaceURI() == null;
    }

    private Wom3Node advance(Wom3Node current) {
        Backbone next = current.getFirstChild();
        if (next != null) {
            return next;
        }
        next = current.getNextSibling();
        while (next == null) {
            if ((current = current.getParentNode()) == this.root) {
                return null;
            }
            next = current.getNextSibling();
        }
        return next;
    }

    @Override
    public Iterator<Wom3Node> iterator() {
        return new Iterator<Wom3Node>(){
            private int index = 0;

            @Override
            public boolean hasNext() {
                return ElementsByTagNameNodeList.this.item(this.index) != null;
            }

            @Override
            public Wom3Node next() {
                Wom3Node item = ElementsByTagNameNodeList.this.item(this.index);
                if (item == null) {
                    throw new NoSuchElementException();
                }
                ++this.index;
                return item;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

