/*
 * Decompiled with CFR 0.152.
 */
package org.sweble.wom3.impl;

import de.fau.cs.osr.utils.WrappedException;
import java.net.MalformedURLException;
import java.net.URL;
import org.sweble.wom3.Wom3ExtLink;
import org.sweble.wom3.Wom3Node;
import org.sweble.wom3.Wom3Title;
import org.sweble.wom3.impl.AttributeBase;
import org.sweble.wom3.impl.AttributeDescriptor;
import org.sweble.wom3.impl.AttributeVerifiers;
import org.sweble.wom3.impl.Backbone;
import org.sweble.wom3.impl.BackboneContainer;
import org.sweble.wom3.impl.ChildDescriptor;
import org.sweble.wom3.impl.DocumentImpl;
import org.sweble.wom3.impl.NativeAndStringValuePair;
import org.sweble.wom3.impl.TitleImpl;

public class ExtLinkImpl
extends BackboneContainer
implements Wom3ExtLink {
    private static final long serialVersionUID = 1L;
    private static final ChildDescriptor[] BODY_DESCRIPTOR = new ChildDescriptor[]{ExtLinkImpl.childDesc("title")};
    private TitleImpl title;

    public ExtLinkImpl(DocumentImpl owner) {
        super(owner);
        try {
            this.setTarget(new URL("http", null, "."));
        }
        catch (MalformedURLException e) {
            throw new WrappedException((Throwable)e);
        }
    }

    @Override
    public String getWomName() {
        return "extlink";
    }

    @Override
    protected void allowsInsertion(Backbone prev, Backbone child) {
        this.checkInsertion(prev, child, BODY_DESCRIPTOR);
    }

    @Override
    protected void allowsRemoval(Backbone child) {
        this.checkRemoval(child, BODY_DESCRIPTOR);
    }

    @Override
    protected void allowsReplacement(Backbone oldChild, Backbone newChild) {
        this.checkReplacement(oldChild, newChild, BODY_DESCRIPTOR);
    }

    @Override
    public void childInserted(Backbone prev, Backbone added) {
        if (added instanceof Wom3Title) {
            this.title = (TitleImpl)added;
        }
    }

    @Override
    public void childRemoved(Backbone prev, Backbone removed) {
        if (removed == this.title) {
            this.title = null;
        }
    }

    @Override
    public URL getTarget() {
        return (URL)this.getAttributeNativeData("target");
    }

    @Override
    public URL getLinkTarget() {
        return this.getTarget();
    }

    @Override
    public URL setTarget(URL target) {
        return this.setAttributeDirect(Attributes.TARGET, "target", target);
    }

    @Override
    public boolean isPlainUrl() {
        return this.getBoolAttr("plainurl");
    }

    @Override
    public boolean setPlainUrl(boolean plainUrl) {
        return this.setBoolAttr(Attributes.PLAINURL, "plainurl", plainUrl);
    }

    @Override
    public Wom3Title setLinkTitle(Wom3Title title) throws NullPointerException {
        return (Wom3Title)this.replaceOrAppend(this.title, title, false);
    }

    @Override
    public Wom3Title getLinkTitle() {
        return this.title;
    }

    @Override
    protected AttributeDescriptor getAttributeDescriptor(String namespaceURL, String localName, String qualifiedName) {
        return ExtLinkImpl.getAttrDescStrict(namespaceURL, localName, qualifiedName, "target", Attributes.TARGET, "plainurl", Attributes.PLAINURL);
    }

    private static enum Attributes implements AttributeDescriptor
    {
        TARGET{

            @Override
            public boolean verifyAndConvert(Backbone parent, NativeAndStringValuePair verified) {
                return AttributeVerifiers.URL.verifyAndConvert(parent, verified);
            }
        }
        ,
        PLAINURL{

            @Override
            public boolean verifyAndConvert(Backbone parent, NativeAndStringValuePair verified) {
                return AttributeVerifiers.verifyAndConvertBool(parent, verified, "plainurl");
            }
        };


        @Override
        public boolean isRemovable() {
            return false;
        }

        @Override
        public AttributeDescriptor.Normalization getNormalizationMode() {
            return AttributeDescriptor.Normalization.CDATA;
        }

        @Override
        public void customAction(Wom3Node parent, AttributeBase oldAttr, AttributeBase newAttr) {
        }
    }
}

