/*
 * Decompiled with CFR 0.152.
 */
package org.sweble.wom3.impl;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.sweble.wom3.Wom3Image;
import org.sweble.wom3.Wom3ImageCaption;
import org.sweble.wom3.Wom3ImageFormat;
import org.sweble.wom3.Wom3ImageHAlign;
import org.sweble.wom3.Wom3ImageVAlign;
import org.sweble.wom3.Wom3Node;
import org.sweble.wom3.Wom3Title;
import org.sweble.wom3.impl.AttributeBase;
import org.sweble.wom3.impl.AttributeDescriptor;
import org.sweble.wom3.impl.AttributeVerifiers;
import org.sweble.wom3.impl.Backbone;
import org.sweble.wom3.impl.BackboneContainer;
import org.sweble.wom3.impl.ChildDescriptor;
import org.sweble.wom3.impl.DocumentImpl;
import org.sweble.wom3.impl.NativeAndStringValuePair;
import org.sweble.wom3.impl.Toolbox;

public class ImageImpl
extends BackboneContainer
implements Wom3Image {
    private static final long serialVersionUID = 1L;
    private static final ChildDescriptor[] BODY_DESCRIPTOR = new ChildDescriptor[]{ImageImpl.childDesc("imgcaption")};
    private Wom3ImageCaption caption;
    private static final Map<String, AttributeDescriptor> nameMap = ImageImpl.getNameMap();

    public ImageImpl(DocumentImpl owner) {
        super(owner);
        this.setSource("unknown");
    }

    @Override
    public String getWomName() {
        return "image";
    }

    @Override
    protected void allowsInsertion(Backbone prev, Backbone child) {
        this.checkInsertion(prev, child, BODY_DESCRIPTOR);
    }

    @Override
    protected void allowsRemoval(Backbone child) {
        this.checkRemoval(child, BODY_DESCRIPTOR);
    }

    @Override
    protected void allowsReplacement(Backbone oldChild, Backbone newChild) {
        this.checkReplacement(oldChild, newChild, BODY_DESCRIPTOR);
    }

    @Override
    public void childInserted(Backbone prev, Backbone added) {
        if (added instanceof Wom3ImageCaption) {
            this.caption = (Wom3ImageCaption)((Object)added);
        }
    }

    @Override
    public void childRemoved(Backbone prev, Backbone removed) {
        if (removed == this.caption) {
            this.caption = null;
        }
    }

    @Override
    public String getSource() {
        return this.getStringAttr("source");
    }

    @Override
    public String setSource(String source) {
        return this.setAttributeDirect(Attributes.SOURCE, "source", source);
    }

    @Override
    public Wom3ImageFormat getFormat() {
        return (Wom3ImageFormat)((Object)this.getAttributeNativeData("format"));
    }

    @Override
    public Wom3ImageFormat setFormat(Wom3ImageFormat format) throws NullPointerException {
        return this.setAttributeDirect(Attributes.FORMAT, "format", format);
    }

    @Override
    public boolean isBorder() {
        return this.getAttributeNativeData("border") != null;
    }

    @Override
    public boolean setBorder(boolean border) {
        return this.setAttributeDirect(Attributes.BORDER, "border", border) != null;
    }

    @Override
    public Wom3ImageHAlign getHAlign() {
        return (Wom3ImageHAlign)((Object)this.getAttributeNativeData("halign"));
    }

    @Override
    public Wom3ImageHAlign setHAlign(Wom3ImageHAlign halign) {
        return this.setAttributeDirect(Attributes.HALIGN, "halign", halign);
    }

    @Override
    public Wom3ImageVAlign getVAlign() {
        return (Wom3ImageVAlign)((Object)this.getAttributeNativeData("valign"));
    }

    @Override
    public Wom3ImageVAlign setVAlign(Wom3ImageVAlign valign) {
        return this.setAttributeDirect(Attributes.VALIGN, "valign", valign);
    }

    @Override
    public Integer getWidth() {
        return (Integer)this.getAttributeNativeData("width");
    }

    @Override
    public Integer setWidth(Integer width) {
        return this.setAttributeDirect(Attributes.WIDTH, "width", width);
    }

    @Override
    public Integer getHeight() {
        return (Integer)this.getAttributeNativeData("height");
    }

    @Override
    public Integer setHeight(Integer height) {
        return this.setAttributeDirect(Attributes.HEIGHT, "height", height);
    }

    @Override
    public boolean isUpright() {
        return this.getAttributeNativeData("upright") != null;
    }

    @Override
    public boolean setUpright(boolean upright) {
        return this.setAttributeDirect(Attributes.UPRIGHT, "upright", upright) != null;
    }

    @Override
    public URL getExtLink() {
        return this.getUrlAttr("extlink");
    }

    @Override
    public URL setExtLink(URL url) {
        return this.setUrlAttr(Attributes.EXTLINK, "extlink", url);
    }

    @Override
    public String getIntLink() {
        return this.getStringAttr("intlink");
    }

    @Override
    public String setIntLink(String target) {
        return this.setAttributeDirect(Attributes.INTLINK, "intlink", target);
    }

    @Override
    public String getAlt() {
        return this.getStringAttr("alt");
    }

    @Override
    public String setAlt(String alt) {
        return this.setAttributeDirect(Attributes.ALT, "alt", alt);
    }

    @Override
    public Wom3ImageCaption setCaption(Wom3ImageCaption caption) throws NullPointerException {
        return (Wom3ImageCaption)this.replaceOrAppend(this.caption, caption, false);
    }

    @Override
    public Wom3ImageCaption getCaption() {
        return this.caption;
    }

    @Override
    public Wom3Title getLinkTitle() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getLinkTarget() {
        String intLink = this.getIntLink();
        if (intLink != null) {
            return intLink;
        }
        return this.getSource();
    }

    private static Map<String, AttributeDescriptor> getNameMap() {
        HashMap<String, AttributeDescriptor> nameMap = new HashMap<String, AttributeDescriptor>();
        nameMap.put("source", Attributes.SOURCE);
        nameMap.put("format", Attributes.FORMAT);
        nameMap.put("border", Attributes.BORDER);
        nameMap.put("halign", Attributes.HALIGN);
        nameMap.put("valign", Attributes.VALIGN);
        nameMap.put("width", Attributes.WIDTH);
        nameMap.put("height", Attributes.HEIGHT);
        nameMap.put("upright", Attributes.UPRIGHT);
        nameMap.put("extlink", Attributes.EXTLINK);
        nameMap.put("intlink", Attributes.INTLINK);
        nameMap.put("alt", Attributes.ALT);
        return nameMap;
    }

    @Override
    protected AttributeDescriptor getAttributeDescriptor(String namespaceUri, String localName, String qualifiedName) {
        return ImageImpl.getAttrDescStrict(namespaceUri, localName, qualifiedName, nameMap);
    }

    private static enum Attributes implements AttributeDescriptor
    {
        SOURCE{

            @Override
            public boolean verifyAndConvert(Backbone parent, NativeAndStringValuePair verified) {
                if (verified.strValue == null) {
                    verified.strValue = (String)verified.value;
                }
                Toolbox.checkValidTarget(verified.strValue);
                return true;
            }

            @Override
            public boolean isRemovable() {
                return false;
            }
        }
        ,
        FORMAT{

            @Override
            public boolean verifyAndConvert(Backbone parent, NativeAndStringValuePair verified) {
                if (verified.strValue != null) {
                    verified.value = Toolbox.stringToImageFormat(verified.strValue);
                } else {
                    verified.strValue = Toolbox.imageFormatToString((Wom3ImageFormat)((Object)verified.value));
                }
                return true;
            }
        }
        ,
        BORDER{

            @Override
            public boolean verifyAndConvert(Backbone parent, NativeAndStringValuePair verified) {
                return AttributeVerifiers.verifyAndConvertBool(parent, verified, "border");
            }
        }
        ,
        HALIGN{

            @Override
            public boolean verifyAndConvert(Backbone parent, NativeAndStringValuePair verified) {
                if (verified.strValue != null) {
                    verified.value = Toolbox.stringToImageHAlign(verified.strValue);
                } else {
                    verified.strValue = Toolbox.imageHAlignToString((Wom3ImageHAlign)((Object)verified.value));
                }
                return true;
            }
        }
        ,
        VALIGN{

            @Override
            public boolean verifyAndConvert(Backbone parent, NativeAndStringValuePair verified) {
                if (verified.strValue != null) {
                    verified.value = Toolbox.stringToImageVAlign(verified.strValue);
                } else {
                    verified.strValue = Toolbox.imageVAlignToString((Wom3ImageVAlign)((Object)verified.value));
                }
                return true;
            }
        }
        ,
        WIDTH{

            @Override
            public boolean verifyAndConvert(Backbone parent, NativeAndStringValuePair verified) {
                return AttributeVerifiers.PIXELS.verifyAndConvert(parent, verified);
            }
        }
        ,
        HEIGHT{

            @Override
            public boolean verifyAndConvert(Backbone parent, NativeAndStringValuePair verified) {
                return AttributeVerifiers.PIXELS.verifyAndConvert(parent, verified);
            }
        }
        ,
        UPRIGHT{

            @Override
            public boolean verifyAndConvert(Backbone parent, NativeAndStringValuePair verified) {
                return AttributeVerifiers.verifyAndConvertBool(parent, verified, "upright");
            }
        }
        ,
        EXTLINK{

            @Override
            public boolean verifyAndConvert(Backbone parent, NativeAndStringValuePair verified) {
                return AttributeVerifiers.URL.verifyAndConvert(parent, verified);
            }
        }
        ,
        INTLINK{

            @Override
            public boolean verifyAndConvert(Backbone parent, NativeAndStringValuePair verified) {
                if (verified.strValue == null) {
                    verified.strValue = (String)verified.value;
                }
                if (!verified.strValue.isEmpty()) {
                    Toolbox.checkValidTarget(verified.strValue);
                }
                return true;
            }
        }
        ,
        ALT{

            @Override
            public boolean verifyAndConvert(Backbone parent, NativeAndStringValuePair verified) {
                return true;
            }
        };


        @Override
        public boolean isRemovable() {
            return true;
        }

        @Override
        public AttributeDescriptor.Normalization getNormalizationMode() {
            return AttributeDescriptor.Normalization.CDATA;
        }

        @Override
        public void customAction(Wom3Node parent, AttributeBase oldAttr, AttributeBase newAttr) {
        }
    }
}

