/*
 * Decompiled with CFR 0.152.
 */
package org.sweble.wom3.impl;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.sweble.wom3.Wom3Node;

public class ImmutableSiblingCollection<T extends Wom3Node>
implements Collection<T> {
    private final int size;
    private final T first;

    public ImmutableSiblingCollection(T first) {
        this.first = first;
        this.size = this.count(first);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean contains(Object o) {
        T i = this.first;
        while (i != null) {
            if (o == null ? i == null : o.equals(i)) {
                return true;
            }
            i = this.advance(i);
        }
        return false;
    }

    @Override
    public Iterator<T> iterator() {
        return new SiblingIterator<T>(this.first);
    }

    @Override
    public Object[] toArray() {
        Object[] array = new Object[this.size];
        int j = 0;
        T i = this.first;
        while (i != null) {
            array[j++] = i;
            i = this.advance(i);
        }
        return array;
    }

    @Override
    public <S> S[] toArray(S[] a) {
        if (a.length < this.size) {
            a = this.makeArray(a);
        }
        int j = 0;
        S[] result = a;
        T i = this.first;
        while (i != null) {
            result[j++] = i;
            i = this.advance(i);
        }
        if (a.length > this.size) {
            a[this.size] = null;
        }
        return a;
    }

    @Override
    public boolean add(T e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    private int count(T first) {
        int count = 0;
        T i = first;
        while (i != null) {
            ++count;
            i = this.advance(i);
        }
        return count;
    }

    private T advance(T i) {
        return (T)i.getNextSibling();
    }

    private <S> S[] makeArray(S[] a) {
        return (Object[])Array.newInstance(a.getClass().getComponentType(), this.size);
    }

    private static final class SiblingIterator<T extends Wom3Node>
    implements Iterator<T> {
        T i;

        public SiblingIterator(T first) {
            this.i = first;
        }

        @Override
        public boolean hasNext() {
            return this.i != null;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            T n = this.i;
            this.i = this.i.getNextSibling();
            return n;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

