/*
 * Decompiled with CFR 0.152.
 */
package org.sweble.wom3.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.sweble.wom3.Wom3List;
import org.sweble.wom3.Wom3ListItem;
import org.sweble.wom3.Wom3Node;
import org.sweble.wom3.impl.AttributeBase;
import org.sweble.wom3.impl.AttributeDescriptor;
import org.sweble.wom3.impl.AttributeVerifiers;
import org.sweble.wom3.impl.Backbone;
import org.sweble.wom3.impl.BackboneWomElemWithCoreAttrs;
import org.sweble.wom3.impl.DocumentImpl;
import org.sweble.wom3.impl.NativeAndStringValuePair;

public abstract class ListBaseImpl
extends BackboneWomElemWithCoreAttrs
implements Wom3List {
    private static final long serialVersionUID = 1L;
    private final ArrayList<Wom3ListItem> items = new ArrayList();

    public ListBaseImpl(DocumentImpl owner) {
        super(owner);
    }

    @Override
    public boolean isCompact() {
        return this.getBoolAttr("compact");
    }

    @Override
    public boolean setCompact(boolean compact) {
        return this.setBoolAttr(Attributes.COMPACT, "compact", compact);
    }

    @Override
    public int getItemNum() {
        return this.items.size();
    }

    @Override
    public Collection<Wom3ListItem> getItems() {
        return Collections.unmodifiableCollection(this.items);
    }

    @Override
    public Wom3ListItem getItem(int index) throws IndexOutOfBoundsException {
        return this.items.get(index);
    }

    @Override
    public Wom3ListItem replaceItem(int index, Wom3ListItem item) throws IndexOutOfBoundsException {
        Wom3ListItem old = this.getItem(index);
        this.replaceChild(item, old);
        return old;
    }

    @Override
    public Wom3ListItem removeItem(int index) throws IndexOutOfBoundsException {
        Wom3ListItem old = this.getItem(index);
        this.removeChild(old);
        return old;
    }

    @Override
    public void appendItem(Wom3ListItem item) {
        this.appendChild(item);
    }

    @Override
    public void insertItem(int beforeIndex, Wom3ListItem item) throws IndexOutOfBoundsException {
        int size = this.getItemNum();
        if (beforeIndex < size) {
            this.insertBefore(item, this.getItem(beforeIndex));
        } else if (beforeIndex == size) {
            this.appendItem(item);
        } else {
            throw new IndexOutOfBoundsException();
        }
    }

    @Override
    public void childInserted(Backbone prev, Backbone added) {
        if (added instanceof Wom3ListItem) {
            int i = prev == null ? 0 : this.indexOf(prev) + 1;
            this.items.add(i, (Wom3ListItem)((Object)added));
        }
    }

    @Override
    public void childRemoved(Backbone prev, Backbone removed) {
        if (removed instanceof Wom3ListItem) {
            int i = prev == null ? 0 : this.indexOf(prev) + 1;
            this.items.remove(i);
        }
    }

    private int indexOf(Wom3Node node) {
        int i = -1;
        Backbone child = this.getFirstChild();
        while (true) {
            if (child instanceof Wom3ListItem) {
                ++i;
            }
            if (child == node) {
                return i;
            }
            child = child.getNextSibling();
        }
    }

    static enum Attributes implements AttributeDescriptor
    {
        COMPACT{

            @Override
            public boolean verifyAndConvert(Backbone parent, NativeAndStringValuePair verified) {
                return AttributeVerifiers.verifyAndConvertBool(parent, verified, "compact");
            }
        };


        @Override
        public boolean isRemovable() {
            return true;
        }

        @Override
        public AttributeDescriptor.Normalization getNormalizationMode() {
            return AttributeDescriptor.Normalization.NON_CDATA;
        }

        @Override
        public void customAction(Wom3Node parent, AttributeBase oldAttr, AttributeBase newAttr) {
        }
    }
}

