/*
 * Decompiled with CFR 0.152.
 */
package org.sweble.wom3.impl;

import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.sweble.wom3.Wom3Node;
import org.sweble.wom3.Wom3NodeList;
import org.sweble.wom3.impl.Backbone;

public class NodeListImpl
implements Wom3NodeList {
    private final Backbone parent;
    private int last = -1;
    private int length = -1;
    private Wom3Node lastNode = null;
    private int childrenChanges;

    public NodeListImpl(Backbone parent) {
        this.parent = parent;
        this.childrenChanges = this.getChildrenChanges();
    }

    @Override
    public Wom3Node item(int index) {
        Wom3Node n;
        this.testInvalidate();
        if (this.last == -1) {
            int cnt = 0;
            for (n = this.parent.getFirstChild(); n != null && cnt++ < index; n = n.getNextSibling()) {
            }
        } else {
            int cnt = index - this.last;
            if (cnt > 0) {
                for (n = this.lastNode; n != null && cnt-- > 0; n = n.getNextSibling()) {
                }
            } else {
                while (n != null && cnt++ < 0) {
                    n = n.getPreviousSibling();
                }
            }
        }
        this.last = index;
        this.lastNode = n;
        return n;
    }

    @Override
    public int getLength() {
        this.testInvalidate();
        if (this.length == -1) {
            int len = 0;
            for (Backbone n = this.parent.getFirstChild(); n != null; n = n.getNextSibling()) {
                ++len;
            }
            this.length = len;
        }
        return this.length;
    }

    @Override
    public Iterator<Wom3Node> iterator() {
        return new Iterator<Wom3Node>(){
            private int index = 0;
            private int childrenChanges = NodeListImpl.access$000(NodeListImpl.this);

            @Override
            public boolean hasNext() {
                if (this.hasModification()) {
                    throw new ConcurrentModificationException();
                }
                return NodeListImpl.this.item(this.index) != null;
            }

            @Override
            public Wom3Node next() {
                if (this.hasModification()) {
                    throw new ConcurrentModificationException();
                }
                Wom3Node item = NodeListImpl.this.item(this.index);
                if (item == null) {
                    throw new NoSuchElementException();
                }
                ++this.index;
                return item;
            }

            @Override
            public void remove() {
                if (this.hasModification()) {
                    throw new ConcurrentModificationException();
                }
                throw new UnsupportedOperationException();
            }

            private boolean hasModification() {
                return this.childrenChanges != NodeListImpl.this.getChildrenChanges();
            }
        };
    }

    private void testInvalidate() {
        if (this.hasModification()) {
            this.childrenChanges = this.getChildrenChanges();
            this.length = -1;
            this.last = -1;
        }
    }

    private boolean hasModification() {
        return this.childrenChanges != this.getChildrenChanges();
    }

    private int getChildrenChanges() {
        return this.parent.childrenChanges;
    }
}

