/*
 * Decompiled with CFR 0.152.
 */
package org.sweble.wom3.impl;

import org.sweble.wom3.Wom3Body;
import org.sweble.wom3.Wom3Heading;
import org.sweble.wom3.Wom3Node;
import org.sweble.wom3.Wom3Section;
import org.sweble.wom3.impl.AttributeBase;
import org.sweble.wom3.impl.AttributeDescriptor;
import org.sweble.wom3.impl.AttributeVerifiers;
import org.sweble.wom3.impl.Backbone;
import org.sweble.wom3.impl.BackboneContainer;
import org.sweble.wom3.impl.ChildDescriptor;
import org.sweble.wom3.impl.DocumentImpl;
import org.sweble.wom3.impl.NativeAndStringValuePair;

public class SectionImpl
extends BackboneContainer
implements Wom3Section {
    private static final long serialVersionUID = 1L;
    private static final ChildDescriptor[] BODY_DESCRIPTOR = new ChildDescriptor[]{SectionImpl.childDesc("heading", 1), SectionImpl.childDesc("body", 1)};
    private Wom3Heading heading;
    private Wom3Body body;

    public SectionImpl(DocumentImpl owner) {
        super(owner);
        this.setLevelAttr(1);
    }

    @Override
    public String getWomName() {
        return "section";
    }

    @Override
    protected void allowsInsertion(Backbone prev, Backbone child) {
        this.checkInsertion(prev, child, BODY_DESCRIPTOR);
    }

    @Override
    protected void allowsRemoval(Backbone child) {
        this.checkRemoval(child, BODY_DESCRIPTOR);
    }

    @Override
    protected void allowsReplacement(Backbone oldChild, Backbone newChild) {
        this.checkReplacement(oldChild, newChild, BODY_DESCRIPTOR);
    }

    @Override
    public void childInserted(Backbone prev, Backbone added) {
        if (added instanceof Wom3Heading) {
            this.heading = (Wom3Heading)((Object)added);
        } else if (added instanceof Wom3Body) {
            this.body = (Wom3Body)((Object)added);
        }
    }

    @Override
    public void childRemoved(Backbone prev, Backbone removed) {
        if (removed == this.heading) {
            this.heading = null;
        } else if (removed == this.body) {
            this.body = null;
        }
    }

    @Override
    public int getLevel() {
        return (Integer)this.getAttributeNativeData("level");
    }

    @Override
    public int setLevel(int level) throws IllegalArgumentException {
        return this.setLevelAttr(level);
    }

    private Integer setLevelAttr(int level) {
        return this.setAttributeDirect(Attributes.LEVEL, "level", level);
    }

    @Override
    public Wom3Heading getHeading() {
        return this.heading;
    }

    @Override
    public Wom3Heading setHeading(Wom3Heading heading) {
        return (Wom3Heading)this.replaceOrInsertBeforeOrAppend(this.heading, this.body, heading, true);
    }

    @Override
    public Wom3Body getBody() {
        return this.body;
    }

    @Override
    public Wom3Body setBody(Wom3Body body) throws NullPointerException {
        return (Wom3Body)this.replaceOrAppend(this.body, body, true);
    }

    @Override
    protected AttributeDescriptor getAttributeDescriptor(String namespaceUri, String localName, String qualifiedName) {
        return SectionImpl.getAttrDescStrict(namespaceUri, localName, qualifiedName, "level", Attributes.LEVEL);
    }

    public static enum Attributes implements AttributeDescriptor
    {
        LEVEL{

            @Override
            public boolean verifyAndConvert(Backbone parent, NativeAndStringValuePair verified) {
                if (verified.strValue == null) {
                    verified.strValue = String.valueOf(verified.value);
                }
                verified.value = AttributeVerifiers.verifyRange(verified.strValue, 1, 6);
                return true;
            }
        };


        @Override
        public boolean isRemovable() {
            return false;
        }

        @Override
        public AttributeDescriptor.Normalization getNormalizationMode() {
            return AttributeDescriptor.Normalization.NONE;
        }

        @Override
        public void customAction(Wom3Node parent, AttributeBase oldAttr, AttributeBase newAttr) {
        }
    }
}

