/*
 * Decompiled with CFR 0.152.
 */
package org.sweble.wom3.impl;

import java.io.Serializable;
import java.util.AbstractSequentialList;
import java.util.Deque;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.sweble.wom3.impl.Backbone;
import org.sweble.wom3.impl.BackboneWithChildren;
import org.sweble.wom3.impl.SiblingCollectionBounds;

public class SiblingRangeCollection<U extends BackboneWithChildren, T extends Backbone>
extends AbstractSequentialList<T>
implements Serializable,
Deque<T> {
    private static final long serialVersionUID = 1L;
    private T first;
    private T last;
    private final U container;
    private final SiblingCollectionBounds bounds;

    public SiblingRangeCollection(U container, SiblingCollectionBounds bounds) {
        this.container = container;
        this.bounds = bounds;
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        return new ListIter(index);
    }

    @Override
    public int size() {
        int count = 0;
        T i = this.first;
        while (i != null) {
            ++count;
            i = this.advance(i);
        }
        return count;
    }

    @Override
    public boolean add(T e) {
        this.addLast(e);
        return true;
    }

    @Override
    public T peek() {
        return (T)this.peekFirst();
    }

    @Override
    public T peekFirst() {
        return this.first;
    }

    @Override
    public T peekLast() {
        return this.last;
    }

    @Override
    public T getFirst() {
        if (this.first == null) {
            throw new NoSuchElementException();
        }
        return this.first;
    }

    @Override
    public T getLast() {
        if (this.last == null) {
            throw new NoSuchElementException();
        }
        return this.last;
    }

    @Override
    public T element() {
        return (T)this.getFirst();
    }

    @Override
    public void addFirst(T e) {
        Object n = this.first;
        if (n == null) {
            n = this.bounds.getSucc();
        }
        Backbone p = this.bounds.getPred();
        this.checkBeforeAdd(p, e);
        ((Backbone)e).link((Backbone)this.container, p, (Backbone)n);
        if (this.last == null) {
            this.last = e;
        }
        this.first = e;
        ((BackboneWithChildren)this.container).childInserted(p, (Backbone)e);
    }

    @Override
    public void addLast(T e) {
        Object p = this.last;
        if (p == null) {
            p = this.bounds.getPred();
        }
        this.checkBeforeAdd((Backbone)p, e);
        ((Backbone)e).link((Backbone)this.container, (Backbone)p, this.bounds.getSucc());
        if (this.first == null) {
            this.first = e;
        }
        this.last = e;
        ((BackboneWithChildren)this.container).childInserted((Backbone)p, (Backbone)e);
    }

    @Override
    public boolean offer(T e) {
        return this.add(e);
    }

    @Override
    public boolean offerFirst(T e) {
        this.addFirst(e);
        return true;
    }

    @Override
    public boolean offerLast(T e) {
        this.addLast(e);
        return true;
    }

    @Override
    public T removeFirst() {
        this.checkBeforeRemove(this.first);
        Backbone prev = ((Backbone)this.first).getPreviousSibling();
        T n = this.advance(this.first);
        T removed = this.first;
        ((Backbone)removed).unlink();
        this.first = n;
        if (n == null) {
            this.last = null;
        }
        ((BackboneWithChildren)this.container).childRemoved(prev, (Backbone)removed);
        return removed;
    }

    @Override
    public T removeLast() {
        this.checkBeforeRemove(this.last);
        Backbone prev = ((Backbone)this.last).getPreviousSibling();
        T p = this.retreat(this.last);
        T removed = this.last;
        ((Backbone)removed).unlink();
        this.last = p;
        if (p == null) {
            this.first = null;
        }
        ((BackboneWithChildren)this.container).childRemoved(prev, (Backbone)removed);
        return removed;
    }

    @Override
    public T poll() {
        return (T)this.pollFirst();
    }

    @Override
    public T pollFirst() {
        if (this.first != null) {
            return (T)this.removeFirst();
        }
        return null;
    }

    @Override
    public T pollLast() {
        if (this.last != null) {
            return (T)this.removeLast();
        }
        return null;
    }

    @Override
    public void push(T e) {
        this.addFirst(e);
    }

    @Override
    public T pop() {
        return (T)this.removeFirst();
    }

    @Override
    public T remove() {
        return (T)this.removeFirst();
    }

    @Override
    public boolean removeFirstOccurrence(Object o) {
        return this.remove(o);
    }

    @Override
    public boolean removeLastOccurrence(Object o) {
        if (o == null) {
            throw new NullPointerException();
        }
        Iterator<T> i = this.descendingIterator();
        while (i.hasNext()) {
            if (!o.equals(i.next())) continue;
            i.remove();
            return true;
        }
        return false;
    }

    @Override
    public Iterator<T> descendingIterator() {
        return new DescIter();
    }

    private void checkBeforeAdd(Backbone p, T e) {
        if (e == null) {
            throw new IllegalArgumentException("Argument `e' is null.");
        }
        if (((Backbone)e).isLinked()) {
            throw new IllegalStateException("Given node `e' is still child of another WOM node.");
        }
        ((BackboneWithChildren)this.container).allowsInsertion(p, (Backbone)e);
    }

    private void checkBeforeRemove(T e) {
        if (e == null) {
            throw new NoSuchElementException();
        }
        ((BackboneWithChildren)this.container).allowsRemoval((Backbone)e);
    }

    private T retreat(T i) {
        Backbone p = ((Backbone)i).getPreviousSibling();
        if (p == this.bounds.getPred()) {
            p = null;
        }
        return (T)p;
    }

    private T advance(T i) {
        Backbone n = ((Backbone)i).getNextSibling();
        if (n == this.bounds.getSucc()) {
            n = null;
        }
        return (T)n;
    }

    private class DescIter
    implements Iterator<T> {
        private final ListIter i;

        private DescIter() {
            this.i = new ListIter(SiblingRangeCollection.this.size());
        }

        @Override
        public boolean hasNext() {
            return this.i.hasPrevious();
        }

        @Override
        public T next() {
            return this.i.previous();
        }

        @Override
        public void remove() {
            this.i.remove();
        }
    }

    private final class ListIter
    implements ListIterator<T> {
        private T lastReturned = null;
        private T next;
        private int nextIndex;

        public ListIter(int index) {
            if (index < 0) {
                throw new IndexOutOfBoundsException();
            }
            Backbone i = SiblingRangeCollection.this.first;
            for (int count = 0; count != index; ++count) {
                if (i == null) {
                    throw new IndexOutOfBoundsException();
                }
                i = SiblingRangeCollection.this.advance(i);
            }
            this.next = i;
            this.nextIndex = index;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.lastReturned = this.next;
            this.next = SiblingRangeCollection.this.advance(this.next);
            ++this.nextIndex;
            return this.lastReturned;
        }

        @Override
        public boolean hasPrevious() {
            return this.nextIndex > 0;
        }

        @Override
        public T previous() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            this.lastReturned = SiblingRangeCollection.this.last;
            if (this.next != null) {
                this.lastReturned = SiblingRangeCollection.this.retreat(this.next);
            }
            this.next = this.lastReturned;
            --this.nextIndex;
            return this.lastReturned;
        }

        @Override
        public int nextIndex() {
            return this.nextIndex;
        }

        @Override
        public int previousIndex() {
            return this.nextIndex - 1;
        }

        @Override
        public void remove() {
            Object removed = this.lastReturned;
            if (removed == null) {
                throw new IllegalStateException();
            }
            SiblingRangeCollection.this.container.allowsRemoval((Backbone)removed);
            Backbone realPrev = ((Backbone)removed).getPreviousSibling();
            Backbone lastPrev = SiblingRangeCollection.this.retreat(removed);
            Backbone lastNext = SiblingRangeCollection.this.advance(removed);
            ((Backbone)removed).unlink();
            if (removed == SiblingRangeCollection.this.first) {
                SiblingRangeCollection.this.first = lastNext;
                if (SiblingRangeCollection.this.first == null) {
                    SiblingRangeCollection.this.last = null;
                }
            } else if (removed == SiblingRangeCollection.this.last) {
                SiblingRangeCollection.this.last = lastPrev;
            }
            if (this.next == removed) {
                this.next = lastNext;
            } else {
                --this.nextIndex;
            }
            this.lastReturned = null;
            SiblingRangeCollection.this.container.childRemoved(realPrev, (Backbone)removed);
        }

        @Override
        public void set(T e) {
            Object replaced = this.lastReturned;
            if (replaced == null) {
                throw new IllegalStateException();
            }
            if (((Backbone)e).isLinked()) {
                throw new IllegalStateException("Given node `e' is still child of another WOM node.");
            }
            SiblingRangeCollection.this.container.allowsRemoval((Backbone)replaced);
            Backbone lastPrev = ((Backbone)replaced).getPreviousSibling();
            Backbone lastNext = ((Backbone)replaced).getNextSibling();
            SiblingRangeCollection.this.container.allowsReplacement((Backbone)replaced, (Backbone)e);
            ((Backbone)replaced).unlink();
            ((Backbone)e).link(SiblingRangeCollection.this.container, lastPrev, lastNext);
            if (SiblingRangeCollection.this.first == replaced) {
                SiblingRangeCollection.this.first = e;
            }
            if (SiblingRangeCollection.this.last == replaced) {
                SiblingRangeCollection.this.last = e;
            }
            if (this.next == replaced) {
                this.next = e;
            }
            this.lastReturned = e;
            SiblingRangeCollection.this.container.childRemoved(lastPrev, (Backbone)replaced);
            SiblingRangeCollection.this.container.childInserted(lastPrev, (Backbone)e);
        }

        @Override
        public void add(T e) {
            this.lastReturned = null;
            if (this.next == null) {
                SiblingRangeCollection.this.addLast(e);
            } else {
                boolean becomesFirst;
                if (e == null) {
                    throw new IllegalArgumentException("Argument `e' is null.");
                }
                if (((Backbone)e).isLinked()) {
                    throw new IllegalStateException("Given node `e' is still child of another WOM node.");
                }
                Backbone p = SiblingRangeCollection.this.retreat(this.next);
                boolean bl = becomesFirst = p == null;
                if (becomesFirst) {
                    p = SiblingRangeCollection.this.bounds.getPred();
                }
                SiblingRangeCollection.this.container.allowsInsertion(p, (Backbone)e);
                if (becomesFirst) {
                    SiblingRangeCollection.this.first = e;
                }
                ((Backbone)e).link(SiblingRangeCollection.this.container, p, (Backbone)this.next);
                SiblingRangeCollection.this.container.childInserted(p, (Backbone)e);
            }
            ++this.nextIndex;
        }
    }
}

