/*
 * Decompiled with CFR 0.152.
 */
package org.sweble.wom3.impl;

import org.joda.time.DateTime;
import org.sweble.wom3.Wom3Node;
import org.sweble.wom3.Wom3Rtd;
import org.sweble.wom3.Wom3Signature;
import org.sweble.wom3.Wom3SignatureFormat;
import org.sweble.wom3.impl.AttributeBase;
import org.sweble.wom3.impl.AttributeDescriptor;
import org.sweble.wom3.impl.Backbone;
import org.sweble.wom3.impl.BackboneContainer;
import org.sweble.wom3.impl.DocumentImpl;
import org.sweble.wom3.impl.NativeAndStringValuePair;
import org.sweble.wom3.impl.Toolbox;

public class SignatureImpl
extends BackboneContainer
implements Wom3Signature {
    private static final long serialVersionUID = 1L;

    public SignatureImpl(DocumentImpl owner) {
        super(owner);
        this.setSignatureFormat(Wom3SignatureFormat.USER);
        this.setAuthor("noname");
        this.setTimestamp(DateTime.now());
    }

    @Override
    public String getWomName() {
        return "signature";
    }

    @Override
    public Wom3SignatureFormat getSignatureFormat() {
        return (Wom3SignatureFormat)((Object)this.getAttributeNativeData("format"));
    }

    @Override
    public Wom3SignatureFormat setSignatureFormat(Wom3SignatureFormat format) throws NullPointerException {
        return this.setAttributeDirect(Attributes.FORMAT, "format", format);
    }

    @Override
    public String getAuthor() {
        return this.getAttribute("author");
    }

    @Override
    public String setAuthor(String author) throws IllegalArgumentException, NullPointerException {
        return this.setAttributeDirect(Attributes.AUTHOR, "author", author);
    }

    @Override
    public DateTime getTimestamp() {
        return (DateTime)this.getAttributeNativeData("timestamp");
    }

    @Override
    public DateTime setTimestamp(DateTime timestamp) throws NullPointerException {
        return this.setAttributeDirect(Attributes.TIMESTAMP, "timestamp", timestamp);
    }

    @Override
    protected void allowsInsertion(Backbone prev, Backbone child) {
        if (this.getOwnerDocument().getStrictErrorChecking() && !(child instanceof Wom3Rtd)) {
            this.doesNotAllowInsertion(prev, child);
        }
    }

    @Override
    protected void allowsRemoval(Backbone child) {
    }

    @Override
    protected void allowsReplacement(Backbone oldChild, Backbone newChild) {
        if (this.getOwnerDocument().getStrictErrorChecking() && !(newChild instanceof Wom3Rtd)) {
            this.doesNotAllowReplacement(oldChild, newChild);
        }
    }

    @Override
    protected AttributeDescriptor getAttributeDescriptor(String namespaceUri, String localName, String qualifiedName) {
        return SignatureImpl.getAttrDescStrict(namespaceUri, localName, qualifiedName, "format", Attributes.FORMAT, "author", Attributes.AUTHOR, "timestamp", Attributes.TIMESTAMP);
    }

    public static enum Attributes implements AttributeDescriptor
    {
        FORMAT{

            @Override
            public boolean verifyAndConvert(Backbone parent, NativeAndStringValuePair verified) {
                if (verified.strValue != null) {
                    verified.value = Toolbox.stringToSignatureFormat(verified.strValue);
                } else {
                    verified.strValue = Toolbox.signatureFormatToString((Wom3SignatureFormat)((Object)verified.value));
                }
                return true;
            }
        }
        ,
        AUTHOR{

            @Override
            public boolean verifyAndConvert(Backbone parent, NativeAndStringValuePair verified) {
                return true;
            }
        }
        ,
        TIMESTAMP{

            @Override
            public boolean verifyAndConvert(Backbone parent, NativeAndStringValuePair verified) {
                if (verified.strValue != null) {
                    verified.value = Toolbox.stringToDateTime(verified.strValue);
                } else {
                    verified.strValue = Toolbox.dateTimeToString((DateTime)verified.value);
                }
                return true;
            }
        };


        @Override
        public boolean isRemovable() {
            return false;
        }

        @Override
        public AttributeDescriptor.Normalization getNormalizationMode() {
            return AttributeDescriptor.Normalization.CDATA;
        }

        @Override
        public void customAction(Wom3Node parent, AttributeBase oldAttr, AttributeBase newAttr) {
        }
    }
}

