/*
 * Decompiled with CFR 0.152.
 */
package org.sweble.wom3.impl;

import java.util.HashMap;
import java.util.Map;
import org.sweble.wom3.Wom3Color;
import org.sweble.wom3.Wom3HorizAlign;
import org.sweble.wom3.Wom3Node;
import org.sweble.wom3.Wom3TableCellBase;
import org.sweble.wom3.Wom3TableCellScope;
import org.sweble.wom3.Wom3TableVAlign;
import org.sweble.wom3.Wom3ValueWithUnit;
import org.sweble.wom3.impl.AttributeBase;
import org.sweble.wom3.impl.AttributeDescriptor;
import org.sweble.wom3.impl.AttributeVerifiers;
import org.sweble.wom3.impl.Backbone;
import org.sweble.wom3.impl.BackboneWomElemWithCoreAttrs;
import org.sweble.wom3.impl.DocumentImpl;
import org.sweble.wom3.impl.NativeAndStringValuePair;
import org.sweble.wom3.impl.TablePartitionImpl;
import org.sweble.wom3.impl.TableRowImpl;
import org.sweble.wom3.impl.UniversalAttributes;

public abstract class TableCellBaseImpl
extends BackboneWomElemWithCoreAttrs
implements Wom3TableCellBase {
    private static final long serialVersionUID = 1L;
    private int rowIndex;
    private int colIndex;
    private static final Map<String, AttributeDescriptor> nameMap = TableCellBaseImpl.getNameMap();

    public TableCellBaseImpl(DocumentImpl owner) {
        super(owner);
    }

    @Override
    public String getAbbr() {
        return this.getStringAttr("abbr");
    }

    @Override
    public String setAbbr(String abbr) {
        return this.setStringAttr(Attributes.ABBR, "abbr", abbr);
    }

    @Override
    public String getAxis() {
        return this.getStringAttr("axis");
    }

    @Override
    public String setAxis(String axis) {
        return this.setStringAttr(Attributes.AXIS, "axis", axis);
    }

    @Override
    public Wom3TableCellScope getScope() {
        return (Wom3TableCellScope)((Object)this.getAttributeNativeData("scope"));
    }

    @Override
    public Wom3TableCellScope setScope(Wom3TableCellScope scope) {
        return this.setAttributeDirect(Attributes.SCOPE, "scope", scope);
    }

    @Override
    public Wom3HorizAlign getAlign() {
        return this.getAlignAttr("align");
    }

    @Override
    public Wom3HorizAlign setAlign(Wom3HorizAlign align) {
        return this.setAlignAttr(Attributes.ALIGN, "align", align);
    }

    @Override
    public Wom3TableVAlign getVAlign() {
        return this.getTableVAlignAttr("valign");
    }

    @Override
    public Wom3TableVAlign setVAlign(Wom3TableVAlign valign) {
        return this.setTableVAlignAttr(Attributes.VALIGN, "valign", valign);
    }

    @Override
    public Wom3Color getBgColor() {
        return this.getColorAttr("bgcolor");
    }

    @Override
    public Wom3Color setBgColor(Wom3Color color) {
        return this.setColorAttr(Attributes.BGCOLOR, "bgcolor", color);
    }

    @Override
    public Integer getColspan() {
        return this.getIntAttr("colspan");
    }

    @Override
    public Integer setColspan(Integer span) throws IllegalArgumentException {
        return this.setIntAttr(Attributes.COLSPAN, "colspan", span);
    }

    @Override
    public Integer getRowspan() {
        return this.getIntAttr("rowspan");
    }

    @Override
    public Integer setRowspan(Integer span) throws IllegalArgumentException {
        return this.setIntAttr(Attributes.ROWSPAN, "rowspan", span);
    }

    @Override
    public boolean isNowrap() {
        return this.getBoolAttr("nowrap");
    }

    @Override
    public boolean setNowrap(boolean nowrap) {
        return this.setBoolAttr(Attributes.NOWRAP, "nowrap", nowrap);
    }

    @Override
    public Wom3ValueWithUnit getWidth() {
        return this.getValueWithUnitAttr("width");
    }

    @Override
    public Wom3ValueWithUnit setWidth(Wom3ValueWithUnit width) {
        return this.setValueWithUnitAttr(Attributes.WIDTH, "width", width);
    }

    @Override
    public Wom3ValueWithUnit getHeight() {
        return this.getValueWithUnitAttr("height");
    }

    @Override
    public Wom3ValueWithUnit setHeight(Wom3ValueWithUnit height) {
        return this.setValueWithUnitAttr(Attributes.HEIGHT, "height", height);
    }

    @Override
    public int getRowIndex() {
        this.checkAttachedToTable();
        return this.rowIndex;
    }

    @Override
    public int getColIndex() {
        this.checkAttachedToTable();
        return this.colIndex;
    }

    protected void checkAttachedToTable() {
        if (!this.isAttachedToTable()) {
            throw new IllegalStateException("Cell not part of a table");
        }
    }

    protected boolean isAttachedToTable() {
        return this.getParentNode() instanceof TableRowImpl && this.getRow().isAttachedToTable();
    }

    protected TableRowImpl getRow() {
        return (TableRowImpl)this.getParentNode();
    }

    protected TablePartitionImpl getTablePartition() {
        TableRowImpl row = this.getRow();
        if (row == null) {
            return null;
        }
        return row.getTablePartition();
    }

    protected void invalidate() {
        TablePartitionImpl p = this.getTablePartition();
        if (p != null) {
            p.invalidate();
        }
    }

    protected void setCoords(int rowIndex, int colIndex) {
        this.rowIndex = rowIndex;
        this.colIndex = colIndex;
    }

    private static Map<String, AttributeDescriptor> getNameMap() {
        HashMap<String, AttributeDescriptor> nameMap = new HashMap<String, AttributeDescriptor>();
        nameMap.putAll(UniversalAttributes.getNameMap());
        nameMap.put("abbr", Attributes.ABBR);
        nameMap.put("axis", Attributes.AXIS);
        nameMap.put("scope", Attributes.SCOPE);
        nameMap.put("align", Attributes.ALIGN);
        nameMap.put("valign", Attributes.VALIGN);
        nameMap.put("bgcolor", Attributes.BGCOLOR);
        nameMap.put("colspan", Attributes.COLSPAN);
        nameMap.put("rowspan", Attributes.ROWSPAN);
        nameMap.put("nowrap", Attributes.NOWRAP);
        nameMap.put("width", Attributes.WIDTH);
        nameMap.put("height", Attributes.HEIGHT);
        return nameMap;
    }

    @Override
    protected AttributeDescriptor getAttributeDescriptor(String namespaceUri, String localName, String qualifiedName) {
        return TableCellBaseImpl.getAttrDesc(namespaceUri, localName, qualifiedName, nameMap);
    }

    private static enum Attributes implements AttributeDescriptor
    {
        ABBR{

            @Override
            public boolean verifyAndConvert(Backbone parent, NativeAndStringValuePair verified) {
                return true;
            }
        }
        ,
        AXIS{

            @Override
            public boolean verifyAndConvert(Backbone parent, NativeAndStringValuePair verified) {
                return true;
            }
        }
        ,
        SCOPE{

            @Override
            public boolean verifyAndConvert(Backbone parent, NativeAndStringValuePair verified) {
                return AttributeVerifiers.SCOPE.verifyAndConvert(parent, verified);
            }
        }
        ,
        ALIGN{

            @Override
            public boolean verifyAndConvert(Backbone parent, NativeAndStringValuePair verified) {
                return AttributeVerifiers.LCRJC_ALIGN.verifyAndConvert(parent, verified);
            }
        }
        ,
        VALIGN{

            @Override
            public boolean verifyAndConvert(Backbone parent, NativeAndStringValuePair verified) {
                return AttributeVerifiers.TMBB_VALIGN.verifyAndConvert(parent, verified);
            }
        }
        ,
        BGCOLOR{

            @Override
            public boolean verifyAndConvert(Backbone parent, NativeAndStringValuePair verified) {
                return AttributeVerifiers.COLOR.verifyAndConvert(parent, verified);
            }
        }
        ,
        COLSPAN{

            @Override
            public boolean verifyAndConvert(Backbone parent, NativeAndStringValuePair verified) {
                AttributeVerifiers.NUMBER.verifyAndConvert(parent, verified);
                if ((Integer)verified.value <= 0) {
                    throw new IllegalArgumentException("Illegal colspan: " + verified.strValue);
                }
                return true;
            }

            @Override
            public void customAction(Wom3Node parent, AttributeBase oldAttr, AttributeBase newAttr) {
                ((TableCellBaseImpl)parent).invalidate();
            }
        }
        ,
        ROWSPAN{

            @Override
            public boolean verifyAndConvert(Backbone parent, NativeAndStringValuePair verified) {
                AttributeVerifiers.NUMBER.verifyAndConvert(parent, verified);
                if ((Integer)verified.value <= 0) {
                    throw new IllegalArgumentException("Illegal rowspan: " + verified.strValue);
                }
                return true;
            }

            @Override
            public void customAction(Wom3Node parent, AttributeBase oldAttr, AttributeBase newAttr) {
                ((TableCellBaseImpl)parent).invalidate();
            }
        }
        ,
        NOWRAP{

            @Override
            public boolean verifyAndConvert(Backbone parent, NativeAndStringValuePair verified) {
                return AttributeVerifiers.verifyAndConvertBool(parent, verified, "nowrap");
            }
        }
        ,
        WIDTH{

            @Override
            public boolean verifyAndConvert(Backbone parent, NativeAndStringValuePair verified) {
                return AttributeVerifiers.LENGTH.verifyAndConvert(parent, verified);
            }
        }
        ,
        HEIGHT{

            @Override
            public boolean verifyAndConvert(Backbone parent, NativeAndStringValuePair verified) {
                return AttributeVerifiers.LENGTH.verifyAndConvert(parent, verified);
            }
        };


        @Override
        public boolean isRemovable() {
            return true;
        }

        @Override
        public AttributeDescriptor.Normalization getNormalizationMode() {
            return AttributeDescriptor.Normalization.NON_CDATA;
        }

        @Override
        public void customAction(Wom3Node parent, AttributeBase oldAttr, AttributeBase newAttr) {
        }
    }
}

