/*
 * Decompiled with CFR 0.152.
 */
package org.sweble.wom3.impl;

import java.util.ArrayList;
import org.sweble.wom3.Wom3TableCellBase;
import org.sweble.wom3.Wom3TableRow;
import org.sweble.wom3.impl.Backbone;
import org.sweble.wom3.impl.TableCellBaseImpl;
import org.sweble.wom3.impl.TablePartitionImpl;
import org.sweble.wom3.impl.TableRowImpl;

public class TableField {
    private final ArrayList<ArrayList<TableCellBaseImpl>> cells = new ArrayList();
    private ArrayList<TableRowImpl> rows = new ArrayList();
    private int colNum;

    public TableField(TablePartitionImpl part) {
        ArrayList<Integer> ars = new ArrayList<Integer>();
        ArrayList lastRow = null;
        int rowIndex = 0;
        Backbone womRowNode = part.getFirstChild();
        while (womRowNode != null) {
            if (!(womRowNode instanceof TableRowImpl)) {
                womRowNode = womRowNode.getNextSibling();
                continue;
            }
            TableRowImpl rowNode = (TableRowImpl)womRowNode;
            ArrayList row = new ArrayList();
            this.cells.add(row);
            this.rows.add(rowNode);
            int colIndex = 0;
            Backbone womCellNode = rowNode.getFirstChild();
            while (womCellNode != null) {
                Integer rowSpan;
                if (!(womCellNode instanceof TableCellBaseImpl)) {
                    womCellNode = womCellNode.getNextSibling();
                    continue;
                }
                TableCellBaseImpl cellNode = (TableCellBaseImpl)womCellNode;
                boolean hadRowSpan = false;
                if (colIndex < ars.size() && (rowSpan = (Integer)ars.get(colIndex)) != null && rowSpan > 0) {
                    ars.set(colIndex, rowSpan - 1);
                    row.add(lastRow.get(colIndex));
                    hadRowSpan = true;
                }
                if (!hadRowSpan) {
                    Integer colSpan;
                    cellNode.setCoords(rowIndex, colIndex);
                    rowSpan = cellNode.getRowspan();
                    if (rowSpan == null) {
                        rowSpan = 1;
                    }
                    if ((colSpan = cellNode.getColspan()) == null) {
                        colSpan = 1;
                    }
                    for (int cs = 0; cs < colSpan; ++cs) {
                        row.add(cellNode);
                        if (rowSpan > 1) {
                            while (ars.size() <= colIndex) {
                                ars.add(null);
                            }
                            ars.set(colIndex, rowSpan - 1);
                        }
                        ++colIndex;
                    }
                    womCellNode = cellNode.getNextSibling();
                    continue;
                }
                ++colIndex;
            }
            this.colNum = Math.max(this.colNum, colIndex);
            rowNode.setCoords(rowIndex);
            lastRow = row;
            ++rowIndex;
            womRowNode = rowNode.getNextSibling();
        }
    }

    public int getNumCols() {
        return this.colNum;
    }

    public int getNumRows() {
        return this.rows.size();
    }

    public Wom3TableRow getRow(int row) {
        if (row >= this.getNumRows()) {
            throw new IndexOutOfBoundsException("Row: " + String.valueOf(row));
        }
        return this.rows.get(row);
    }

    public Wom3TableCellBase getCell(int row, int col) {
        if (row >= this.getNumRows()) {
            throw new IndexOutOfBoundsException("Row: " + String.valueOf(row));
        }
        if (col >= this.getNumCols()) {
            throw new IndexOutOfBoundsException("Col: " + String.valueOf(col));
        }
        ArrayList<TableCellBaseImpl> r = this.cells.get(row);
        if (col >= r.size()) {
            return null;
        }
        return r.get(col);
    }
}

