/*
 * Decompiled with CFR 0.152.
 */
package org.sweble.wom3.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.sweble.wom3.Wom3Color;
import org.sweble.wom3.Wom3HorizAlign;
import org.sweble.wom3.Wom3Node;
import org.sweble.wom3.Wom3Table;
import org.sweble.wom3.Wom3TableBody;
import org.sweble.wom3.Wom3TableCaption;
import org.sweble.wom3.Wom3TableFrame;
import org.sweble.wom3.Wom3TablePartition;
import org.sweble.wom3.Wom3TableRules;
import org.sweble.wom3.Wom3ValueWithUnit;
import org.sweble.wom3.impl.AttributeBase;
import org.sweble.wom3.impl.AttributeDescriptor;
import org.sweble.wom3.impl.AttributeVerifiers;
import org.sweble.wom3.impl.Backbone;
import org.sweble.wom3.impl.BackboneChildOperationChecker;
import org.sweble.wom3.impl.BackboneWomElemWithCoreAttrs;
import org.sweble.wom3.impl.ChildrenSubset;
import org.sweble.wom3.impl.DocumentImpl;
import org.sweble.wom3.impl.NativeAndStringValuePair;
import org.sweble.wom3.impl.UniversalAttributes;

public class TableImpl
extends BackboneWomElemWithCoreAttrs
implements Wom3Table {
    private static final long serialVersionUID = 1L;
    private Wom3TableCaption caption;
    private ChildrenSubset<Wom3TablePartition> partitions = new ChildrenSubset(1);
    private static final Map<String, AttributeDescriptor> nameMap = TableImpl.getNameMap();

    public TableImpl(DocumentImpl owner) {
        super(owner);
    }

    @Override
    public String getWomName() {
        return "table";
    }

    @Override
    protected void allowsInsertion(Backbone prev, Backbone child) {
        if (this.getOwnerDocument().getStrictErrorChecking()) {
            if (BackboneChildOperationChecker.isIgnoredDefault(child)) {
                return;
            }
            if (child instanceof Wom3TableCaption && this.getCaption() == null) {
                return;
            }
            if (child instanceof Wom3TableBody) {
                return;
            }
            this.doesNotAllowInsertion(prev, child);
        }
    }

    @Override
    protected void allowsRemoval(Backbone child) {
    }

    @Override
    protected void allowsReplacement(Backbone oldChild, Backbone newChild) {
        if (this.getOwnerDocument().getStrictErrorChecking()) {
            if (newChild instanceof Wom3TableBody) {
                return;
            }
            if (BackboneChildOperationChecker.isIgnoredDefault(newChild)) {
                return;
            }
            if (newChild instanceof Wom3TableCaption && (oldChild == this.getCaption() || this.getCaption() == null)) {
                return;
            }
            this.doesNotAllowReplacement(oldChild, newChild);
        }
    }

    @Override
    public void childInserted(Backbone prev, Backbone added) {
        if (added instanceof Wom3TableCaption) {
            this.caption = (Wom3TableCaption)((Object)added);
        } else if (added instanceof Wom3TableBody) {
            this.partitions.insertAfter(prev, Wom3TablePartition.class, (Wom3TableBody)((Object)added));
        }
    }

    @Override
    public void childRemoved(Backbone prev, Backbone removed) {
        if (removed == this.caption) {
            this.caption = null;
        } else {
            this.partitions.remove(removed);
        }
    }

    @Override
    public Wom3HorizAlign getAlign() {
        return this.getAlignAttr("align");
    }

    @Override
    public Wom3HorizAlign setAlign(Wom3HorizAlign align) {
        return this.setAlignAttr(Attributes.ALIGN, "align", align);
    }

    @Override
    public Integer getBorder() {
        return this.getIntAttr("border");
    }

    @Override
    public Integer setBorder(Integer thickness) {
        return this.setIntAttr(Attributes.BORDER, "border", thickness);
    }

    @Override
    public Wom3Color getBgColor() {
        return this.getColorAttr("bgcolor");
    }

    @Override
    public Wom3Color setBgColor(Wom3Color color) {
        return this.setColorAttr(Attributes.BGCOLOR, "bgcolor", color);
    }

    @Override
    public Wom3ValueWithUnit getCellPadding() {
        return this.getValueWithUnitAttr("cellpadding");
    }

    @Override
    public Wom3ValueWithUnit setCellPadding(Wom3ValueWithUnit padding) {
        return this.setValueWithUnitAttr(Attributes.CELLPADDING, "cellpadding", padding);
    }

    @Override
    public Wom3ValueWithUnit getCellSpacing() {
        return this.getValueWithUnitAttr("cellspacing");
    }

    @Override
    public Wom3ValueWithUnit setCellSpacing(Wom3ValueWithUnit spacing) {
        return this.setValueWithUnitAttr(Attributes.CELLSPACING, "cellspacing", spacing);
    }

    @Override
    public Wom3TableFrame getFrame() {
        return (Wom3TableFrame)((Object)this.getAttributeNativeData("frame"));
    }

    @Override
    public Wom3TableFrame setFrame(Wom3TableFrame frame) {
        return this.setAttributeDirect(Attributes.FRAME, "frame", frame);
    }

    @Override
    public Wom3TableRules getRules() {
        return (Wom3TableRules)((Object)this.getAttributeNativeData("rules"));
    }

    @Override
    public Wom3TableRules setRules(Wom3TableRules rules) {
        return this.setAttributeDirect(Attributes.RULES, "rules", rules);
    }

    @Override
    public String getSummary() {
        return this.getStringAttr("summary");
    }

    @Override
    public String setSummary(String summary) {
        return this.setStringAttr(Attributes.SUMMARY, "summary", summary);
    }

    @Override
    public Wom3ValueWithUnit getWidth() {
        return this.getValueWithUnitAttr("width");
    }

    @Override
    public Wom3ValueWithUnit setWidth(Wom3ValueWithUnit width) {
        return this.setValueWithUnitAttr(Attributes.WIDTH, "width", width);
    }

    @Override
    public Wom3TableCaption getCaption() {
        return this.caption;
    }

    @Override
    public Wom3TableCaption setCaption(Wom3TableCaption caption) {
        return (Wom3TableCaption)this.replaceOrInsertBeforeOrAppend(this.caption, this.partitions.getFirstOrNull(), caption, false);
    }

    @Override
    public Collection<Wom3TablePartition> getPartitions() {
        return Collections.unmodifiableCollection(this.partitions);
    }

    public static Map<String, AttributeDescriptor> getNameMap() {
        HashMap<String, AttributeDescriptor> nameMap = new HashMap<String, AttributeDescriptor>();
        nameMap.putAll(UniversalAttributes.getNameMap());
        nameMap.put("align", Attributes.ALIGN);
        nameMap.put("border", Attributes.BORDER);
        nameMap.put("bgcolor", Attributes.BGCOLOR);
        nameMap.put("cellpadding", Attributes.CELLPADDING);
        nameMap.put("cellspacing", Attributes.CELLSPACING);
        nameMap.put("frame", Attributes.FRAME);
        nameMap.put("rules", Attributes.RULES);
        nameMap.put("summary", Attributes.SUMMARY);
        nameMap.put("width", Attributes.WIDTH);
        return nameMap;
    }

    @Override
    protected AttributeDescriptor getAttributeDescriptor(String namespaceUri, String localName, String qualifiedName) {
        return TableImpl.getAttrDesc(namespaceUri, localName, qualifiedName, nameMap);
    }

    public static enum Attributes implements AttributeDescriptor
    {
        ALIGN{

            @Override
            public boolean verifyAndConvert(Backbone parent, NativeAndStringValuePair verified) {
                return AttributeVerifiers.LCR_ALIGN.verifyAndConvert(parent, verified);
            }
        }
        ,
        BORDER{

            @Override
            public boolean verifyAndConvert(Backbone parent, NativeAndStringValuePair verified) {
                return AttributeVerifiers.PIXELS.verifyAndConvert(parent, verified);
            }
        }
        ,
        BGCOLOR{

            @Override
            public boolean verifyAndConvert(Backbone parent, NativeAndStringValuePair verified) {
                return AttributeVerifiers.COLOR.verifyAndConvert(parent, verified);
            }
        }
        ,
        CELLPADDING{

            @Override
            public boolean verifyAndConvert(Backbone parent, NativeAndStringValuePair verified) {
                return AttributeVerifiers.LENGTH.verifyAndConvert(parent, verified);
            }
        }
        ,
        CELLSPACING{

            @Override
            public boolean verifyAndConvert(Backbone parent, NativeAndStringValuePair verified) {
                return AttributeVerifiers.LENGTH.verifyAndConvert(parent, verified);
            }
        }
        ,
        FRAME{

            @Override
            public boolean verifyAndConvert(Backbone parent, NativeAndStringValuePair verified) {
                return AttributeVerifiers.FRAME.verifyAndConvert(parent, verified);
            }
        }
        ,
        RULES{

            @Override
            public boolean verifyAndConvert(Backbone parent, NativeAndStringValuePair verified) {
                return AttributeVerifiers.RULES.verifyAndConvert(parent, verified);
            }
        }
        ,
        SUMMARY{

            @Override
            public boolean verifyAndConvert(Backbone parent, NativeAndStringValuePair verified) {
                return true;
            }
        }
        ,
        WIDTH{

            @Override
            public boolean verifyAndConvert(Backbone parent, NativeAndStringValuePair verified) {
                return AttributeVerifiers.LENGTH.verifyAndConvert(parent, verified);
            }
        };


        @Override
        public boolean isRemovable() {
            return true;
        }

        @Override
        public AttributeDescriptor.Normalization getNormalizationMode() {
            return AttributeDescriptor.Normalization.CDATA;
        }

        @Override
        public void customAction(Wom3Node parent, AttributeBase oldAttr, AttributeBase newAttr) {
        }
    }
}

