/*
 * Decompiled with CFR 0.152.
 */
package org.sweble.wom3.impl;

import java.util.HashMap;
import java.util.Map;
import org.sweble.wom3.Wom3Color;
import org.sweble.wom3.Wom3HorizAlign;
import org.sweble.wom3.Wom3Node;
import org.sweble.wom3.Wom3TableCellBase;
import org.sweble.wom3.Wom3TableRow;
import org.sweble.wom3.Wom3TableVAlign;
import org.sweble.wom3.impl.AttributeBase;
import org.sweble.wom3.impl.AttributeDescriptor;
import org.sweble.wom3.impl.AttributeVerifiers;
import org.sweble.wom3.impl.Backbone;
import org.sweble.wom3.impl.BackboneWomElemWithCoreAttrs;
import org.sweble.wom3.impl.DocumentImpl;
import org.sweble.wom3.impl.NativeAndStringValuePair;
import org.sweble.wom3.impl.TableField;
import org.sweble.wom3.impl.TablePartitionImpl;
import org.sweble.wom3.impl.UniversalAttributes;

public class TableRowImpl
extends BackboneWomElemWithCoreAttrs
implements Wom3TableRow {
    private static final long serialVersionUID = 1L;
    private int rowIndex;
    private static final Map<String, AttributeDescriptor> nameMap = TableRowImpl.getNameMap();

    public TableRowImpl(DocumentImpl owner) {
        super(owner);
    }

    @Override
    public String getWomName() {
        return "tr";
    }

    @Override
    public Wom3HorizAlign getAlign() {
        return this.getAlignAttr("align");
    }

    @Override
    public Wom3HorizAlign setAlign(Wom3HorizAlign align) {
        return this.setAlignAttr(Attributes.ALIGN, "align", align);
    }

    @Override
    public Wom3TableVAlign getVAlign() {
        return this.getTableVAlignAttr("valign");
    }

    @Override
    public Wom3TableVAlign setVAlign(Wom3TableVAlign valign) {
        return this.setTableVAlignAttr(Attributes.VALIGN, "valign", valign);
    }

    @Override
    public Wom3Color getBgColor() {
        return this.getColorAttr("bgcolor");
    }

    @Override
    public Wom3Color setBgColor(Wom3Color color) {
        return this.setColorAttr(Attributes.BGCOLOR, "bgcolor", color);
    }

    @Override
    public int getRowIndex() {
        this.checkAttachedToTable();
        return this.rowIndex;
    }

    @Override
    public int getNumCols() {
        this.checkAttachedToTable();
        return this.tf().getNumCols();
    }

    @Override
    public Wom3TableCellBase getCell(int col) throws IndexOutOfBoundsException {
        this.checkAttachedToTable();
        return this.tf().getCell(this.rowIndex, col);
    }

    protected void checkAttachedToTable() {
        if (!this.isAttachedToTable()) {
            throw new IllegalStateException("Row not part of a table");
        }
    }

    protected boolean isAttachedToTable() {
        return this.getParentNode() instanceof TablePartitionImpl && this.getTablePartition().isAttachedToTable();
    }

    protected TableField tf() {
        return this.getTablePartition().tf();
    }

    protected TablePartitionImpl getTablePartition() {
        return (TablePartitionImpl)this.getParentNode();
    }

    protected void setCoords(int rowIndex) {
        this.rowIndex = rowIndex;
    }

    @Override
    public void childInserted(Backbone prev, Backbone added) {
        if (this.isAttachedToTable()) {
            this.getTablePartition().invalidate();
        }
    }

    @Override
    public void childRemoved(Backbone prev, Backbone removed) {
        if (this.isAttachedToTable()) {
            this.getTablePartition().invalidate();
        }
    }

    private static Map<String, AttributeDescriptor> getNameMap() {
        HashMap<String, AttributeDescriptor> nameMap = new HashMap<String, AttributeDescriptor>();
        nameMap.putAll(UniversalAttributes.getNameMap());
        nameMap.put("align", Attributes.ALIGN);
        nameMap.put("valign", Attributes.VALIGN);
        nameMap.put("bgcolor", Attributes.BGCOLOR);
        return nameMap;
    }

    @Override
    protected AttributeDescriptor getAttributeDescriptor(String namespaceUri, String localName, String qualifiedName) {
        return TableRowImpl.getAttrDesc(namespaceUri, localName, qualifiedName, nameMap);
    }

    private static enum Attributes implements AttributeDescriptor
    {
        ALIGN{

            @Override
            public boolean verifyAndConvert(Backbone parent, NativeAndStringValuePair verified) {
                return AttributeVerifiers.LCRJC_ALIGN.verifyAndConvert(parent, verified);
            }
        }
        ,
        VALIGN{

            @Override
            public boolean verifyAndConvert(Backbone parent, NativeAndStringValuePair verified) {
                return AttributeVerifiers.TMBB_VALIGN.verifyAndConvert(parent, verified);
            }
        }
        ,
        BGCOLOR{

            @Override
            public boolean verifyAndConvert(Backbone parent, NativeAndStringValuePair verified) {
                return AttributeVerifiers.COLOR.verifyAndConvert(parent, verified);
            }
        };


        @Override
        public boolean isRemovable() {
            return true;
        }

        @Override
        public AttributeDescriptor.Normalization getNormalizationMode() {
            return AttributeDescriptor.Normalization.NON_CDATA;
        }

        @Override
        public void customAction(Wom3Node parent, AttributeBase oldAttr, AttributeBase newAttr) {
        }
    }
}

