/*
 * Decompiled with CFR 0.152.
 */
package org.sweble.wom3.impl;

import java.io.Serializable;
import org.sweble.wom3.Wom3Unit;
import org.sweble.wom3.Wom3ValueWithUnit;

public class ValueWithUnitImpl
implements Wom3ValueWithUnit,
Serializable {
    private static final long serialVersionUID = 1L;
    private Wom3Unit unit;
    private float value;
    private int intValue;

    public ValueWithUnitImpl(Wom3Unit unit, float value) {
        this.unit = unit;
        this.value = value;
        this.intValue = (int)value;
    }

    public ValueWithUnitImpl(Wom3Unit unit, int value) {
        this.unit = unit;
        this.value = value;
        this.intValue = value;
    }

    @Override
    public Wom3Unit getUnit() {
        return this.unit;
    }

    @Override
    public float getValue() {
        return this.value;
    }

    @Override
    public int getIntValue() {
        return this.intValue;
    }

    public String toString() {
        switch (this.getUnit()) {
            case PERCENT: {
                return String.valueOf(this.getValue()) + "%";
            }
            case PIXELS: {
                return String.valueOf(this.getIntValue());
            }
        }
        throw new InternalError();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.intValue;
        result = 31 * result + (this.unit == null ? 0 : this.unit.hashCode());
        result = 31 * result + Float.floatToIntBits(this.value);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ValueWithUnitImpl other = (ValueWithUnitImpl)obj;
        if (this.intValue != other.intValue) {
            return false;
        }
        if (this.unit != other.unit) {
            return false;
        }
        return Float.floatToIntBits(this.value) == Float.floatToIntBits(other.value);
    }
}

