/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import java.util.List;
import javax.inject.Singleton;
import model.Database;
import model.PCMInfo;
import play.mvc.Controller;
import play.mvc.Result;
import play.twirl.api.Content;
import views.html.aboutPrivacyPolicy;
import views.html.aboutProject;
import views.html.edit;
import views.html.embed;
import views.html.index;
import views.html.list;
import views.html.search;

@Singleton
public class Application
extends Controller {
    public Result index() {
        return Application.ok((Content)index.render());
    }

    public Result aboutProject() {
        return Application.ok((Content)aboutProject.render());
    }

    public Result aboutPrivacyPolicy() {
        return Application.ok((Content)aboutPrivacyPolicy.render());
    }

    public Result list(int limit, int page) {
        List<PCMInfo> pcms = Database.INSTANCE.list(limit, page);
        int count = (int)Database.INSTANCE.count();
        int nbPages = count / limit;
        if (count % limit != 0) {
            ++nbPages;
        }
        return Application.ok((Content)list.render(pcms, limit, page, nbPages));
    }

    public Result search(String request) {
        List<PCMInfo> results = Database.INSTANCE.search(request);
        return Application.ok((Content)search.render(request, results));
    }

    public Result edit(String id) {
        boolean exists = Database.INSTANCE.exists(id);
        if (exists) {
            return Application.ok((Content)edit.render(id, null, null));
        }
        return Application.ok((Content)edit.render(null, null, null));
    }

    public Result create() {
        return Application.ok((Content)edit.render(null, null, null));
    }

    public Result importer(String ext) {
        if (ext.equals("csv")) {
            return Application.ok((Content)edit.render(null, null, "CsvImport"));
        }
        if (ext.equals("html")) {
            return Application.ok((Content)edit.render(null, null, "HtmlImport"));
        }
        if (ext.equals("wikipedia")) {
            return Application.ok((Content)edit.render(null, null, "WikipediaImport"));
        }
        return Application.notFound();
    }

    public Result embedPCM(String id) {
        boolean exists = Database.INSTANCE.exists(id);
        if (exists) {
            return Application.ok((Content)embed.render(id, null, null));
        }
        return Application.ok((Content)embed.render(null, null, null));
    }

    public Result embed() {
        return Application.ok((Content)embed.render(null, null, null));
    }
}

