/*
 * Decompiled with CFR 0.152.
 */
package org.sweble.wom3.swcadapter;

import de.fau.cs.osr.ptk.common.AstVisitor;
import de.fau.cs.osr.ptk.common.ast.AstNode;
import de.fau.cs.osr.utils.XmlGrammar;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Map;
import org.joda.time.DateTime;
import org.sweble.wikitext.engine.PageTitle;
import org.sweble.wikitext.engine.config.WikiConfig;
import org.sweble.wikitext.engine.nodes.CompleteEngineVisitor;
import org.sweble.wikitext.engine.nodes.EngNowiki;
import org.sweble.wikitext.engine.nodes.EngPage;
import org.sweble.wikitext.engine.nodes.EngProcessedPage;
import org.sweble.wikitext.engine.nodes.EngSoftErrorNode;
import org.sweble.wikitext.engine.nodes.EngineNodeFactory;
import org.sweble.wikitext.engine.utils.EngineAstTextUtils;
import org.sweble.wikitext.parser.WtRtData;
import org.sweble.wikitext.parser.nodes.WtBody;
import org.sweble.wikitext.parser.nodes.WtBold;
import org.sweble.wikitext.parser.nodes.WtContentNode;
import org.sweble.wikitext.parser.nodes.WtDefinitionList;
import org.sweble.wikitext.parser.nodes.WtDefinitionListDef;
import org.sweble.wikitext.parser.nodes.WtDefinitionListTerm;
import org.sweble.wikitext.parser.nodes.WtExternalLink;
import org.sweble.wikitext.parser.nodes.WtHeading;
import org.sweble.wikitext.parser.nodes.WtHorizontalRule;
import org.sweble.wikitext.parser.nodes.WtIgnored;
import org.sweble.wikitext.parser.nodes.WtIllegalCodePoint;
import org.sweble.wikitext.parser.nodes.WtImEndTag;
import org.sweble.wikitext.parser.nodes.WtImStartTag;
import org.sweble.wikitext.parser.nodes.WtImageLink;
import org.sweble.wikitext.parser.nodes.WtInternalLink;
import org.sweble.wikitext.parser.nodes.WtItalics;
import org.sweble.wikitext.parser.nodes.WtLinkOptionAltText;
import org.sweble.wikitext.parser.nodes.WtLinkOptionGarbage;
import org.sweble.wikitext.parser.nodes.WtLinkOptionKeyword;
import org.sweble.wikitext.parser.nodes.WtLinkOptionLinkTarget;
import org.sweble.wikitext.parser.nodes.WtLinkOptionResize;
import org.sweble.wikitext.parser.nodes.WtLinkOptions;
import org.sweble.wikitext.parser.nodes.WtLinkTarget;
import org.sweble.wikitext.parser.nodes.WtLinkTitle;
import org.sweble.wikitext.parser.nodes.WtListItem;
import org.sweble.wikitext.parser.nodes.WtName;
import org.sweble.wikitext.parser.nodes.WtNewline;
import org.sweble.wikitext.parser.nodes.WtNode;
import org.sweble.wikitext.parser.nodes.WtNodeList;
import org.sweble.wikitext.parser.nodes.WtOnlyInclude;
import org.sweble.wikitext.parser.nodes.WtOrderedList;
import org.sweble.wikitext.parser.nodes.WtPageName;
import org.sweble.wikitext.parser.nodes.WtPageSwitch;
import org.sweble.wikitext.parser.nodes.WtParagraph;
import org.sweble.wikitext.parser.nodes.WtParsedWikitextPage;
import org.sweble.wikitext.parser.nodes.WtPreproWikitextPage;
import org.sweble.wikitext.parser.nodes.WtRedirect;
import org.sweble.wikitext.parser.nodes.WtSection;
import org.sweble.wikitext.parser.nodes.WtSemiPre;
import org.sweble.wikitext.parser.nodes.WtSemiPreLine;
import org.sweble.wikitext.parser.nodes.WtSignature;
import org.sweble.wikitext.parser.nodes.WtTable;
import org.sweble.wikitext.parser.nodes.WtTableCaption;
import org.sweble.wikitext.parser.nodes.WtTableCell;
import org.sweble.wikitext.parser.nodes.WtTableHeader;
import org.sweble.wikitext.parser.nodes.WtTableImplicitTableBody;
import org.sweble.wikitext.parser.nodes.WtTableRow;
import org.sweble.wikitext.parser.nodes.WtTagExtension;
import org.sweble.wikitext.parser.nodes.WtTagExtensionBody;
import org.sweble.wikitext.parser.nodes.WtTemplate;
import org.sweble.wikitext.parser.nodes.WtTemplateArgument;
import org.sweble.wikitext.parser.nodes.WtTemplateArguments;
import org.sweble.wikitext.parser.nodes.WtTemplateParameter;
import org.sweble.wikitext.parser.nodes.WtText;
import org.sweble.wikitext.parser.nodes.WtTicks;
import org.sweble.wikitext.parser.nodes.WtUnorderedList;
import org.sweble.wikitext.parser.nodes.WtUrl;
import org.sweble.wikitext.parser.nodes.WtValue;
import org.sweble.wikitext.parser.nodes.WtWhitespace;
import org.sweble.wikitext.parser.nodes.WtXmlAttribute;
import org.sweble.wikitext.parser.nodes.WtXmlAttributeGarbage;
import org.sweble.wikitext.parser.nodes.WtXmlAttributes;
import org.sweble.wikitext.parser.nodes.WtXmlCharRef;
import org.sweble.wikitext.parser.nodes.WtXmlComment;
import org.sweble.wikitext.parser.nodes.WtXmlElement;
import org.sweble.wikitext.parser.nodes.WtXmlEmptyTag;
import org.sweble.wikitext.parser.nodes.WtXmlEndTag;
import org.sweble.wikitext.parser.nodes.WtXmlEntityRef;
import org.sweble.wikitext.parser.nodes.WtXmlStartTag;
import org.sweble.wikitext.parser.parser.LinkTargetException;
import org.sweble.wikitext.parser.postprocessor.WtNodeFlags;
import org.sweble.wikitext.parser.utils.StringConversionException;
import org.sweble.wikitext.parser.utils.WtRtDataPrinter;
import org.sweble.wom3.Wom3Article;
import org.sweble.wom3.Wom3Attribute;
import org.sweble.wom3.Wom3Comment;
import org.sweble.wom3.Wom3Document;
import org.sweble.wom3.Wom3Element;
import org.sweble.wom3.Wom3ElementNode;
import org.sweble.wom3.Wom3ExtLink;
import org.sweble.wom3.Wom3For;
import org.sweble.wom3.Wom3Image;
import org.sweble.wom3.Wom3ImageFormat;
import org.sweble.wom3.Wom3ImageHAlign;
import org.sweble.wom3.Wom3ImageVAlign;
import org.sweble.wom3.Wom3IntLink;
import org.sweble.wom3.Wom3Node;
import org.sweble.wom3.Wom3Nowiki;
import org.sweble.wom3.Wom3Paragraph;
import org.sweble.wom3.Wom3Redirect;
import org.sweble.wom3.Wom3Repl;
import org.sweble.wom3.Wom3Rtd;
import org.sweble.wom3.Wom3Section;
import org.sweble.wom3.Wom3Signature;
import org.sweble.wom3.Wom3SignatureFormat;
import org.sweble.wom3.Wom3Subst;
import org.sweble.wom3.Wom3Table;
import org.sweble.wom3.Wom3TableCaption;
import org.sweble.wom3.Wom3Text;
import org.sweble.wom3.Wom3Title;
import org.sweble.wom3.Wom3XmlText;
import org.sweble.wom3.impl.Backbone;
import org.sweble.wom3.impl.DocumentImpl;
import org.sweble.wom3.impl.DomImplementationImpl;
import org.sweble.wom3.impl.Toolbox;
import org.sweble.wom3.swcadapter.HtmlElement;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class AstToWomConverter
extends AstVisitor<WtNode>
implements CompleteEngineVisitor<Wom3Node> {
    public static final String MWW_NS_URI = "http://sweble.org/schema/mww30";
    public static final String DEFAULT_MWW_NS_PREFIX = "mww";
    private final WikiConfig wikiConfig;
    private final Map<String, HtmlElement> xhtmlElems;
    private final EngineAstTextUtils astTextUtils;
    private final EngineNodeFactory nodeFactory;
    private boolean preserveRtd = true;
    private boolean suppressRtd = false;
    private boolean addSubst = true;
    private LinkedList<Wom3ElementNode> stack = new LinkedList();
    private PageTitle pageTitle;
    private String author;
    private DateTime timestamp;
    private Document doc;
    private Wom3Article page;
    private int displacement = 0;
    private boolean inNoTextScope;

    public AstToWomConverter(WikiConfig config) {
        this.wikiConfig = config;
        this.xhtmlElems = new HashMap<String, HtmlElement>();
        for (HtmlElement e : HtmlElement.values()) {
            this.xhtmlElems.put(e.name().toLowerCase(), e);
        }
        this.astTextUtils = this.wikiConfig.getAstTextUtils();
        this.nodeFactory = this.wikiConfig.getNodeFactory();
    }

    public static Wom3Document convert(WikiConfig config, PageTitle pageTitle, String author, DateTime timestamp, WtNode ast) {
        DocumentImpl doc = DomImplementationImpl.get().createDocument("http://sweble.org/schema/wom30", "article", null);
        AstToWomConverter converter = new AstToWomConverter(config);
        converter.convert((Wom3Document)doc, pageTitle, author, timestamp, ast);
        return doc;
    }

    public Wom3Document convert(PageTitle pageTitle, String author, DateTime timestamp, WtNode ast) {
        DocumentImpl doc = DomImplementationImpl.get().createDocument("http://sweble.org/schema/wom30", "article", null);
        return this.convert((Wom3Document)doc, pageTitle, author, timestamp, ast);
    }

    public Wom3Document convert(Wom3Document doc, PageTitle pageTitle, String author, DateTime timestamp, WtNode ast) {
        this.doc = doc;
        this.pageTitle = pageTitle;
        this.author = author;
        this.timestamp = timestamp;
        this.go(ast);
        return doc;
    }

    public Object go(WtNode node) {
        if (this.doc == null) {
            throw new UnsupportedOperationException("You must not call go() directly!");
        }
        return super.go((Object)node);
    }

    protected Object after(WtNode node, Object result) {
        Wom3ElementNode root = (Wom3ElementNode)result;
        root.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:mww", MWW_NS_URI);
        this.doc.replaceChild((Node)root, this.doc.getDocumentElement());
        return this.doc;
    }

    public WikiConfig getWikiConfig() {
        return this.wikiConfig;
    }

    public boolean setPreserveRtd(boolean preserveRtd) {
        boolean old = this.preserveRtd;
        this.preserveRtd = preserveRtd;
        return old;
    }

    public boolean isPreserveRtd() {
        return this.preserveRtd;
    }

    public void setAddSubst(boolean addSubst) {
        this.addSubst = addSubst;
    }

    public boolean isAddSubst() {
        return this.addSubst;
    }

    public Wom3ElementNode visit(WtIllegalCodePoint n) {
        this.appendInconvertible((WtNode)n, false);
        return null;
    }

    public Wom3ElementNode visit(WtTagExtension n) {
        Wom3Element tag = this.genPushMww("tagext");
        tag.setAttribute("name", n.getName());
        this.appendRtd((Wom3ElementNode)tag, (WtNode)n, 0);
        this.convertToExplicitMwwAttributes((Wom3ElementNode)tag, n.getXmlAttributes());
        this.appendRtd((Wom3ElementNode)tag, (WtNode)n, 1);
        if (n.hasBody()) {
            this.dispatchAppend((Wom3ElementNode)tag, (WtNode)n.getBody());
        }
        this.appendRtd((Wom3ElementNode)tag, (WtNode)n, 2);
        return this.pop((Wom3Node)tag);
    }

    public Wom3ElementNode visit(WtTagExtensionBody n) {
        Wom3Element body = this.genPushMww("body");
        this.appendText(n.getContent());
        return this.pop((Wom3Node)body);
    }

    public Wom3ElementNode visit(WtTemplate n) {
        Wom3Element template = this.genPushMww("transclusion");
        this.appendRtd((Wom3ElementNode)template, (WtNode)n, 0);
        this.dispatchAppend((Wom3ElementNode)template, (WtNode)n.getName());
        this.appendRtd((Wom3ElementNode)template, (WtNode)n, 1);
        this.dispatchAppend((Wom3ElementNode)template, (WtNode)n.getArgs());
        this.appendRtd((Wom3ElementNode)template, (WtNode)n, 2);
        return this.pop((Wom3Node)template);
    }

    public Wom3ElementNode visit(WtTemplateArguments n) {
        this.processContainerNode((WtNode)n);
        return null;
    }

    public Wom3ElementNode visit(WtTemplateArgument n) {
        Wom3Element arg = this.genPushMww("arg");
        this.appendRtd((Wom3ElementNode)arg, (WtNode)n, 0);
        if (n.hasName()) {
            this.dispatchAppend((Wom3ElementNode)arg, (WtNode)n.getName());
        }
        this.appendRtd((Wom3ElementNode)arg, (WtNode)n, 1);
        this.dispatchAppend((Wom3ElementNode)arg, (WtNode)n.getValue());
        this.appendRtd((Wom3ElementNode)arg, (WtNode)n, 2);
        return this.pop((Wom3Node)arg);
    }

    public Wom3ElementNode visit(WtTemplateParameter n) {
        Wom3Element param = this.genPushMww("param");
        this.appendRtd((Wom3ElementNode)param, (WtNode)n, 0);
        this.dispatchAppend((Wom3ElementNode)param, (WtNode)n.getName());
        this.appendRtd((Wom3ElementNode)param, (WtNode)n, 1);
        if (n.hasDefault()) {
            this.dispatchAppend((Wom3ElementNode)param, (WtNode)n.getDefault());
        }
        this.appendRtd((Wom3ElementNode)param, (WtNode)n, 2);
        if (!n.getGarbage().isEmpty()) {
            Wom3Element garbage = this.genPushMww("garbage");
            this.dispatchAppend((Wom3ElementNode)garbage, (WtNode)n.getGarbage());
            this.popAppend((Wom3ElementNode)param, (Wom3Node)garbage);
        }
        this.appendRtd((Wom3ElementNode)param, (WtNode)n, 3);
        return this.pop((Wom3Node)param);
    }

    public Wom3ElementNode visit(WtXmlCharRef n) {
        if (this.addSubst) {
            Wom3Subst subst = (Wom3Subst)this.genPushWom("subst");
            Wom3Repl repl = (Wom3Repl)this.genPushWom("repl");
            this.convertCharRef(n);
            this.popAppend((Wom3ElementNode)subst, (Wom3Node)repl);
            Wom3For for_ = (Wom3For)this.genPushWom("for");
            Wom3Element charRef = this.genPushMww("xml-char-ref");
            charRef.setAttribute("code", String.valueOf(n.getCodePoint()));
            this.appendRtd((Wom3ElementNode)charRef, (WtNode)n, 0);
            this.popAppend((Wom3ElementNode)for_, (Wom3Node)charRef);
            this.popAppend((Wom3ElementNode)subst, (Wom3Node)for_);
            return this.pop((Wom3Node)subst);
        }
        this.convertCharRef(n);
        return null;
    }

    private Wom3ElementNode convertCharRef(WtXmlCharRef n) {
        int codePoint = n.getCodePoint();
        if (!XmlGrammar.isChar((int)codePoint)) {
            this.appendInconvertible((WtNode)n, false);
        } else {
            this.appendText(new String(Character.toChars(codePoint)));
        }
        return null;
    }

    public Wom3ElementNode visit(WtXmlEntityRef n) {
        if (this.addSubst) {
            Wom3Subst subst = (Wom3Subst)this.genPushWom("subst");
            Wom3Repl repl = (Wom3Repl)this.genPushWom("repl");
            this.convertEntityRef(n);
            this.popAppend((Wom3ElementNode)subst, (Wom3Node)repl);
            Wom3For for_ = (Wom3For)this.genPushWom("for");
            Wom3Element entityRef = this.genPushMww("xml-entity-ref");
            entityRef.setAttribute("name", String.valueOf(n.getName()));
            this.appendRtd((Wom3ElementNode)entityRef, (WtNode)n, 0);
            this.popAppend((Wom3ElementNode)for_, (Wom3Node)entityRef);
            this.popAppend((Wom3ElementNode)subst, (Wom3Node)for_);
            return this.pop((Wom3Node)subst);
        }
        this.convertEntityRef(n);
        return null;
    }

    private Wom3ElementNode convertEntityRef(WtXmlEntityRef n) {
        String resolved = n.getResolved();
        if (resolved == null) {
            this.appendInconvertible((WtNode)n, false);
        } else {
            this.appendText(resolved);
        }
        return null;
    }

    public Wom3ElementNode visit(WtXmlEmptyTag n) {
        this.appendInconvertible((WtNode)n, false);
        return null;
    }

    public Wom3ElementNode visit(WtXmlStartTag n) {
        this.appendInconvertible((WtNode)n, false);
        return null;
    }

    public Wom3ElementNode visit(WtXmlEndTag n) {
        this.appendInconvertible((WtNode)n, false);
        return null;
    }

    public Wom3ElementNode visit(WtImStartTag n) {
        this.appendInconvertible((WtNode)n, false);
        return null;
    }

    public Wom3ElementNode visit(WtImEndTag n) {
        this.appendInconvertible((WtNode)n, false);
        return null;
    }

    public Wom3ElementNode visit(WtXmlElement n) {
        String lowercaseName = n.getName().toLowerCase();
        HtmlElement elementType = this.xhtmlElems.get(lowercaseName);
        if (elementType != null) {
            return this.convertXmlElementToNative(n, elementType);
        }
        return this.convertGenericXmlElement(n);
    }

    private Wom3ElementNode convertXmlElementToNative(WtXmlElement n, HtmlElement elementType) {
        switch (elementType) {
            case ABBR: {
                return this.womFromXmlElement(n, "abbr");
            }
            case B: {
                return this.womFromXmlElement(n, "b");
            }
            case BIG: {
                return this.womFromXmlElement(n, "big");
            }
            case BLOCKQUOTE: {
                return this.womFromXmlElement(n, "blockquote");
            }
            case BR: {
                return this.womFromXmlElement(n, "br");
            }
            case CENTER: {
                return this.womFromXmlElement(n, "center");
            }
            case CITE: {
                return this.womFromXmlElement(n, "cite");
            }
            case CODE: {
                return this.womFromXmlElement(n, "code");
            }
            case DEL: {
                return this.womFromXmlElement(n, "del");
            }
            case DFN: {
                return this.womFromXmlElement(n, "dfn");
            }
            case DIV: {
                return this.womFromXmlElement(n, "div");
            }
            case EM: {
                return this.womFromXmlElement(n, "em");
            }
            case FONT: {
                return this.womFromXmlElement(n, "font");
            }
            case HR: {
                return this.womFromXmlElement(n, "hr");
            }
            case I: {
                return this.womFromXmlElement(n, "i");
            }
            case INS: {
                return this.womFromXmlElement(n, "ins");
            }
            case KBD: {
                return this.womFromXmlElement(n, "kbd");
            }
            case P: {
                return this.womFromXmlElement(n, "p");
            }
            case S: {
                return this.womFromXmlElement(n, "s");
            }
            case SAMP: {
                return this.womFromXmlElement(n, "samp");
            }
            case SMALL: {
                return this.womFromXmlElement(n, "small");
            }
            case SPAN: {
                return this.womFromXmlElement(n, "span");
            }
            case STRIKE: {
                return this.womFromXmlElement(n, "strike");
            }
            case STRONG: {
                return this.womFromXmlElement(n, "strong");
            }
            case SUB: {
                return this.womFromXmlElement(n, "sub");
            }
            case SUP: {
                return this.womFromXmlElement(n, "sup");
            }
            case TT: {
                return this.womFromXmlElement(n, "tt");
            }
            case U: {
                return this.womFromXmlElement(n, "u");
            }
            case VAR: {
                return this.womFromXmlElement(n, "var");
            }
            case DD: {
                return this.womFromXmlElement(n, "dd");
            }
            case DL: {
                return this.womFromXmlElement(n, "dl");
            }
            case DT: {
                return this.womFromXmlElement(n, "dt");
            }
            case LI: {
                return this.womFromXmlElement(n, "li");
            }
            case OL: {
                return this.womFromXmlElement(n, "ol");
            }
            case UL: {
                return this.womFromXmlElement(n, "ul");
            }
            case TABLE: {
                return this.tableFromElement(n);
            }
            case CAPTION: {
                return this.tableCaptionFromElement(n);
            }
            case TBODY: {
                return this.tableBodyFromElement(n);
            }
            case TR: {
                return this.womFromXmlElement(n, "tr");
            }
            case TD: {
                return this.tableCellFromElement(n);
            }
            case TH: {
                return this.tableHeaderFromElement(n);
            }
            case PRE: {
                return this.preFromElement(n);
            }
        }
        throw new IllegalArgumentException("Unknown element type: " + (Object)((Object)elementType));
    }

    private Wom3ElementNode convertGenericXmlElement(WtXmlElement n) {
        Wom3Element element = this.genPushMww("xmlelement");
        element.setAttribute("tag", n.getName());
        this.appendRtd((Wom3ElementNode)element, (WtNode)n, 0);
        this.convertToExplicitMwwAttributes((Wom3ElementNode)element, n.getXmlAttributes());
        this.appendRtd((Wom3ElementNode)element, (WtNode)n, 1);
        if (n.hasBody()) {
            this.processChildrenPushAppend((WtNode)n.getBody(), (Wom3ElementNode)this.genMww("body"));
        }
        this.appendRtd((Wom3ElementNode)element, (WtNode)n, 2);
        return this.pop((Wom3Node)element);
    }

    private Wom3ElementNode womFromXmlElement(WtXmlElement n, String womName) {
        Wom3ElementNode womElement = this.genPushWom(womName);
        this.appendRtd(womElement, (WtNode)n, 0);
        this.dispatchAppend(womElement, (WtNode)n.getXmlAttributes());
        this.appendRtd(womElement, (WtNode)n, 1);
        if (n.hasBody()) {
            this.processChildrenNoPush((WtNode)n.getBody(), womElement);
        }
        this.appendRtd(womElement, (WtNode)n, 2);
        return this.pop((Wom3Node)womElement);
    }

    private Wom3ElementNode preFromElement(WtXmlElement n) {
        Wom3ElementNode pre = this.genPushWom("pre");
        this.appendRtd(pre, (WtNode)n, 0);
        this.dispatchAppend(pre, (WtNode)n.getXmlAttributes());
        this.appendRtd(pre, (WtNode)n, 1);
        if (n.hasBody()) {
            this.processChildrenPushAppend((WtNode)n.getBody(), this.genWom("nowiki"));
        }
        this.appendRtd(pre, (WtNode)n, 2);
        return this.pop((Wom3Node)pre);
    }

    private Wom3ElementNode tableFromElement(WtXmlElement n) {
        Wom3Table table = (Wom3Table)this.genPushWom("table");
        this.inNoTextScope = true;
        this.appendRtd((Wom3ElementNode)table, (WtNode)n, 0);
        this.dispatchAppend((Wom3ElementNode)table, (WtNode)n.getXmlAttributes());
        this.appendRtd((Wom3ElementNode)table, (WtNode)n, 1);
        if (n.hasBody()) {
            this.processChildrenNoPush((WtNode)n.getBody(), table);
        }
        this.appendRtd((Wom3ElementNode)table, (WtNode)n, 2);
        this.inNoTextScope = false;
        return this.pop((Wom3Node)table);
    }

    private Wom3ElementNode tableBodyFromElement(WtXmlElement n) {
        return this.womFromXmlElement(n, "tbody");
    }

    private Wom3ElementNode tableCaptionFromElement(WtXmlElement n) {
        Wom3Table table;
        Wom3ElementNode scope = this.getScope();
        if (scope instanceof Wom3Table && (table = (Wom3Table)scope).getCaption() != null) {
            this.appendInconvertible((WtNode)n, true);
            return null;
        }
        return this.tableXFromX(n, "caption");
    }

    private Wom3ElementNode tableHeaderFromElement(WtXmlElement n) {
        return this.tableXFromX(n, "th");
    }

    private Wom3ElementNode tableCellFromElement(WtXmlElement n) {
        return this.tableXFromX(n, "td");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Wom3ElementNode tableXFromX(WtXmlElement n, String womName) {
        try {
            this.inNoTextScope = false;
            Wom3ElementNode wom3ElementNode = this.womFromXmlElement(n, womName);
            return wom3ElementNode;
        }
        finally {
            this.inNoTextScope = true;
        }
    }

    public Wom3ElementNode visit(WtXmlAttributes n) {
        boolean old = this.setSuppressRtd(n.getRtd());
        this.processContainerNode((WtNode)n);
        this.setSuppressRtd(old);
        return null;
    }

    public Wom3Node visit(WtXmlAttribute n) {
        boolean failed = true;
        try {
            if (n.getName().isResolved()) {
                String nameAsString = n.getName().getAsString();
                if (XmlGrammar.xmlName().matcher(nameAsString).matches() && nameAsString.indexOf(58) == -1) {
                    String valueAsString = this.stringify((WtContentNode)n.getValue());
                    Wom3ElementNode parent = this.getScope();
                    parent.setAttributeNode((Attr)this.attr(nameAsString, valueAsString));
                    if (!this.isRtdSuppressed()) {
                        this.appendRtd(parent, this.convertToText((WtNode)n));
                    }
                    failed = false;
                }
            }
        }
        catch (IllegalArgumentException e) {
        }
        catch (IllegalStateException e) {
        }
        catch (StringConversionException stringConversionException) {
            // empty catch block
        }
        if (failed) {
            this.appendInconvertible((WtNode)n, true);
        }
        return null;
    }

    public Wom3ElementNode visit(WtXmlAttributeGarbage n) {
        this.appendInconvertible((WtNode)n, true);
        return null;
    }

    private void convertToExplicitMwwAttributes(Wom3ElementNode womParent, WtXmlAttributes xmlAttribs) {
        this.appendRtd(womParent, (WtNode)xmlAttribs, 0);
        for (WtNode wtAttr : xmlAttribs) {
            if (wtAttr instanceof WtXmlAttribute) {
                womParent.appendChild((Node)this.convertToExplicitMwwAttribute((WtXmlAttribute)wtAttr));
                continue;
            }
            this.dispatchAppend(womParent, wtAttr);
        }
        this.appendRtd(womParent, (WtNode)xmlAttribs, 1);
    }

    private Wom3Element convertToExplicitMwwAttribute(WtXmlAttribute wtAttr) {
        Wom3Element womAttr = this.genPushMww("attr");
        this.appendRtd((Wom3ElementNode)womAttr, (WtNode)wtAttr, 0);
        this.processChildrenPushAppend((WtNode)wtAttr.getName(), (Wom3ElementNode)this.genMww("name"));
        this.appendRtd((Wom3ElementNode)womAttr, (WtNode)wtAttr, 1);
        if (wtAttr.hasValue()) {
            this.processChildrenPushAppend((WtNode)wtAttr.getValue(), (Wom3ElementNode)this.genMww("value"));
        }
        this.appendRtd((Wom3ElementNode)womAttr, (WtNode)wtAttr, 2);
        return (Wom3Element)this.pop((Wom3Node)womAttr);
    }

    public Wom3ElementNode visit(WtRedirect n) {
        String targetAsString = this.getTargetAsString(n.getTarget());
        String normalizedTarget = this.getNormalizedTargetAsString(targetAsString);
        if (targetAsString != null && normalizedTarget != null) {
            Wom3Redirect redirect = (Wom3Redirect)this.genWom("redirect");
            String did = String.valueOf(this.displacement++);
            redirect.setDisplacementId(did);
            redirect.setTarget(normalizedTarget);
            this.page.setRedirect(redirect);
            if (this.addSubst) {
                Wom3Subst subst = (Wom3Subst)this.genPushWom("subst");
                subst.setDisplacementId(did);
                Wom3Repl repl = (Wom3Repl)this.genPushWom("repl");
                this.popAppend((Wom3ElementNode)subst, (Wom3Node)repl);
                Wom3For for_ = (Wom3For)this.genPushWom("for");
                Wom3Element mwwRedirect = this.genPushMww("redirect");
                this.appendRtd((Wom3ElementNode)mwwRedirect, (WtNode)n, 0);
                this.dispatchAppend((Wom3ElementNode)mwwRedirect, (WtNode)n.getTarget());
                this.appendRtd((Wom3ElementNode)mwwRedirect, (WtNode)n, 1);
                this.popAppend((Wom3ElementNode)for_, (Wom3Node)mwwRedirect);
                this.popAppend((Wom3ElementNode)subst, (Wom3Node)for_);
                return this.pop((Wom3Node)subst);
            }
            return null;
        }
        this.appendInconvertible((WtNode)n, false);
        return null;
    }

    public Wom3ElementNode visit(WtPageName n) {
        try {
            this.appendText(n.getAsString());
            return null;
        }
        catch (IllegalStateException e) {
            throw new IllegalArgumentException("WtPageName cannot be rendered as text");
        }
    }

    private String getTargetAsString(WtPageName target) {
        try {
            return target.getAsString();
        }
        catch (IllegalStateException e) {
            return null;
        }
    }

    private String getNormalizedTargetAsString(String targetAsString) {
        try {
            PageTitle target = PageTitle.make((WikiConfig)this.wikiConfig, (String)targetAsString);
            String normalized = target.getNormalizedFullTitle();
            if (target.getFragment() != null) {
                normalized = normalized + "#" + target.getFragment();
            }
            Toolbox.checkValidTarget((String)normalized);
            return normalized;
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        catch (LinkTargetException e) {
            return null;
        }
    }

    public Wom3ElementNode visit(WtUrl n) {
        URL url = this.urlNodeToUrl(n);
        if (url != null) {
            Wom3ExtLink extLink = (Wom3ExtLink)this.genPushWom("extlink");
            extLink.setTarget(url);
            extLink.setPlainUrl(true);
            this.appendRtd((Wom3ElementNode)extLink, (WtNode)n, 0);
            return this.pop((Wom3Node)extLink);
        }
        this.appendInconvertible((WtNode)n, false);
        return null;
    }

    public Wom3ElementNode visit(WtExternalLink n) {
        URL url = this.urlNodeToUrl(n.getTarget());
        if (url != null) {
            Wom3ExtLink extLink = (Wom3ExtLink)this.genPushWom("extlink");
            extLink.setTarget(url);
            this.appendRtd((Wom3ElementNode)extLink, (WtNode)n, 0);
            this.appendRtd((Wom3ElementNode)extLink, (WtNode)n.getTarget(), 0);
            this.appendRtd((Wom3ElementNode)extLink, (WtNode)n, 1);
            if (n.hasTitle()) {
                this.dispatchAppend((Wom3ElementNode)extLink, (WtNode)n.getTitle());
            }
            this.appendRtd((Wom3ElementNode)extLink, (WtNode)n, 2);
            return this.pop((Wom3Node)extLink);
        }
        this.appendInconvertible((WtNode)n, false);
        return null;
    }

    private URL urlNodeToUrl(WtUrl urlNode) {
        try {
            if (urlNode.getProtocol().isEmpty()) {
                return new URL(urlNode.getPath());
            }
            return new URL(urlNode.getProtocol() + ":" + urlNode.getPath());
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public Wom3ElementNode visit(WtInternalLink n) {
        String originalTarget = this.getTargetAsString(n.getTarget());
        String normalizedTarget = this.getNormalizedTargetAsString(originalTarget);
        if (originalTarget == null || normalizedTarget == null) {
            this.appendInconvertible((WtNode)n, false);
            return null;
        }
        boolean subst = this.addSubst && (!n.getPostfix().isEmpty() || !n.getPrefix().isEmpty());
        return subst ? this.substIntLink(n, originalTarget, normalizedTarget) : this.nativeIntLink(n, originalTarget, normalizedTarget);
    }

    private Wom3ElementNode nativeIntLink(WtInternalLink n, String originalTarget, String normalizedTarget) {
        Wom3IntLink intLink = (Wom3IntLink)this.genPushWom("intlink");
        intLink.setTarget(normalizedTarget);
        this.appendRtd((Wom3ElementNode)intLink, (WtNode)n, 0);
        boolean old = this.setSuppressRtd(n.getTarget().getRtd());
        this.appendRtd((Wom3ElementNode)intLink, originalTarget);
        this.setSuppressRtd(old);
        this.appendRtd((Wom3ElementNode)intLink, (WtNode)n, 1);
        if (n.hasTitle()) {
            this.dispatchAppend((Wom3ElementNode)intLink, (WtNode)n.getTitle());
        }
        this.appendRtd((Wom3ElementNode)intLink, (WtNode)n, 2);
        return this.pop((Wom3Node)intLink);
    }

    private Wom3ElementNode substIntLink(WtInternalLink n, String originalTarget, String normalizedTarget) {
        Wom3Subst subst = (Wom3Subst)this.genPushWom("subst");
        Wom3Repl repl = (Wom3Repl)this.genPushWom("repl");
        Wom3IntLink intLink = (Wom3IntLink)this.genPushWom("intlink");
        boolean oldPreserveRtd = this.setPreserveRtd(false);
        intLink.setTarget(normalizedTarget);
        if (n.hasTitle()) {
            Wom3Title title = (Wom3Title)this.dispatchAppend((Wom3ElementNode)intLink, (WtNode)n.getTitle());
            this.push(title);
            if (!n.getPrefix().isEmpty()) {
                this.prependText((Wom3ElementNode)title, n.getPrefix());
            }
            if (!n.getPostfix().isEmpty()) {
                this.appendText((Wom3ElementNode)title, n.getPostfix());
            }
            this.pop((Wom3Node)title);
        } else {
            Wom3Title title = (Wom3Title)this.genPushWom("title");
            if (!n.getPrefix().isEmpty()) {
                this.appendText((Wom3ElementNode)title, n.getPrefix());
            }
            this.appendText((Wom3ElementNode)title, originalTarget);
            if (!n.getPostfix().isEmpty()) {
                this.appendText((Wom3ElementNode)title, n.getPostfix());
            }
            intLink.setLinkTitle((Wom3Title)this.pop((Wom3Node)title));
        }
        this.setPreserveRtd(oldPreserveRtd);
        this.popAppend((Wom3ElementNode)repl, (Wom3Node)intLink);
        this.popAppend((Wom3ElementNode)subst, (Wom3Node)repl);
        Wom3For for_ = (Wom3For)this.genPushWom("for");
        Wom3Element intLink2 = this.genPushMww("intlink");
        intLink2.setAttribute("target", originalTarget);
        if (!n.getPostfix().isEmpty()) {
            intLink2.setAttribute("postfix", n.getPostfix());
        }
        if (!n.getPrefix().isEmpty()) {
            intLink2.setAttribute("prefix", n.getPrefix());
        }
        this.appendRtd((Wom3ElementNode)intLink2, (WtNode)n, 0);
        this.appendRtd((Wom3ElementNode)intLink2, originalTarget);
        this.appendRtd((Wom3ElementNode)intLink2, (WtNode)n, 1);
        if (n.hasTitle()) {
            this.dispatchAppend((Wom3ElementNode)intLink2, (WtNode)n.getTitle());
        }
        this.appendRtd((Wom3ElementNode)intLink2, (WtNode)n, 2);
        this.popAppend((Wom3ElementNode)for_, (Wom3Node)intLink2);
        this.popAppend((Wom3ElementNode)subst, (Wom3Node)for_);
        return this.pop((Wom3Node)subst);
    }

    public Wom3ElementNode visit(WtImageLink n) {
        String targetAsString = this.getTargetAsString(n.getTarget());
        String normalizedTarget = this.getNormalizedTargetAsString(targetAsString);
        if (targetAsString != null && normalizedTarget != null) {
            Wom3Image img = (Wom3Image)this.genPushWom("image");
            img.setSource(normalizedTarget);
            img.setFormat(this.mapImgFormat(n.getFormat()));
            img.setBorder(n.getBorder());
            img.setHAlign(this.mapImgHAlign(n.getHAlign()));
            img.setVAlign(this.mapImgVAlign(n.getVAlign()));
            img.setUpright(n.getUpright());
            if (n.getWidth() >= 0) {
                img.setWidth(Integer.valueOf(n.getWidth()));
            }
            if (n.getHeight() >= 0) {
                img.setHeight(Integer.valueOf(n.getHeight()));
            }
            if (n.hasAlt()) {
                img.setAlt(this.convertContentToText((WtContentNode)n.getAlt()));
            }
            this.setImgLink(img, n.getLink());
            this.appendRtd((Wom3ElementNode)img, (WtNode)n, 0);
            this.appendRtd((Wom3ElementNode)img, targetAsString);
            this.appendRtd((Wom3ElementNode)img, (WtNode)n, 1);
            this.processChildrenNoPush((WtNode)n.getOptions(), img);
            this.appendRtd((Wom3ElementNode)img, (WtNode)n, 2);
            return this.pop((Wom3Node)img);
        }
        this.appendInconvertible((WtNode)n, false);
        return null;
    }

    private void setImgLink(Wom3Image img, WtLinkOptionLinkTarget link) {
        WtLinkTarget.LinkTargetType linkType = link.getTargetType();
        switch (linkType) {
            case DEFAULT: {
                return;
            }
            case NO_LINK: {
                img.setIntLink("");
                return;
            }
            case PAGE: {
                img.setIntLink(this.getTargetAsString((WtPageName)link.getTarget()));
                return;
            }
            case URL: {
                img.setExtLink(this.urlNodeToUrl((WtUrl)link.getTarget()));
                return;
            }
        }
        throw new IllegalArgumentException("Unknown element type: " + linkType);
    }

    private Wom3ImageVAlign mapImgVAlign(WtImageLink.ImageVertAlign vAlign) {
        switch (vAlign) {
            case BASELINE: {
                return Wom3ImageVAlign.BASELINE;
            }
            case BOTTOM: {
                return Wom3ImageVAlign.BOTTOM;
            }
            case MIDDLE: {
                return Wom3ImageVAlign.MIDDLE;
            }
            case SUB: {
                return Wom3ImageVAlign.SUB;
            }
            case SUPER: {
                return Wom3ImageVAlign.SUPER;
            }
            case TEXT_BOTTOM: {
                return Wom3ImageVAlign.TEXT_BOTTOM;
            }
            case TEXT_TOP: {
                return Wom3ImageVAlign.TEXT_TOP;
            }
            case TOP: {
                return Wom3ImageVAlign.TOP;
            }
        }
        throw new IllegalArgumentException("Unknown image vertical alignment: " + vAlign);
    }

    private Wom3ImageHAlign mapImgHAlign(WtImageLink.ImageHorizAlign hAlign) {
        switch (hAlign) {
            case CENTER: {
                return Wom3ImageHAlign.CENTER;
            }
            case LEFT: {
                return Wom3ImageHAlign.LEFT;
            }
            case NONE: {
                return Wom3ImageHAlign.NONE;
            }
            case RIGHT: {
                return Wom3ImageHAlign.RIGHT;
            }
            case UNSPECIFIED: {
                return Wom3ImageHAlign.DEFAULT;
            }
        }
        throw new IllegalArgumentException("Unknown image horizontal alignment: " + hAlign);
    }

    private Wom3ImageFormat mapImgFormat(WtImageLink.ImageViewFormat format) {
        switch (format) {
            case FRAME: {
                return Wom3ImageFormat.FRAME;
            }
            case FRAMELESS: {
                return Wom3ImageFormat.FRAMELESS;
            }
            case THUMBNAIL: {
                return Wom3ImageFormat.THUMBNAIL;
            }
            case UNRESTRAINED: {
                return Wom3ImageFormat.UNRESTRAINED;
            }
        }
        throw new IllegalArgumentException("Unknown image view format: " + format);
    }

    public Wom3ElementNode visit(WtLinkOptions n) {
        boolean old = this.setSuppressRtd(n.getRtd());
        this.processContainerNode((WtNode)n);
        this.setSuppressRtd(old);
        return null;
    }

    public Wom3ElementNode visit(WtLinkOptionLinkTarget n) {
        this.appendRtd(this.convertToText((WtNode)n));
        return null;
    }

    public Wom3ElementNode visit(WtLinkOptionKeyword n) {
        this.appendRtd(this.convertToText((WtNode)n));
        return null;
    }

    public Wom3ElementNode visit(WtLinkOptionResize n) {
        this.appendRtd(this.convertToText((WtNode)n));
        return null;
    }

    public Wom3ElementNode visit(WtLinkOptionAltText n) {
        this.appendRtd(this.convertToText((WtNode)n));
        return null;
    }

    public Wom3ElementNode visit(WtLinkOptionGarbage n) {
        this.appendInconvertible((WtNode)n, true);
        return null;
    }

    public Wom3ElementNode visit(WtSection n) {
        Wom3Section section = (Wom3Section)this.genPushWom("section");
        section.setLevel(n.getLevel());
        this.appendRtd((Wom3ElementNode)section, (WtNode)n, 0);
        this.dispatchAppend((Wom3ElementNode)section, (WtNode)n.getHeading());
        this.appendRtd((Wom3ElementNode)section, (WtNode)n, 1);
        this.dispatchAppend((Wom3ElementNode)section, (WtNode)n.getBody());
        this.appendRtd((Wom3ElementNode)section, (WtNode)n, 2);
        return this.pop((Wom3Node)section);
    }

    public Wom3ElementNode visit(WtHeading n) {
        return this.processChildrenPush((WtNode)n, this.genWom("heading"));
    }

    public Wom3ElementNode visit(WtOrderedList n) {
        return this.processChildrenPush((WtNode)n, this.genWom("ol"));
    }

    public Wom3ElementNode visit(WtUnorderedList n) {
        return this.processChildrenPush((WtNode)n, this.genWom("ul"));
    }

    public Wom3ElementNode visit(WtListItem n) {
        return this.processChildrenPush((WtNode)n, this.genWom("li"));
    }

    public Wom3ElementNode visit(WtDefinitionList n) {
        return this.processChildrenPush((WtNode)n, this.genWom("dl"));
    }

    public Wom3ElementNode visit(WtDefinitionListDef n) {
        return this.processChildrenPush((WtNode)n, this.genWom("dd"));
    }

    public Wom3ElementNode visit(WtDefinitionListTerm n) {
        return this.processChildrenPush((WtNode)n, this.genWom("dt"));
    }

    public Wom3ElementNode visit(WtTable n) {
        Wom3Table table = (Wom3Table)this.genPushWom("table");
        this.inNoTextScope = true;
        this.appendRtd((Wom3ElementNode)table, (WtNode)n, 0);
        this.dispatchAppend((Wom3ElementNode)table, (WtNode)n.getXmlAttributes());
        this.appendRtd((Wom3ElementNode)table, (WtNode)n, 1);
        this.processChildrenNoPush((WtNode)n.getBody(), table);
        this.appendRtd((Wom3ElementNode)table, (WtNode)n, 2);
        this.inNoTextScope = false;
        return this.pop((Wom3Node)table);
    }

    public Wom3ElementNode visit(WtTableCaption n) {
        Wom3Table table;
        Wom3ElementNode scope = this.getScope();
        if (scope instanceof Wom3Table && (table = (Wom3Table)scope).getCaption() != null) {
            this.appendInconvertible((WtNode)n, true);
            return null;
        }
        Wom3TableCaption caption = (Wom3TableCaption)this.genPushWom("caption");
        this.inNoTextScope = false;
        this.appendRtd((Wom3ElementNode)caption, (WtNode)n, 0);
        this.dispatchAppend((Wom3ElementNode)caption, (WtNode)n.getXmlAttributes());
        this.appendRtd((Wom3ElementNode)caption, (WtNode)n, 1);
        this.processChildrenNoPush((WtNode)n.getBody(), caption);
        this.appendRtd((Wom3ElementNode)caption, (WtNode)n, 2);
        this.inNoTextScope = true;
        return this.pop((Wom3Node)caption);
    }

    public Wom3ElementNode visit(WtTableImplicitTableBody n) {
        return this.processChildrenPush((WtNode)n.getBody(), this.genWom("tbody"));
    }

    public Wom3ElementNode visit(WtTableRow n) {
        return this.buildRowOrCell((WtNode)n, n.getXmlAttributes(), n.getBody(), "tr");
    }

    public Wom3ElementNode visit(WtTableCell n) {
        this.inNoTextScope = false;
        Wom3ElementNode cell = this.buildRowOrCell((WtNode)n, n.getXmlAttributes(), n.getBody(), "td");
        this.inNoTextScope = true;
        return cell;
    }

    public Wom3ElementNode visit(WtTableHeader n) {
        this.inNoTextScope = false;
        Wom3ElementNode header = this.buildRowOrCell((WtNode)n, n.getXmlAttributes(), n.getBody(), "th");
        this.inNoTextScope = true;
        return header;
    }

    private Wom3ElementNode buildRowOrCell(WtNode n, WtXmlAttributes attrs, WtBody body, String name) {
        Wom3ElementNode rowOrCell = this.genPushWom(name);
        this.appendRtd(rowOrCell, n, 0);
        this.dispatchAppend(rowOrCell, (WtNode)attrs);
        this.appendRtd(rowOrCell, n, 1);
        this.processChildrenNoPush((WtNode)body, rowOrCell);
        this.appendRtd(rowOrCell, n, 2);
        return this.pop((Wom3Node)rowOrCell);
    }

    public Wom3ElementNode visit(WtHorizontalRule n) {
        Wom3ElementNode hr = this.genPushWom("hr");
        this.appendRtd(hr, (WtNode)n, 0);
        return this.pop((Wom3Node)hr);
    }

    public Wom3ElementNode visit(WtItalics n) {
        return this.processChildrenPush((WtNode)n, this.genWom("i"));
    }

    public Wom3ElementNode visit(WtBold n) {
        return this.processChildrenPush((WtNode)n, this.genWom("b"));
    }

    public Wom3ElementNode visit(WtSignature n) {
        Wom3Signature sig = (Wom3Signature)this.genPushWom("signature");
        sig.setSignatureFormat(this.mapSignatureFormat(n));
        sig.setAuthor(this.author);
        sig.setTimestamp(this.timestamp);
        this.appendRtd((Wom3ElementNode)sig, (WtNode)n, 0);
        return this.pop((Wom3Node)sig);
    }

    private Wom3SignatureFormat mapSignatureFormat(WtSignature n) {
        switch (n.getTildeCount()) {
            case 3: {
                return Wom3SignatureFormat.USER;
            }
            case 4: {
                return Wom3SignatureFormat.USER_TIMESTAMP;
            }
            case 5: {
                return Wom3SignatureFormat.TIMESTAMP;
            }
        }
        throw new IllegalArgumentException("Illegal signature tilde count: " + n.getTildeCount());
    }

    public Wom3ElementNode visit(WtParagraph n) {
        Wom3Paragraph paragraph = (Wom3Paragraph)this.genPushWom("p");
        paragraph.setTopGap(this.countNewlines(n.listIterator(), false));
        paragraph.setBottomGap(this.countNewlines(n.listIterator(n.size()), true));
        this.processChildrenNoPush((WtNode)n, paragraph);
        if (!paragraph.hasChildNodes()) {
            this.pop((Wom3Node)paragraph);
            return null;
        }
        return this.pop((Wom3Node)paragraph);
    }

    private int countNewlines(ListIterator<?> i, boolean reverse) {
        int count = 0;
        block4: while (reverse ? i.hasPrevious() : i.hasNext()) {
            WtNode n = (WtNode)(reverse ? i.previous() : i.next());
            switch (n.getNodeType()) {
                case 196610: {
                    ++count;
                    break;
                }
                case 4097: {
                    String text = ((WtText)n).getContent();
                    int len = text.length();
                    for (int j = 0; j < len; ++j) {
                        char ch = text.charAt(reverse ? len - 1 - j : j);
                        if (ch == '\n' || ch == '\r') {
                            if (j + 1 < len) {
                                char ch2 = text.charAt(reverse ? len - 1 - j : j);
                                if (ch == '\r' && ch2 == '\n' || ch == '\n' && ch2 == '\r') {
                                    ++j;
                                }
                            }
                            ++count;
                            continue;
                        }
                        if (!Character.isWhitespace((int)ch)) break block4;
                    }
                    continue block4;
                }
                default: {
                    break block4;
                }
            }
        }
        return count;
    }

    public Wom3ElementNode visit(WtSemiPre n) {
        return this.processChildrenPush((WtNode)n, this.genWom("pre"));
    }

    public Wom3ElementNode visit(WtSemiPreLine n) {
        return this.processContainerNode((WtNode)n);
    }

    public Wom3ElementNode visit(WtNodeList n) {
        return this.processContainerNode((WtNode)n);
    }

    public Wom3ElementNode visit(WtBody n) {
        return this.processChildrenPush((WtNode)n, this.genWom("body"));
    }

    public Wom3ElementNode visit(WtLinkTitle n) {
        Wom3ElementNode parent = this.getScope();
        if (parent instanceof Wom3Image) {
            return this.processChildrenPush((WtNode)n, this.genWom("imgcaption"));
        }
        return this.processChildrenPush((WtNode)n, this.genWom("title"));
    }

    public Wom3ElementNode visit(WtName n) {
        return this.processChildrenPush((WtNode)n, this.genMww("name"));
    }

    public Wom3ElementNode visit(WtValue n) {
        return this.processChildrenPush((WtNode)n, this.genMww("value"));
    }

    public Wom3ElementNode visit(WtWhitespace n) {
        return this.processContainerNode((WtNode)n);
    }

    public Wom3ElementNode visit(WtOnlyInclude n) {
        return this.processContainerNode((WtNode)n);
    }

    public Wom3ElementNode visit(WtIgnored n) {
        this.appendRtd(this.convertToText((WtNode)n));
        return null;
    }

    public Wom3ElementNode visit(WtPageSwitch n) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public Wom3ElementNode visit(EngProcessedPage n) {
        return (Wom3ElementNode)this.dispatch((AstNode)n.getPage());
    }

    public Wom3ElementNode visit(EngPage n) {
        return this.createRootNode((WtContentNode)n);
    }

    public Wom3ElementNode visit(WtParsedWikitextPage n) {
        return this.createRootNode((WtContentNode)n);
    }

    public Wom3ElementNode visit(WtPreproWikitextPage n) {
        return this.createRootNode((WtContentNode)n);
    }

    private Wom3ElementNode createRootNode(WtContentNode wtBody) {
        String title = this.pageTitle.getDenormalizedTitle();
        String path = null;
        int i = title.lastIndexOf(47);
        if (i != -1) {
            path = title.substring(0, i);
            title = title.substring(i + 1);
        }
        this.page = (Wom3Article)this.genPushWom("article");
        this.page.setNamespace(this.pageTitle.getNamespaceAlias());
        this.page.setPath(path);
        this.page.setTitle(title);
        Wom3ElementNode womBody = this.genPushWom("body");
        this.processChildrenNoPush((WtNode)wtBody, womBody);
        this.popAppend((Wom3ElementNode)this.page, (Wom3Node)womBody);
        return this.pop((Wom3Node)this.page);
    }

    public Wom3ElementNode visit(WtTicks n) {
        this.appendInconvertible((WtNode)n, false);
        return null;
    }

    public Wom3ElementNode visit(EngSoftErrorNode n) {
        return this.visit((WtXmlElement)n);
    }

    public Wom3ElementNode visit(WtXmlComment n) {
        WtRtData rtd = n.getRtd();
        if (!rtd.isStringOnly(0)) {
            this.appendInconvertible((WtNode)n, false);
            return null;
        }
        Wom3Comment comment = (Wom3Comment)this.genPushWom("comment");
        String content = n.getContent();
        String before = null;
        String after = null;
        String rtdStr = rtd.toString(0);
        int i = rtdStr.indexOf(content);
        if (i != -1) {
            before = rtdStr.substring(0, i);
            after = rtdStr.substring(i + content.length());
        }
        this.appendRtd((Wom3ElementNode)comment, before);
        this.appendText(content);
        this.appendRtd((Wom3ElementNode)comment, after);
        return this.pop((Wom3Node)comment);
    }

    public Wom3ElementNode visit(EngNowiki n) {
        WtRtData rtd = n.getRtd();
        if (!rtd.isStringOnly(0)) {
            this.appendInconvertible((WtNode)n, false);
            return null;
        }
        Wom3Nowiki nowiki = (Wom3Nowiki)this.genPushWom("nowiki");
        String content = n.getContent();
        String before = null;
        String after = null;
        String rtdStr = rtd.toString(0);
        int i = rtdStr.indexOf(content);
        if (i != -1) {
            before = rtdStr.substring(0, i);
            after = rtdStr.substring(i + content.length());
        }
        this.appendRtd((Wom3ElementNode)nowiki, before);
        this.appendText(content);
        this.appendRtd((Wom3ElementNode)nowiki, after);
        return this.pop((Wom3Node)nowiki);
    }

    public Wom3ElementNode visit(WtText n) {
        if (this.inNoTextScope) {
            this.appendRtd(n.getContent());
        } else {
            this.appendText(n.getContent());
        }
        return null;
    }

    public Wom3ElementNode visit(WtNewline n) {
        this.appendText(n.getContent());
        return null;
    }

    private Wom3ElementNode getScope() {
        return this.stack.peek();
    }

    private <T extends Wom3ElementNode> T push(T element) {
        this.stack.push(element);
        return element;
    }

    private Wom3ElementNode pop(Wom3Node expected) {
        Wom3ElementNode popped = this.stack.pop();
        if (popped != expected) {
            throw new InternalError();
        }
        return popped;
    }

    private Wom3ElementNode genPushWom(String name) {
        return this.push(this.genWom(name));
    }

    private Wom3Element genPushMww(String name) {
        return this.push(this.genMww(name));
    }

    private Wom3ElementNode popAppend(Wom3ElementNode parent, Wom3Node expected) {
        Wom3ElementNode child = this.pop(expected);
        parent.appendChild((Node)child);
        return child;
    }

    private <T extends Wom3ElementNode> T processChildrenNoPush(WtNode astNode, T womNode) {
        this.appendRtd(womNode, astNode, 0);
        for (WtNode c : astNode) {
            this.dispatchAppend(womNode, c);
        }
        this.appendRtd(womNode, astNode, 1);
        return womNode;
    }

    private <T extends Wom3ElementNode> T processChildrenPush(WtNode astNode, T womNode) {
        this.push(womNode);
        this.processChildrenNoPush(astNode, womNode);
        this.pop((Wom3Node)womNode);
        return womNode;
    }

    private void processChildrenPushAppend(WtNode astNode, Wom3ElementNode womNode) {
        this.getScope().appendChild((Node)this.processChildrenPush(astNode, womNode));
    }

    private Wom3ElementNode processContainerNode(WtNode n) {
        this.processChildrenNoPush(n, this.getScope());
        return null;
    }

    private Wom3ElementNode dispatchAppend(Wom3ElementNode parent, WtNode child) {
        Wom3ElementNode result = (Wom3ElementNode)this.dispatch((AstNode)child);
        if (result != null) {
            parent.appendChild((Node)result);
        }
        return result;
    }

    private void appendInconvertible(WtNode n, boolean inNoTextScope) {
        if (!WtNodeFlags.isRepairNode((WtNode)n)) {
            if (this.inNoTextScope || inNoTextScope) {
                this.appendRtd(this.convertToText(n));
            } else {
                this.appendText(this.convertToText(n));
            }
        }
    }

    private String convertToText(WtNode n) {
        return WtRtDataPrinter.print((WtNode)n);
    }

    private String convertContentToText(WtContentNode n) {
        return this.convertToText((WtNode)this.nodeFactory.toList((AstNode)n));
    }

    private String stringify(WtContentNode value) throws StringConversionException {
        return this.astTextUtils.astToText((WtNode)value);
    }

    private void prependText(Wom3ElementNode parent, String text) {
        if (text != null && !text.isEmpty()) {
            Backbone first = parent.getFirstChild();
            if (first instanceof Wom3Text) {
                if (this.isRtdSuppressed() == this.isHideRtd((Wom3ElementNode)((Wom3Text)first))) {
                    Wom3XmlText tn = (Wom3XmlText)first.getFirstChild();
                    tn.insertData(0, text);
                } else {
                    this.prependTextNode(parent, text, (Wom3Node)first);
                }
            } else {
                this.prependTextNode(parent, text, (Wom3Node)first);
            }
        }
    }

    private void prependTextNode(Wom3ElementNode parent, String text, Wom3Node first) {
        Wom3Text tn = this.createTextNode(text);
        if (first == null) {
            parent.appendChild((Node)tn);
        } else {
            parent.insertBefore((Node)tn, (Node)first);
        }
    }

    private void appendText(String text) {
        this.appendText(this.getScope(), text);
    }

    private void appendText(Wom3ElementNode parent, String text) {
        Backbone last = parent.getLastChild();
        if (last instanceof Wom3Text) {
            if (this.isRtdSuppressed() == this.isHideRtd((Wom3ElementNode)((Wom3Text)last))) {
                Wom3XmlText xmlText = (Wom3XmlText)last.getLastChild();
                if (xmlText != null) {
                    xmlText.appendData(text);
                } else {
                    last.setTextContent(text);
                }
            } else {
                this.appendTextNode(parent, text);
            }
        } else {
            this.appendTextNode(parent, text);
        }
    }

    private void appendTextNode(Wom3ElementNode n, String text) {
        n.appendChild((Node)this.createTextNode(text));
    }

    private Wom3Text createTextNode(String text) {
        Wom3Text tn = this.text(text);
        if (this.isRtdSuppressed()) {
            this.setHideRtd(tn);
        }
        return tn;
    }

    private void appendRtd(Wom3ElementNode parent, WtNode n, int index) {
        WtRtData rtd = n.getRtd();
        if (!this.isRtdVisible() && rtd != null && !rtd.isSuppress()) {
            if (rtd.isStringOnly(index)) {
                this.appendRtd(parent, rtd.toString(index));
            } else {
                for (Object x : rtd.getField(index)) {
                    if (x instanceof String) {
                        this.appendRtd(parent, (String)x);
                        continue;
                    }
                    this.dispatchAppend(parent, (WtNode)x);
                }
            }
        }
    }

    private void appendRtd(Wom3ElementNode parent, String rtd) {
        if (!this.isRtdVisible() && rtd != null && !rtd.isEmpty()) {
            Backbone last = parent.getLastChild();
            if (last instanceof Wom3Rtd) {
                Wom3XmlText xmlText = (Wom3XmlText)last.getLastChild();
                if (xmlText != null) {
                    xmlText.appendData(rtd);
                } else {
                    last.setTextContent(rtd);
                }
            } else {
                parent.appendChild((Node)this.rtd(rtd));
            }
        }
    }

    private boolean setSuppressRtd(boolean suppressRtd) {
        boolean old = this.isRtdSuppressed();
        this.suppressRtd = suppressRtd;
        return old;
    }

    private boolean setSuppressRtd(WtRtData rtd) {
        if (this.isRtdSuppressed()) {
            return this.isRtdSuppressed();
        }
        return this.setSuppressRtd(rtd != null && rtd.isSuppress());
    }

    private boolean isRtdSuppressed() {
        return this.suppressRtd;
    }

    private boolean isRtdVisible() {
        return !this.preserveRtd || this.isRtdSuppressed();
    }

    private void appendRtd(String rtd) {
        this.appendRtd(this.getScope(), rtd);
    }

    private boolean isHideRtd(Wom3ElementNode node) {
        return "true".equalsIgnoreCase(node.getAttributeNS(DEFAULT_MWW_NS_PREFIX, "hideRtd"));
    }

    private <T extends Wom3ElementNode> T setHideRtd(T node) {
        node.setAttributeNS(DEFAULT_MWW_NS_PREFIX, "hideRtd", "true");
        return node;
    }

    private Wom3ElementNode genWom(String tag) {
        return (Wom3ElementNode)this.doc.createElementNS("http://sweble.org/schema/wom30", tag);
    }

    private Wom3Element genMww(String type) {
        return (Wom3Element)this.doc.createElementNS(MWW_NS_URI, "mww:" + type);
    }

    private Wom3Attribute attr(String name, String value) {
        Wom3Attribute attr = (Wom3Attribute)this.doc.createAttribute(name);
        attr.setValue(value);
        return attr;
    }

    private Wom3Text text(String text) {
        Wom3ElementNode node = this.genWom("text");
        node.setTextContent(text);
        return (Wom3Text)node;
    }

    private Wom3Rtd rtd(String text) {
        Wom3ElementNode node = this.genWom("rtd");
        node.setTextContent(text);
        return (Wom3Rtd)node;
    }
}

