/*
 * Decompiled with CFR 0.152.
 */
package org.sweble.wom3.swcadapter;

import de.fau.cs.osr.utils.WrappedException;
import org.sweble.wikitext.engine.PageTitle;
import org.sweble.wikitext.engine.config.WikiConfig;
import org.sweble.wikitext.parser.parser.LinkTargetException;
import org.sweble.wom3.Wom3Article;
import org.sweble.wom3.Wom3Articles;
import org.sweble.wom3.Wom3Big;
import org.sweble.wom3.Wom3Blockquote;
import org.sweble.wom3.Wom3Body;
import org.sweble.wom3.Wom3Bold;
import org.sweble.wom3.Wom3Break;
import org.sweble.wom3.Wom3Center;
import org.sweble.wom3.Wom3Cite;
import org.sweble.wom3.Wom3Code;
import org.sweble.wom3.Wom3Comment;
import org.sweble.wom3.Wom3DefinitionList;
import org.sweble.wom3.Wom3DefinitionListDef;
import org.sweble.wom3.Wom3DefinitionListTerm;
import org.sweble.wom3.Wom3Div;
import org.sweble.wom3.Wom3Document;
import org.sweble.wom3.Wom3Element;
import org.sweble.wom3.Wom3ElementNode;
import org.sweble.wom3.Wom3Emphasize;
import org.sweble.wom3.Wom3ExtLink;
import org.sweble.wom3.Wom3Font;
import org.sweble.wom3.Wom3For;
import org.sweble.wom3.Wom3Heading;
import org.sweble.wom3.Wom3HorizontalRule;
import org.sweble.wom3.Wom3Image;
import org.sweble.wom3.Wom3ImageCaption;
import org.sweble.wom3.Wom3IntLink;
import org.sweble.wom3.Wom3Italics;
import org.sweble.wom3.Wom3List;
import org.sweble.wom3.Wom3ListItem;
import org.sweble.wom3.Wom3Node;
import org.sweble.wom3.Wom3Nowiki;
import org.sweble.wom3.Wom3OrderedList;
import org.sweble.wom3.Wom3Paragraph;
import org.sweble.wom3.Wom3Pre;
import org.sweble.wom3.Wom3Redirect;
import org.sweble.wom3.Wom3Ref;
import org.sweble.wom3.Wom3Repl;
import org.sweble.wom3.Wom3Rtd;
import org.sweble.wom3.Wom3Section;
import org.sweble.wom3.Wom3Small;
import org.sweble.wom3.Wom3Span;
import org.sweble.wom3.Wom3Strike;
import org.sweble.wom3.Wom3Strong;
import org.sweble.wom3.Wom3Sub;
import org.sweble.wom3.Wom3Subst;
import org.sweble.wom3.Wom3Sup;
import org.sweble.wom3.Wom3Table;
import org.sweble.wom3.Wom3TableBody;
import org.sweble.wom3.Wom3TableCaption;
import org.sweble.wom3.Wom3TableCell;
import org.sweble.wom3.Wom3TableHeaderCell;
import org.sweble.wom3.Wom3TableRow;
import org.sweble.wom3.Wom3Teletype;
import org.sweble.wom3.Wom3Text;
import org.sweble.wom3.Wom3Title;
import org.sweble.wom3.Wom3Underline;
import org.sweble.wom3.Wom3UnorderedList;
import org.sweble.wom3.impl.Backbone;
import org.sweble.wom3.swcadapter.FixWomRtdBase;
import org.w3c.dom.Node;

public class FixWomRtd
extends FixWomRtdBase {
    private static final String LIST_PREFIXES = "*#:;";
    private final WikiConfig wikiConfig;
    private int inInlineBlock = 0;
    private String curListPrefix = "";
    private boolean inSemiPre;
    private ListTypeEnum inListType;
    private boolean isHtmlListItem = false;

    public FixWomRtd(WikiConfig wikiConfig) {
        this.wikiConfig = wikiConfig;
    }

    public static Wom3Node process(WikiConfig wikiConfig, Wom3Node wom) {
        new FixWomRtd(wikiConfig).go(wom);
        return wom;
    }

    public void visit(Wom3Document document) {
        this.dispatch((Wom3Node)document.getDocumentElement());
    }

    public void visit(Wom3Articles articles) {
        this.iterate((Wom3Node)articles);
    }

    public void visit(Wom3Article article) {
        this.iterate((Wom3Node)article);
    }

    public void visit(Wom3Body body) {
        this.iterate((Wom3Node)body);
    }

    public void visit(Wom3Title title) {
        this.iterate((Wom3Node)title);
    }

    public void visit(Wom3Redirect redirect) {
    }

    public void visit(Wom3Div div) {
        this.restoreHtmlRtd((Wom3ElementNode)div);
    }

    public void visit(Wom3Blockquote bq) {
        this.restoreHtmlRtd((Wom3ElementNode)bq);
    }

    public void visit(Wom3Center center) {
        this.restoreHtmlRtd((Wom3ElementNode)center);
    }

    public void visit(Wom3Span span) {
        this.restoreHtmlRtd((Wom3ElementNode)span);
    }

    public void visit(Wom3Break br) {
        this.restoreHtmlRtd((Wom3ElementNode)br);
    }

    public void visit(Wom3Sub sub) {
        this.restoreHtmlRtd((Wom3ElementNode)sub);
    }

    public void visit(Wom3Sup sup) {
        this.restoreHtmlRtd((Wom3ElementNode)sup);
    }

    public void visit(Wom3Cite cite) {
        this.restoreHtmlRtd((Wom3ElementNode)cite);
    }

    public void visit(Wom3Strong strong) {
        this.restoreHtmlRtd((Wom3ElementNode)strong);
    }

    public void visit(Wom3Emphasize em) {
        this.restoreHtmlRtd((Wom3ElementNode)em);
    }

    public void visit(Wom3Small small) {
        this.restoreHtmlRtd((Wom3ElementNode)small);
    }

    public void visit(Wom3Big big) {
        this.restoreHtmlRtd((Wom3ElementNode)big);
    }

    public void visit(Wom3Font font) {
        this.restoreHtmlRtd((Wom3ElementNode)font);
    }

    public void visit(Wom3Code code) {
        this.restoreHtmlRtd((Wom3ElementNode)code);
    }

    public void visit(Wom3Underline u) {
        this.restoreHtmlRtd((Wom3ElementNode)u);
    }

    public void visit(Wom3Strike strike) {
        this.restoreHtmlRtd((Wom3ElementNode)strike);
    }

    public void visit(Wom3Teletype tt) {
        this.restoreHtmlRtd((Wom3ElementNode)tt);
    }

    private void restoreHtmlRtd(Wom3ElementNode e) {
        if (!this.startsWithRtd((Wom3Node)e)) {
            // empty if block
        }
        this.fixNewlinesBeforeElement(e, false);
        this.iterate((Wom3Node)e);
    }

    public void visit(Wom3HorizontalRule hr) {
        if (!this.startsWithRtd((Wom3Node)hr)) {
            throw new UnsupportedOperationException();
        }
        this.fixNewlinesBeforeElement((Wom3ElementNode)hr, true);
        this.iterate((Wom3Node)hr);
    }

    public void visit(Wom3Bold b) {
        if (!this.startsWithRtd((Wom3Node)b)) {
            throw new UnsupportedOperationException();
        }
        this.fixNewlinesBeforeElement((Wom3ElementNode)b, false);
        this.iterate((Wom3Node)b);
    }

    public void visit(Wom3Italics i) {
        if (!this.startsWithRtd((Wom3Node)i)) {
            throw new UnsupportedOperationException();
        }
        this.fixNewlinesBeforeElement((Wom3ElementNode)i, false);
        this.iterate((Wom3Node)i);
    }

    public void visit(Wom3Text text) {
        String stripped;
        String content = text.getTextContent();
        if (!(text.getParentNode() instanceof Wom3Nowiki) && !(text.getParentNode() instanceof Wom3Pre) && (stripped = this.stripDangerousWhitespace((Wom3Node)text, content)) != content) {
            if (stripped.isEmpty()) {
                Backbone next = text.getNextSibling();
                text.getParentNode().removeChild((Node)text);
                this.continueAfterDelete((Wom3Node)next);
            } else {
                text.setTextContent(stripped);
            }
        }
    }

    public void visit(Wom3Rtd rtd) {
        String content = rtd.getTextContent();
        this.appendWm(content);
    }

    private String stripDangerousWhitespace(Wom3Node node, String text) {
        int newlines = this.getNewlineCount();
        boolean atStartOfP = false;
        if (this.inInlineBlock > 0) {
            atStartOfP = this.isAtStartOfParagraph(node);
            if (newlines > 1 && !atStartOfP) {
                this.removePrecedingNewlines(node, newlines - 1);
                newlines = 1;
            }
            if (newlines > 0 && this.hadSpaceAfterLastNewline()) {
                this.removePrecedingSpace(node);
            }
        }
        Wom3Node last = node;
        String stripped = null;
        int l = text.length();
        int firstNewline = -1;
        boolean hadSpaceSinceNl = false;
        block7: for (int i = 0; i < l; ++i) {
            char ch = text.charAt(i);
            switch (ch) {
                case '\n': {
                    ++newlines;
                    hadSpaceSinceNl = false;
                    if (firstNewline != -1) continue block7;
                    firstNewline = i;
                    continue block7;
                }
                case '\t': 
                case ' ': {
                    hadSpaceSinceNl = true;
                    continue block7;
                }
                default: {
                    if (this.inInlineBlock > 0 && newlines > 1 && !atStartOfP || !this.inSemiPre && newlines > 0 && hadSpaceSinceNl) {
                        int from = firstNewline + 1;
                        int count = i - from;
                        text = text.substring(0, from) + text.substring(i);
                        i -= count;
                        l = text.length();
                        switch (ch) {
                            case '#': 
                            case '*': 
                            case ':': 
                            case ';': {
                                if (hadSpaceSinceNl) break;
                                String checked = text.substring(0, i);
                                if (stripped == null) {
                                    stripped = checked;
                                } else if (!checked.isEmpty()) {
                                    last = this.insertTextAfterNoMerge(last, checked);
                                }
                                this.appendWm(checked);
                                last = this.insertNowikiAfter(last, String.valueOf(ch));
                                text = text.substring(i + 1);
                                l = text.length();
                                i = 0;
                            }
                        }
                    }
                    newlines = 0;
                    firstNewline = -1;
                    hadSpaceSinceNl = false;
                }
            }
        }
        if (stripped == null) {
            this.appendWm(text);
            return text;
        }
        return stripped;
    }

    public void visit(Wom3Nowiki nowiki) {
        if (!this.startsWithRtd((Wom3Node)nowiki)) {
            this.prependRtd((Wom3Node)nowiki, "<" + nowiki.getTagName() + ">");
            this.appendRtd((Wom3Node)nowiki, "</" + nowiki.getTagName() + ">");
        }
        this.fixNewlinesBeforeElement((Wom3ElementNode)nowiki, false);
        for (Wom3Node child : nowiki) {
            if (child instanceof Wom3Text) {
                this.appendWm(child.getTextContent());
                continue;
            }
            this.dispatch(child);
        }
    }

    public void visit(Wom3Comment comment) {
        if (!this.startsWithRtd((Wom3Node)comment)) {
            throw new UnsupportedOperationException();
        }
    }

    public void visit(Wom3Table table) {
        if (!this.startsWithRtd((Wom3Node)table)) {
            // empty if block
        }
        this.fixNewlinesBeforeElement((Wom3ElementNode)table, true);
        this.iterate((Wom3Node)table);
    }

    public void visit(Wom3TableCaption caption) {
        if (!this.startsWithRtd((Wom3Node)caption)) {
            // empty if block
        }
        this.iterate((Wom3Node)caption);
    }

    public void visit(Wom3TableBody body) {
        if (!this.startsWithRtd((Wom3Node)body)) {
            // empty if block
        }
        this.iterate((Wom3Node)body);
    }

    public void visit(Wom3TableRow row) {
        if (!this.startsWithRtd((Wom3Node)row)) {
            // empty if block
        }
        this.iterate((Wom3Node)row);
    }

    public void visit(Wom3TableHeaderCell header) {
        if (!this.startsWithRtd((Wom3Node)header)) {
            // empty if block
        }
        this.iterate((Wom3Node)header);
    }

    public void visit(Wom3TableCell cell) {
        if (!this.startsWithRtd((Wom3Node)cell)) {
            // empty if block
        }
        this.iterate((Wom3Node)cell);
    }

    public void visit(Wom3Section section) {
        this.fixNewlinesBeforeElement((Wom3ElementNode)section, true);
        this.iterate((Wom3Node)section);
    }

    public void visit(Wom3Heading heading) {
        if (!this.startsWithRtd((Wom3Node)heading)) {
            throw new UnsupportedOperationException();
        }
        this.iterate((Wom3Node)heading);
    }

    public void visit(Wom3Paragraph p) {
        Wom3Text text0;
        ++this.inInlineBlock;
        if (this.hasHtmlTagRtd((Wom3Node)p)) {
            if (p.getTopGap() == 0 && p.getBottomGap() == 0) {
                this.fixNewlinesBeforeElement((Wom3ElementNode)p, false);
                this.iterate((Wom3Node)p);
                --this.inInlineBlock;
                return;
            }
            p.removeChild((Node)p.getFirstChild());
            p.removeChild((Node)p.getLastChild());
        }
        int haveNewlines = this.getNewlineCount();
        if (this.isAtPageStart()) {
            if (haveNewlines > 1) {
                this.removePrecedingNewlines((Wom3Node)p, haveNewlines - 1);
            }
        } else if (haveNewlines > 2) {
            this.removePrecedingNewlines((Wom3Node)p, haveNewlines - 2);
        } else if (haveNewlines < 2) {
            int needNewlines = 2;
            Wom3Node pnws = this.getPrecedingNonWsNode((Wom3Node)p);
            if (!(pnws instanceof Wom3Paragraph) && (pnws != null && this.isNonHtmlBlockElement(pnws) || this.isFirstInContainer((Wom3Node)p))) {
                needNewlines = 1;
            }
            if (haveNewlines < needNewlines) {
                this.addPrecedingTextNewlines((Wom3Node)p, needNewlines - haveNewlines);
            }
        }
        if ((text0 = this.getFirstTextNode((Wom3Node)p)) != null) {
            this.assureStartWithEnoughNewlines((Wom3Node)text0, p.getTopGap());
        } else if (p.getTopGap() > 0) {
            this.insertTextBefore((Wom3Node)p.getFirstChild(), this.genNewlines(p.getTopGap()));
        }
        this.iterate((Wom3Node)p);
        --this.inInlineBlock;
    }

    public void visit(Wom3DefinitionList list) {
        this.iterate((Wom3Node)list);
    }

    public void visit(Wom3DefinitionListTerm term) {
        ++this.inInlineBlock;
        this.iterate((Wom3Node)term);
        --this.inInlineBlock;
    }

    public void visit(Wom3DefinitionListDef def) {
        ++this.inInlineBlock;
        this.iterate((Wom3Node)def);
        --this.inInlineBlock;
    }

    public void visit(Wom3OrderedList list) {
        this.processList((Wom3List)list, "#");
    }

    public void visit(Wom3UnorderedList list) {
        this.processList((Wom3List)list, "*");
    }

    private void processList(Wom3List list, String bulletType) {
        this.iterate((Wom3Node)list);
    }

    public void visit(Wom3ListItem li) {
        ++this.inInlineBlock;
        this.iterate((Wom3Node)li);
        --this.inInlineBlock;
    }

    private String gatherAncestorListItemPrefix(Wom3Node li) {
        Wom3Node prev;
        String prefix = "";
        Wom3Node list = li.getParentNode();
        Wom3Node listContainer = list.getParentNode();
        while (listContainer != null && (listContainer instanceof Wom3ListItem || listContainer instanceof Wom3DefinitionListTerm || listContainer instanceof Wom3DefinitionListDef) && (prev = this.getPrecedingNonWsNode(list)) == null) {
            Wom3Rtd rtd0 = this.getFirstRtdNode(listContainer);
            String containerPrefix = rtd0.getTextContent();
            if (rtd0 == null || this.lastIndexOfOneOf(containerPrefix, LIST_PREFIXES) == -1) break;
            prefix = containerPrefix.trim() + prefix;
            li = listContainer;
        }
        return prefix;
    }

    public void visit(Wom3Pre pre) {
        if (!this.startsWithRtd((Wom3Node)pre) && !this.startsWithText((Wom3Node)pre)) {
            throw new UnsupportedOperationException();
        }
        this.fixNewlinesBeforeElement((Wom3ElementNode)pre, false);
        Wom3Nowiki nowiki = this.findFirstChildOfType((Wom3Node)pre, Wom3Nowiki.class);
        if (nowiki == null) {
            this.iterate((Wom3Node)pre);
        } else {
            for (Wom3Node c : pre) {
                if (c == nowiki) continue;
                this.dispatch(c);
            }
        }
    }

    public void visit(Wom3IntLink link) {
        this.fixNewlinesBeforeElement((Wom3ElementNode)link, false);
        if (!this.startsWithRtd((Wom3Node)link)) {
            this.prependRtd((Wom3Node)link, "[[" + link.getTarget());
            Wom3Title title = link.getLinkTitle();
            if (title != null && !this.startsWithRtd((Wom3Node)title)) {
                this.prependRtd((Wom3Node)title, "|");
            }
            this.appendRtd((Wom3Node)link, "]]");
        }
        this.iterate((Wom3Node)link);
    }

    public void visit(Wom3ExtLink link) {
        this.fixNewlinesBeforeElement((Wom3ElementNode)link, false);
        if (!this.startsWithRtd((Wom3Node)link)) {
            throw new UnsupportedOperationException();
        }
        this.iterate((Wom3Node)link);
    }

    public void visit(Wom3Image image) {
        if (!this.startsWithRtd((Wom3Node)image)) {
            throw new UnsupportedOperationException();
        }
        this.fixNewlinesBeforeElement((Wom3ElementNode)image, false);
        this.iterate((Wom3Node)image);
    }

    public void visit(Wom3ImageCaption caption) {
        if (!this.startsWithRtd((Wom3Node)caption)) {
            throw new UnsupportedOperationException();
        }
        this.iterate((Wom3Node)caption);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void visit(Wom3Subst subst) {
        Wom3For for_ = subst.getFor();
        if (!(for_.getFirstChild() instanceof Wom3Element)) throw new InternalError();
        String name = ((Wom3Element)for_.getFirstChild()).getLocalName();
        if (name.equals("intlink")) {
            this.processSubstIntLink(subst);
            return;
        } else if (name.equals("xml-entity-ref")) {
            this.processXmlEntityRef(subst);
            return;
        } else {
            if (!name.equals("xml-char-ref")) throw new InternalError("NYI: " + name);
            this.processXmlCharRef(subst);
        }
    }

    private void processXmlEntityRef(Wom3Subst subst) {
        this.iterate((Wom3Node)subst.getFor());
    }

    private void processXmlCharRef(Wom3Subst subst) {
        this.iterate((Wom3Node)subst.getFor());
    }

    private void processSubstIntLink(Wom3Subst subst) {
        this.fixNewlinesBeforeElement((Wom3ElementNode)subst, false);
        Wom3Repl repl = subst.getRepl();
        if (!repl.hasChildNodes() || !(this.findFirstNonWhitespaceNode((Wom3Node)repl) instanceof Wom3IntLink)) {
            this.unwrapIntlink(subst, repl);
        } else {
            String oldTitle;
            Wom3IntLink replLink = this.findFirstChildOfType((Wom3Node)repl, Wom3IntLink.class);
            Wom3Title replTitle = replLink.getLinkTitle();
            String replTarget = replLink.getTarget();
            Wom3For for_ = subst.getFor();
            Wom3Element forLink = this.findFirstChildOfType((Wom3Node)for_, Wom3Element.class);
            String forTarget = forLink.getAttribute("target");
            String forPrefix = forLink.getAttribute("prefix");
            String forSuffix = forLink.getAttribute("postfix");
            Wom3Title forTitle = this.findFirstChildOfType((Wom3Node)forLink, Wom3Title.class);
            String newTitle = this.stringifyTitle(replTitle, replTarget);
            if (!newTitle.equals(oldTitle = this.stringifyTitle(forPrefix, forTitle, forSuffix, forTarget))) {
                this.unwrapIntlink(subst, repl);
            } else {
                boolean update = false;
                if (!replTarget.equals(forTarget)) {
                    PageTitle forTargetNl;
                    PageTitle replTargetNl;
                    try {
                        replTargetNl = PageTitle.make((WikiConfig)this.wikiConfig, (String)replTarget);
                        forTargetNl = PageTitle.make((WikiConfig)this.wikiConfig, (String)forTarget);
                    }
                    catch (LinkTargetException e) {
                        throw new WrappedException((Throwable)e);
                    }
                    if (!replTargetNl.equals((Object)forTargetNl)) {
                        if (forTitle == null) {
                            this.unwrapIntlink(subst, repl);
                            return;
                        }
                        forLink.setAttribute("target", replTarget);
                        update = true;
                    }
                }
                if (update || this.getFirstRtdNode((Wom3Node)forLink) == null) {
                    this.fixIntLink(forLink, forTarget, replTarget);
                }
                this.iterate((Wom3Node)forLink);
            }
        }
    }

    private void unwrapIntlink(Wom3Subst subst, Wom3Repl repl) {
        Backbone next = subst.getNextSibling();
        this.moveChildrenInFrontOfXRemoveXAndAndProcess((Wom3Node)repl, (Wom3Node)subst);
        this.continueAfterDelete((Wom3Node)next);
    }

    protected String stringifyTitle(Wom3Title replTitle, String target) {
        return replTitle == null ? target : this.stringifyChildren((Wom3Node)replTitle);
    }

    protected String stringifyTitle(String prefix, Wom3Title title, String postfix, String target) {
        String t;
        String string = t = title == null ? target : this.stringifyChildren((Wom3Node)title);
        if (prefix != null && !prefix.isEmpty()) {
            t = prefix + t;
        }
        if (postfix != null && !postfix.isEmpty()) {
            t = t + postfix;
        }
        return t;
    }

    private void fixIntLink(Wom3Element link, String oldTarget, String newTarget) {
        Wom3Rtd rtd0;
        String prefix = link.getAttribute("prefix");
        String suffix = link.getAttribute("postfix");
        String rtd0Str = "[[" + newTarget;
        if (prefix != null && !prefix.isEmpty()) {
            rtd0Str = prefix + rtd0Str;
        }
        String rtd1Str = "]]";
        if (suffix != null && !suffix.isEmpty()) {
            rtd1Str = rtd1Str + suffix;
        }
        if ((rtd0 = this.getFirstRtdNode((Wom3Node)link)) != null) {
            Wom3Rtd rtd1 = this.getLastRtdNode((Wom3Node)link);
            if (rtd0 == rtd1) {
                rtd0Str = rtd0Str + rtd1Str;
            } else {
                rtd1.setTextContent(rtd1Str);
            }
            rtd0.setTextContent(rtd0Str);
        } else {
            this.prependRtd((Wom3Node)link, rtd0Str);
            this.appendRtd((Wom3Node)link, rtd1Str);
        }
        Wom3Title title = this.findFirstChildOfType((Wom3Node)link, Wom3Title.class);
        if (title != null && !this.startsWithRtd((Wom3Node)title)) {
            this.prependRtd((Wom3Node)title, "|");
        }
    }

    public void visit(Wom3Element e) {
        String name = e.getLocalName();
        if (name.equals("tagext")) {
            this.processTagExt(e);
        } else if (name.equals("transclusion")) {
            this.processTransclusion(e);
        } else if (name.equals("xml-entity-ref")) {
            this.processXmlEntityRef(e);
        } else if (name.equals("xmlelement")) {
            this.processXmlElement(e);
        }
    }

    private void processXmlElement(Wom3Element e) {
        this.iterate((Wom3Node)e);
    }

    private void processXmlEntityRef(Wom3Element e) {
        this.iterate((Wom3Node)e);
    }

    private void processTagExt(Wom3Element e) {
        this.appendWm("<" + e.getAttribute("name") + "/>");
    }

    private void processTransclusion(Wom3Element e) {
        this.appendWm("{{N|...}}");
    }

    public void visit(Wom3Ref ref) {
        this.iterate((Wom3Node)ref);
    }

    private void fixNewlinesBeforeElement(Wom3ElementNode e, boolean needNewline) {
        int newlines = this.getNewlineCount();
        int allowed = 2;
        int required = 0;
        if (needNewline && !this.isAtPageStart()) {
            ++required;
        }
        if (this.isAtStartOfParagraph((Wom3Node)e)) {
            return;
        }
        if (this.inInlineBlock > 0 && !needNewline) {
            --allowed;
        } else {
            Wom3Paragraph p = this.getPrecedingParagraph((Wom3Node)e);
            if (p != null && p.getBottomGap() > 0) {
                required = allowed += p.getBottomGap();
            }
        }
        if (newlines > allowed) {
            this.removePrecedingNewlines((Wom3Node)e, newlines - allowed);
        } else if (newlines < required) {
            this.insertTextBeforeAfterProcessing((Wom3Node)e, this.genNewlines(required - newlines));
        }
    }

    public static enum ListTypeEnum {
        HTML_LIST,
        PRERENDER;

    }
}

