/*
 * Decompiled with CFR 0.152.
 */
package org.sweble.wom3.swcadapter;

import de.fau.cs.osr.utils.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.sweble.wom3.Wom3Attribute;
import org.sweble.wom3.Wom3Comment;
import org.sweble.wom3.Wom3Document;
import org.sweble.wom3.Wom3Element;
import org.sweble.wom3.Wom3Node;
import org.sweble.wom3.Wom3Nowiki;
import org.sweble.wom3.Wom3Paragraph;
import org.sweble.wom3.Wom3Repl;
import org.sweble.wom3.Wom3Rtd;
import org.sweble.wom3.Wom3Text;
import org.sweble.wom3.Wom3XmlText;
import org.sweble.wom3.impl.Backbone;
import org.sweble.wom3.swcadapter.ElementProperties;
import org.sweble.wom3.swcadapter.utils.AnalyzingStringBuffer;
import org.sweble.wom3.util.Wom3Visitor;
import org.w3c.dom.Node;

public class FixWomRtdBase
extends Wom3Visitor {
    private final AnalyzingStringBuffer wm = new AnalyzingStringBuffer();
    private static Map<String, ElementProperties> elements;
    private static Set<String> blockElementSet;
    private Wom3Document doc;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FixWomRtdBase() {
        Class<FixWomRtdBase> clazz = FixWomRtdBase.class;
        synchronized (FixWomRtdBase.class) {
            if (elements == null) {
                elements = new HashMap<String, ElementProperties>();
                for (ElementProperties e : ElementProperties.values()) {
                    elements.put(e.toString(), e);
                }
            }
            if (blockElementSet == null) {
                blockElementSet = new HashSet<String>();
                blockElementSet.add("address");
                blockElementSet.add("blockquote");
                blockElementSet.add("center");
                blockElementSet.add("div");
                blockElementSet.add("dl");
                blockElementSet.add("section");
                blockElementSet.add("hr");
                blockElementSet.add("ol");
                blockElementSet.add("p");
                blockElementSet.add("pre");
                blockElementSet.add("table");
                blockElementSet.add("ul");
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    protected static ElementProperties getInfo(String tagName) {
        return elements.get(tagName);
    }

    protected boolean before(Wom3Node node) {
        this.doc = node.getOwnerDocument();
        if (this.doc == null) {
            this.doc = (Wom3Document)node;
        }
        return super.before((Object)node);
    }

    protected Object after(Wom3Node node, Object result) {
        return super.after((Object)node, result);
    }

    public String womToWmFast(Wom3Node wom) {
        StringBuilder sb = new StringBuilder();
        this.restoreWmFromWomFast(sb, wom);
        return sb.toString();
    }

    private void restoreWmFromWomFast(StringBuilder sb, Wom3Node wom) {
        if (wom instanceof Wom3Rtd || wom instanceof Wom3Text) {
            sb.append(wom.getTextContent());
            return;
        }
        if (wom instanceof Wom3Repl || wom instanceof Wom3Comment) {
            return;
        }
        if (wom instanceof Wom3Element) {
            Wom3Element element = (Wom3Element)wom;
            String name = element.getLocalName();
            if (name.equals("tagext")) {
                sb.append("<" + element.getAttribute("name") + "/>");
                return;
            }
            if (name.equals("transclusion")) {
                sb.append("{{N|...}}");
                return;
            }
        }
        for (Wom3Node c : wom) {
            this.restoreWmFromWomFast(sb, c);
        }
    }

    protected void appendWm(String text) {
        this.wm.append(text);
    }

    protected void discardWm(int wmPosBeforeChildren) {
        this.wm.discard(wmPosBeforeChildren);
    }

    private void rollbackWm(int count) {
        this.wm.rollback(count);
    }

    protected String stringifyChildren(Wom3Node node) {
        if (node == null) {
            throw new NullPointerException();
        }
        StringBuilder b = new StringBuilder();
        for (Backbone c = node.getFirstChild(); c != null; c = c.getNextSibling()) {
            this.stringify(b, (Wom3Node)c);
        }
        return b.toString();
    }

    private void stringify(StringBuilder b, Wom3Node node) {
        if (node == null) {
            throw new NullPointerException();
        }
        if (node instanceof Wom3Rtd) {
            return;
        }
        boolean isText = node instanceof Wom3Text;
        if (!isText) {
            b.append('<');
            b.append(node.getNodeName());
            this.stringifyAttrs(b, node.getWomAttributes());
            b.append('>');
            for (Backbone c = node.getFirstChild(); c != null; c = c.getNextSibling()) {
                this.stringify(b, (Wom3Node)c);
            }
            b.append("</");
            b.append(node.getNodeName());
            b.append('>');
        } else {
            String text = node.getTextContent();
            if (text != null) {
                b.append(text);
            }
        }
    }

    private void stringifyAttrs(StringBuilder b, Collection<Wom3Attribute> attributes) {
        if (attributes.isEmpty()) {
            return;
        }
        ArrayList<Wom3Attribute> attrs = new ArrayList<Wom3Attribute>(attributes);
        Collections.sort(attrs, new Comparator<Wom3Attribute>(){

            @Override
            public int compare(Wom3Attribute o1, Wom3Attribute o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        for (Wom3Attribute attr : attrs) {
            b.append(' ');
            b.append(attr.getName());
            b.append("=\"");
            b.append(attr.getValue());
            b.append('\"');
        }
    }

    protected int lastIndexOfOneOf(String haystack, String needleSet) {
        int len = haystack.length();
        for (int i = len - 1; i >= 0; --i) {
            char ch = haystack.charAt(i);
            if (needleSet.indexOf(ch) == -1) continue;
            return i;
        }
        return -1;
    }

    protected Wom3Text text(String text) {
        Wom3Text node = (Wom3Text)this.doc.createElementNS("http://sweble.org/schema/wom30", "text");
        node.setTextContent(text);
        return node;
    }

    protected void insertTextBefore(Wom3Node n, String text) {
        Backbone prev = n.getPreviousSibling();
        if (prev instanceof Wom3Text) {
            prev.setTextContent(prev.getTextContent() + text);
        } else {
            n.getParentNode().insertBefore((Node)this.text(text), (Node)n);
        }
    }

    protected void insertTextBeforeAfterProcessing(Wom3Node n, String text) {
        this.insertTextBefore(n, text);
        this.appendWm(text);
    }

    protected void prependText(Wom3Node n, String text) {
        Backbone first = n.getFirstChild();
        if (first instanceof Wom3Text) {
            first.setTextContent(text + first.getTextContent());
        } else {
            this.prependNode(n, (Wom3Node)this.text(text));
        }
    }

    protected void appendText(Wom3Node n, String text) {
        Backbone last = n.getLastChild();
        if (last instanceof Wom3Text) {
            last.setTextContent(last.getTextContent() + text);
        } else {
            n.appendChild((Node)this.text(text));
        }
    }

    protected Wom3Node insertTextAfterNoMerge(Wom3Node n, String text) {
        Backbone next = n.getNextSibling();
        Wom3Text newText = this.text(text);
        if (next != null) {
            n.getParentNode().insertBefore((Node)newText, (Node)next);
        } else {
            n.getParentNode().appendChild((Node)newText);
        }
        return newText;
    }

    protected Wom3Nowiki nowiki(String text) {
        Wom3Nowiki node = (Wom3Nowiki)this.doc.createElementNS("http://sweble.org/schema/wom30", "nowiki");
        node.appendChild((Node)this.text(text));
        return node;
    }

    protected Wom3Node insertNowikiAfter(Wom3Node n, String text) {
        if (!(n instanceof Wom3Nowiki)) {
            Backbone next = n.getNextSibling();
            Wom3Nowiki newNowiki = this.nowiki(text);
            if (next != null) {
                n.getParentNode().insertBefore((Node)newNowiki, (Node)next);
            } else {
                n.getParentNode().appendChild((Node)newNowiki);
            }
            return newNowiki;
        }
        Wom3Nowiki newNowiki = (Wom3Nowiki)n;
        n.setTextContent(n.getTextContent() + text);
        return newNowiki;
    }

    protected Wom3Rtd rtd(String text) {
        Wom3Rtd node = (Wom3Rtd)this.doc.createElementNS("http://sweble.org/schema/wom30", "rtd");
        node.setTextContent(text);
        return node;
    }

    protected void insertRtdBefore(Wom3Node n, String rtd) {
        Backbone prev = n.getPreviousSibling();
        if (prev instanceof Wom3Rtd) {
            prev.setTextContent(prev.getTextContent() + rtd);
        } else {
            n.getParentNode().insertBefore((Node)this.rtd(rtd), (Node)n);
        }
    }

    protected Wom3Rtd prependRtd(Wom3Node n, String rtd) {
        Backbone first = n.getFirstChild();
        if (first instanceof Wom3Rtd) {
            first.setTextContent(rtd + first.getTextContent());
            return (Wom3Rtd)first;
        }
        Wom3Rtd rtdNode = this.rtd(rtd);
        this.prependNode(n, (Wom3Node)rtdNode);
        return rtdNode;
    }

    protected void appendRtd(Wom3Node n, String rtd) {
        Backbone last = n.getLastChild();
        if (last instanceof Wom3Rtd) {
            last.setTextContent(last.getTextContent() + rtd);
        } else {
            n.appendChild((Node)this.rtd(rtd));
        }
    }

    protected void appendRtdAfterProcessing(Wom3Node node, String newlines) {
        this.appendRtd(node, newlines);
        this.appendWm(newlines);
    }

    protected void prependNode(Wom3Node parent, Wom3Node child) {
        Backbone first = parent.getFirstChild();
        if (first != null) {
            parent.insertBefore((Node)child, (Node)first);
        } else {
            parent.appendChild((Node)child);
        }
    }

    protected void assureStartWithEnoughNewlines(Wom3Node n, int topGap) {
        String text = n.getTextContent();
        int len = text.length();
        int count = 0;
        block7: for (int i = 0; i < len; ++i) {
            switch (text.charAt(i)) {
                case '\n': {
                    if (++count <= topGap) continue block7;
                    int to1 = i++;
                    block8: while (i < len) {
                        switch (text.charAt(i)) {
                            case '\t': 
                            case '\n': 
                            case ' ': {
                                break;
                            }
                            default: {
                                break block8;
                            }
                        }
                        ++i;
                    }
                    int from2 = i;
                    n.setTextContent(text.substring(0, to1) + text.substring(from2));
                    return;
                }
                case '\t': 
                case ' ': {
                    continue block7;
                }
            }
        }
        if (count < topGap) {
            n.setTextContent(this.genNewlines(topGap - count) + text);
        }
    }

    protected void addPrecedingTextNewlines(Wom3Node current, int count) {
        String missing = this.genNewlines(count);
        this.insertTextBefore(current, missing);
        this.appendWm(missing);
    }

    protected void removePrecedingNewlines(Wom3Node current, int count) {
        if (count <= 0) {
            throw new IllegalArgumentException();
        }
        int rollback = 0;
        Wom3Node n = current;
        while (true) {
            Wom3Node p;
            if (!((p = (n = this.toPreviousXmlTextInDocumentOrder(n)).getParentNode()) instanceof Wom3Text) && !(p instanceof Wom3Rtd)) {
                continue;
            }
            String text = n.getTextContent();
            int l = text.length();
            int i = l - 1;
            while (i >= 0) {
                char ch = text.charAt(i);
                switch (ch) {
                    case '\n': {
                        if (--count > 0) break;
                        if (i == 0) {
                            p.getParentNode().removeChild((Node)p);
                        } else {
                            ((Wom3XmlText)n).deleteData(i, l - i);
                        }
                        this.rollbackWm(rollback + 1);
                        return;
                    }
                    case '\t': 
                    case ' ': {
                        break;
                    }
                    default: {
                        throw new RuntimeException("Should not happen");
                    }
                }
                --i;
                ++rollback;
            }
            p.getParentNode().removeChild((Node)p);
        }
    }

    protected void moveChildrenInFrontOfXRemoveXAndAndProcess(Wom3Node container, Wom3Node x) {
        Wom3Node parent = x.getParentNode();
        Backbone first = container.getFirstChild();
        Backbone last = container.getLastChild();
        Backbone c = first;
        while (c != null) {
            Backbone n = c.getNextSibling();
            container.removeChild((Node)c);
            parent.insertBefore((Node)c, (Node)x);
            c = n;
        }
        parent.removeChild((Node)x);
        if (first != null) {
            c = first;
            while (true) {
                this.dispatch((Wom3Node)c);
                if (c == last) break;
                c = c.getNextSibling();
            }
        }
    }

    protected void clearChildren(Wom3Element n) {
        for (Backbone c = n.getFirstChild(); c != null; c = c.getNextSibling()) {
            Backbone remove = c;
            n.removeChild((Node)remove);
        }
    }

    protected void removePrecedingSpace(Wom3Node node) {
        throw new UnsupportedOperationException();
    }

    protected String genNewlines(int n) {
        return StringUtils.strrep((char)'\n', (int)n);
    }

    protected int getNewlineCount() {
        return this.wm.newlineCount();
    }

    protected boolean isAtPageStart() {
        return this.wm.noContentYet();
    }

    protected boolean hadSpaceAfterLastNewline() {
        return this.wm.hadSpaceAfterLastNewline();
    }

    protected int countNewlinesSince(int wmPosBeforeListItem) {
        return this.wm.countNewlinesSince(wmPosBeforeListItem);
    }

    protected int getWmPos() {
        return this.wm.length();
    }

    private Wom3XmlText toPreviousXmlTextInDocumentOrder(Wom3Node n) {
        while (true) {
            Backbone p;
            if (n == null) {
                System.err.println();
            }
            if ((p = n.getPreviousSibling()) == null) {
                n = n.getParentNode();
                continue;
            }
            while (p.hasChildNodes()) {
                p = p.getLastChild();
            }
            if (p.getNodeType() == 3) {
                return (Wom3XmlText)p;
            }
            n = p;
        }
    }

    protected <T extends Wom3Node> T findFirstChildOfType(Wom3Node container, Class<T> type) {
        for (Backbone c = container.getFirstChild(); c != null; c = c.getNextSibling()) {
            if (!type.isInstance(c)) continue;
            Backbone tmp = c;
            return (T)tmp;
        }
        return null;
    }

    protected <T extends Wom3Node> T findLastChildOfType(Wom3Node container, Class<T> type) {
        for (Backbone c = container.getLastChild(); c != null; c = c.getPreviousSibling()) {
            if (!type.isInstance(c)) continue;
            Backbone tmp = c;
            return (T)tmp;
        }
        return null;
    }

    protected boolean hasHtmlTagRtd(Wom3Node n) {
        Wom3Rtd rtd = this.getFirstRtdNode(n);
        if (rtd == null) {
            return false;
        }
        String text = rtd.getTextContent();
        if (text.length() < 3) {
            return false;
        }
        if (text.charAt(0) != '<') {
            return false;
        }
        return text.lastIndexOf(62) != -1;
    }

    protected Wom3Rtd getFirstRtdNode(Wom3Node parent) {
        for (Backbone n = parent.getFirstChild(); n != null; n = n.getNextSibling()) {
            if (n instanceof Wom3Rtd) {
                return (Wom3Rtd)n;
            }
            if (n instanceof Wom3Comment || this.isElementContentWhitespace((Wom3Node)n)) continue;
            return null;
        }
        return null;
    }

    protected Wom3Text getFirstTextNode(Wom3Node parent) {
        for (Backbone n = parent.getFirstChild(); n != null; n = n.getNextSibling()) {
            if (n instanceof Wom3Text) {
                return (Wom3Text)n;
            }
            if (n instanceof Wom3Comment || this.isElementContentWhitespace((Wom3Node)n)) continue;
            return null;
        }
        return null;
    }

    protected Wom3Rtd getLastRtdNode(Wom3Node parent) {
        for (Backbone n = parent.getLastChild(); n != null; n = n.getPreviousSibling()) {
            if (n instanceof Wom3Rtd) {
                return (Wom3Rtd)n;
            }
            if (n instanceof Wom3Comment || this.isElementContentWhitespace((Wom3Node)n)) continue;
            return null;
        }
        return null;
    }

    protected Wom3Node findFirstNonWhitespaceNode(Wom3Node parent) {
        for (Backbone n = parent.getFirstChild(); n != null; n = n.getNextSibling()) {
            if (this.isElementContentWhitespace((Wom3Node)n)) continue;
            return n;
        }
        return null;
    }

    protected boolean isElementContentWhitespace(Wom3Node n) {
        return n instanceof Wom3XmlText && StringUtils.isWhitespace((String)((Wom3XmlText)n).getTextContent());
    }

    protected boolean isAtStartOfParagraph(Wom3Node node) {
        Backbone prev;
        while ((prev = node.getPreviousSibling()) != null) {
            if (!(prev instanceof Wom3Rtd || prev instanceof Wom3Comment || this.isTextWhitespace((Wom3Node)prev))) {
                return false;
            }
            node = prev;
        }
        Wom3Node p = node.getParentNode();
        return p instanceof Wom3Paragraph;
    }

    protected Wom3Paragraph getPrecedingParagraph(Wom3Node n) {
        for (Backbone prev = n.getPreviousSibling(); prev != null; prev = prev.getPreviousSibling()) {
            if (prev instanceof Wom3Paragraph) {
                return (Wom3Paragraph)prev;
            }
            if (!(prev instanceof Wom3Rtd) && !(prev instanceof Wom3Comment) && !this.isTextWhitespace((Wom3Node)prev)) break;
        }
        return null;
    }

    protected boolean isFirstInContainer(Wom3Node n) {
        for (Backbone prev = n.getPreviousSibling(); prev != null; prev = prev.getPreviousSibling()) {
            if (prev instanceof Wom3Rtd || prev instanceof Wom3Comment || this.isTextWhitespace((Wom3Node)prev)) continue;
            return false;
        }
        return true;
    }

    protected Wom3Node getPrecedingNonWsNode(Wom3Node n) {
        for (Backbone prev = n.getPreviousSibling(); prev != null; prev = prev.getPreviousSibling()) {
            if (prev instanceof Wom3Rtd || prev instanceof Wom3Comment || this.isTextWhitespace((Wom3Node)prev)) continue;
            return prev;
        }
        return null;
    }

    protected boolean isNonHtmlBlockElement(Wom3Node pnws) {
        return blockElementSet.contains(pnws.getNodeName()) && !this.hasHtmlTagRtd(pnws);
    }

    protected boolean isTextWhitespace(Wom3Node n) {
        return n instanceof Wom3Text && StringUtils.isWhitespace((String)n.getTextContent());
    }

    protected boolean startsWithRtd(Wom3Node n) {
        for (Wom3Node c : n) {
            if (c instanceof Wom3Rtd) {
                return true;
            }
            if (c instanceof Wom3Text || c instanceof Wom3Comment || this.isElementContentWhitespace(c)) continue;
            return false;
        }
        return false;
    }

    protected boolean startsWithText(Wom3Node n) {
        for (Wom3Node c : n) {
            if (c instanceof Wom3Text) {
                return true;
            }
            if (c instanceof Wom3Comment || this.isElementContentWhitespace(c)) continue;
            return false;
        }
        return false;
    }
}

