/*
 * Decompiled with CFR 0.152.
 */
package org.sweble.wom3.swcadapter.utils;

public class AnalyzingStringBuffer {
    private final StringBuffer sb;
    private boolean onlyWhitespaceSoFar = true;
    private int newlinesSinceLastNonWhitespace = 0;

    public AnalyzingStringBuffer() {
        this.sb = new StringBuffer();
    }

    public AnalyzingStringBuffer(int capacity) {
        this.sb = new StringBuffer(capacity);
    }

    public AnalyzingStringBuffer(String str) {
        this.sb = new StringBuffer(str);
    }

    public AnalyzingStringBuffer(CharSequence seq) {
        this.sb = new StringBuffer(seq);
    }

    public int length() {
        return this.sb.length();
    }

    public char charAt(int index) {
        return this.sb.charAt(index);
    }

    public StringBuffer append(String str) {
        this.checkString(str);
        return this.sb.append(str);
    }

    public void discard(int wmPosBeforeChildren) {
        this.sb.delete(wmPosBeforeChildren, this.sb.length());
        this.recountNewlinesSinceLastNonWhitespace();
    }

    public void rollback(int count) {
        int length = this.sb.length();
        this.sb.delete(length - count, length);
        this.recountNewlinesSinceLastNonWhitespace();
    }

    public String toString() {
        return this.sb.toString();
    }

    public int newlineCount() {
        return this.newlinesSinceLastNonWhitespace;
    }

    public boolean hadNewline() {
        return this.newlineCount() > 0;
    }

    public boolean noContentYet() {
        return this.onlyWhitespaceSoFar;
    }

    public boolean hadSpaceAfterLastNewline() {
        int l = this.sb.length() - 1;
        if (l < 0) {
            throw new RuntimeException("Should not happen!");
        }
        switch (this.sb.charAt(l)) {
            case '\t': 
            case ' ': {
                return true;
            }
            case '\n': {
                return false;
            }
        }
        throw new RuntimeException("Should not happen!");
    }

    public int countNewlinesSince(int wmPosBeforeListItem) {
        int count = 0;
        int length = this.sb.length();
        for (int i = wmPosBeforeListItem; i < length; ++i) {
            if (this.sb.charAt(i) != '\n') continue;
            ++count;
        }
        return count;
    }

    private void recountNewlinesSinceLastNonWhitespace() {
        this.newlinesSinceLastNonWhitespace = 0;
        block4: for (int i = this.sb.length() - 1; i >= 0; --i) {
            char ch = this.sb.charAt(i);
            switch (ch) {
                case '\n': {
                    ++this.newlinesSinceLastNonWhitespace;
                    continue block4;
                }
                case '\t': 
                case ' ': {
                    continue block4;
                }
                default: {
                    return;
                }
            }
        }
        this.onlyWhitespaceSoFar = true;
    }

    protected void checkString(String str) {
        int len = str.length();
        block4: for (int i = 0; i < len; ++i) {
            char ch = str.charAt(i);
            switch (ch) {
                case '\n': {
                    ++this.newlinesSinceLastNonWhitespace;
                    continue block4;
                }
                case '\t': 
                case ' ': {
                    continue block4;
                }
                default: {
                    this.onlyWhitespaceSoFar = false;
                    this.newlinesSinceLastNonWhitespace = 0;
                }
            }
        }
    }
}

