/*
 * Decompiled with CFR 0.152.
 */
package org.sweble.wom3.swcadapter.utils;

import de.fau.cs.osr.utils.FileContent;
import de.fau.cs.osr.utils.TestResourcesFixture;
import java.io.File;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.joda.time.DateTime;
import org.sweble.wikitext.engine.ExpansionCallback;
import org.sweble.wikitext.engine.PageId;
import org.sweble.wikitext.engine.config.WikiConfig;
import org.sweble.wikitext.engine.nodes.EngProcessedPage;
import org.sweble.wikitext.engine.utils.WtEngineToolbox;
import org.sweble.wikitext.parser.nodes.WtNode;
import org.sweble.wom3.Wom3Document;
import org.sweble.wom3.Wom3ElementNode;
import org.sweble.wom3.Wom3Node;
import org.sweble.wom3.swcadapter.AstToWomConverter;
import org.sweble.wom3.util.Wom3Toolbox;
import org.w3c.dom.Node;

public class WtWom3Toolbox
extends WtEngineToolbox {
    public static final String WOM_NS_DEFAULT_PREFIX = "wom";

    public Artifacts wmToWom(String wmPath) throws Exception {
        File wmFile = TestResourcesFixture.resourceNameToFile(((Object)((Object)this)).getClass(), (String)wmPath);
        String title = FilenameUtils.getBaseName((String)wmFile.getName());
        PageId pageId = this.makePageId(title);
        return this.wmToWom(wmFile, pageId);
    }

    public Artifacts wmToWom(File wmFile) throws Exception {
        String title = FilenameUtils.getBaseName((String)wmFile.getName());
        PageId pageId = this.makePageId(title);
        return this.wmToWom(wmFile, pageId);
    }

    public Artifacts wmToWom(File inputFile, PageId pageId) throws Exception {
        FileContent inputFileContent = new FileContent(inputFile);
        return this.wmToWom(inputFile, inputFileContent.getContent(), pageId);
    }

    public Artifacts wmToWom(File inputFile, String wikitext, PageId pageId) throws Exception {
        WtEngineToolbox.TestExpansionCallback expCallback = new WtEngineToolbox.TestExpansionCallback();
        return this.wmToWom(inputFile, wikitext, pageId, (ExpansionCallback)expCallback);
    }

    public Artifacts wmToWom(File inputFile, PageId pageId, ExpansionCallback callback) throws Exception {
        FileContent inputFileContent = new FileContent(inputFile);
        return this.wmToWom(inputFile, inputFileContent.getContent(), pageId, callback);
    }

    public Artifacts wmToWom(File inputFile, String wikitext, PageId pageId, ExpansionCallback callback) throws Exception {
        Artifacts a = new Artifacts();
        a.wmFile = inputFile;
        a.pageId = pageId;
        a.wm = wikitext;
        a.ast = this.wmToAst(pageId, a.wm, callback);
        a.womDoc = this.astToWom(pageId, a.ast);
        return a;
    }

    public Artifacts astToWom(EngProcessedPage ast, PageId pageId, ExpansionCallback callback) throws Exception {
        Artifacts a = new Artifacts();
        a.wmFile = null;
        a.pageId = pageId;
        a.wm = null;
        a.ast = ast;
        a.womDoc = this.astToWom(pageId, a.ast);
        return a;
    }

    public Wom3Document astToWom(PageId pageId, EngProcessedPage ast) {
        Wom3Document womDoc = AstToWomConverter.convert((WikiConfig)this.getWikiConfig(), pageId.getTitle(), "Mr. Tester", DateTime.parse((String)"2012-12-07T12:15:30.000+01:00"), (WtNode)ast.getPage());
        return womDoc;
    }

    public String wmToWomXml(PageId pageId, String wm) throws Exception {
        return Wom3Toolbox.printWom((Wom3Node)this.astToWom(pageId, this.wmToAst(pageId, wm)));
    }

    public static Wom3Document wrapMultipleArticles(Artifacts afs) {
        Wom3Document womDoc = Wom3Toolbox.createDocument((String)"articles");
        Wom3ElementNode articles = womDoc.getDocumentElement();
        Wom3ElementNode article = afs.womDoc.getDocumentElement();
        womDoc.adoptNode((Node)article);
        articles.appendChild((Node)article);
        return womDoc;
    }

    public static Wom3Document wrapMultipleArticles(Map<String, Artifacts> afs) {
        Wom3Document womDoc = Wom3Toolbox.createDocument((String)"articles");
        Wom3ElementNode articles = womDoc.getDocumentElement();
        for (Artifacts a : afs.values()) {
            Wom3ElementNode article = a.womDoc.getDocumentElement();
            womDoc.adoptNode((Node)article);
            articles.appendChild((Node)article);
        }
        return womDoc;
    }

    public static final class Artifacts {
        public File wmFile;
        public PageId pageId;
        public String wm;
        public EngProcessedPage ast;
        public Wom3Document womDoc;
    }
}

