/*
 * Decompiled with CFR 0.152.
 */
package org.sweble.wikitext.parser;

import de.fau.cs.osr.ptk.common.Warning;
import de.fau.cs.osr.ptk.common.ast.Span;

public abstract class WikitextWarning
extends Warning {
    private static final long serialVersionUID = 1L;
    protected final WarningSeverity severity;

    public WikitextWarning(Span span, WarningSeverity severity, String origin, String message) {
        super(span, origin, message);
        this.severity = severity;
    }

    public WikitextWarning(Span span, WarningSeverity severity, Class<?> origin, String message) {
        super(span, origin, message);
        this.severity = severity;
    }

    public WarningSeverity getSeverity() {
        return this.severity;
    }

    public String toString() {
        String span = this.spanToString();
        String message = this.messageToString();
        String severity = this.severityToString();
        return "Warning (" + severity + "): " + span + " : " + message;
    }

    protected String severityToString() {
        String severity = "-";
        if (this.getSeverity() != null) {
            severity = this.getSeverity().toString().toLowerCase();
        }
        return severity;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.severity == null ? 0 : this.severity.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        WikitextWarning other = (WikitextWarning)((Object)obj);
        return this.severity == other.severity;
    }

    public static enum WarningSeverity {
        NONE{

            @Override
            public int getLevel() {
                return 0;
            }
        }
        ,
        INFORMATIVE{

            @Override
            public int getLevel() {
                return 5;
            }
        }
        ,
        NORMAL{

            @Override
            public int getLevel() {
                return 10;
            }
        }
        ,
        FATAL{

            @Override
            public int getLevel() {
                return 100;
            }
        };


        public abstract int getLevel();
    }
}

