/*
 * Decompiled with CFR 0.152.
 */
package org.sweble.wikitext.parser.nodes;

import de.fau.cs.osr.ptk.common.ast.AstNodeList;
import de.fau.cs.osr.ptk.common.ast.AstNodePropertyIterator;
import java.io.IOException;
import java.util.Iterator;
import org.sweble.wikitext.parser.WtRtData;
import org.sweble.wikitext.parser.nodes.WtEmptyImmutableNode;
import org.sweble.wikitext.parser.nodes.WtNode;
import org.sweble.wikitext.parser.nodes.WtNodeList;

public interface WtContentNode
extends WtNodeList {

    public static abstract class WtContentNodeImpl
    extends WtNodeList.WtNodeListImpl
    implements WtContentNode {
        private static final long serialVersionUID = 3407356901471138122L;
        private WtRtData rtd = null;

        protected WtContentNodeImpl() {
        }

        protected WtContentNodeImpl(WtNodeList content) {
            super(content);
        }

        @Override
        public void setRtd(WtRtData rtd) {
            if (rtd != null && rtd.size() != 2) {
                throw new IllegalArgumentException();
            }
            this.rtd = rtd;
        }

        @Override
        public void setRtd(Object ... glue) {
            this.rtd = new WtRtData(2, glue);
        }

        @Override
        public void setRtd(String ... glue) {
            this.rtd = new WtRtData(2, glue);
        }

        @Override
        public WtRtData getRtd() {
            return this.rtd;
        }

        @Override
        public void clearRtd() {
            this.rtd = null;
        }

        @Override
        public void suppressRtd() {
            this.rtd = WtRtData.SUPPRESS;
        }

        public int getPropertyCount() {
            return 1;
        }

        public AstNodePropertyIterator propertyIterator() {
            return new WtContentNodePropertyIterator();
        }

        public void toString(Appendable out) throws IOException {
            out.append(this.getNodeName());
            out.append('[');
            Iterator i = this.iterator();
            while (i.hasNext()) {
                ((WtNode)i.next()).toString(out);
                if (!i.hasNext()) continue;
                out.append(", ");
            }
            out.append(']');
        }

        public class WtContentNodePropertyIterator
        extends AstNodePropertyIterator {
            protected int getPropertyCount() {
                return WtContentNodeImpl.this.getPropertyCount();
            }

            protected String getName(int index) {
                switch (index) {
                    case 0: {
                        return "rtd";
                    }
                }
                throw new IndexOutOfBoundsException();
            }

            protected Object getValue(int index) {
                switch (index) {
                    case 0: {
                        return WtContentNodeImpl.this.getRtd();
                    }
                }
                throw new IndexOutOfBoundsException();
            }

            protected Object setValue(int index, Object value) {
                switch (index) {
                    case 0: {
                        WtRtData old = WtContentNodeImpl.this.getRtd();
                        WtContentNodeImpl.this.setRtd((WtRtData)((Object)value));
                        return old;
                    }
                }
                throw new IndexOutOfBoundsException();
            }
        }
    }

    public static abstract class WtEmptyContentNode
    extends WtEmptyImmutableNode
    implements WtContentNode {
        private static final long serialVersionUID = 2465445739660029292L;

        protected WtEmptyContentNode() {
        }

        @Override
        public abstract int getNodeType();

        @Override
        public abstract String getNodeName();

        public void exchange(AstNodeList<WtNode> other) {
            throw new UnsupportedOperationException(this.genMsg());
        }

        @Override
        public boolean indicatesAbsence() {
            return false;
        }
    }

    public static abstract class WtAbsentContentNode
    extends WtEmptyImmutableNode
    implements WtContentNode {
        private static final long serialVersionUID = 2465445739660029292L;

        protected WtAbsentContentNode() {
        }

        @Override
        public abstract int getNodeType();

        @Override
        public abstract String getNodeName();

        public void exchange(AstNodeList<WtNode> other) {
            throw new UnsupportedOperationException(this.genMsg());
        }

        @Override
        public boolean indicatesAbsence() {
            return true;
        }
    }
}

