/*
 * Decompiled with CFR 0.152.
 */
package org.sweble.wikitext.parser.nodes;

import de.fau.cs.osr.ptk.common.ast.AstNodePropertyIterator;
import de.fau.cs.osr.ptk.common.ast.Uninitialized;
import java.util.ListIterator;
import org.sweble.wikitext.parser.nodes.WtInnerNode2;
import org.sweble.wikitext.parser.nodes.WtLinkOptionAltText;
import org.sweble.wikitext.parser.nodes.WtLinkOptionLinkTarget;
import org.sweble.wikitext.parser.nodes.WtLinkOptions;
import org.sweble.wikitext.parser.nodes.WtLinkTitle;
import org.sweble.wikitext.parser.nodes.WtNode;
import org.sweble.wikitext.parser.nodes.WtPageName;

public class WtImageLink
extends WtInnerNode2 {
    private static final long serialVersionUID = 1L;
    private int width;
    private int height;
    private boolean upright;
    private ImageHorizAlign hAlign;
    private ImageVertAlign vAlign;
    private ImageViewFormat format;
    private boolean border;
    private static final String[] CHILD_NAMES = new String[]{"target", "options"};

    protected WtImageLink() {
        super(Uninitialized.X);
    }

    protected WtImageLink(WtPageName target, WtLinkOptions options, ImageViewFormat format, boolean border, ImageHorizAlign hAlign, ImageVertAlign vAlign, int width, int height, boolean upright) {
        super(target, options);
        this.setFormat(format);
        this.setBorder(border);
        this.setHAlign(hAlign);
        this.setVAlign(vAlign);
        this.setWidth(width);
        this.setHeight(height);
        this.setUpright(upright);
    }

    public int getNodeType() {
        return 720903;
    }

    public final int getWidth() {
        return this.width;
    }

    public final void setWidth(int width) {
        this.width = width;
    }

    public final int getHeight() {
        return this.height;
    }

    public final void setHeight(int height) {
        this.height = height;
    }

    public final boolean getUpright() {
        return this.upright;
    }

    public final void setUpright(boolean upright) {
        this.upright = upright;
    }

    public final ImageHorizAlign getHAlign() {
        return this.hAlign;
    }

    public final void setHAlign(ImageHorizAlign hAlign) {
        if (hAlign == null) {
            throw new NullPointerException();
        }
        this.hAlign = hAlign;
    }

    public final ImageVertAlign getVAlign() {
        return this.vAlign;
    }

    public final void setVAlign(ImageVertAlign vAlign) {
        if (vAlign == null) {
            throw new NullPointerException();
        }
        this.vAlign = vAlign;
    }

    public final ImageViewFormat getFormat() {
        return this.format;
    }

    public final void setFormat(ImageViewFormat format) {
        if (format == null) {
            throw new NullPointerException();
        }
        this.format = format;
    }

    public final boolean getBorder() {
        return this.border;
    }

    public final void setBorder(boolean border) {
        this.border = border;
    }

    @Override
    public final int getPropertyCount() {
        return 7 + this.getSuperPropertyCount();
    }

    private final int getSuperPropertyCount() {
        return super.getPropertyCount();
    }

    @Override
    public final AstNodePropertyIterator propertyIterator() {
        return new WtInnerNode2.WtInnerNode2PropertyIterator(){

            @Override
            protected int getPropertyCount() {
                return WtImageLink.this.getPropertyCount();
            }

            @Override
            protected String getName(int index) {
                switch (index - WtImageLink.this.getSuperPropertyCount()) {
                    case 0: {
                        return "width";
                    }
                    case 1: {
                        return "height";
                    }
                    case 2: {
                        return "upright";
                    }
                    case 3: {
                        return "hAlign";
                    }
                    case 4: {
                        return "vAlign";
                    }
                    case 5: {
                        return "format";
                    }
                    case 6: {
                        return "border";
                    }
                }
                return super.getName(index);
            }

            @Override
            protected Object getValue(int index) {
                switch (index - WtImageLink.this.getSuperPropertyCount()) {
                    case 0: {
                        return WtImageLink.this.getWidth();
                    }
                    case 1: {
                        return WtImageLink.this.getHeight();
                    }
                    case 2: {
                        return WtImageLink.this.getUpright();
                    }
                    case 3: {
                        return WtImageLink.this.getHAlign();
                    }
                    case 4: {
                        return WtImageLink.this.getVAlign();
                    }
                    case 5: {
                        return WtImageLink.this.getFormat();
                    }
                    case 6: {
                        return WtImageLink.this.getBorder();
                    }
                }
                return super.getValue(index);
            }

            @Override
            protected Object setValue(int index, Object value) {
                switch (index - WtImageLink.this.getSuperPropertyCount()) {
                    case 0: {
                        int old = WtImageLink.this.getWidth();
                        WtImageLink.this.setWidth((Integer)value);
                        return old;
                    }
                    case 1: {
                        int old = WtImageLink.this.getHeight();
                        WtImageLink.this.setHeight((Integer)value);
                        return old;
                    }
                    case 2: {
                        boolean old = WtImageLink.this.getUpright();
                        WtImageLink.this.setUpright((Boolean)value);
                        return old;
                    }
                    case 3: {
                        ImageHorizAlign old = WtImageLink.this.getHAlign();
                        WtImageLink.this.setHAlign((ImageHorizAlign)((Object)value));
                        return old;
                    }
                    case 4: {
                        ImageVertAlign old = WtImageLink.this.getVAlign();
                        WtImageLink.this.setVAlign((ImageVertAlign)((Object)value));
                        return old;
                    }
                    case 5: {
                        ImageViewFormat old = WtImageLink.this.getFormat();
                        WtImageLink.this.setFormat((ImageViewFormat)((Object)value));
                        return old;
                    }
                    case 6: {
                        boolean old = WtImageLink.this.getBorder();
                        WtImageLink.this.setBorder((Boolean)value);
                        return old;
                    }
                }
                return super.setValue(index, value);
            }
        };
    }

    public final void setTarget(WtPageName target) {
        this.set(0, target);
    }

    public final WtPageName getTarget() {
        return (WtPageName)this.get(0);
    }

    public final void setOptions(WtLinkOptions options) {
        this.set(1, options);
    }

    public final WtLinkOptions getOptions() {
        return (WtLinkOptions)this.get(1);
    }

    public final String[] getChildNames() {
        return CHILD_NAMES;
    }

    public final WtLinkOptionLinkTarget getLink() {
        WtNode target = this.getFromOpts(720907);
        if (target == null) {
            return WtLinkOptionLinkTarget.DEFAULT;
        }
        return (WtLinkOptionLinkTarget)target;
    }

    public final void setLink(WtLinkOptionLinkTarget link) {
        if (link == WtLinkOptionLinkTarget.DEFAULT) {
            link = null;
        }
        this.setInOpts(720907, link);
    }

    public final boolean hasAlt() {
        return this.getFromOpts(720904) != null;
    }

    public final void setAlt(WtLinkOptionAltText alt) {
        if (alt == WtLinkOptionAltText.NO_ALT) {
            alt = null;
        }
        this.setInOpts(720904, alt);
    }

    public final WtLinkOptionAltText getAlt() {
        WtNode alt = this.getFromOpts(720904);
        if (alt == null) {
            return WtLinkOptionAltText.NO_ALT;
        }
        return (WtLinkOptionAltText)alt;
    }

    public boolean hasTitle() {
        return this.getFromOpts(720910) != null;
    }

    public final void setTitle(WtLinkTitle title) {
        if (title == WtLinkTitle.NO_TITLE) {
            title = null;
        }
        this.setInOpts(720910, title);
    }

    public final WtLinkTitle getTitle() {
        WtNode title = this.getFromOpts(720910);
        if (title == null) {
            return WtLinkTitle.NO_TITLE;
        }
        return (WtLinkTitle)title;
    }

    private void setInOpts(int type, WtNode node) {
        WtLinkOptions opts = this.getOptions();
        ListIterator i = opts.listIterator(opts.size());
        while (i.hasPrevious()) {
            WtNode o = (WtNode)i.previous();
            if (o.getNodeType() != type) continue;
            if (node != null) {
                i.set(node);
                return;
            }
            i.remove();
        }
        if (node != null) {
            opts.add(node);
        }
    }

    private WtNode getFromOpts(int type) {
        WtLinkOptions opts = this.getOptions();
        for (int i = opts.size() - 1; i >= 0; --i) {
            WtNode o = (WtNode)opts.get(i);
            if (o.getNodeType() != type) continue;
            return o;
        }
        return null;
    }

    public static enum ImageViewFormat {
        UNRESTRAINED{

            @Override
            public String asKeyword() {
                return "";
            }

            @Override
            public int priority() {
                return 0;
            }

            @Override
            public boolean isFramed() {
                return false;
            }
        }
        ,
        FRAMELESS{

            @Override
            public String asKeyword() {
                return "frameless";
            }

            @Override
            public int priority() {
                return 1;
            }

            @Override
            public boolean isFramed() {
                return false;
            }
        }
        ,
        THUMBNAIL{

            @Override
            public String asKeyword() {
                return "thumb";
            }

            @Override
            public int priority() {
                return 2;
            }

            @Override
            public boolean isFramed() {
                return true;
            }
        }
        ,
        FRAME{

            @Override
            public String asKeyword() {
                return "frame";
            }

            @Override
            public int priority() {
                return 3;
            }

            @Override
            public boolean isFramed() {
                return true;
            }
        };

        private static final Object[] formatMap;

        public abstract String asKeyword();

        public abstract int priority();

        public abstract boolean isFramed();

        public static ImageViewFormat which(String s) {
            if (s == null) {
                throw new NullPointerException();
            }
            s = s.trim().toLowerCase();
            for (int i = 0; i < formatMap.length; i += 2) {
                String f = (String)formatMap[i];
                if (!f.equals(s)) continue;
                return (ImageViewFormat)((Object)formatMap[i + 1]);
            }
            return null;
        }

        public ImageViewFormat combine(ImageViewFormat other) {
            return this.priority() > other.priority() ? this : other;
        }

        static {
            formatMap = new Object[]{"frameless", FRAMELESS, "thumb", THUMBNAIL, "thumbnail", THUMBNAIL, "frame", FRAME};
        }
    }

    public static enum ImageVertAlign {
        BASELINE{

            @Override
            public String asKeyword() {
                return "baseline";
            }
        }
        ,
        SUB{

            @Override
            public String asKeyword() {
                return "sub";
            }
        }
        ,
        SUPER{

            @Override
            public String asKeyword() {
                return "super";
            }
        }
        ,
        TOP{

            @Override
            public String asKeyword() {
                return "top";
            }
        }
        ,
        TEXT_TOP{

            @Override
            public String asKeyword() {
                return "text-top";
            }
        }
        ,
        MIDDLE{

            @Override
            public String asKeyword() {
                return "middle";
            }
        }
        ,
        BOTTOM{

            @Override
            public String asKeyword() {
                return "bottom";
            }
        }
        ,
        TEXT_BOTTOM{

            @Override
            public String asKeyword() {
                return "text-bottom";
            }
        };


        public abstract String asKeyword();

        public static ImageVertAlign which(String s) {
            if (s == null) {
                throw new NullPointerException();
            }
            s = s.trim().toLowerCase();
            for (ImageVertAlign v : ImageVertAlign.values()) {
                if (!v.asKeyword().equals(s)) continue;
                return v;
            }
            return null;
        }
    }

    public static enum ImageHorizAlign {
        LEFT{

            @Override
            public String asKeyword() {
                return "left";
            }
        }
        ,
        RIGHT{

            @Override
            public String asKeyword() {
                return "right";
            }
        }
        ,
        CENTER{

            @Override
            public String asKeyword() {
                return "center";
            }
        }
        ,
        NONE{

            @Override
            public String asKeyword() {
                return "";
            }
        }
        ,
        UNSPECIFIED{

            @Override
            public String asKeyword() {
                return null;
            }
        };


        public abstract String asKeyword();

        public static ImageHorizAlign which(String s) {
            if (s == null) {
                throw new NullPointerException();
            }
            s = s.trim().toLowerCase();
            for (ImageHorizAlign h : ImageHorizAlign.values()) {
                if (!s.equals(h.asKeyword())) continue;
                return h;
            }
            return null;
        }
    }
}

