/*
 * Decompiled with CFR 0.152.
 */
package org.sweble.wikitext.parser.parser;

import de.fau.cs.osr.ptk.common.AstVisitor;
import org.sweble.wikitext.parser.WtEntityMap;
import org.sweble.wikitext.parser.nodes.WtIgnored;
import org.sweble.wikitext.parser.nodes.WtNode;
import org.sweble.wikitext.parser.nodes.WtNodeList;
import org.sweble.wikitext.parser.nodes.WtOnlyInclude;
import org.sweble.wikitext.parser.nodes.WtPreproWikitextPage;
import org.sweble.wikitext.parser.nodes.WtText;
import org.sweble.wikitext.parser.nodes.WtXmlComment;
import org.sweble.wikitext.parser.preprocessor.PreprocessedWikitext;

public class PreprocessorToParserTransformer {
    public static PreprocessedWikitext transform(WtPreproWikitextPage preprocessedArticle) {
        return PreprocessorToParserTransformer.transform(preprocessedArticle, false);
    }

    public static PreprocessedWikitext transform(WtPreproWikitextPage preprocessedArticle, boolean trim) {
        TransformVisitor tv = new TransformVisitor(trim);
        return (PreprocessedWikitext)tv.go(preprocessedArticle);
    }

    protected static final class TransformVisitor
    extends AstVisitor<WtNode> {
        private StringBuilder builder;
        private WtEntityMap entityMap;
        private final boolean trim;

        public TransformVisitor(boolean trim) {
            this.trim = trim;
        }

        protected boolean before(WtNode node) {
            this.builder = new StringBuilder();
            return super.before((Object)node);
        }

        protected PreprocessedWikitext after(WtNode node, Object result) {
            return new PreprocessedWikitext(this.builder.toString(), this.entityMap);
        }

        public void visit(WtPreproWikitextPage n) {
            this.entityMap = n.getEntityMap();
            this.iterate(n);
        }

        public void visit(WtNodeList n) {
            this.iterate(n);
        }

        public void visit(WtOnlyInclude n) {
            this.iterate(n);
        }

        public void visit(WtText n) {
            this.builder.append(n.getContent());
        }

        public void visit(WtNode n) {
            this.makeParserEntity(n);
        }

        public void visit(WtIgnored n) {
            if (!this.trim) {
                this.makeParserEntity(n);
            }
        }

        public void visit(WtXmlComment n) {
            if (!this.trim) {
                this.makeParserEntity(n);
            }
        }

        private void makeParserEntity(WtNode n) {
            int id = this.entityMap.registerEntity(n);
            this.builder.append('\ue000');
            this.builder.append(id);
            this.builder.append('\ue001');
        }
    }
}

