/*
 * Decompiled with CFR 0.152.
 */
package org.sweble.wikitext.parser.postprocessor;

import de.fau.cs.osr.ptk.common.AstVisitor;
import de.fau.cs.osr.utils.FmtInternalLogicError;
import de.fau.cs.osr.utils.StringUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import org.sweble.wikitext.parser.ParserConfig;
import org.sweble.wikitext.parser.nodes.WikitextNodeFactory;
import org.sweble.wikitext.parser.nodes.WtContentNode;
import org.sweble.wikitext.parser.nodes.WtDefinitionListDef;
import org.sweble.wikitext.parser.nodes.WtDefinitionListTerm;
import org.sweble.wikitext.parser.nodes.WtLeafNode;
import org.sweble.wikitext.parser.nodes.WtListItem;
import org.sweble.wikitext.parser.nodes.WtNewline;
import org.sweble.wikitext.parser.nodes.WtNode;
import org.sweble.wikitext.parser.nodes.WtNodeList;
import org.sweble.wikitext.parser.nodes.WtSemiPreLine;
import org.sweble.wikitext.parser.nodes.WtStringNode;
import org.sweble.wikitext.parser.nodes.WtTableCell;
import org.sweble.wikitext.parser.nodes.WtTableHeader;
import org.sweble.wikitext.parser.nodes.WtText;
import org.sweble.wikitext.parser.nodes.WtTicks;
import org.sweble.wikitext.parser.nodes.WtWhitespace;
import org.sweble.wikitext.parser.postprocessor.IntermediateTags;

public class TicksAnalyzer {
    private WikitextNodeFactory nf;

    public static WtNode process(ParserConfig config, WtNode a) {
        return new TicksAnalyzer(config).process(a);
    }

    public TicksAnalyzer(ParserConfig config) {
        this.nf = config.getNodeFactory();
    }

    public WtNode process(WtNode a) {
        LinkedList<Line> lines = new LinkedList<Line>();
        new LineAnalyzer(lines).go(a);
        if (lines.isEmpty()) {
            return a;
        }
        this.analyzeOddTicksCombos(lines);
        return (WtNode)new TicksConverter(lines).go(a);
    }

    private void analyzeOddTicksCombos(LinkedList<Line> lines) {
        for (Line line : lines) {
            if (line.numBold % 2 != 1 || line.numItalics % 2 != 1) continue;
            int firstSpace = -1;
            int firstSlWord = -1;
            int firstMlWord = -1;
            for (int i = 0; i < line.ticks.size(); ++i) {
                LineEntry entry = line.ticks.get(i);
                WtNode p = entry.previous;
                if (p == null || entry.tickCount != 3) continue;
                if (p instanceof WtContentNode) {
                    WtContentNode c = (WtContentNode)p;
                    p = null;
                    if (!c.isEmpty()) {
                        p = (WtNode)c.get(c.size() - 1);
                    }
                }
                int tMinus1 = 0;
                int tMinus2 = 0;
                if (p instanceof WtStringNode) {
                    String t = ((WtStringNode)p).getContent();
                    if (t.length() >= 1) {
                        tMinus1 = t.charAt(t.length() - 1);
                    }
                    if (t.length() >= 2) {
                        tMinus2 = t.charAt(t.length() - 2);
                    }
                }
                if (tMinus1 == 32) {
                    if (firstSpace != -1) continue;
                    firstSpace = i;
                    continue;
                }
                if (tMinus2 == 32) {
                    if (firstSlWord != -1) continue;
                    firstSlWord = i;
                    continue;
                }
                if (firstMlWord != -1) continue;
                firstMlWord = i;
            }
            if (firstSlWord != -1) {
                this.apostrophize(line.ticks.get(firstSlWord));
                continue;
            }
            if (firstMlWord != -1) {
                this.apostrophize(line.ticks.get(firstMlWord));
                continue;
            }
            if (firstSpace == -1) continue;
            this.apostrophize(line.ticks.get(firstSpace));
        }
    }

    private void apostrophize(LineEntry entry) {
        --entry.tickCount;
        if (entry.prefix != null) {
            String t = entry.prefix.getContent() + "'";
            entry.prefix.setContent(t);
        } else {
            entry.prefix = this.nf.text("'");
        }
    }

    protected static final class LineEntry {
        public final WtNode previous;
        public WtText prefix;
        public int tickCount;

        public LineEntry(WtNode previous, WtText prefix, int tickCount) {
            this.previous = previous;
            this.prefix = prefix;
            this.tickCount = tickCount;
        }

        public String toString() {
            String pv = "null";
            if (this.previous != null) {
                pv = this.previous.getNodeName();
                if (this.previous.isNodeType(4097) && (pv = ((WtText)this.previous).getContent()).length() > 16) {
                    pv = pv.substring(pv.length() - 12);
                    pv = "... " + pv;
                }
                pv = '\"' + pv + '\"';
            }
            String pf = "-";
            if (this.prefix != null) {
                pf = '\"' + this.prefix.getContent() + '\"';
            }
            return String.format("LineEntry(%s, %s, %d)", pv, pf, this.tickCount);
        }
    }

    protected static final class Line {
        public final int numItalics;
        public final int numBold;
        public final ArrayList<LineEntry> ticks;

        public Line(int numItalics, int numBold, ArrayList<LineEntry> ticks) {
            this.numItalics = numItalics;
            this.numBold = numBold;
            this.ticks = ticks;
        }

        public String toString() {
            return String.format("Line(#i = %d, #b = %d): %s", this.numItalics, this.numBold, this.ticks != null ? this.ticks.toString() : "-");
        }
    }

    protected final class TicksConverter
    extends AstVisitor<WtNode> {
        private final Iterator<Line> lineIter;
        private Iterator<LineEntry> entryIter;
        private State state = State.None;

        public TicksConverter(LinkedList<Line> lines) {
            this.lineIter = lines.iterator();
            if (this.lineIter.hasNext()) {
                this.entryIter = this.lineIter.next().ticks.iterator();
            }
        }

        public WtNode visit(WtNode n) {
            this.mapInPlace(n);
            return n;
        }

        public WtNode visit(WtLeafNode n) {
            return n;
        }

        public WtNode visit(WtTicks n) {
            LineEntry entry = this.nextEntry();
            WtNodeList result = TicksAnalyzer.this.nf.list(entry.prefix);
            this.toTag(entry, result);
            return result;
        }

        public WtNode visit(WtNewline newline) {
            WtNodeList result = this.closeRemainingTags();
            if (result == null) {
                return newline;
            }
            this.state = State.None;
            result.add(newline);
            return result;
        }

        public WtNode visit(WtWhitespace ws) {
            if (!ws.getHasNewline()) {
                return ws;
            }
            WtNodeList result = this.closeRemainingTags();
            if (result == null) {
                return ws;
            }
            this.state = State.None;
            result.add(ws);
            return result;
        }

        public WtNode visit(WtListItem n) {
            return this.implicitLineScope(n);
        }

        public WtNode visit(WtDefinitionListTerm n) {
            return this.implicitLineScope(n);
        }

        public WtNode visit(WtDefinitionListDef n) {
            return this.implicitLineScope(n);
        }

        public WtNode visit(WtSemiPreLine n) {
            return this.implicitLineScope(n);
        }

        public WtNode visit(WtTableCell n) {
            this.implicitLineScope(n.getBody());
            return n;
        }

        public WtNode visit(WtTableHeader n) {
            this.implicitLineScope(n.getBody());
            return n;
        }

        private WtNode implicitLineScope(WtNodeList content) {
            this.mapInPlace(content);
            this.finishLine(content);
            return content;
        }

        private void finishLine(WtNodeList body) {
            WtNodeList result = this.closeRemainingTags();
            if (result == null) {
                return;
            }
            this.state = State.None;
            body.add(result);
        }

        private LineEntry nextEntry() {
            if (!this.entryIter.hasNext()) {
                Line line = this.lineIter.next();
                this.entryIter = line.ticks.iterator();
            }
            return this.entryIter.next();
        }

        private void toTag(LineEntry entry, WtNodeList result) {
            block0 : switch (entry.tickCount) {
                case 2: {
                    switch (this.state) {
                        case Italics: {
                            result.add(IntermediateTags.ITALICS.createClose(TicksAnalyzer.this.nf, false));
                            this.state = State.None;
                            break;
                        }
                        case BoldItalics: {
                            result.add(IntermediateTags.ITALICS.createClose(TicksAnalyzer.this.nf, false));
                            this.state = State.Bold;
                            break;
                        }
                        case ItalicsBold: {
                            result.add(IntermediateTags.BOLD.createClose(TicksAnalyzer.this.nf, true));
                            result.add(IntermediateTags.ITALICS.createClose(TicksAnalyzer.this.nf, false));
                            result.add(IntermediateTags.BOLD.createOpen(TicksAnalyzer.this.nf, true));
                            this.state = State.Bold;
                            break;
                        }
                        case Bold: {
                            result.add(IntermediateTags.ITALICS.createOpen(TicksAnalyzer.this.nf, false));
                            this.state = State.BoldItalics;
                            break;
                        }
                        case None: {
                            result.add(IntermediateTags.ITALICS.createOpen(TicksAnalyzer.this.nf, false));
                            this.state = State.Italics;
                        }
                    }
                    break;
                }
                case 3: {
                    switch (this.state) {
                        case Bold: {
                            result.add(IntermediateTags.BOLD.createClose(TicksAnalyzer.this.nf, false));
                            this.state = State.None;
                            break;
                        }
                        case BoldItalics: {
                            result.add(IntermediateTags.ITALICS.createClose(TicksAnalyzer.this.nf, true));
                            result.add(IntermediateTags.BOLD.createClose(TicksAnalyzer.this.nf, false));
                            result.add(IntermediateTags.ITALICS.createOpen(TicksAnalyzer.this.nf, true));
                            this.state = State.Italics;
                            break;
                        }
                        case ItalicsBold: {
                            result.add(IntermediateTags.BOLD.createClose(TicksAnalyzer.this.nf, false));
                            this.state = State.Italics;
                            break;
                        }
                        case Italics: {
                            result.add(IntermediateTags.BOLD.createOpen(TicksAnalyzer.this.nf, false));
                            this.state = State.ItalicsBold;
                            break;
                        }
                        case None: {
                            result.add(IntermediateTags.BOLD.createOpen(TicksAnalyzer.this.nf, false));
                            this.state = State.Bold;
                        }
                    }
                    break;
                }
                case 5: {
                    switch (this.state) {
                        case Italics: {
                            result.add(IntermediateTags.ITALICS.createClose(TicksAnalyzer.this.nf, false));
                            result.add(IntermediateTags.BOLD.createOpen(TicksAnalyzer.this.nf, false));
                            this.state = State.Bold;
                            break block0;
                        }
                        case Bold: {
                            result.add(IntermediateTags.BOLD.createClose(TicksAnalyzer.this.nf, false));
                            result.add(IntermediateTags.ITALICS.createOpen(TicksAnalyzer.this.nf, false));
                            this.state = State.Italics;
                            break block0;
                        }
                        case BoldItalics: {
                            result.add(IntermediateTags.ITALICS.createClose(TicksAnalyzer.this.nf, false));
                            result.add(IntermediateTags.BOLD.createClose(TicksAnalyzer.this.nf, false));
                            this.state = State.None;
                            break block0;
                        }
                        case ItalicsBold: {
                            result.add(IntermediateTags.BOLD.createClose(TicksAnalyzer.this.nf, false));
                            result.add(IntermediateTags.ITALICS.createClose(TicksAnalyzer.this.nf, false));
                            this.state = State.None;
                            break block0;
                        }
                        case None: {
                            result.add(IntermediateTags.ITALICS.createOpen(TicksAnalyzer.this.nf, false));
                            result.add(IntermediateTags.BOLD.createOpen(TicksAnalyzer.this.nf, false));
                            this.state = State.ItalicsBold;
                        }
                    }
                }
            }
        }

        private WtNodeList closeRemainingTags() {
            WtNodeList result = null;
            switch (this.state) {
                case Italics: {
                    result = TicksAnalyzer.this.nf.list();
                    result.add(IntermediateTags.ITALICS.createClose(TicksAnalyzer.this.nf, true));
                    break;
                }
                case Bold: {
                    result = TicksAnalyzer.this.nf.list();
                    result.add(IntermediateTags.BOLD.createClose(TicksAnalyzer.this.nf, true));
                    break;
                }
                case BoldItalics: {
                    result = TicksAnalyzer.this.nf.list();
                    result.add(IntermediateTags.ITALICS.createClose(TicksAnalyzer.this.nf, true));
                    result.add(IntermediateTags.BOLD.createClose(TicksAnalyzer.this.nf, true));
                    break;
                }
                case ItalicsBold: {
                    result = TicksAnalyzer.this.nf.list();
                    result.add(IntermediateTags.BOLD.createClose(TicksAnalyzer.this.nf, true));
                    result.add(IntermediateTags.ITALICS.createClose(TicksAnalyzer.this.nf, true));
                    break;
                }
            }
            return result;
        }
    }

    private static enum State {
        None,
        Italics,
        Bold,
        ItalicsBold,
        BoldItalics;

    }

    protected final class LineAnalyzer
    extends AstVisitor<WtNode> {
        private final LinkedList<Line> lines;
        private ArrayList<LineEntry> ticks;
        private int numItalics = 0;
        private int numBold = 0;
        private WtNode previous = null;

        public LineAnalyzer(LinkedList<Line> lines) {
            this.lines = lines;
        }

        protected Object after(WtNode node, Object result) {
            this.finishLine();
            return node;
        }

        public void visit(WtNode n) {
            this.iterate(n);
        }

        public void visit(WtNodeList list) {
            this.iterateContent(list);
        }

        private void iterateContent(WtNodeList list) {
            this.previous = null;
            Iterator i$ = list.iterator();
            while (i$.hasNext()) {
                WtNode n = (WtNode)i$.next();
                this.dispatch(n);
                this.previous = n;
            }
            this.previous = null;
        }

        public void visit(WtNewline ws) {
            this.finishLine();
        }

        public void visit(WtWhitespace ws) {
            if (ws.getHasNewline()) {
                this.finishLine();
            }
        }

        public void visit(WtListItem n) {
            this.iterateContent(n);
            this.finishLine();
        }

        public void visit(WtDefinitionListTerm n) {
            this.iterateContent(n);
            this.finishLine();
        }

        public void visit(WtDefinitionListDef n) {
            this.iterateContent(n);
            this.finishLine();
        }

        public void visit(WtSemiPreLine n) {
            this.iterateContent(n);
            this.finishLine();
        }

        public void visit(WtTableCell n) {
            this.iterateContent(n.getBody());
            this.finishLine();
        }

        public void visit(WtTableHeader n) {
            this.iterateContent(n.getBody());
            this.finishLine();
        }

        public void visit(WtLeafNode n) {
        }

        public void visit(WtTicks n) {
            if (this.ticks == null) {
                this.ticks = new ArrayList();
            }
            int tickCount = n.getTickCount();
            switch (tickCount) {
                case 2: {
                    this.ticks.add(new LineEntry(null, null, 2));
                    ++this.numItalics;
                    break;
                }
                case 3: {
                    this.ticks.add(new LineEntry(this.previous, null, 3));
                    ++this.numBold;
                    break;
                }
                case 4: {
                    this.ticks.add(new LineEntry(this.previous, TicksAnalyzer.this.nf.text("'"), 3));
                    ++this.numBold;
                    break;
                }
                case 5: {
                    this.ticks.add(new LineEntry(null, null, 5));
                    ++this.numBold;
                    ++this.numItalics;
                    break;
                }
                default: {
                    if (n.getTickCount() <= 5) {
                        throw new FmtInternalLogicError();
                    }
                    String excessTicks = StringUtils.strrep((char)'\'', (int)(tickCount - 5));
                    this.ticks.add(new LineEntry(null, TicksAnalyzer.this.nf.text(excessTicks), 5));
                    ++this.numBold;
                    ++this.numItalics;
                }
            }
        }

        private void finishLine() {
            if (this.ticks == null) {
                return;
            }
            this.lines.add(new Line(this.numItalics, this.numBold, this.ticks));
            this.numItalics = 0;
            this.numBold = 0;
            this.ticks = null;
        }
    }
}

