/*
 * Decompiled with CFR 0.152.
 */
package org.sweble.wikitext.parser.utils;

import java.util.Iterator;
import org.sweble.wikitext.parser.ParserConfig;
import org.sweble.wikitext.parser.nodes.WikitextNodeFactory;
import org.sweble.wikitext.parser.nodes.WtContentNode;
import org.sweble.wikitext.parser.nodes.WtIgnored;
import org.sweble.wikitext.parser.nodes.WtNode;
import org.sweble.wikitext.parser.nodes.WtNodeList;
import org.sweble.wikitext.parser.nodes.WtText;
import org.sweble.wikitext.parser.nodes.WtXmlCharRef;
import org.sweble.wikitext.parser.nodes.WtXmlComment;
import org.sweble.wikitext.parser.nodes.WtXmlEntityRef;
import org.sweble.wikitext.parser.utils.AstTextUtils;
import org.sweble.wikitext.parser.utils.StringConversionException;

public class AstTextUtilsImpl
implements AstTextUtils {
    protected final ParserConfig parserConfig;

    public AstTextUtilsImpl(ParserConfig parserConfig) {
        this.parserConfig = parserConfig;
    }

    @Override
    public String astToText(WtNode node) throws StringConversionException {
        return this.astToText(node, new SimpleStringConverter());
    }

    @Override
    public String astToText(WtNode node, int ... options) throws StringConversionException {
        return this.astToText(node, new SimpleStringConverter(options));
    }

    protected String astToText(WtNode node, SimpleStringConverter sc) throws StringConversionException {
        int nodeType = node.getNodeType();
        if (node instanceof WtContentNode) {
            nodeType = 2;
        }
        sc.dispatch(node, nodeType);
        return sc.toString();
    }

    @Override
    public AstTextUtils.PartialConversion astToTextPartial(WtNode node) {
        return this.astToTextPartial(node, new PartialStringConverter());
    }

    @Override
    public AstTextUtils.PartialConversion astToTextPartial(WtNode node, int ... options) {
        return this.astToTextPartial(node, new PartialStringConverter(options));
    }

    protected AstTextUtils.PartialConversion astToTextPartial(WtNode node, final PartialStringConverter sc) {
        int nodeType = node.getNodeType();
        if (node instanceof WtContentNode) {
            nodeType = 2;
        }
        try {
            sc.dispatch(node, nodeType);
        }
        catch (StringConversionException e) {
            sc.tail = this.nf().list(node);
        }
        return new AstTextUtils.PartialConversion(){

            @Override
            public String getText() {
                return sc.toString();
            }

            @Override
            public WtNodeList getTail() {
                return sc.tail;
            }
        };
    }

    protected WikitextNodeFactory nf() {
        return this.parserConfig.getNodeFactory();
    }

    protected class PartialStringConverter
    extends SimpleStringConverter {
        WtNodeList tail;

        public PartialStringConverter() {
            this.tail = AstTextUtilsImpl.this.nf().emptyList();
        }

        public PartialStringConverter(int[] options) {
            super(options);
            this.tail = AstTextUtilsImpl.this.nf().emptyList();
        }

        @Override
        public void visit(WtNodeList node) throws StringConversionException {
            Iterator i = node.iterator();
            while (i.hasNext()) {
                WtNode c = (WtNode)i.next();
                try {
                    this.dispatch(c, c.getNodeType());
                }
                catch (StringConversionException e) {
                    this.tail = AstTextUtilsImpl.this.nf().list();
                    this.tail.add(c);
                    while (i.hasNext()) {
                        this.tail.add(i.next());
                    }
                    return;
                }
            }
        }
    }

    protected static class SimpleStringConverter {
        protected boolean failOnUnresolvedEntityRef = false;
        protected StringBuilder b = new StringBuilder();

        public SimpleStringConverter() {
        }

        public SimpleStringConverter(int[] options) {
            this();
            for (int option : options) {
                this.setOption(option);
            }
        }

        protected void setOption(int option) {
            switch (option) {
                case 1: {
                    this.failOnUnresolvedEntityRef = true;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown option");
                }
            }
        }

        public String toString() {
            return this.b.toString();
        }

        public void dispatch(WtNode node, int nodeType) throws StringConversionException {
            switch (nodeType) {
                case 2: {
                    this.visit((WtNodeList)node);
                    break;
                }
                case 4097: {
                    this.visit((WtText)node);
                    break;
                }
                case 720931: {
                    this.visit((WtXmlCharRef)node);
                    break;
                }
                case 720933: {
                    this.visit((WtXmlEntityRef)node);
                    break;
                }
                case 458754: {
                    this.visit((WtXmlComment)node);
                    break;
                }
                case 196613: {
                    this.visit((WtIgnored)node);
                    break;
                }
                default: {
                    this.visitNotFound(node);
                }
            }
        }

        protected void visitNotFound(WtNode node) throws StringConversionException {
            throw new StringConversionException(node);
        }

        protected void visit(WtIgnored node) {
        }

        protected void visit(WtXmlComment node) {
        }

        protected void visit(WtXmlEntityRef node) throws StringConversionException {
            if (node.getResolved() == null) {
                if (this.failOnUnresolvedEntityRef) {
                    throw new StringConversionException(node);
                }
                this.b.append('&');
                this.b.append(node.getName());
                this.b.append(';');
            } else {
                this.b.append(node.getResolved());
            }
        }

        protected void visit(WtXmlCharRef node) {
            this.b.append(Character.toChars(node.getCodePoint()));
        }

        protected void visit(WtText node) {
            this.b.append(node.getContent());
        }

        protected void visit(WtNodeList node) throws StringConversionException {
            Iterator i$ = node.iterator();
            while (i$.hasNext()) {
                WtNode n = (WtNode)i$.next();
                this.dispatch(n, n.getNodeType());
            }
        }
    }
}

